/*
 * Decompiled with CFR 0.152.
 */
package ch.digitalfondue.jfiveparse;

import ch.digitalfondue.jfiveparse.Common;
import ch.digitalfondue.jfiveparse.Entities;
import ch.digitalfondue.jfiveparse.Prefix;
import ch.digitalfondue.jfiveparse.ProcessedInputStream;
import ch.digitalfondue.jfiveparse.ResizableCharBuilder;
import ch.digitalfondue.jfiveparse.Tokenizer;
import java.util.Arrays;

class TokenizerCharacterReference {
    private static final int[] invalidCharacterReference = new int[]{11, 65534, 65535, 131070, 131071, 196606, 196607, 262142, 262143, 327678, 327679, 393214, 393215, 458750, 458751, 524286, 524287, 589822, 589823, 655358, 655359, 720894, 720895, 786430, 786431, 851966, 851967, 917502, 917503, 983038, 983039, 1048574, 1048575, 1114110, 0x10FFFF};

    TokenizerCharacterReference() {
    }

    static char[] consumeCharacterReference(int additionalCharacter, boolean inAttribute, ProcessedInputStream processedInputStream, Tokenizer tokenHandler) {
        if (!tokenHandler.transformEntities) {
            return null;
        }
        int chr = processedInputStream.getNextInputCharacter();
        if (additionalCharacter != -1 && additionalCharacter == chr) {
            return null;
        }
        switch (chr) {
            case -1: 
            case 9: 
            case 10: 
            case 32: 
            case 38: 
            case 60: {
                return null;
            }
            case 35: {
                return TokenizerCharacterReference.parseNumberSign(processedInputStream, tokenHandler);
            }
        }
        return TokenizerCharacterReference.parseEntity(inAttribute, processedInputStream, tokenHandler, chr);
    }

    private static char[] parseNumberSign(ProcessedInputStream processedInputStream, Tokenizer tokenHandler) {
        processedInputStream.consume();
        int nextChar = processedInputStream.getNextInputCharacter();
        if (nextChar == 120 || nextChar == 88) {
            return TokenizerCharacterReference.parseHexSection(processedInputStream, tokenHandler, nextChar);
        }
        return TokenizerCharacterReference.parseDecSection(processedInputStream, tokenHandler);
    }

    private static char[] parseEntity(boolean inAttribute, ProcessedInputStream processedInputStream, Tokenizer tokenHandler, int chr) {
        Prefix maybeCompleteParent;
        int matchedCount = 0;
        Prefix currentPrefix = Entities.ENTITIES;
        ResizableCharBuilder tentativelyMatched = new ResizableCharBuilder();
        while (true) {
            Prefix tmpPrefix;
            int next;
            if ((next = processedInputStream.peekNextInputCharacter(matchedCount + 1)) != -1) {
                tentativelyMatched.append((char)next);
            }
            if ((tmpPrefix = currentPrefix.getNode((char)next)) == null) break;
            currentPrefix = tmpPrefix;
            ++matchedCount;
        }
        if (!currentPrefix.isComplete() && (maybeCompleteParent = currentPrefix.getMaybeCompleteParent()) != null) {
            currentPrefix = maybeCompleteParent;
        }
        if (currentPrefix.isComplete()) {
            return TokenizerCharacterReference.handleCompleteEntity(inAttribute, processedInputStream, tokenHandler, currentPrefix);
        }
        TokenizerCharacterReference.handleUncompleteEntity(tokenHandler, chr, tentativelyMatched);
        return null;
    }

    private static void handleUncompleteEntity(Tokenizer tokenHandler, int chr, ResizableCharBuilder tentativelyMatched) {
        boolean emitParseError;
        int tentativelyMatchedLength = tentativelyMatched.pos();
        boolean bl = emitParseError = tentativelyMatchedLength > 1 && tentativelyMatched.at(tentativelyMatchedLength - 1) == ';';
        if (emitParseError) {
            for (int i = 0; emitParseError && i < tentativelyMatchedLength - 1; ++i) {
                emitParseError = emitParseError && Common.isAlphaNumericASCII(chr);
            }
        }
        if (emitParseError) {
            tokenHandler.emitParseError();
        }
    }

    private static char[] handleCompleteEntity(boolean inAttribute, ProcessedInputStream processedInputStream, Tokenizer tokenHandler, Prefix currentPrefix) {
        String entityMatched = currentPrefix.getString();
        if (inAttribute) {
            return TokenizerCharacterReference.handleCompleteEntityInAttribute(processedInputStream, tokenHandler, currentPrefix, entityMatched);
        }
        return TokenizerCharacterReference.handleCompleteEntityNotInAttribute(processedInputStream, tokenHandler, currentPrefix, entityMatched);
    }

    private static char[] handleCompleteEntityNotInAttribute(ProcessedInputStream processedInputStream, Tokenizer tokenHandler, Prefix currentPrefix, String entityMatched) {
        if (currentPrefix.c != ';') {
            tokenHandler.emitParseError();
        }
        processedInputStream.consume(entityMatched.length() - 1);
        return currentPrefix.chars;
    }

    private static char[] handleCompleteEntityInAttribute(ProcessedInputStream processedInputStream, Tokenizer tokenHandler, Prefix currentPrefix, String entityMatched) {
        if (currentPrefix.c != ';') {
            int nextCharacterAfterMatchedEntity = processedInputStream.peekNextInputCharacter(entityMatched.length());
            if (Common.isAlphaNumericASCII(nextCharacterAfterMatchedEntity)) {
                return null;
            }
            if (61 == nextCharacterAfterMatchedEntity) {
                tokenHandler.emitParseError();
                return null;
            }
            return TokenizerCharacterReference.handleCompleteEntityNotInAttribute(processedInputStream, tokenHandler, currentPrefix, entityMatched);
        }
        processedInputStream.consume(entityMatched.length() - 1);
        return currentPrefix.chars;
    }

    private static char[] parseDecSection(ProcessedInputStream processedInputStream, Tokenizer tokenHandler) {
        int nextPossibleHexDigit;
        int matchedCount = 0;
        ResizableCharBuilder sb = new ResizableCharBuilder();
        while (Common.isASCIIDigit(nextPossibleHexDigit = processedInputStream.peekNextInputCharacter(matchedCount + 1))) {
            sb.append((char)nextPossibleHexDigit);
            ++matchedCount;
        }
        if (matchedCount == 0) {
            processedInputStream.reconsume(35);
            tokenHandler.emitParseError();
            return null;
        }
        processedInputStream.consume(matchedCount);
        if (59 == processedInputStream.getNextInputCharacter()) {
            processedInputStream.consume();
        } else {
            tokenHandler.emitParseError();
        }
        try {
            return TokenizerCharacterReference.numberToChars(tokenHandler, sb, 10);
        }
        catch (NumberFormatException nfe) {
            tokenHandler.emitParseError();
            return Character.toChars(65533);
        }
    }

    private static char[] parseHexSection(ProcessedInputStream processedInputStream, Tokenizer tokenHandler, int prevChar) {
        int nextPossibleHexDigit;
        processedInputStream.consume();
        int matchedCount = 0;
        ResizableCharBuilder sb = new ResizableCharBuilder();
        while (Common.isASCIIHexDigit(nextPossibleHexDigit = processedInputStream.peekNextInputCharacter(matchedCount + 1))) {
            sb.append((char)nextPossibleHexDigit);
            ++matchedCount;
        }
        if (matchedCount == 0) {
            processedInputStream.reconsume(prevChar);
            processedInputStream.reconsume(35);
            tokenHandler.emitParseError();
            return null;
        }
        processedInputStream.consume(matchedCount);
        if (59 == processedInputStream.getNextInputCharacter()) {
            processedInputStream.consume();
        } else {
            tokenHandler.emitParseError();
        }
        try {
            return TokenizerCharacterReference.numberToChars(tokenHandler, sb, 16);
        }
        catch (NumberFormatException nfe) {
            tokenHandler.emitParseError();
            return Character.toChars(65533);
        }
    }

    private static char[] numberToChars(Tokenizer tokenHandler, ResizableCharBuilder sb, int radix) {
        int parsedInt = Integer.parseInt(sb.asString(), radix);
        int characterReferenceInSubstitutionTable = TokenizerCharacterReference.isCharacterReferenceSubstitutionTable(parsedInt);
        if (characterReferenceInSubstitutionTable != -1) {
            tokenHandler.emitParseError();
            return Character.toChars(characterReferenceInSubstitutionTable);
        }
        if (parsedInt >= 55296 && parsedInt <= 57343 || parsedInt > 0x10FFFF) {
            tokenHandler.emitParseError();
            return Character.toChars(65533);
        }
        if (TokenizerCharacterReference.isCharacterReferenceInvalid(parsedInt)) {
            tokenHandler.emitParseError();
        }
        return Character.toChars(parsedInt);
    }

    private static boolean isCharacterReferenceInvalid(int chr) {
        return chr >= 1 && chr <= 8 || chr >= 13 && chr <= 31 || chr >= 127 && chr <= 159 || chr >= 64976 && chr <= 65007 || Arrays.binarySearch(invalidCharacterReference, chr) > -1;
    }

    private static int isCharacterReferenceSubstitutionTable(int chr) {
        if (chr == 0) {
            return 65533;
        }
        if (chr >= 128 && chr <= 142) {
            return TokenizerCharacterReference.handleRange8X(chr);
        }
        if (chr >= 145 && chr <= 159) {
            return TokenizerCharacterReference.handleRange9x(chr);
        }
        return -1;
    }

    private static int handleRange9x(int chr) {
        switch (chr) {
            case 145: {
                return 8216;
            }
            case 146: {
                return 8217;
            }
            case 147: {
                return 8220;
            }
            case 148: {
                return 8221;
            }
            case 149: {
                return 8226;
            }
            case 150: {
                return 8211;
            }
            case 151: {
                return 8212;
            }
            case 152: {
                return 732;
            }
            case 153: {
                return 8482;
            }
            case 154: {
                return 353;
            }
            case 155: {
                return 8250;
            }
            case 156: {
                return 339;
            }
            case 158: {
                return 382;
            }
            case 159: {
                return 376;
            }
        }
        return -1;
    }

    private static int handleRange8X(int chr) {
        switch (chr) {
            case 128: {
                return 8364;
            }
            case 130: {
                return 8218;
            }
            case 131: {
                return 402;
            }
            case 132: {
                return 8222;
            }
            case 133: {
                return 8230;
            }
            case 134: {
                return 8224;
            }
            case 135: {
                return 8225;
            }
            case 136: {
                return 710;
            }
            case 137: {
                return 8240;
            }
            case 138: {
                return 352;
            }
            case 139: {
                return 8249;
            }
            case 140: {
                return 338;
            }
            case 142: {
                return 381;
            }
        }
        return -1;
    }

    static {
        Arrays.sort(invalidCharacterReference);
    }
}

