/*
 * Decompiled with CFR 0.152.
 */
package ch.digitalfondue.jfiveparse;

import ch.digitalfondue.jfiveparse.AttributeNode;
import ch.digitalfondue.jfiveparse.Attributes;
import ch.digitalfondue.jfiveparse.Element;
import ch.digitalfondue.jfiveparse.ProcessedInputStream;
import ch.digitalfondue.jfiveparse.ResizableCharBuilder;
import ch.digitalfondue.jfiveparse.StopParse;
import ch.digitalfondue.jfiveparse.TokenizerAttributesState;
import ch.digitalfondue.jfiveparse.TokenizerCDataSectionAndDataState;
import ch.digitalfondue.jfiveparse.TokenizerCommentStates;
import ch.digitalfondue.jfiveparse.TokenizerDoctypeStates;
import ch.digitalfondue.jfiveparse.TokenizerMarkupDeclarationState;
import ch.digitalfondue.jfiveparse.TokenizerPlainAndRawTextStates;
import ch.digitalfondue.jfiveparse.TokenizerRCDataAndScriptStates;
import ch.digitalfondue.jfiveparse.TokenizerTagStates;
import ch.digitalfondue.jfiveparse.TreeConstructor;
import java.util.Locale;

class Tokenizer {
    private final TreeConstructor tokenHandler;
    private int state;
    private int additionalAllowedCharacter;
    private int previousState;
    private Attributes attributes;
    private ResizableCharBuilder currentAttributeName;
    private ResizableCharBuilder currentAttributeValue;
    private int currentAttributeQuoteType;
    private boolean selfClosing;
    private ResizableCharBuilder tagName;
    private boolean isEndTagToken;
    private ResizableCharBuilder lastEmittedStartTagName;
    private boolean doctypeForceQuirksFlag;
    private StringBuilder doctypeNameToken;
    private StringBuilder doctypePublicIdentifier;
    private StringBuilder doctypeSystemIdentifier;
    private ResizableCharBuilder commentToken;
    private ResizableCharBuilder temporaryBuffer;
    final boolean transformEntities;

    Tokenizer(TreeConstructor tokenHandler) {
        this(tokenHandler, true);
    }

    Tokenizer(TreeConstructor tokenHandler, boolean transformEntities) {
        this.tokenHandler = tokenHandler;
        this.state = 0;
        this.transformEntities = transformEntities;
    }

    void appendCurrentAttributeName(int chr) {
        this.currentAttributeName.append((char)chr);
    }

    void appendCurrentAttributeValue(int chr) {
        this.currentAttributeValue.append((char)chr);
    }

    void createTemporaryBuffer() {
        this.temporaryBuffer = new ResizableCharBuilder();
    }

    void appendToTemporaryBuffer(int chr) {
        this.temporaryBuffer.append((char)chr);
    }

    void emitTemporaryBufferAsCharacters() {
        int pos = this.temporaryBuffer.pos();
        for (int i = 0; i < pos; ++i) {
            this.tokenHandler.emitCharacter(this.temporaryBuffer.at(i));
        }
    }

    boolean isTemporaryBufferEquals(ResizableCharBuilder s) {
        return this.temporaryBuffer.equalsASCIICaseInsensitive(s);
    }

    int getState() {
        return this.state;
    }

    void setState(int state) {
        this.state = state;
    }

    void emitParseError() {
        this.tokenHandler.emitParseError();
    }

    void setStateAndEmitCharacter(int state, int chr) {
        this.state = state;
        this.tokenHandler.emitCharacter((char)chr);
    }

    void emitCharacter(int chr) {
        this.tokenHandler.emitCharacter((char)chr);
    }

    void tokenize(ProcessedInputStream processedInputStream) {
        try {
            block15: while (true) {
                switch (this.state) {
                    case 0: {
                        TokenizerCDataSectionAndDataState.handleDataState(this, processedInputStream);
                        continue block15;
                    }
                    case 1: {
                        TokenizerAttributesState.handleAttributeValueDoubleQuotedState(this, processedInputStream);
                        continue block15;
                    }
                    case 2: {
                        TokenizerAttributesState.handleAttributeNameState(this, processedInputStream);
                        continue block15;
                    }
                    case 3: {
                        TokenizerTagStates.handleTagNameState(this, processedInputStream);
                        continue block15;
                    }
                    case 4: {
                        TokenizerPlainAndRawTextStates.handleRawtextState(this, processedInputStream);
                        continue block15;
                    }
                    case 5: {
                        TokenizerRCDataAndScriptStates.handleScriptDataState(this, processedInputStream);
                        continue block15;
                    }
                    case 6: {
                        TokenizerTagStates.handleTagOpenState(this, processedInputStream);
                        continue block15;
                    }
                    case 7: {
                        TokenizerAttributesState.handleBeforeAttributeNameState(this, processedInputStream);
                        continue block15;
                    }
                    case 8: {
                        TokenizerAttributesState.handleBeforeAttributeValueState(this, processedInputStream);
                        continue block15;
                    }
                    case 9: {
                        TokenizerAttributesState.handleAfterAttributeValueQuotedState(this, processedInputStream);
                        continue block15;
                    }
                    case 10: {
                        TokenizerTagStates.handleEndTagOpenState(this, processedInputStream);
                        continue block15;
                    }
                }
                this.allStates(processedInputStream);
            }
        }
        catch (StopParse stopParse) {
            return;
        }
    }

    private void allStates(ProcessedInputStream processedInputStream) {
        switch (this.state) {
            case 0: {
                TokenizerCDataSectionAndDataState.handleDataState(this, processedInputStream);
                break;
            }
            case 11: {
                TokenizerCDataSectionAndDataState.handleCharacterReferenceInDataState(this, processedInputStream);
                break;
            }
            case 12: {
                TokenizerRCDataAndScriptStates.handleRCDataState(this, processedInputStream);
                break;
            }
            case 13: {
                TokenizerRCDataAndScriptStates.handleCharacterReferenceInRCDataState(this, processedInputStream);
                break;
            }
            case 4: {
                TokenizerPlainAndRawTextStates.handleRawtextState(this, processedInputStream);
                break;
            }
            case 5: {
                TokenizerRCDataAndScriptStates.handleScriptDataState(this, processedInputStream);
                break;
            }
            case 14: {
                TokenizerPlainAndRawTextStates.handlePlainTextState(this, processedInputStream);
                break;
            }
            case 6: {
                TokenizerTagStates.handleTagOpenState(this, processedInputStream);
                break;
            }
            case 10: {
                TokenizerTagStates.handleEndTagOpenState(this, processedInputStream);
                break;
            }
            case 3: {
                TokenizerTagStates.handleTagNameState(this, processedInputStream);
                break;
            }
            case 15: {
                TokenizerRCDataAndScriptStates.handleRCDataLessThanSignState(this, processedInputStream);
                break;
            }
            case 16: {
                TokenizerRCDataAndScriptStates.handleRCDataEndTagOpenState(this, processedInputStream);
                break;
            }
            case 17: {
                TokenizerRCDataAndScriptStates.handleRCDataEndTagNameState(this, processedInputStream);
                break;
            }
            case 18: {
                TokenizerPlainAndRawTextStates.handleRawTextLessThanSignState(this, processedInputStream);
                break;
            }
            case 19: {
                TokenizerPlainAndRawTextStates.handleRawTextEndTagOpenState(this, processedInputStream);
                break;
            }
            case 20: {
                TokenizerPlainAndRawTextStates.handleRawTextEndTagNameState(this, processedInputStream);
                break;
            }
            case 21: {
                TokenizerRCDataAndScriptStates.handleScriptDataLessThanSignState(this, processedInputStream);
                break;
            }
            case 22: {
                TokenizerRCDataAndScriptStates.handleScriptDataEndTagOpenState(this, processedInputStream);
                break;
            }
            case 23: {
                TokenizerRCDataAndScriptStates.handleScriptDataEndTagNameState(this, processedInputStream);
                break;
            }
            case 24: {
                TokenizerRCDataAndScriptStates.handleScriptDataEscapeStartState(this, processedInputStream);
                break;
            }
            case 25: {
                TokenizerRCDataAndScriptStates.handleScriptDataEscapeStartDashState(this, processedInputStream);
                break;
            }
            case 26: {
                TokenizerRCDataAndScriptStates.handleScriptDataEscapedState(this, processedInputStream);
                break;
            }
            case 27: {
                TokenizerRCDataAndScriptStates.handleScriptDataEscapedDashState(this, processedInputStream);
                break;
            }
            case 28: {
                TokenizerRCDataAndScriptStates.handleScriptDataEscapedDashDashState(this, processedInputStream);
                break;
            }
            case 29: {
                TokenizerRCDataAndScriptStates.handleScriptDataEscapedLessThanSignState(this, processedInputStream);
                break;
            }
            case 30: {
                TokenizerRCDataAndScriptStates.handleScriptDataEscapedEndTagOpenState(this, processedInputStream);
                break;
            }
            case 31: {
                TokenizerRCDataAndScriptStates.handleScriptDataEscapedEndTagNameState(this, processedInputStream);
                break;
            }
            case 32: {
                TokenizerRCDataAndScriptStates.handleScriptDataDoubleEscapeStartState(this, processedInputStream);
                break;
            }
            case 33: {
                TokenizerRCDataAndScriptStates.handleScriptDataDoubleEscapedState(this, processedInputStream);
                break;
            }
            case 34: {
                TokenizerRCDataAndScriptStates.handleScriptDataDoubleEscapedDashState(this, processedInputStream);
                break;
            }
            case 35: {
                TokenizerRCDataAndScriptStates.handleScriptDataDoubleEscapedDashDashState(this, processedInputStream);
                break;
            }
            case 36: {
                TokenizerRCDataAndScriptStates.handleScriptDataDoubleEscapedLessThanSignState(this, processedInputStream);
                break;
            }
            case 37: {
                TokenizerRCDataAndScriptStates.handleScriptDataDoubleEscapedEndState(this, processedInputStream);
                break;
            }
            case 7: {
                TokenizerAttributesState.handleBeforeAttributeNameState(this, processedInputStream);
                break;
            }
            case 2: {
                TokenizerAttributesState.handleAttributeNameState(this, processedInputStream);
                break;
            }
            case 38: {
                TokenizerAttributesState.handleAfterAttributeNameState(this, processedInputStream);
                break;
            }
            case 8: {
                TokenizerAttributesState.handleBeforeAttributeValueState(this, processedInputStream);
                break;
            }
            case 1: {
                TokenizerAttributesState.handleAttributeValueDoubleQuotedState(this, processedInputStream);
                break;
            }
            case 39: {
                TokenizerAttributesState.handleAttributeValueSingleQuotedState(this, processedInputStream);
                break;
            }
            case 40: {
                TokenizerAttributesState.handleAttributeValueUnquotedState(this, processedInputStream);
                break;
            }
            case 41: {
                TokenizerAttributesState.handleCharacterReferenceInAttributeValueState(this, processedInputStream);
                break;
            }
            case 9: {
                TokenizerAttributesState.handleAfterAttributeValueQuotedState(this, processedInputStream);
                break;
            }
            case 42: {
                TokenizerTagStates.handleSelfClosingStartTagState(this, processedInputStream);
                break;
            }
            case 43: {
                TokenizerCommentStates.handleBogusCommentState(this, processedInputStream);
                break;
            }
            case 44: {
                TokenizerMarkupDeclarationState.handleMarkupDeclarationOpenState(this, processedInputStream);
                break;
            }
            case 45: {
                TokenizerCommentStates.handleCommentStartState(this, processedInputStream);
                break;
            }
            case 46: {
                TokenizerCommentStates.handleCommentStartDashState(this, processedInputStream);
                break;
            }
            case 47: {
                TokenizerCommentStates.handleCommentState(this, processedInputStream);
                break;
            }
            case 48: {
                TokenizerCommentStates.handleCommentEndDashState(this, processedInputStream);
                break;
            }
            case 49: {
                TokenizerCommentStates.handleCommentEndState(this, processedInputStream);
                break;
            }
            case 50: {
                TokenizerCommentStates.handleCommentEndBangState(this, processedInputStream);
                break;
            }
            case 51: {
                TokenizerDoctypeStates.handleDoctypeState(this, processedInputStream);
                break;
            }
            case 52: {
                TokenizerDoctypeStates.handleBeforeDoctypeNameState(this, processedInputStream);
                break;
            }
            case 53: {
                TokenizerDoctypeStates.handleDoctypeNameState(this, processedInputStream);
                break;
            }
            case 54: {
                TokenizerDoctypeStates.handleAfterDoctypeNameState(this, processedInputStream);
                break;
            }
            case 55: {
                TokenizerDoctypeStates.handleAfterDoctypePublicKeywordState(this, processedInputStream);
                break;
            }
            case 56: {
                TokenizerDoctypeStates.handleBeforeDoctypePublicIdentifierState(this, processedInputStream);
                break;
            }
            case 57: {
                TokenizerDoctypeStates.handleDoctypePublicIdentifierDoubleQuotedState(this, processedInputStream);
                break;
            }
            case 58: {
                TokenizerDoctypeStates.handleDoctypePublicIdentifierSingleQuotedState(this, processedInputStream);
                break;
            }
            case 59: {
                TokenizerDoctypeStates.handleAfterDoctypePublicIdentifierState(this, processedInputStream);
                break;
            }
            case 60: {
                TokenizerDoctypeStates.handleBetweenDoctypePublicAndSystemIdentifiersState(this, processedInputStream);
                break;
            }
            case 61: {
                TokenizerDoctypeStates.handleAfterDoctypeSystemKeywordState(this, processedInputStream);
                break;
            }
            case 62: {
                TokenizerDoctypeStates.handleBeforeDoctypeSystemIdentifierState(this, processedInputStream);
                break;
            }
            case 63: {
                TokenizerDoctypeStates.handleDoctypeSystemIdentifierDoubleQuotedState(this, processedInputStream);
                break;
            }
            case 64: {
                TokenizerDoctypeStates.handleDoctypeSystemIdentifierSingleQuotedState(this, processedInputStream);
                break;
            }
            case 65: {
                TokenizerDoctypeStates.handleAfterDoctypeSystemIdentifierState(this, processedInputStream);
                break;
            }
            case 66: {
                TokenizerDoctypeStates.handleBogusDoctypeState(this, processedInputStream);
                break;
            }
            case 67: {
                TokenizerCDataSectionAndDataState.handleCDataSectionState(this, processedInputStream);
            }
        }
    }

    boolean isAppropriateEndTagToken() {
        return this.tagName != null && this.lastEmittedStartTagName != null && this.tagName.equalsASCIICaseInsensitive(this.lastEmittedStartTagName);
    }

    void addCurrentAttributeInAttributes() {
        try {
            if (this.currentAttributeName != null) {
                String curAttrName = this.currentAttributeName.toLowerCase();
                if (this.attributes.containsKey(curAttrName)) {
                    this.tokenHandler.emitParseError();
                } else {
                    this.attributes.put(new AttributeNode(curAttrName, this.currentAttributeName.containsUpperCase ? this.currentAttributeName.asString() : curAttrName, this.currentAttributeValue, this.currentAttributeQuoteType));
                }
            }
        }
        catch (NullPointerException npe) {
            this.tokenHandler.emitParseError();
        }
        finally {
            this.currentAttributeName = null;
            this.currentAttributeValue = null;
        }
    }

    void startNewAttributeAndAppendToName(int chr) {
        this.addCurrentAttributeInAttributes();
        this.currentAttributeName = new ResizableCharBuilder();
        this.currentAttributeValue = new ResizableCharBuilder();
        this.currentAttributeQuoteType = 40;
        this.appendCurrentAttributeName(chr);
    }

    void setAttributeQuoteType(int currentAttributeQuoteType) {
        this.currentAttributeQuoteType = currentAttributeQuoteType;
    }

    void newEndTokenTag() {
        this.tagName = new ResizableCharBuilder();
        this.isEndTagToken = true;
        this.attributes = null;
        this.currentAttributeName = null;
        this.currentAttributeValue = null;
    }

    void appendCurrentTagToken(int chr) {
        this.tagName.append((char)chr);
    }

    void createNewStartTagToken(int chr) {
        this.tagName = new ResizableCharBuilder();
        this.appendCurrentTagToken(chr);
        this.isEndTagToken = false;
        this.attributes = new Attributes();
        this.currentAttributeName = null;
        this.currentAttributeValue = null;
        this.selfClosing = false;
    }

    void addCurrentAttributeAndEmitToken() {
        this.addCurrentAttributeInAttributes();
        if (!this.isEndTagToken) {
            this.lastEmittedStartTagName = this.tagName;
        }
        this.emitTagToken();
    }

    void createNewDoctypeToken() {
        this.doctypeForceQuirksFlag = false;
        this.doctypeNameToken = new StringBuilder();
    }

    void createDoctypeSystemIdentifier() {
        this.doctypeSystemIdentifier = new StringBuilder();
    }

    void createDoctypePublicIdentifier() {
        this.doctypePublicIdentifier = new StringBuilder();
    }

    void appendDoctypeNameCharacter(int chr) {
        this.doctypeNameToken.append((char)chr);
    }

    void appendDoctypePublicIdentifier(int chr) {
        this.doctypePublicIdentifier.append((char)chr);
    }

    void appendDoctypeSystemIdentifierCharacter(int chr) {
        this.doctypeSystemIdentifier.append((char)chr);
    }

    void createNewCommentToken() {
        this.commentToken = new ResizableCharBuilder();
    }

    void appendCommentCharacter(int chr) {
        this.commentToken.append((char)chr);
    }

    void appendCommentCharacter(int chr, int chr2) {
        this.commentToken.append((char)chr);
        this.commentToken.append((char)chr2);
    }

    void setLastStartTag(ResizableCharBuilder lastStartTag) {
        this.lastEmittedStartTagName = lastStartTag;
    }

    void emitEOF() {
        this.tokenHandler.emitEOF();
    }

    void emitDoctypeToken(StringBuilder doctypeName, StringBuilder doctypePublicId, StringBuilder doctypeSystemId) {
        if (doctypeName != null) {
            doctypeName = new StringBuilder(doctypeName.toString().toLowerCase(Locale.ENGLISH));
        }
        this.tokenHandler.emitDoctypeToken(doctypeName, doctypePublicId, doctypeSystemId, !this.doctypeForceQuirksFlag);
    }

    void emitComment() {
        this.tokenHandler.emitComment(this.commentToken);
    }

    void emitComment(ResizableCharBuilder cb) {
        this.tokenHandler.emitComment(cb);
    }

    void emitTagToken() {
        if (this.selfClosing && this.isEndTagToken) {
            this.tokenHandler.emitParseError();
        }
        if (!this.isEndTagToken) {
            this.tokenHandler.emitStartTagToken(this.tagName, this.attributes, this.selfClosing);
        } else {
            this.tokenHandler.emitEndTagToken(this.tagName);
        }
    }

    int getPreviousState() {
        return this.previousState;
    }

    void setPreviousState(int previousState) {
        this.previousState = previousState;
    }

    int getAdditionalAllowedCharacter() {
        return this.additionalAllowedCharacter;
    }

    void setAdditionalAllowedCharacter(int additionalAllowedCharacter) {
        this.additionalAllowedCharacter = additionalAllowedCharacter;
    }

    Element getAdjustedCurrentNode() {
        return this.tokenHandler.getAdjustedCurrentNode();
    }

    int getTokenHandlerInsertionMode() {
        return this.tokenHandler.getInsertionMode();
    }

    boolean isTokenHandlerInHtmlContent() {
        return this.tokenHandler.isInHtmlContent();
    }

    ResizableCharBuilder getTokenHandlerInsertCharacterPreviousTextNode() {
        return this.tokenHandler.getInsertCharacterPreviousTextNode();
    }

    void resetTokenHandlerInsertCharacterPreviousTextNode() {
        this.tokenHandler.resetInsertCharacterPreviousTextNode();
    }

    void emitParseErrorAndSetState(int state) {
        this.tokenHandler.emitParseError();
        this.state = state;
    }

    void setDoctypeForceQuirksFlag(boolean doctypeForceQuirksFlag) {
        this.doctypeForceQuirksFlag = doctypeForceQuirksFlag;
    }

    StringBuilder getDoctypeNameToken() {
        return this.doctypeNameToken;
    }

    StringBuilder getDoctypePublicIdentifier() {
        return this.doctypePublicIdentifier;
    }

    StringBuilder getDoctypeSystemIdentifier() {
        return this.doctypeSystemIdentifier;
    }

    void setSelfClosing(boolean selfClosing) {
        this.selfClosing = selfClosing;
    }

    void setStartToken(String tagName, Attributes attributes) {
        this.tagName = new ResizableCharBuilder(tagName);
        this.attributes = attributes;
        this.isEndTagToken = false;
    }

    ResizableCharBuilder getCurrentAttributeValue() {
        return this.currentAttributeValue;
    }
}

