/*
 * Decompiled with CFR 0.152.
 */
package ch.digitalfondue.jfiveparse;

import ch.digitalfondue.jfiveparse.DOMTokenList;
import ch.digitalfondue.jfiveparse.Element;
import ch.digitalfondue.jfiveparse.NodeMatcher;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;

public class Selector {
    private final List<NodeMatcher> matchers = new ArrayList<NodeMatcher>();

    public static Selector select() {
        return new Selector();
    }

    public Selector element(String name) {
        this.matchers.add(node -> node.getNodeType() == 1 && name.equals(node.getNodeName()));
        return this;
    }

    public Selector universal() {
        this.matchers.add(n -> n.getNodeType() == 1);
        return this;
    }

    public Selector element(String name, String namespace) {
        this.matchers.add(node -> node.getNodeType() == 1 && name.equals(node.getNodeName()) && Objects.equals(namespace, ((Element)node).getNamespaceURI()));
        return this;
    }

    public Selector hasClass(String value) {
        return this.attrValInList("class", value);
    }

    public Selector hasClass(String value, String ... others) {
        this.hasClass(value);
        if (others != null) {
            for (String n : others) {
                this.hasClass(n);
            }
        }
        return this;
    }

    public Selector id(String value) {
        return this.attrValEq("id", value);
    }

    private static NodeMatcher matchAttr(String name, BiPredicate<String, Element> attributeValueMatcher) {
        return node -> {
            if (node.getNodeType() != 1) {
                return false;
            }
            Element elem = (Element)node;
            return elem.getAttributes().containsKey(name) && attributeValueMatcher.test(elem.getAttribute(name), elem);
        };
    }

    public Selector attr(String name) {
        this.matchers.add(Selector.matchAttr(name, (attrValue, elem) -> true));
        return this;
    }

    public Selector attrValEq(String name, String value) {
        this.matchers.add(Selector.matchAttr(name, (attrValue, elem) -> Objects.equals(attrValue, value)));
        return this;
    }

    public Selector attrValInList(String name, String value) {
        this.matchers.add(Selector.matchAttr(name, (attrValue, elem) -> new DOMTokenList((Element)elem, name).contains(value)));
        return this;
    }

    public Selector attrValStartWith(String name, String value) {
        this.matchers.add(Selector.matchAttr(name, (attrValue, elem) -> attrValue != null && value != null && attrValue.startsWith(value)));
        return this;
    }

    public Selector attrValEndWith(String name, String value) {
        this.matchers.add(Selector.matchAttr(name, (attrValue, elem) -> attrValue != null && value != null && attrValue.endsWith(value)));
        return this;
    }

    public Selector attrValContains(String name, String value) {
        this.matchers.add(Selector.matchAttr(name, (attrValue, elem) -> attrValue != null && value != null && attrValue.contains(value)));
        return this;
    }

    public Selector isFirstChild() {
        this.matchers.add(node -> node.parentNode != null && node.parentNode.getFirstChild() == node);
        return this;
    }

    public Selector isFirstElementChild() {
        this.matchers.add(node -> node.parentNode != null && node.parentNode.getFirstElementChild() == node);
        return this;
    }

    public Selector isLastChild() {
        this.matchers.add(node -> node.parentNode != null && node.parentNode.getLastChild() == node);
        return this;
    }

    public Selector isLastElementChild() {
        this.matchers.add(node -> node.parentNode != null && node.parentNode.getLastElementChild() == node);
        return this;
    }

    private List<NodeMatcher> copyAndClear() {
        ArrayList<NodeMatcher> copyMatchers = new ArrayList<NodeMatcher>(this.matchers);
        this.matchers.clear();
        return copyMatchers;
    }

    public Selector withChild() {
        NodeMatcher rules = Selector.andMatchers(this.copyAndClear());
        NodeMatcher hasParentMatching = node -> node.parentNode != null && rules.match(node.parentNode);
        this.matchers.add(hasParentMatching);
        return this;
    }

    public Selector withDescendant() {
        NodeMatcher ancestorMatcher = Selector.andMatchers(this.copyAndClear());
        NodeMatcher hasAncestorMatching = node -> {
            while (node.parentNode != null) {
                node = node.parentNode;
                if (!ancestorMatcher.match(node)) continue;
                return true;
            }
            return false;
        };
        this.matchers.add(hasAncestorMatching);
        return this;
    }

    private static NodeMatcher andMatchers(List<NodeMatcher> nodeMatchers) {
        return node -> {
            for (NodeMatcher m : nodeMatchers) {
                if (m.match(node)) continue;
                return false;
            }
            return true;
        };
    }

    public NodeMatcher toMatcher() {
        return this.matchers.size() == 1 ? this.matchers.get(0) : Selector.andMatchers(this.matchers);
    }
}

