/*
 * Decompiled with CFR 0.152.
 */
package ch.digitalfondue.jfiveparse;

import java.util.Arrays;

class ResizableIntBuffer {
    private int[] buff = new int[32];
    private int start = 15;
    private int pos = 15;
    boolean isEmpty = true;

    ResizableIntBuffer() {
    }

    void addFirst(int c) {
        if (this.start == 0) {
            this.resizeForStart();
        }
        this.buff[--this.start] = c;
        this.isEmpty = false;
    }

    private void resizeForStart() {
        int[] buffNew = new int[this.buff.length * 2];
        System.arraycopy(this.buff, 0, buffNew, this.buff.length, this.buff.length);
        this.start += this.buff.length;
        this.pos += this.buff.length;
        this.buff = buffNew;
    }

    void add(int c) {
        if (this.pos == this.buff.length) {
            this.resizeForEnd();
        }
        this.buff[this.pos++] = c;
        this.isEmpty = false;
    }

    private void resizeForEnd() {
        this.buff = Arrays.copyOf(this.buff, this.buff.length * 2 + 2);
    }

    int getCharAt(int offset) {
        return this.buff[this.start + offset - 1];
    }

    int length() {
        return this.pos - this.start;
    }

    int removeFirst() {
        int chr = this.buff[this.start++];
        this.isEmpty = this.length() == 0;
        return chr;
    }
}

