/*
 * Decompiled with CFR 0.152.
 */
package ch.digitalfondue.jfiveparse;

import ch.digitalfondue.jfiveparse.Common;
import java.util.Arrays;

class ResizableCharBuilder {
    private char[] buff;
    private int pos = 0;
    boolean containsUpperCase;

    ResizableCharBuilder() {
        this.buff = new char[16];
    }

    ResizableCharBuilder(String s) {
        this.buff = s.toCharArray();
        this.pos = this.buff.length;
    }

    char at(int i) {
        return this.buff[i];
    }

    int pos() {
        return this.pos;
    }

    void append(char c) {
        try {
            this.buff[this.pos++] = c;
        }
        catch (IndexOutOfBoundsException e) {
            this.buff = Arrays.copyOf(this.buff, this.buff.length * 2 + 2);
            this.buff[this.pos - 1] = c;
        }
    }

    String toLowerCase() {
        this.containsUpperCase = false;
        for (char c : this.buff) {
            if (!Common.isUpperCaseASCIILetter(c)) continue;
            this.containsUpperCase = true;
            break;
        }
        if (this.containsUpperCase) {
            return this.lowerCaseInternal();
        }
        return this.asString();
    }

    private String lowerCaseInternal() {
        char[] newBuff = Arrays.copyOf(this.buff, this.pos);
        for (int i = 0; i < this.pos; ++i) {
            if (!Common.isUpperCaseASCIILetter(newBuff[i])) continue;
            int n = i;
            newBuff[n] = (char)(newBuff[n] + 32);
        }
        return new String(newBuff);
    }

    String asString() {
        return new String(this.buff, 0, this.pos);
    }

    public String toString() {
        return this.asString();
    }

    boolean equalsASCIICaseInsensitive(ResizableCharBuilder cb) {
        if (this.pos != cb.pos) {
            return false;
        }
        for (int i = 0; i < this.pos; ++i) {
            if (Common.toLowerCase(this.buff[i]) == Common.toLowerCase(cb.buff[i])) continue;
            return false;
        }
        return true;
    }
}

