/*
 * Decompiled with CFR 0.152.
 */
package ch.digitalfondue.jfiveparse;

import ch.digitalfondue.jfiveparse.ParserException;
import ch.digitalfondue.jfiveparse.ResizableIntBuffer;
import java.io.IOException;
import java.io.Reader;

abstract class ProcessedInputStream {
    private boolean crFound;
    protected final ResizableIntBuffer buffer = new ResizableIntBuffer();

    ProcessedInputStream() {
    }

    protected abstract int read();

    protected int getCharAt(int position) {
        throw new IllegalArgumentException();
    }

    private int readWithCRHandling(boolean crFoundInternal, int chr) {
        if (crFoundInternal) {
            chr = this.handleCrFoundInternal(chr);
        }
        if (chr == 13) {
            chr = this.handleChrIsCR();
        }
        return chr;
    }

    private int handleChrIsCR() {
        this.crFound = true;
        return 10;
    }

    private int handleCrFoundInternal(int chr) {
        this.crFound = false;
        if (chr == 10) {
            chr = this.read();
        }
        return chr;
    }

    int peekNextInputCharacter(int offset) {
        if (this.buffer.length() < offset) {
            for (int i = this.buffer.length(); i < offset; ++i) {
                this.buffer.add(this.readWithCRHandling(this.crFound, this.read()));
            }
        }
        return this.buffer.getCharAt(offset);
    }

    int getNextInputCharacterAndConsume() {
        return this.consume();
    }

    int consume() {
        return !this.buffer.isEmpty ? this.buffer.removeFirst() : this.readWithCRHandling(this.crFound, this.read());
    }

    int getNextInputCharacter() {
        return this.peekNextInputCharacter(1);
    }

    void reconsume(int chr) {
        this.buffer.addFirst(chr);
    }

    void consume(int count) {
        for (int i = 0; i < count; ++i) {
            this.consume();
        }
    }

    static final class ReaderProcessedInputStream
    extends ProcessedInputStream {
        private final Reader reader;

        ReaderProcessedInputStream(Reader reader) {
            this.reader = reader;
        }

        @Override
        protected int read() {
            try {
                return this.reader.read();
            }
            catch (IOException ioe) {
                throw new ParserException(ioe);
            }
        }
    }

    static class StringProcessedInputStream
    extends ProcessedInputStream {
        private int pos = 0;
        private final char[] input;

        StringProcessedInputStream(String input) {
            this.input = input.toCharArray();
        }

        @Override
        protected int read() {
            try {
                return this.input[this.pos++];
            }
            catch (IndexOutOfBoundsException s) {
                return -1;
            }
        }

        @Override
        protected int getCharAt(int position) {
            try {
                return this.input[position];
            }
            catch (IndexOutOfBoundsException s) {
                return -1;
            }
        }
    }
}

