/*
 * Decompiled with CFR 0.152.
 */
package ch.digitalfondue.jfiveparse;

import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;

class Prefix {
    char c;
    char[] chars;
    private TreeMap<Character, Prefix> tmpChilds;
    private int offset;
    private Prefix[] childsCompacted;
    private final Prefix parent;

    Prefix(Prefix prefix) {
        this.parent = prefix;
    }

    void compact() {
        if (this.childsCompacted == null && this.tmpChilds != null) {
            this.offset = this.tmpChilds.firstKey().charValue();
            this.childsCompacted = new Prefix[this.tmpChilds.lastKey().charValue() - this.offset + 1];
            for (Map.Entry entry : this.tmpChilds.entrySet()) {
                this.childsCompacted[((Character)entry.getKey()).charValue() - this.offset] = (Prefix)entry.getValue();
            }
        }
        this.tmpChilds = null;
        if (this.childsCompacted != null) {
            for (Prefix p : this.childsCompacted) {
                if (p == null) continue;
                p.compact();
            }
        }
    }

    String getString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.c);
        Prefix p = this.parent;
        while (p != null) {
            sb.append(p.c);
            p = p.parent;
        }
        return sb.reverse().toString();
    }

    Prefix getMaybeCompleteParent() {
        Prefix p = this.parent;
        while (p != null) {
            if (p.isComplete()) {
                return p;
            }
            p = p.parent;
        }
        return null;
    }

    void addWord(String s, int[] codepoints) {
        this.c = s.charAt(0);
        if (s.length() == 1) {
            ArrayList<Character> l = new ArrayList<Character>();
            for (int codePoint : codepoints) {
                for (char chr : Character.toChars(codePoint)) {
                    l.add(Character.valueOf(chr));
                }
            }
            this.chars = new char[l.size()];
            for (int i = 0; i < l.size(); ++i) {
                this.chars[i] = ((Character)l.get(i)).charValue();
            }
        } else {
            char nextVal = s.charAt(1);
            if (this.tmpChilds == null) {
                this.tmpChilds = new TreeMap();
            }
            if (!this.tmpChilds.containsKey(Character.valueOf(nextVal))) {
                this.tmpChilds.put(Character.valueOf(nextVal), new Prefix(this));
            }
            this.tmpChilds.get(Character.valueOf(nextVal)).addWord(s.substring(1), codepoints);
        }
    }

    boolean isComplete() {
        return this.chars != null;
    }

    Prefix getNode(char c) {
        if (this.childsCompacted != null) {
            int idx = c - this.offset;
            if (idx < 0 || idx >= this.childsCompacted.length) {
                return null;
            }
            return this.childsCompacted[idx];
        }
        return null;
    }
}

