/*
 * Decompiled with CFR 0.152.
 */
package ch.digitalfondue.jfiveparse;

import ch.digitalfondue.jfiveparse.Common;
import ch.digitalfondue.jfiveparse.Document;
import ch.digitalfondue.jfiveparse.Element;
import ch.digitalfondue.jfiveparse.Node;
import ch.digitalfondue.jfiveparse.Option;
import ch.digitalfondue.jfiveparse.ProcessedInputStream;
import ch.digitalfondue.jfiveparse.Tokenizer;
import ch.digitalfondue.jfiveparse.TreeConstructor;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class Parser {
    private final boolean scriptingFlag;
    private final boolean transformEntities;
    private final boolean disableIgnoreTokenInBodyStartTag;
    private final boolean interpretSelfClosingAnythingElse;

    public Parser() {
        this.scriptingFlag = true;
        this.transformEntities = true;
        this.disableIgnoreTokenInBodyStartTag = false;
        this.interpretSelfClosingAnythingElse = false;
    }

    public Parser(Set<Option> options) {
        this.scriptingFlag = !options.contains((Object)Option.SCRIPTING_DISABLED);
        this.transformEntities = !options.contains((Object)Option.DONT_TRANSFORM_ENTITIES);
        this.disableIgnoreTokenInBodyStartTag = options.contains((Object)Option.DISABLE_IGNORE_TOKEN_IN_BODY_START_TAG);
        this.interpretSelfClosingAnythingElse = options.contains((Object)Option.INTERPRET_SELF_CLOSING_ANYTHING_ELSE);
    }

    public Document parse(String input) {
        return this.parse(new ProcessedInputStream.StringProcessedInputStream(input));
    }

    public Document parse(Reader input) {
        return this.parse(new ProcessedInputStream.ReaderProcessedInputStream(input));
    }

    public List<Node> parseFragment(Element node, String input) {
        return this.parseFragment(new ProcessedInputStream.StringProcessedInputStream(input), node);
    }

    public List<Node> parseFragment(Element node, Reader input) {
        return this.parseFragment(new ProcessedInputStream.ReaderProcessedInputStream(input), node);
    }

    private List<Node> parseFragment(ProcessedInputStream is, Element node) {
        TreeConstructor tokenHandler = new TreeConstructor(this.disableIgnoreTokenInBodyStartTag, this.interpretSelfClosingAnythingElse);
        tokenHandler.setHtmlFragmentParsing(true);
        tokenHandler.setScriptingFlag(this.scriptingFlag);
        Tokenizer tokenizer = new Tokenizer(tokenHandler, this.transformEntities);
        tokenHandler.setTokenizer(tokenizer);
        byte namespaceID = node.namespaceID;
        String name = node.nodeName;
        if (1 == namespaceID) {
            if ("title".equals(name) || "textarea".equals(name)) {
                tokenizer.setState(12);
            } else if ("style".equals(name) || "xmp".equals(name) || "iframe".equals(name) || "noembed".equals(name) || "noframes".equals(name)) {
                tokenizer.setState(4);
            } else if ("script".equals(name)) {
                tokenizer.setState(5);
            } else if ("noscript".equals(name) && this.scriptingFlag) {
                tokenizer.setState(4);
            } else if ("plaintext".equals(name)) {
                tokenizer.setState(14);
            } else {
                tokenizer.setState(0);
            }
        } else {
            tokenizer.setState(0);
        }
        Element root = TreeConstructor.buildElement("html", (byte)41, "html", "http://www.w3.org/1999/xhtml", (byte)1, null);
        tokenHandler.setContext(node);
        tokenHandler.getDocument().appendChild(root);
        tokenHandler.addToOpenElements(root);
        if (Common.isHtmlNS(node, (byte)71)) {
            tokenHandler.pushIntoStackTemplatesInsertionMode(17);
        }
        tokenizer.setStartToken(node.getNodeName(), node.getAttributes().copy());
        tokenHandler.resetInsertionModeAppropriately();
        tokenHandler.setForm(Parser.getFirstFormElementFrom(node));
        tokenizer.tokenize(is);
        return new ArrayList<Node>(root.getChildNodes());
    }

    private static Element getFirstFormElementFrom(Node element) {
        while (element != null) {
            if (element instanceof Element && Common.isHtmlNS((Element)element, (byte)28)) {
                return (Element)element;
            }
            element = element.parentNode;
        }
        return null;
    }

    private Document parse(ProcessedInputStream is) {
        TreeConstructor tokenHandler = new TreeConstructor(this.disableIgnoreTokenInBodyStartTag, this.interpretSelfClosingAnythingElse);
        tokenHandler.setScriptingFlag(this.scriptingFlag);
        Tokenizer tokenizer = new Tokenizer(tokenHandler, this.transformEntities);
        tokenHandler.setTokenizer(tokenizer);
        tokenizer.tokenize(is);
        return tokenHandler.getDocument();
    }
}

