/*
 * Decompiled with CFR 0.152.
 */
package ch.digitalfondue.jfiveparse;

import ch.digitalfondue.jfiveparse.Element;
import ch.digitalfondue.jfiveparse.NodeMatcher;
import ch.digitalfondue.jfiveparse.NodeMatchers;
import ch.digitalfondue.jfiveparse.NodesVisitor;
import ch.digitalfondue.jfiveparse.Selector;
import ch.digitalfondue.jfiveparse.Text;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public abstract class Node {
    private static final List<Node> EMPTY_LIST = List.of();
    Node parentNode;
    public static final String NAMESPACE_HTML = "http://www.w3.org/1999/xhtml";
    static final byte NAMESPACE_HTML_ID = 1;
    public static final String NAMESPACE_SVG = "http://www.w3.org/2000/svg";
    static final byte NAMESPACE_SVG_ID = 2;
    public static final String NAMESPACE_MATHML = "http://www.w3.org/1998/Math/MathML";
    static final byte NAMESPACE_MATHML_ID = 3;
    public static final String NAMESPACE_XMLNS = "http://www.w3.org/2000/xmlns/";
    static final byte NAMESPACE_XMLNS_ID = 4;
    public static final String NAMESPACE_XML = "http://www.w3.org/XML/1998/namespace";
    static final byte NAMESPACE_XML_ID = 5;
    public static final String NAMESPACE_XLINK = "http://www.w3.org/1999/xlink";
    static final byte NAMESPACE_XLINK_ID = 6;
    public static final byte ELEMENT_NODE = 1;
    public static final byte TEXT_NODE = 3;
    public static final byte COMMENT_NODE = 8;
    public static final byte DOCUMENT_NODE = 9;
    public static final byte DOCUMENT_TYPE_NODE = 10;

    static byte toNameSpaceId(String s) {
        if (s == null) {
            return 0;
        }
        switch (s) {
            case "http://www.w3.org/1999/xhtml": {
                return 1;
            }
            case "http://www.w3.org/2000/svg": {
                return 2;
            }
            case "http://www.w3.org/1998/Math/MathML": {
                return 3;
            }
            case "http://www.w3.org/2000/xmlns/": {
                return 4;
            }
            case "http://www.w3.org/XML/1998/namespace": {
                return 5;
            }
            case "http://www.w3.org/1999/xlink": {
                return 6;
            }
        }
        return 0;
    }

    public abstract byte getNodeType();

    public abstract String getNodeName();

    public Node getParentNode() {
        return this.parentNode;
    }

    List<Node> getMutableChildNodes() {
        return EMPTY_LIST;
    }

    public void empty() {
        List<Node> childs = this.getMutableChildNodes();
        if (childs == EMPTY_LIST) {
            return;
        }
        for (Node n : childs) {
            n.parentNode = null;
        }
        childs.clear();
    }

    public int getChildCount() {
        return this.getMutableChildNodes().size();
    }

    public void appendChild(Node node) {
        Objects.requireNonNull(node);
        List<Node> childs = this.getMutableChildNodes();
        if (childs == EMPTY_LIST) {
            return;
        }
        if (node.parentNode == this) {
            childs.remove(node);
            node.parentNode = null;
        }
        this.insertChildren(childs.size(), node);
    }

    public void insertChildren(int position, Node node) {
        Objects.requireNonNull(node);
        List<Node> childs = this.getMutableChildNodes();
        if (childs == EMPTY_LIST) {
            return;
        }
        Node previousParent = node.parentNode;
        node.parentNode = this;
        if (position == childs.size()) {
            childs.add(node);
        } else {
            childs.add(position, node);
        }
        if (previousParent != null) {
            previousParent.getMutableChildNodes().remove(node);
        }
    }

    public void insertBefore(Node toInsert, Node before) {
        Objects.requireNonNull(toInsert);
        Objects.requireNonNull(before);
        int idx = this.getChildNodes().indexOf(before);
        if (idx >= 0) {
            this.insertChildren(idx, toInsert);
        }
    }

    public void replaceChild(Node node, Node oldChild) {
        Objects.requireNonNull(node);
        Objects.requireNonNull(oldChild);
        List<Node> childs = this.getMutableChildNodes();
        if (childs == EMPTY_LIST) {
            return;
        }
        int idx = childs.indexOf(oldChild);
        if (idx >= 0) {
            Node previousParent = node.parentNode;
            node.parentNode = this;
            childs.set(idx, node);
            if (previousParent != null) {
                previousParent.getMutableChildNodes().remove(node);
            }
            oldChild.parentNode = null;
        }
    }

    public void removeChild(Node node) {
        Objects.requireNonNull(node);
        List<Node> childs = this.getMutableChildNodes();
        if (childs == EMPTY_LIST) {
            return;
        }
        if (childs.remove(node)) {
            node.parentNode = null;
        }
    }

    public List<Node> getChildNodes() {
        return EMPTY_LIST;
    }

    public Node getFirstChild() {
        List<Node> childs = this.getChildNodes();
        return childs.isEmpty() ? null : childs.get(0);
    }

    public Node getLastChild() {
        List<Node> childs = this.getChildNodes();
        return childs.isEmpty() ? null : childs.get(childs.size() - 1);
    }

    public Element getFirstElementChild() {
        List<Node> childs = this.getChildNodes();
        for (Node n : childs) {
            if (n.getNodeType() != 1) continue;
            return (Element)n;
        }
        return null;
    }

    public Element getLastElementChild() {
        List<Node> childs = this.getChildNodes();
        for (int i = childs.size() - 1; i >= 0; --i) {
            Node n = childs.get(i);
            if (n.getNodeType() != 1) continue;
            return (Element)n;
        }
        return null;
    }

    public Node getPreviousSibling() {
        if (this.parentNode == null) {
            return null;
        }
        List<Node> siblings = this.parentNode.getChildNodes();
        int currentElemIdx = siblings.indexOf(this);
        return currentElemIdx == 0 ? null : siblings.get(currentElemIdx - 1);
    }

    public Element getPreviousElementSibling() {
        for (Node n = this.getPreviousSibling(); n != null; n = n.getPreviousSibling()) {
            if (n.getNodeType() != 1) continue;
            return (Element)n;
        }
        return null;
    }

    public Node getNextSibling() {
        if (this.parentNode == null) {
            return null;
        }
        List<Node> siblings = this.parentNode.getChildNodes();
        int currentElemIdx = siblings.indexOf(this);
        return currentElemIdx == siblings.size() - 1 ? null : siblings.get(currentElemIdx + 1);
    }

    public Element getNextElementSibling() {
        for (Node n = this.getNextSibling(); n != null; n = n.getNextSibling()) {
            if (n.getNodeType() != 1) continue;
            return (Element)n;
        }
        return null;
    }

    public boolean hasChildNodes() {
        return !this.getChildNodes().isEmpty();
    }

    public void traverse(NodesVisitor visitor) {
        Node node = this.getFirstChild();
        while (node != null) {
            visitor.start(node);
            if (visitor.complete()) {
                return;
            }
            if (node.hasChildNodes()) {
                node = node.getFirstChild();
                continue;
            }
            while (node != this && node.getNextSibling() == null) {
                visitor.end(node);
                if (visitor.complete()) {
                    return;
                }
                node = node.getParentNode();
            }
            if (node == this) break;
            visitor.end(node);
            if (visitor.complete()) {
                return;
            }
            node = node.getNextSibling();
        }
    }

    public void traverseWithCurrentNode(NodesVisitor visitor) {
        visitor.start(this);
        this.traverse(visitor);
        visitor.end(this);
    }

    public <T extends Node> List<T> getAllNodesMatching(NodeMatcher matcher) {
        return this.getAllNodesMatching(matcher, false);
    }

    public <T extends Node> List<T> getAllNodesMatching(NodeMatcher matcher, boolean onlyFirstMatch) {
        ArrayList l = new ArrayList();
        this.traverse(new NodeMatchers(matcher, l, onlyFirstMatch));
        return l;
    }

    public List<Element> getElementsByTagName(String name) {
        return this.getAllNodesMatching(Selector.select().element(name).toMatcher());
    }

    public List<Element> getElementsByTagNameNS(String name, String namespace) {
        return this.getAllNodesMatching(Selector.select().element(name, namespace).toMatcher());
    }

    public Element getElementById(String idValue) {
        List l = this.getAllNodesMatching(Selector.select().id(idValue).toMatcher(), true);
        return l.isEmpty() ? null : (Element)l.get(0);
    }

    public boolean contains(Node node) {
        return !this.getAllNodesMatching(n -> n == node, true).isEmpty();
    }

    public String getTextContent() {
        if (this.getNodeType() == 3) {
            return ((Text)this).getData();
        }
        List textNodes = this.getAllNodesMatching(node -> node.getNodeType() == 3);
        StringBuilder sb = new StringBuilder();
        for (Text n : textNodes) {
            sb.append(n.getData());
        }
        return sb.toString();
    }

    public void normalize() {
        ArrayList<Node> childs = new ArrayList<Node>(this.getChildNodes());
        Node text = null;
        StringBuilder concatenatedText = null;
        for (Node n : childs) {
            if (text == null && n.getNodeType() == 3) {
                text = n;
                concatenatedText = new StringBuilder();
                concatenatedText.append(((Text)n).getData());
                continue;
            }
            if (text != null && n.getNodeType() == 3) {
                concatenatedText.append(((Text)n).getData());
                this.removeChild(n);
                continue;
            }
            if (text != null) {
                this.replaceTextNodeWith(text, concatenatedText);
                text = null;
                n.normalize();
                continue;
            }
            n.normalize();
        }
        if (concatenatedText != null) {
            this.replaceTextNodeWith(text, concatenatedText);
        }
    }

    public Node cloneNode() {
        return this.cloneNode(false);
    }

    public boolean isSameNode(Node other) {
        return this == other;
    }

    public abstract Node cloneNode(boolean var1);

    public abstract boolean isEqualNode(Node var1);

    static boolean nodesEquals(Node a, Node b) {
        if (a != null && b != null) {
            return a.isEqualNode(b);
        }
        return a == null && b == null;
    }

    private void replaceTextNodeWith(Node text, StringBuilder concatenatedText) {
        if (concatenatedText.length() == 0) {
            this.removeChild(text);
        } else {
            this.replaceChild(new Text(concatenatedText.toString()), text);
        }
    }
}

