/*
 * Decompiled with CFR 0.152.
 */
package ch.digitalfondue.jfiveparse;

import ch.digitalfondue.jfiveparse.AttributeNode;
import ch.digitalfondue.jfiveparse.Comment;
import ch.digitalfondue.jfiveparse.Common;
import ch.digitalfondue.jfiveparse.DocumentType;
import ch.digitalfondue.jfiveparse.Element;
import ch.digitalfondue.jfiveparse.Node;
import ch.digitalfondue.jfiveparse.NodesVisitor;
import ch.digitalfondue.jfiveparse.Option;
import ch.digitalfondue.jfiveparse.Text;
import java.io.IOException;
import java.io.Writer;
import java.util.EnumSet;
import java.util.Set;

public class HtmlSerializer
implements NodesVisitor {
    protected final Appendable appendable;
    protected final boolean transformEntities;
    protected final boolean hideEmptyAttributeValue;
    protected final boolean scriptingDisabled;
    protected final boolean printOriginalAttributeQuote;
    protected final boolean printOriginalAttributeCase;
    protected final boolean printOriginalTagName;

    public HtmlSerializer(Appendable appendable, Set<Option> options) {
        this.appendable = appendable;
        this.transformEntities = !options.contains((Object)Option.DONT_TRANSFORM_ENTITIES);
        this.hideEmptyAttributeValue = options.contains((Object)Option.HIDE_EMPTY_ATTRIBUTE_VALUE);
        this.scriptingDisabled = options.contains((Object)Option.SCRIPTING_DISABLED);
        this.printOriginalAttributeQuote = options.contains((Object)Option.PRINT_ORIGINAL_ATTRIBUTE_QUOTE);
        this.printOriginalAttributeCase = options.contains((Object)Option.PRINT_ORIGINAL_ATTRIBUTES_CASE);
        this.printOriginalTagName = options.contains((Object)Option.PRINT_ORIGINAL_TAG_CASE);
    }

    protected String serializeAttributeName(AttributeNode attribute) {
        String lowercaseName = attribute.getName();
        String name = this.printOriginalAttributeCase ? attribute.originalName : lowercaseName;
        String namespace = attribute.getNamespace();
        if ("http://www.w3.org/XML/1998/namespace".equals(namespace)) {
            return "xml:" + name;
        }
        if ("http://www.w3.org/2000/xmlns/".equals(namespace)) {
            return "xmlns".equals(lowercaseName) ? "xmlns" : "xmlns:" + name;
        }
        if ("http://www.w3.org/1999/xlink".equals(namespace)) {
            return "xlink:" + name;
        }
        if (namespace != null) {
            return namespace + ":" + name;
        }
        return name;
    }

    protected String quoteCharacters(AttributeNode attribute) {
        if (this.printOriginalAttributeQuote) {
            if (attribute.attributeQuoteType == 40) {
                return "";
            }
            if (attribute.attributeQuoteType == 39) {
                return "'";
            }
        }
        return "\"";
    }

    protected String escapeAttributeValue(AttributeNode attribute) {
        String s = attribute.getValue();
        if (s != null) {
            if (this.transformEntities) {
                s = s.replace("&", "&amp;").replace("\"", "&quot;");
            }
            s = s.replace(Character.valueOf('\u00a0').toString(), "&nbsp;");
        }
        return s;
    }

    protected String escapeTextData(String s) {
        if (s != null) {
            if (this.transformEntities) {
                s = s.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;");
            }
            s = s.replace(Character.valueOf('\u00a0').toString(), "&nbsp;");
        }
        return s;
    }

    protected static boolean skipEndTag(Element e) {
        return 1 == e.namespaceID && Common.isNoEndTag(e.getNodeName());
    }

    @Override
    public void start(Node node) {
        try {
            if (node.getNodeType() == 1) {
                String text;
                Element e = (Element)node;
                this.appendable.append('<').append(this.getNodeName(e));
                for (AttributeNode attr : e.getAttributes()) {
                    this.appendable.append(' ').append(this.serializeAttributeName(attr));
                    if ((this.hideEmptyAttributeValue || this.printOriginalAttributeQuote && attr.attributeQuoteType == 40) && (attr.getValue() == null || attr.getValue().isEmpty())) continue;
                    this.appendable.append('=').append(this.quoteCharacters(attr)).append(this.escapeAttributeValue(attr)).append(this.quoteCharacters(attr));
                }
                this.appendable.append('>');
                if ((Common.isHtmlNS(e, (byte)61) || Common.isHtmlNS(e, (byte)72) || Common.isHtmlNS(e, (byte)47)) && e.hasChildNodes() && e.getFirstChild().getNodeType() == 3 && (text = ((Text)e.getFirstChild()).getData()).length() > 0 && text.charAt(0) == '\n') {
                    this.appendable.append('\n');
                }
            } else if (node.getNodeType() == 3) {
                Node parent = node.getParentNode();
                boolean literalAppend = false;
                if (parent != null && parent.getNodeType() == 1) {
                    Element p = (Element)parent;
                    literalAppend = 1 == p.namespaceID && (Common.isTextNodeParent(p.getNodeName()) || "noscript".equals(p.getNodeName()) && !this.scriptingDisabled);
                }
                Text t = (Text)node;
                this.appendable.append(literalAppend ? t.getData() : this.escapeTextData(t.getData()));
            } else if (node.getNodeType() == 8) {
                this.appendable.append("<!--").append(((Comment)node).getData()).append("-->");
            } else if (node.getNodeType() == 10) {
                this.appendable.append("<!DOCTYPE ").append(((DocumentType)node).getName()).append('>');
            }
        }
        catch (IOException ioe) {
            throw new SerializationException(ioe);
        }
    }

    protected String getNodeName(Element e) {
        return this.printOriginalTagName ? e.originalNodeName : e.getNodeName();
    }

    @Override
    public void end(Node node) {
        try {
            Element e;
            if (node.getNodeType() == 1 && !HtmlSerializer.skipEndTag(e = (Element)node)) {
                this.appendable.append("</").append(this.getNodeName(e)).append(">");
            }
        }
        catch (IOException ioe) {
            throw new SerializationException(ioe);
        }
    }

    public static void serialize(Node node, Writer writer) throws IOException {
        HtmlSerializer.serialize(node, EnumSet.noneOf(Option.class), writer);
    }

    public static void serialize(Node node, Set<Option> options, Writer writer) throws IOException {
        node.traverseWithCurrentNode(new HtmlSerializer(writer, options));
        writer.flush();
    }

    public static String serialize(Node node) {
        return HtmlSerializer.serialize(node, EnumSet.noneOf(Option.class));
    }

    public static String serialize(Node node, Set<Option> options) {
        StringBuilder sb = new StringBuilder();
        node.traverseWithCurrentNode(new HtmlSerializer(sb, options));
        return sb.toString();
    }

    @Override
    public boolean complete() {
        return false;
    }

    public static class SerializationException
    extends RuntimeException {
        private static final long serialVersionUID = -2182908125163112627L;

        public SerializationException(Throwable t) {
            super(t);
        }
    }
}

