/*
 * Decompiled with CFR 0.152.
 */
package ch.digitalfondue.jfiveparse;

import ch.digitalfondue.jfiveparse.AttributeNode;
import ch.digitalfondue.jfiveparse.Attributes;
import ch.digitalfondue.jfiveparse.Common;
import ch.digitalfondue.jfiveparse.DOMTokenList;
import ch.digitalfondue.jfiveparse.HtmlSerializer;
import ch.digitalfondue.jfiveparse.Node;
import ch.digitalfondue.jfiveparse.Option;
import ch.digitalfondue.jfiveparse.Parser;
import ch.digitalfondue.jfiveparse.Text;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;

public class Element
extends Node {
    final String nodeName;
    final String originalNodeName;
    final String namespaceURI;
    final byte namespaceID;
    final byte nodeNameID;
    Attributes attributes;
    private List<Node> childNodes = null;

    public Element(String name) {
        this(name, "http://www.w3.org/1999/xhtml");
    }

    public Element(String name, String nameSpace) {
        this(name, nameSpace, null);
    }

    public Element(String name, String nameSpace, Attributes attributes) {
        this(name, Common.tagNameToID(name), name, nameSpace, Node.toNameSpaceId(nameSpace), attributes);
    }

    Element(String name, byte nameID, String originalName, String nameSpace, byte namespaceID, Attributes attributes) {
        this.nodeName = name;
        this.nodeNameID = nameID;
        this.originalNodeName = originalName;
        this.namespaceURI = nameSpace;
        this.namespaceID = namespaceID;
        this.attributes = attributes;
    }

    private void ensureAttributesPresence() {
        if (this.attributes == null) {
            this.attributes = new Attributes();
        }
    }

    @Override
    public List<Node> getChildNodes() {
        return this.childNodes == null ? List.of() : Collections.unmodifiableList(this.childNodes);
    }

    @Override
    List<Node> getMutableChildNodes() {
        if (this.childNodes == null) {
            this.childNodes = new ArrayList<Node>(2);
        }
        return this.childNodes;
    }

    @Override
    public byte getNodeType() {
        return 1;
    }

    @Override
    public String getNodeName() {
        return this.nodeName;
    }

    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    void setInnerHtml(List<Node> nodes) {
        this.empty();
        for (Node n : nodes) {
            this.appendChild(n);
        }
    }

    private Node insertAdjacentNode(String position, Node node) {
        Objects.requireNonNull(position, "position must be not null");
        position = position.toLowerCase(Locale.ENGLISH);
        Node parentNode = this.getParentNode();
        switch (position) {
            case "beforebegin": {
                if (parentNode == null) {
                    throw new IllegalStateException("The element has no parent. Cannot use beforebegin.");
                }
                parentNode.insertBefore(node, this);
                break;
            }
            case "afterbegin": {
                Node firstChild = this.getFirstChild();
                this.insertBefore(node, firstChild);
                break;
            }
            case "beforeend": {
                this.appendChild(node);
                break;
            }
            case "afterend": {
                if (parentNode == null) {
                    throw new IllegalStateException("The element has no parent. Cannot use afterend.");
                }
                node.parentNode = parentNode;
                List<Node> parentChildNodes = parentNode.getMutableChildNodes();
                parentChildNodes.addAll(parentChildNodes.indexOf(this) + 1, Collections.singletonList(node));
                break;
            }
            default: {
                throw new IllegalStateException("The position provided ('" + position + "') is not one of 'beforeBegin', 'afterBegin', 'beforeEnd', or 'afterEnd'.");
            }
        }
        return node;
    }

    public Element insertAdjacentElement(String position, Element element) {
        return (Element)this.insertAdjacentNode(position, element);
    }

    public void insertAdjacentText(String position, String text) {
        this.insertAdjacentNode(position, new Text(text));
    }

    public void insertAdjacentHTML(String position, String text) {
        Objects.requireNonNull(position, "position must be not null");
        position = position.toLowerCase(Locale.ENGLISH);
        Parser parser = new Parser();
        Node parentNode = this.getParentNode();
        switch (position) {
            case "beforebegin": {
                if (parentNode == null) {
                    throw new IllegalStateException("The element has no parent. Cannot use beforebegin.");
                }
                for (Node node : parser.parseFragment((Element)parentNode, text)) {
                    parentNode.insertBefore(node, this);
                }
                break;
            }
            case "afterbegin": {
                Node firstChild = this.getFirstChild();
                for (Node node : parser.parseFragment(this, text)) {
                    this.insertBefore(node, firstChild);
                }
                break;
            }
            case "beforeend": {
                for (Node node : parser.parseFragment(this, text)) {
                    this.appendChild(node);
                }
                break;
            }
            case "afterend": {
                if (parentNode == null) {
                    throw new IllegalStateException("The element has no parent. Cannot use afterend.");
                }
                List<Node> newNodeList = parser.parseFragment((Element)parentNode, text);
                for (Node node : newNodeList) {
                    node.parentNode = parentNode;
                }
                List<Node> parentChildNodes = parentNode.getMutableChildNodes();
                parentChildNodes.addAll(parentChildNodes.indexOf(this) + 1, newNodeList);
                break;
            }
            default: {
                throw new IllegalStateException("The position provided ('" + position + "') is not one of 'beforeBegin', 'afterBegin', 'beforeEnd', or 'afterEnd'.");
            }
        }
    }

    public void setInnerHTML(String html) {
        this.setInnerHtml(new Parser().parseFragment(this, html));
    }

    public Attributes getAttributes() {
        this.ensureAttributesPresence();
        return this.attributes;
    }

    public String getAttribute(String name) {
        return this.attributes != null ? this.attributes.getNamedItem(Common.convertToAsciiLowerCase(name)) : null;
    }

    public AttributeNode getAttributeNode(String name) {
        return this.attributes != null ? this.attributes.get(Common.convertToAsciiLowerCase(name)) : null;
    }

    public void setAttribute(String name, String value) {
        this.ensureAttributesPresence();
        this.attributes.put(Common.convertToAsciiLowerCase(name), value);
    }

    public void removeAttribute(String name) {
        if (this.attributes != null) {
            this.attributes.remove(Common.convertToAsciiLowerCase(name));
        }
    }

    public String toString() {
        return this.nodeName;
    }

    public String getClassName() {
        return Common.join(this.getClassList().listIterator());
    }

    public DOMTokenList getClassList() {
        return new DOMTokenList(this, "class");
    }

    public String getId() {
        return this.getAttribute("id");
    }

    public void setId(String id) {
        this.getAttributes().put("id", id);
    }

    public boolean hasAttributes() {
        return this.attributes != null && !this.attributes.isEmpty();
    }

    public boolean hasAttribute(String name) {
        return this.attributes != null && this.attributes.containsKey(Common.convertToAsciiLowerCase(name));
    }

    @Override
    public Node cloneNode(boolean deep) {
        Element clone = new Element(this.nodeName, this.nodeNameID, this.originalNodeName, this.namespaceURI, this.namespaceID, this.attributes == null ? null : this.attributes.copy());
        if (!deep) {
            return clone;
        }
        if (this.childNodes != null) {
            clone.childNodes = new ArrayList<Node>(this.childNodes.size());
            for (Node node : this.childNodes) {
                Node clonedChild = node.cloneNode(true);
                clonedChild.parentNode = clone;
                clone.childNodes.add(clonedChild);
            }
        }
        return clone;
    }

    @Override
    public boolean isEqualNode(Node other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Element) {
            boolean equalityCheck;
            Element otherElement = (Element)other;
            int count = this.getChildCount();
            boolean bl = equalityCheck = Objects.equals(this.getNodeName(), otherElement.getNodeName()) && Objects.equals(this.getNamespaceURI(), otherElement.getNamespaceURI()) && Objects.equals(count, otherElement.getChildCount()) && Objects.equals(this.getAttributes(), otherElement.getAttributes());
            if (!equalityCheck) {
                return false;
            }
            for (int i = 0; i < count; ++i) {
                if (Node.nodesEquals(this.childNodes.get(i), otherElement.childNodes.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String getInnerHTML() {
        return this.getInnerHTML(EnumSet.noneOf(Option.class));
    }

    public String getInnerHTML(Set<Option> options) {
        StringBuilder sb = new StringBuilder();
        this.traverse(new HtmlSerializer(sb, options));
        return sb.toString();
    }

    public String getOuterHTML() {
        return this.getOuterHTML(EnumSet.noneOf(Option.class));
    }

    public String getOuterHTML(Set<Option> options) {
        StringBuilder sb = new StringBuilder();
        this.traverseWithCurrentNode(new HtmlSerializer(sb, options));
        return sb.toString();
    }

    public String getTagName() {
        if (1 == this.namespaceID) {
            return this.nodeName.toUpperCase(Locale.ENGLISH);
        }
        return this.originalNodeName;
    }
}

