/*
 * Decompiled with CFR 0.152.
 */
package ch.digitalfondue.jfiveparse;

import ch.digitalfondue.jfiveparse.Node;
import java.util.Objects;

public class DocumentType
extends Node {
    private final String name;
    private final String publicId;
    private final String systemId;

    public DocumentType(String name, String publicId, String systemId) {
        this.name = name;
        this.publicId = publicId;
        this.systemId = systemId;
    }

    @Override
    public byte getNodeType() {
        return 10;
    }

    public String getName() {
        return this.name;
    }

    public String getPublicId() {
        return this.publicId;
    }

    public String getSystemId() {
        return this.systemId;
    }

    @Override
    public String getNodeName() {
        return "#doctype";
    }

    @Override
    public Node cloneNode(boolean deep) {
        return new DocumentType(this.getName(), this.getPublicId(), this.getSystemId());
    }

    @Override
    public boolean isEqualNode(Node other) {
        if (this == other) {
            return true;
        }
        if (other instanceof DocumentType) {
            DocumentType otherDocType = (DocumentType)other;
            return Objects.equals(this.name, otherDocType.name) && Objects.equals(this.publicId, otherDocType.publicId) && Objects.equals(this.systemId, otherDocType.systemId);
        }
        return false;
    }
}

