/*
 * Decompiled with CFR 0.152.
 */
package ch.digitalfondue.jfiveparse;

import ch.digitalfondue.jfiveparse.DocumentType;
import ch.digitalfondue.jfiveparse.Element;
import ch.digitalfondue.jfiveparse.Node;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;

public class Document
extends Node {
    private final List<Node> childNodes = new ArrayList<Node>(2);
    private DocumentType doctype;

    @Override
    public byte getNodeType() {
        return 9;
    }

    @Override
    public List<Node> getChildNodes() {
        return Collections.unmodifiableList(this.childNodes);
    }

    @Override
    List<Node> getMutableChildNodes() {
        return this.childNodes;
    }

    public void setDoctype(DocumentType doctype) {
        this.doctype = doctype;
    }

    public DocumentType getDoctype() {
        return this.doctype;
    }

    public Element getDocumentElement() {
        return this.getFirstElementChild();
    }

    private Element getChildOfDocumentElementMatching(Predicate<String> nodeNameMatcher) {
        Element e = this.getFirstElementChild();
        if (e != null) {
            for (Node c : e.getChildNodes()) {
                if (!(c instanceof Element) || !nodeNameMatcher.test(c.getNodeName()) || 1 != ((Element)c).namespaceID) continue;
                return (Element)c;
            }
        }
        return null;
    }

    public Element getHead() {
        return this.getChildOfDocumentElementMatching("head"::equals);
    }

    public Element getBody() {
        return this.getChildOfDocumentElementMatching(n -> "body".equals(n) || "frameset".equals(n));
    }

    public void setBody(Element element) {
        Element e = this.getBody();
        if (element != null && e != null && e.parentNode != null) {
            e.parentNode.replaceChild(element, e);
        }
    }

    @Override
    public String getNodeName() {
        return "#document";
    }

    @Override
    public Node cloneNode(boolean deep) {
        Document cloned = new Document();
        if (this.doctype != null) {
            cloned.doctype = (DocumentType)this.doctype.cloneNode(true);
            cloned.doctype.parentNode = this;
        }
        if (!deep) {
            return cloned;
        }
        for (Node child : this.childNodes) {
            Node clonedChild = child.cloneNode(true);
            clonedChild.parentNode = cloned;
            cloned.childNodes.add(clonedChild);
        }
        return cloned;
    }

    @Override
    public boolean isEqualNode(Node other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Document) {
            Document otherDocument = (Document)other;
            if (!Node.nodesEquals(this.doctype, otherDocument.doctype)) {
                return false;
            }
            int count = this.getChildCount();
            if (count != otherDocument.getChildCount()) {
                return false;
            }
            for (int i = 0; i < count; ++i) {
                if (Node.nodesEquals(this.childNodes.get(i), otherDocument.childNodes.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

