/*
 * Decompiled with CFR 0.152.
 */
package ch.digitalfondue.jfiveparse;

import ch.digitalfondue.jfiveparse.AttributeNode;
import ch.digitalfondue.jfiveparse.Common;
import ch.digitalfondue.jfiveparse.Element;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class DOMTokenList
extends AbstractList<String> {
    private final String attrName;
    private final Element element;

    public DOMTokenList(Element element, String attrName) {
        this.element = element;
        this.attrName = attrName;
    }

    private List<String> attributeValues() {
        AttributeNode a;
        AttributeNode attributeNode = a = this.element.attributes != null ? this.element.attributes.get(this.attrName) : null;
        if (a != null && a.getValue() != null) {
            ArrayList<String> vals = new ArrayList<String>();
            for (String s : a.getValue().split("\\s+")) {
                if (s == null || s.trim().isEmpty()) continue;
                vals.add(s);
            }
            return vals;
        }
        return new ArrayList<String>(1);
    }

    @Override
    public void add(int index, String value) {
        if (this.contains(value)) {
            return;
        }
        List<String> vals = this.attributeValues();
        vals.add(index, value);
        this.element.getAttributes().put(this.attrName, Common.join(vals.iterator()));
    }

    @SafeVarargs
    public final void add(String val, String ... values) {
        this.add(val);
        if (values != null) {
            for (String s : values) {
                this.add(s);
            }
        }
    }

    @Override
    public String remove(int index) {
        List<String> vals = this.attributeValues();
        String val = vals.remove(index);
        this.element.getAttributes().put(this.attrName, Common.join(vals.iterator()));
        return val;
    }

    @Override
    public boolean remove(Object o) {
        List<String> vals = this.attributeValues();
        boolean removed = vals.remove(o);
        if (removed) {
            this.element.getAttributes().put(this.attrName, Common.join(vals.iterator()));
        }
        return removed;
    }

    @Override
    public String set(int index, String value) {
        if (this.contains(value)) {
            return null;
        }
        List<String> vals = this.attributeValues();
        String replaced = vals.set(index, value);
        this.element.getAttributes().put(this.attrName, Common.join(vals.iterator()));
        return replaced;
    }

    public boolean toggle(String name) {
        if (this.contains(name)) {
            this.remove(name);
            return false;
        }
        this.add(name);
        return true;
    }

    public boolean toggle(String name, boolean condition) {
        return condition && this.toggle(name);
    }

    public String item(int index) {
        return this.get(index);
    }

    @Override
    public ListIterator<String> listIterator(int idx) {
        return Collections.unmodifiableList(this.attributeValues()).listIterator(idx);
    }

    @Override
    public ListIterator<String> listIterator() {
        return Collections.unmodifiableList(this.attributeValues()).listIterator();
    }

    @Override
    public Iterator<String> iterator() {
        return Collections.unmodifiableList(this.attributeValues()).iterator();
    }

    @Override
    public String get(int index) {
        return this.attributeValues().get(index);
    }

    @Override
    public int size() {
        return this.attributeValues().size();
    }
}

