/*
 * Decompiled with CFR 0.152.
 */
package ch.digitalfondue.jfiveparse;

import ch.digitalfondue.jfiveparse.AttributeNode;
import ch.digitalfondue.jfiveparse.Attributes;
import ch.digitalfondue.jfiveparse.Element;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

class Common {
    private static final char[] SYSTEM = new char[]{'s', 'y', 's', 't', 'e', 'm'};
    private static final char[] PUBLIC = new char[]{'p', 'u', 'b', 'l', 'i', 'c'};
    private static final char[] DOCTYPE = new char[]{'d', 'o', 'c', 't', 'y', 'p', 'e'};
    private static final HashMap<String, String> SVG_ATTRIBUTES = new HashMap();
    private static final Map<String, String[]> FOREIGN_ATTRIBUTES_TO_ADJUST;
    static final byte ELEMENT_ADDRESS_ID = 1;
    static final byte ELEMENT_APPLET_ID = 2;
    static final byte ELEMENT_AREA_ID = 3;
    static final byte ELEMENT_ARTICLE_ID = 4;
    static final byte ELEMENT_ASIDE_ID = 5;
    static final byte ELEMENT_BASE_ID = 6;
    static final byte ELEMENT_BASEFONT_ID = 7;
    static final byte ELEMENT_BGSOUND_ID = 8;
    static final byte ELEMENT_BLOCKQUOTE_ID = 9;
    static final byte ELEMENT_BODY_ID = 10;
    static final byte ELEMENT_BR_ID = 11;
    static final byte ELEMENT_BUTTON_ID = 12;
    static final byte ELEMENT_CAPTION_ID = 13;
    static final byte ELEMENT_CENTER_ID = 14;
    static final byte ELEMENT_COL_ID = 15;
    static final byte ELEMENT_COLGROUP_ID = 16;
    static final byte ELEMENT_DD_ID = 17;
    static final byte ELEMENT_DETAILS_ID = 18;
    static final byte ELEMENT_DIR_ID = 19;
    static final byte ELEMENT_DIV_ID = 20;
    static final byte ELEMENT_DL_ID = 21;
    static final byte ELEMENT_DT_ID = 22;
    static final byte ELEMENT_EMBED_ID = 23;
    static final byte ELEMENT_FIELDSET_ID = 24;
    static final byte ELEMENT_FIGCAPTION_ID = 25;
    static final byte ELEMENT_FIGURE_ID = 26;
    static final byte ELEMENT_FOOTER_ID = 27;
    static final byte ELEMENT_FORM_ID = 28;
    static final byte ELEMENT_FRAME_ID = 29;
    static final byte ELEMENT_FRAMESET_ID = 30;
    static final byte ELEMENT_H1_ID = 31;
    static final byte ELEMENT_H2_ID = 32;
    static final byte ELEMENT_H3_ID = 33;
    static final byte ELEMENT_H4_ID = 34;
    static final byte ELEMENT_H5_ID = 35;
    static final byte ELEMENT_H6_ID = 36;
    static final byte ELEMENT_HEAD_ID = 37;
    static final byte ELEMENT_HEADER_ID = 38;
    static final byte ELEMENT_HGROUP_ID = 39;
    static final byte ELEMENT_HR_ID = 40;
    static final byte ELEMENT_HTML_ID = 41;
    static final byte ELEMENT_IFRAME_ID = 42;
    static final byte ELEMENT_IMG_ID = 43;
    static final byte ELEMENT_INPUT_ID = 44;
    static final byte ELEMENT_LI_ID = 45;
    static final byte ELEMENT_LINK_ID = 46;
    static final byte ELEMENT_LISTING_ID = 47;
    static final byte ELEMENT_MAIN_ID = 48;
    static final byte ELEMENT_MARQUEE_ID = 49;
    static final byte ELEMENT_MENU_ID = 50;
    static final byte ELEMENT_META_ID = 51;
    static final byte ELEMENT_NAV_ID = 52;
    static final byte ELEMENT_NOEMBED_ID = 53;
    static final byte ELEMENT_NOFRAMES_ID = 54;
    static final byte ELEMENT_NOSCRIPT_ID = 55;
    static final byte ELEMENT_OBJECT_ID = 56;
    static final byte ELEMENT_OL_ID = 57;
    static final byte ELEMENT_P_ID = 58;
    static final byte ELEMENT_PARAM_ID = 59;
    static final byte ELEMENT_PLAINTEXT_ID = 60;
    static final byte ELEMENT_PRE_ID = 61;
    static final byte ELEMENT_SCRIPT_ID = 62;
    static final byte ELEMENT_SECTION_ID = 63;
    static final byte ELEMENT_SELECT_ID = 64;
    static final byte ELEMENT_SOURCE_ID = 65;
    static final byte ELEMENT_STYLE_ID = 66;
    static final byte ELEMENT_SUMMARY_ID = 67;
    static final byte ELEMENT_TABLE_ID = 68;
    static final byte ELEMENT_TBODY_ID = 69;
    static final byte ELEMENT_TD_ID = 70;
    static final byte ELEMENT_TEMPLATE_ID = 71;
    static final byte ELEMENT_TEXTAREA_ID = 72;
    static final byte ELEMENT_TFOOT_ID = 73;
    static final byte ELEMENT_TH_ID = 74;
    static final byte ELEMENT_THEAD_ID = 75;
    static final byte ELEMENT_TITLE_ID = 76;
    static final byte ELEMENT_TR_ID = 77;
    static final byte ELEMENT_TRACK_ID = 78;
    static final byte ELEMENT_UL_ID = 79;
    static final byte ELEMENT_WBR_ID = 80;
    static final byte ELEMENT_XMP_ID = 81;
    static final byte ELEMENT_OPTGROUP_ID = 82;
    static final byte ELEMENT_OPTION_ID = 83;
    static final byte ELEMENT_RB_ID = 84;
    static final byte ELEMENT_RP_ID = 85;
    static final byte ELEMENT_RT_ID = 86;
    static final byte ELEMENT_RTC_ID = 87;
    static final byte ELEMENT_A_ID = 88;
    static final byte ELEMENT_DIALOG_ID = 89;
    static final byte ELEMENT_SEARCH_ID = 90;
    static final byte ELEMENT_B_ID = 91;
    static final byte ELEMENT_BIG_ID = 92;
    static final byte ELEMENT_CODE_ID = 93;
    static final byte ELEMENT_EM_ID = 94;
    static final byte ELEMENT_FONT_ID = 95;
    static final byte ELEMENT_I_ID = 96;
    static final byte ELEMENT_S_ID = 97;
    static final byte ELEMENT_SMALL_ID = 98;
    static final byte ELEMENT_STRIKE_ID = 99;
    static final byte ELEMENT_STRONG_ID = 100;
    static final byte ELEMENT_TT_ID = 101;
    static final byte ELEMENT_U_ID = 102;
    static final byte ELEMENT_NO_BR_ID = 103;
    static final byte ELEMENT_KEYGEN_ID = 104;
    static final byte ELEMENT_IMAGE_ID = 105;
    static final byte ELEMENT_MATH_ID = 106;
    static final byte ELEMENT_SVG_ID = 107;
    static final byte ELEMENT_RUBY_ID = 108;
    static final byte ELEMENT_SPAN_ID = 109;
    static final byte ELEMENT_SUB_ID = 110;
    static final byte ELEMENT_SUP_ID = 111;
    static final byte ELEMENT_VAR_ID = 112;

    Common() {
    }

    static int toLowerCase(int chr) {
        if (Common.isUpperCaseASCIILetter(chr)) {
            return chr + 32;
        }
        return chr;
    }

    static String convertToAsciiLowerCase(String s) {
        StringBuilder sb = new StringBuilder(s.length());
        for (char c : s.toCharArray()) {
            sb.append((char)Common.toLowerCase(c));
        }
        return sb.toString();
    }

    static boolean isUpperCaseASCIILetter(int chr) {
        return chr >= 65 && chr <= 90;
    }

    static boolean isLowerCaseASCIILetter(int chr) {
        return chr >= 97 && chr <= 122;
    }

    static boolean isASCIIHexDigit(int chr) {
        return chr >= 48 && chr <= 57 || chr >= 65 && chr <= 70 || chr >= 97 && chr <= 102;
    }

    static boolean isASCIIDigit(int chr) {
        return chr >= 48 && chr <= 57;
    }

    static boolean isAlphaNumericASCII(int chr) {
        return Common.isLowerCaseASCIILetter(chr) || Common.isUpperCaseASCIILetter(chr) || Common.isASCIIDigit(chr);
    }

    static boolean matchCharCaseInsensitiveSystem(int[] chars) {
        return Common.matchCharsCaseInsensitive(SYSTEM, chars);
    }

    static boolean matchCharsCaseInsensitivePublic(int[] chars) {
        return Common.matchCharsCaseInsensitive(PUBLIC, chars);
    }

    static boolean matchCharsCaseInsensitiveDoctype(int[] chars) {
        return Common.matchCharsCaseInsensitive(DOCTYPE, chars);
    }

    private static boolean matchCharsCaseInsensitive(char[] str, int[] chars) {
        for (int i = 0; i < chars.length; ++i) {
            if (str[i] == Common.toLowerCase(chars[i])) continue;
            return false;
        }
        return true;
    }

    static void adjustMathMLAttributes(Attributes attrs) {
        if (attrs.containsKey("definitionurl")) {
            AttributeNode attr = attrs.get("definitionurl");
            attr.name = "definitionURL";
            attrs.put(attr);
            attrs.remove("definitionurl");
        }
    }

    static void adjustSVGAttributes(Attributes attrs) {
        if (attrs.isEmpty()) {
            return;
        }
        for (String lowerCaseAttr : new ArrayList<String>(attrs.keySet())) {
            if (!SVG_ATTRIBUTES.containsKey(lowerCaseAttr)) continue;
            AttributeNode attr = attrs.get(lowerCaseAttr);
            attr.name = SVG_ATTRIBUTES.get(lowerCaseAttr);
            attrs.put(attr);
            attrs.remove(lowerCaseAttr);
        }
    }

    static void adjustForeignAttributes(Attributes attrs) {
        if (attrs.isEmpty()) {
            return;
        }
        for (String lowerCaseAttr : new ArrayList<String>(attrs.keySet())) {
            if (!FOREIGN_ATTRIBUTES_TO_ADJUST.containsKey(lowerCaseAttr)) continue;
            String[] adj = FOREIGN_ATTRIBUTES_TO_ADJUST.get(lowerCaseAttr);
            AttributeNode attr = attrs.get(lowerCaseAttr);
            attr.prefix = adj[0];
            attr.name = adj[1];
            attr.namespace = adj[2];
            attrs.put(attr);
            attrs.remove(lowerCaseAttr);
        }
    }

    static boolean isMathMLIntegrationPoint(Element e) {
        String nodeName = e.nodeName;
        return 3 == e.namespaceID && ("mi".equals(nodeName) || "mo".equals(nodeName) || "mn".equals(nodeName) || "ms".equals(nodeName) || "mtext".equals(nodeName));
    }

    static boolean isHtmlIntegrationPoint(Element e) {
        String nodeName = e.nodeName;
        byte namespaceID = e.namespaceID;
        return 3 == namespaceID && "annotation-xml".equals(nodeName) && Common.matchEncoding(e.getAttributes().get("encoding")) || 2 == namespaceID && ("foreignObject".equals(nodeName) || "desc".equals(nodeName) || "title".equals(nodeName));
    }

    private static boolean matchEncoding(AttributeNode target) {
        if (target == null) {
            return false;
        }
        String value = target.getValue();
        String html = "text/html";
        String xhtml = "application/xhtml+xml";
        int targetLen = value.length();
        if (targetLen == "text/html".length()) {
            for (int i = 0; i < targetLen; ++i) {
                if (Common.toLowerCase(value.charAt(i)) == "text/html".charAt(i)) continue;
                return false;
            }
            return true;
        }
        if (targetLen == "application/xhtml+xml".length()) {
            for (int i = 0; i < targetLen; ++i) {
                if (Common.toLowerCase(value.charAt(i)) == "application/xhtml+xml".charAt(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    static boolean isTabLfFfCrOrSpace(int chr) {
        return chr == 9 || chr == 10 || chr == 12 || chr == 13 || chr == 32;
    }

    static boolean isStartTagNamed(byte tokenType, byte namedID, byte tagNameID) {
        return tokenType == 5 && namedID == tagNameID;
    }

    static boolean isEndTagNamed(byte tokenType, byte namedID, byte tagNameID) {
        return tokenType == 4 && namedID == tagNameID;
    }

    static byte tagNameToID(String tagName) {
        if (tagName == null) {
            return 0;
        }
        switch (tagName) {
            case "address": {
                return 1;
            }
            case "applet": {
                return 2;
            }
            case "area": {
                return 3;
            }
            case "article": {
                return 4;
            }
            case "aside": {
                return 5;
            }
            case "base": {
                return 6;
            }
            case "basefont": {
                return 7;
            }
            case "bgsound": {
                return 8;
            }
            case "blockquote": {
                return 9;
            }
            case "body": {
                return 10;
            }
            case "br": {
                return 11;
            }
            case "button": {
                return 12;
            }
            case "caption": {
                return 13;
            }
            case "center": {
                return 14;
            }
            case "col": {
                return 15;
            }
            case "colgroup": {
                return 16;
            }
            case "dd": {
                return 17;
            }
            case "details": {
                return 18;
            }
            case "dir": {
                return 19;
            }
            case "div": {
                return 20;
            }
            case "dl": {
                return 21;
            }
            case "dt": {
                return 22;
            }
            case "embed": {
                return 23;
            }
            case "fieldset": {
                return 24;
            }
            case "figcaption": {
                return 25;
            }
            case "figure": {
                return 26;
            }
            case "footer": {
                return 27;
            }
            case "form": {
                return 28;
            }
            case "frame": {
                return 29;
            }
            case "frameset": {
                return 30;
            }
            case "h1": {
                return 31;
            }
            case "h2": {
                return 32;
            }
            case "h3": {
                return 33;
            }
            case "h4": {
                return 34;
            }
            case "h5": {
                return 35;
            }
            case "h6": {
                return 36;
            }
            case "head": {
                return 37;
            }
            case "header": {
                return 38;
            }
            case "hgroup": {
                return 39;
            }
            case "hr": {
                return 40;
            }
            case "html": {
                return 41;
            }
            case "iframe": {
                return 42;
            }
            case "img": {
                return 43;
            }
            case "input": {
                return 44;
            }
            case "li": {
                return 45;
            }
            case "link": {
                return 46;
            }
            case "listing": {
                return 47;
            }
            case "main": {
                return 48;
            }
            case "marquee": {
                return 49;
            }
            case "menu": {
                return 50;
            }
            case "meta": {
                return 51;
            }
            case "nav": {
                return 52;
            }
            case "noembed": {
                return 53;
            }
            case "noframes": {
                return 54;
            }
            case "noscript": {
                return 55;
            }
            case "object": {
                return 56;
            }
            case "ol": {
                return 57;
            }
            case "p": {
                return 58;
            }
            case "param": {
                return 59;
            }
            case "plaintext": {
                return 60;
            }
            case "pre": {
                return 61;
            }
            case "script": {
                return 62;
            }
            case "section": {
                return 63;
            }
            case "select": {
                return 64;
            }
            case "source": {
                return 65;
            }
            case "style": {
                return 66;
            }
            case "summary": {
                return 67;
            }
            case "table": {
                return 68;
            }
            case "tbody": {
                return 69;
            }
            case "td": {
                return 70;
            }
            case "template": {
                return 71;
            }
            case "textarea": {
                return 72;
            }
            case "tfoot": {
                return 73;
            }
            case "th": {
                return 74;
            }
            case "thead": {
                return 75;
            }
            case "title": {
                return 76;
            }
            case "tr": {
                return 77;
            }
            case "track": {
                return 78;
            }
            case "ul": {
                return 79;
            }
            case "wbr": {
                return 80;
            }
            case "xmp": {
                return 81;
            }
            case "optgroup": {
                return 82;
            }
            case "option": {
                return 83;
            }
            case "rb": {
                return 84;
            }
            case "rp": {
                return 85;
            }
            case "rt": {
                return 86;
            }
            case "rtc": {
                return 87;
            }
            case "a": {
                return 88;
            }
            case "dialog": {
                return 89;
            }
            case "search": {
                return 90;
            }
            case "b": {
                return 91;
            }
            case "big": {
                return 92;
            }
            case "code": {
                return 93;
            }
            case "em": {
                return 94;
            }
            case "font": {
                return 95;
            }
            case "i": {
                return 96;
            }
            case "s": {
                return 97;
            }
            case "small": {
                return 98;
            }
            case "strike": {
                return 99;
            }
            case "strong": {
                return 100;
            }
            case "tt": {
                return 101;
            }
            case "u": {
                return 102;
            }
            case "nobr": {
                return 103;
            }
            case "keygen": {
                return 104;
            }
            case "image": {
                return 105;
            }
            case "math": {
                return 106;
            }
            case "svg": {
                return 107;
            }
            case "ruby": {
                return 108;
            }
            case "span": {
                return 109;
            }
            case "sub": {
                return 110;
            }
            case "sup": {
                return 111;
            }
            case "var": {
                return 112;
            }
        }
        return 0;
    }

    static boolean isSpecialCategory(Element element) {
        String nodeName = element.nodeName;
        byte nodeNameID = element.nodeNameID;
        byte nodeNameSpaceId = element.namespaceID;
        if (1 == nodeNameSpaceId) {
            return nodeNameID >= 1 && nodeNameID <= 81;
        }
        if (3 == nodeNameSpaceId) {
            return Common.isSpecialElementsMathML(nodeName);
        }
        if (2 == nodeNameSpaceId) {
            return Common.isSpecialElementsSVG(nodeName);
        }
        return false;
    }

    static boolean isInCommonInScope(Element element) {
        String tagName = element.nodeName;
        byte tagNameID = element.nodeNameID;
        byte namespaceID = element.namespaceID;
        if (1 == namespaceID) {
            switch (tagNameID) {
                case 2: 
                case 13: 
                case 41: 
                case 49: 
                case 56: 
                case 68: 
                case 70: 
                case 71: 
                case 74: {
                    return true;
                }
            }
            return false;
        }
        if (3 == namespaceID) {
            return Common.isInCommonInScopeMathMl(tagName);
        }
        if (2 == namespaceID) {
            return Common.isInCommonInScopeSVG(tagName);
        }
        return false;
    }

    private static boolean isSpecialElementsSVG(String tagName) {
        return Common.isInCommonInScopeSVG(tagName);
    }

    private static boolean isInCommonInScopeSVG(String tagName) {
        switch (tagName) {
            case "foreignObject": 
            case "desc": 
            case "title": {
                return true;
            }
        }
        return false;
    }

    private static boolean isSpecialElementsMathML(String tagName) {
        return Common.isInCommonInScopeMathMl(tagName);
    }

    private static boolean isInCommonInScopeMathMl(String tagName) {
        switch (tagName) {
            case "mi": 
            case "mo": 
            case "mn": 
            case "ms": 
            case "mtext": 
            case "annotation-xml": {
                return true;
            }
        }
        return false;
    }

    static boolean isImpliedTag(Element e) {
        if (1 != e.namespaceID) {
            return false;
        }
        switch (e.nodeNameID) {
            case 17: 
            case 22: 
            case 45: 
            case 58: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: {
                return true;
            }
        }
        return false;
    }

    static boolean isNoEndTag(String nodeName) {
        switch (nodeName) {
            case "area": 
            case "base": 
            case "basefont": 
            case "bgsound": 
            case "br": 
            case "col": 
            case "embed": 
            case "frame": 
            case "hr": 
            case "img": 
            case "input": 
            case "keygen": 
            case "link": 
            case "meta": 
            case "param": 
            case "source": 
            case "track": 
            case "wbr": {
                return true;
            }
        }
        return false;
    }

    static boolean isTextNodeParent(String nodeName) {
        switch (nodeName) {
            case "style": 
            case "script": 
            case "xmp": 
            case "iframe": 
            case "noembed": 
            case "noframes": 
            case "plaintext": {
                return true;
            }
        }
        return false;
    }

    static boolean isImpliedTagsThoroughly(Element element) {
        byte nodeNameID = element.nodeNameID;
        switch (nodeNameID) {
            case 13: 
            case 16: 
            case 17: 
            case 22: 
            case 45: 
            case 58: 
            case 69: 
            case 70: 
            case 73: 
            case 74: 
            case 75: 
            case 77: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: {
                return true;
            }
        }
        return false;
    }

    static String join(Iterator<String> l) {
        StringBuilder sb = new StringBuilder();
        while (l.hasNext()) {
            sb.append(l.next());
            if (!l.hasNext()) continue;
            sb.append(' ');
        }
        return sb.toString();
    }

    static boolean is(Element element, byte nameID, byte namespaceID) {
        return element.nodeNameID == nameID && element.namespaceID == namespaceID;
    }

    static boolean isHtmlNS(Element element, String name) {
        return element.namespaceID == 1 && element.nodeName.equals(name);
    }

    static boolean isHtmlNS(Element element, byte nameID) {
        return element.nodeNameID == nameID && element.namespaceID == 1;
    }

    static boolean isHtmlNSBetween(Element element, byte nameIDFrom, byte nameIDto) {
        return element.nodeNameID >= nameIDFrom && element.nodeNameID <= nameIDto && element.namespaceID == 1;
    }

    static {
        SVG_ATTRIBUTES.put("attributename", "attributeName");
        SVG_ATTRIBUTES.put("attributetype", "attributeType");
        SVG_ATTRIBUTES.put("basefrequency", "baseFrequency");
        SVG_ATTRIBUTES.put("baseprofile", "baseProfile");
        SVG_ATTRIBUTES.put("calcmode", "calcMode");
        SVG_ATTRIBUTES.put("clippathunits", "clipPathUnits");
        SVG_ATTRIBUTES.put("diffuseconstant", "diffuseConstant");
        SVG_ATTRIBUTES.put("edgemode", "edgeMode");
        SVG_ATTRIBUTES.put("filterunits", "filterUnits");
        SVG_ATTRIBUTES.put("glyphref", "glyphRef");
        SVG_ATTRIBUTES.put("gradienttransform", "gradientTransform");
        SVG_ATTRIBUTES.put("gradientunits", "gradientUnits");
        SVG_ATTRIBUTES.put("kernelmatrix", "kernelMatrix");
        SVG_ATTRIBUTES.put("kernelunitlength", "kernelUnitLength");
        SVG_ATTRIBUTES.put("keypoints", "keyPoints");
        SVG_ATTRIBUTES.put("keysplines", "keySplines");
        SVG_ATTRIBUTES.put("keytimes", "keyTimes");
        SVG_ATTRIBUTES.put("lengthadjust", "lengthAdjust");
        SVG_ATTRIBUTES.put("limitingconeangle", "limitingConeAngle");
        SVG_ATTRIBUTES.put("markerheight", "markerHeight");
        SVG_ATTRIBUTES.put("markerunits", "markerUnits");
        SVG_ATTRIBUTES.put("markerwidth", "markerWidth");
        SVG_ATTRIBUTES.put("maskcontentunits", "maskContentUnits");
        SVG_ATTRIBUTES.put("maskunits", "maskUnits");
        SVG_ATTRIBUTES.put("numoctaves", "numOctaves");
        SVG_ATTRIBUTES.put("pathlength", "pathLength");
        SVG_ATTRIBUTES.put("patterncontentunits", "patternContentUnits");
        SVG_ATTRIBUTES.put("patterntransform", "patternTransform");
        SVG_ATTRIBUTES.put("patternunits", "patternUnits");
        SVG_ATTRIBUTES.put("pointsatx", "pointsAtX");
        SVG_ATTRIBUTES.put("pointsaty", "pointsAtY");
        SVG_ATTRIBUTES.put("pointsatz", "pointsAtZ");
        SVG_ATTRIBUTES.put("preservealpha", "preserveAlpha");
        SVG_ATTRIBUTES.put("preserveaspectratio", "preserveAspectRatio");
        SVG_ATTRIBUTES.put("primitiveunits", "primitiveUnits");
        SVG_ATTRIBUTES.put("refx", "refX");
        SVG_ATTRIBUTES.put("refy", "refY");
        SVG_ATTRIBUTES.put("repeatcount", "repeatCount");
        SVG_ATTRIBUTES.put("repeatdur", "repeatDur");
        SVG_ATTRIBUTES.put("requiredextensions", "requiredExtensions");
        SVG_ATTRIBUTES.put("requiredfeatures", "requiredFeatures");
        SVG_ATTRIBUTES.put("specularconstant", "specularConstant");
        SVG_ATTRIBUTES.put("specularexponent", "specularExponent");
        SVG_ATTRIBUTES.put("spreadmethod", "spreadMethod");
        SVG_ATTRIBUTES.put("startoffset", "startOffset");
        SVG_ATTRIBUTES.put("stddeviation", "stdDeviation");
        SVG_ATTRIBUTES.put("stitchtiles", "stitchTiles");
        SVG_ATTRIBUTES.put("surfacescale", "surfaceScale");
        SVG_ATTRIBUTES.put("systemlanguage", "systemLanguage");
        SVG_ATTRIBUTES.put("tablevalues", "tableValues");
        SVG_ATTRIBUTES.put("targetx", "targetX");
        SVG_ATTRIBUTES.put("targety", "targetY");
        SVG_ATTRIBUTES.put("textlength", "textLength");
        SVG_ATTRIBUTES.put("viewbox", "viewBox");
        SVG_ATTRIBUTES.put("viewtarget", "viewTarget");
        SVG_ATTRIBUTES.put("xchannelselector", "xChannelSelector");
        SVG_ATTRIBUTES.put("ychannelselector", "yChannelSelector");
        SVG_ATTRIBUTES.put("zoomandpan", "zoomAndPan");
        FOREIGN_ATTRIBUTES_TO_ADJUST = new HashMap<String, String[]>();
        FOREIGN_ATTRIBUTES_TO_ADJUST.put("xlink:actuate", new String[]{"xlink", "actuate", "http://www.w3.org/1999/xlink"});
        FOREIGN_ATTRIBUTES_TO_ADJUST.put("xlink:arcrole", new String[]{"xlink", "arcrole", "http://www.w3.org/1999/xlink"});
        FOREIGN_ATTRIBUTES_TO_ADJUST.put("xlink:href", new String[]{"xlink", "href", "http://www.w3.org/1999/xlink"});
        FOREIGN_ATTRIBUTES_TO_ADJUST.put("xlink:role", new String[]{"xlink", "role", "http://www.w3.org/1999/xlink"});
        FOREIGN_ATTRIBUTES_TO_ADJUST.put("xlink:show", new String[]{"xlink", "show", "http://www.w3.org/1999/xlink"});
        FOREIGN_ATTRIBUTES_TO_ADJUST.put("xlink:title", new String[]{"xlink", "title", "http://www.w3.org/1999/xlink"});
        FOREIGN_ATTRIBUTES_TO_ADJUST.put("xlink:type", new String[]{"xlink", "type", "http://www.w3.org/1999/xlink"});
        FOREIGN_ATTRIBUTES_TO_ADJUST.put("xml:lang", new String[]{"xml", "lang", "http://www.w3.org/XML/1998/namespace"});
        FOREIGN_ATTRIBUTES_TO_ADJUST.put("xml:space", new String[]{"xml", "space", "http://www.w3.org/XML/1998/namespace"});
        FOREIGN_ATTRIBUTES_TO_ADJUST.put("xmlns", new String[]{null, "xmlns", "http://www.w3.org/2000/xmlns/"});
        FOREIGN_ATTRIBUTES_TO_ADJUST.put("xmlns:xlink", new String[]{"xmlns", "xlink", "http://www.w3.org/2000/xmlns/"});
    }
}

