/*
 * Decompiled with CFR 0.152.
 */
package ch.digitalfondue.jfiveparse;

import ch.digitalfondue.jfiveparse.AttributeNode;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class Attributes
implements Iterable<AttributeNode> {
    private Map<String, AttributeNode> attributes;

    public Attributes() {
    }

    public Attributes(Map<String, AttributeNode> attributes) {
        this.attributes = attributes;
    }

    public boolean containsKey(String key) {
        return this.attributes != null && this.attributes.containsKey(key);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Attributes) {
            return Objects.equals(this.attributes, ((Attributes)obj).attributes);
        }
        return false;
    }

    public Attributes copy() {
        Attributes a = new Attributes();
        if (this.attributes != null) {
            this.attributes.values().forEach(v -> a.put(new AttributeNode((AttributeNode)v)));
            return a;
        }
        return a;
    }

    public AttributeNode get(String key) {
        return this.attributes == null ? null : this.attributes.get(key);
    }

    Set<String> keySet() {
        return this.attributes == null ? Set.of() : this.attributes.keySet();
    }

    private void ensureMap() {
        if (this.attributes == null) {
            this.attributes = new LinkedHashMap<String, AttributeNode>();
        }
    }

    public void put(AttributeNode attribute) {
        this.ensureMap();
        this.attributes.put(attribute.getName(), attribute);
    }

    public void put(String key, String value) {
        this.ensureMap();
        this.attributes.put(key, new AttributeNode(key, value));
    }

    public void remove(String key) {
        if (this.attributes != null) {
            this.attributes.remove(key);
        }
    }

    public boolean isEmpty() {
        return this.attributes == null || this.attributes.isEmpty();
    }

    @Override
    public Iterator<AttributeNode> iterator() {
        return this.attributes == null ? Collections.emptyIterator() : this.attributes.values().iterator();
    }

    public String getNamedItem(String name) {
        return this.attributes != null && this.attributes.containsKey(name) ? this.attributes.get(name).getValue() : null;
    }
}

