/*
 * Decompiled with CFR 0.152.
 */
package ch.digitalfondue.jfiveparse;

import ch.digitalfondue.jfiveparse.ResizableCharBuilder;
import java.util.Objects;

public class AttributeNode {
    String name;
    String originalName;
    private String value;
    private ResizableCharBuilder valueBuilder;
    String prefix;
    String namespace;
    int attributeQuoteType = 1;

    public AttributeNode(String name, String value) {
        this.name = name;
        this.value = value;
    }

    AttributeNode(String name, String originalName, ResizableCharBuilder value, int attributeQuoteType) {
        this.name = name;
        this.valueBuilder = value;
        this.originalName = originalName;
        this.attributeQuoteType = attributeQuoteType;
    }

    AttributeNode(AttributeNode a) {
        this.name = a.name;
        this.originalName = a.originalName;
        this.value = a.value;
        this.valueBuilder = a.valueBuilder;
        this.prefix = a.prefix;
        this.namespace = a.namespace;
        this.attributeQuoteType = a.attributeQuoteType;
    }

    public AttributeNode(String name, String value, String prefix, String namespace) {
        this(name, value);
        this.prefix = prefix;
        this.namespace = namespace;
    }

    public String getValue() {
        if (this.value == null && this.valueBuilder != null) {
            this.value = this.valueBuilder.asString();
            this.valueBuilder = null;
        }
        return this.value;
    }

    public void setValue(String value) {
        this.valueBuilder = null;
        this.value = value;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.getValue(), this.prefix, this.namespace);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AttributeNode) {
            AttributeNode other = (AttributeNode)obj;
            return this.name.equals(other.name) && this.getValue().equals(other.getValue()) && Objects.equals(this.prefix, other.prefix) && Objects.equals(this.namespace, other.namespace);
        }
        return false;
    }
}

