/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.plugins.p2.repository;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.eclipse.tycho.FileLockService;
import org.eclipse.tycho.p2.tools.FacadeException;
import org.eclipse.tycho.p2.tools.mirroring.facade.MirrorApplicationService;
import org.eclipse.tycho.plugins.p2.repository.AbstractRepositoryMojo;

@Mojo(name="remap-artifacts-to-m2-repo", defaultPhase=LifecyclePhase.PREPARE_PACKAGE, threadSafe=true)
public class RemapArtifactToMavenRepositoriesMojo
extends AbstractRepositoryMojo {
    @Component
    MirrorApplicationService mirrorApp;
    @Component
    private FileLockService fileLockService;

    public void execute() throws MojoExecutionException, MojoFailureException {
        File location = this.getAssemblyRepositoryLocation();
        try (Closeable locking = this.fileLockService.lockVirtually(location);){
            this.mirrorApp.addMavenMappingRules(location, (URI[])this.getProject().getRemoteArtifactRepositories().stream().filter(artifactRepo -> artifactRepo.getLayout().getId().equals("default")).map(ArtifactRepository::getUrl).map(URI::create).toArray(URI[]::new));
        }
        catch (IOException | FacadeException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }
}

