/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2maven.tools;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.model.Repository;
import org.eclipse.equinox.internal.p2.artifact.repository.CompositeArtifactRepository;
import org.eclipse.equinox.internal.p2.metadata.repository.CompositeMetadataRepository;
import org.eclipse.equinox.internal.p2.persistence.CompositeRepositoryIO;
import org.eclipse.equinox.internal.p2.persistence.CompositeRepositoryState;
import org.eclipse.equinox.internal.p2.repository.helpers.RepositoryHelper;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.internal.repository.tools.XZCompressor;
import org.eclipse.equinox.p2.repository.ICompositeRepository;
import org.eclipse.equinox.p2.repository.IRepository;
import org.eclipse.equinox.p2.repository.IRepositoryManager;
import org.eclipse.tycho.MavenRepositoryLocation;
import org.eclipse.tycho.p2maven.repository.P2RepositoryKind;
import org.eclipse.tycho.p2maven.repository.P2RepositoryManager;

@Named
@Singleton
public class P2RepositoryDataManipulator {
    @Inject
    private P2RepositoryManager manager;

    public static ModifiedRepositoryDescriptor createDescriptor(Repository repository, P2RepositoryKind repositoryKind, Path outputLocation, boolean compress, boolean xzCompress, boolean keepNonXzIndexFiles) throws IOException, RepositoryLocationURISyntaxException {
        URI location;
        try {
            location = RepositoryHelper.localRepoURIHelper((URI)new URI(repository.getUrl()));
        }
        catch (Exception e) {
            throw new RepositoryLocationURISyntaxException(e);
        }
        if (outputLocation != null) {
            if (location.getScheme().equals("file") && Files.isSameFile(outputLocation, Path.of(location))) {
                outputLocation = null;
            } else if (!Files.isDirectory(outputLocation, new LinkOption[0])) {
                Files.createDirectories(outputLocation, new FileAttribute[0]);
            } else {
                try (Stream<Path> files = Files.list(outputLocation);){
                    if (files.findAny().isPresent()) {
                        throw new IllegalStateException("Output location is not empty: " + String.valueOf(outputLocation));
                    }
                }
            }
        }
        return new ModifiedRepositoryDescriptor(new MavenRepositoryLocation(repository.getId(), location), repositoryKind, outputLocation, compress, xzCompress, keepNonXzIndexFiles);
    }

    public void modifyRepositoryMetadata(ModifiedRepositoryDescriptor repository, String repositoryName, List<String> propertiesToRemove, Map<String, String> propertiesToAdd) throws ProvisionException, IOException {
        Consumer<IRepository> modification = repo -> {
            if (repositoryName != null) {
                repo.setProperty("name", repositoryName);
            }
            repo.setProperty("p2.compressed", Boolean.toString(repository.compress()));
            if (propertiesToRemove != null) {
                for (String key2 : propertiesToRemove) {
                    repo.setProperty(key2, null);
                }
            }
            if (propertiesToAdd != null) {
                propertiesToAdd.forEach((key, value) -> repo.setProperty(key, value));
            }
        };
        MavenRepositoryLocation location = repository.repository();
        Path outputLocation = repository.outputLocation();
        if (repository.isArtifact()) {
            this.modifyOutputRepository(this.manager.getArtifactRepository(location.getURL(), location.getId()), outputLocation, this.manager::mirrorArtifactRepositoryData, r -> r.executeBatch(m -> modification.accept((IRepository)r), null));
        }
        if (repository.isMetadata()) {
            this.modifyOutputRepository(this.manager.getMetadataRepository(location.getURL(), location.getId()), outputLocation, this.manager::mirrorMetadataRepository, r -> r.executeBatch(m -> modification.accept((IRepository)r), null));
        }
        this.xzCompress(repository, outputLocation);
    }

    private <T, R extends IRepository<T>> void modifyOutputRepository(R repository, Path outputLocation, ThrowingBiFunction<R, Path, R, ProvisionException> copyAction, Consumer<R> modification) throws ProvisionException {
        if (outputLocation != null) {
            IRepository localRepository = (IRepository)copyAction.apply(repository, outputLocation);
            modification.accept(localRepository);
        } else if (repository.isModifiable()) {
            modification.accept(repository);
        } else {
            throw new IllegalStateException("Repository is not modifable and no output location is defined: " + String.valueOf(repository.getLocation()));
        }
    }

    private void xzCompress(ModifiedRepositoryDescriptor repository, Path outputLocation) throws IOException {
        if (repository.xzCompress()) {
            XZCompressor xzCompressor = new XZCompressor();
            xzCompressor.setPreserveOriginalFile(repository.keepNonXzIndexFiles());
            xzCompressor.setRepoFolder(outputLocation.toAbsolutePath().toString());
            xzCompressor.compressRepo();
        }
    }

    public void modifyCompositeRepository(ModifiedRepositoryDescriptor repository, String repositoryName, List<URI> childrenToAdd, List<URI> childrenToRemove, int childLimit) throws ProvisionException, IOException {
        if (childLimit > 0 && childrenToAdd.size() > childLimit) {
            throw new IllegalArgumentException("Cannot add more children than the specified limit of " + childLimit);
        }
        Consumer<CompositeRepositoryState> modification = repo -> {
            if (repositoryName != null) {
                repo.setName(repositoryName);
            }
            LinkedHashSet<URI> children = new LinkedHashSet<URI>(Arrays.asList(repo.getChildren()));
            for (URI child : childrenToRemove) {
                children.remove(child);
            }
            for (URI child : childrenToAdd) {
                children.add(child);
            }
            if (childLimit > 0) {
                while (children.size() > childLimit) {
                    children.removeFirst();
                }
            }
            repo.setChildren((URI[])children.toArray(URI[]::new));
        };
        if (repository.isArtifact()) {
            this.modifyOutputCompositeRepository(repository, (m, r) -> ((CompositeArtifactRepository)m.getArtifactRepository(r.getURL(), r.getId())).toState(), state -> {
                state.setType(CompositeArtifactRepository.REPOSITORY_TYPE);
                state.setVersion("1");
                state.getProperties().put("p2.atomic.composite.loading", "true");
            }, modification, "compositeArtifactRepository", "compositeArtifacts");
        }
        if (repository.isMetadata()) {
            this.modifyOutputCompositeRepository(repository, (m, r) -> ((CompositeMetadataRepository)m.getMetadataRepository(r.getURL(), r.getId())).toState(), state -> {
                state.setType(CompositeMetadataRepository.REPOSITORY_TYPE);
                state.setVersion("1");
                state.getProperties().put("p2.atomic.composite.loading", "true");
            }, modification, "compositeMetadataRepository", "compositeContent");
        }
        this.createP2Index(repository.outputLocation(), repository.isMetadata(), repository.isArtifact());
    }

    private <T, M extends IRepositoryManager<T>, R extends ICompositeRepository<T>> void modifyOutputCompositeRepository(ModifiedRepositoryDescriptor descriptor, ThrowingBiFunction<P2RepositoryManager, MavenRepositoryLocation, CompositeRepositoryState, ProvisionException> getState, Consumer<CompositeRepositoryState> initState, Consumer<CompositeRepositoryState> modification, String piRepositoryType, String filename) throws ProvisionException, IOException {
        CompositeRepositoryState state;
        MavenRepositoryLocation repository = descriptor.repository();
        try {
            state = getState.apply(this.manager, repository);
            state.setProperties(new LinkedHashMap(state.getProperties()));
        }
        catch (ProvisionException e) {
            if (e.getStatus().getCode() == 1000) {
                state = new CompositeRepositoryState();
                state.setProperties(new LinkedHashMap());
                state.setChildren(new URI[0]);
                initState.accept(state);
            }
            throw e;
        }
        Path outputLocation = descriptor.outputLocation();
        if (outputLocation == null) {
            try {
                outputLocation = Path.of(repository.getURL());
            }
            catch (Exception e) {
                throw new IllegalStateException("Repository is not modifable and no output location is defined: " + String.valueOf(repository.getURL()), e);
            }
        }
        modification.accept(state);
        boolean compress = descriptor.compress();
        try (OutputStream output = P2RepositoryDataManipulator.createCompositeFileOutputStream(outputLocation, filename, compress);){
            state.getProperties().put("p2.timestamp", Long.toString(System.currentTimeMillis()));
            state.getProperties().put("p2.compressed", Boolean.toString(compress));
            new CompositeRepositoryIO().write(state, output, piRepositoryType);
        }
    }

    private static OutputStream createCompositeFileOutputStream(Path directory, String filename, boolean compress) throws IOException {
        Path file = directory.resolve(filename + ".xml");
        Path jarFile = directory.resolve(filename + ".jar");
        Files.createDirectories(directory, new FileAttribute[0]);
        if (!compress) {
            Files.deleteIfExists(jarFile);
            return Files.newOutputStream(file, new OpenOption[0]);
        }
        Files.deleteIfExists(file);
        JarOutputStream stream = new JarOutputStream(Files.newOutputStream(jarFile, new OpenOption[0]));
        stream.putNextEntry(new JarEntry(file.getFileName().toString()));
        return stream;
    }

    private void createP2Index(Path directory, boolean metadata, boolean artifacts) throws IOException {
        Properties p2Index = new Properties();
        p2Index.setProperty("version", "1");
        if (metadata) {
            p2Index.setProperty("metadata.repository.factory.order", "compositeContent.xml,!");
        }
        if (artifacts) {
            p2Index.setProperty("artifact.repository.factory.order", "compositeArtifacts.xml,!");
        }
        try (OutputStream output = Files.newOutputStream(directory.resolve("p2.index"), new OpenOption[0]);){
            p2Index.store(output, null);
        }
    }

    public static class RepositoryLocationURISyntaxException
    extends Exception {
        public RepositoryLocationURISyntaxException(Exception cause) {
            super(cause);
        }
    }

    public record ModifiedRepositoryDescriptor(MavenRepositoryLocation repository, P2RepositoryKind repositoryKind, Path outputLocation, boolean compress, boolean xzCompress, boolean keepNonXzIndexFiles) {
        public boolean isArtifact() {
            return this.repositoryKind == null || this.repositoryKind == P2RepositoryKind.artifact;
        }

        public boolean isMetadata() {
            return this.repositoryKind == null || this.repositoryKind == P2RepositoryKind.metadata;
        }
    }

    @FunctionalInterface
    private static interface ThrowingBiFunction<T, U, R, E extends Throwable> {
        public R apply(T var1, U var2) throws E;
    }
}

