/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2maven.repository;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.Repository;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.internal.p2.artifact.repository.simple.SimpleArtifactRepository;
import org.eclipse.equinox.internal.p2.artifact.repository.simple.SimpleArtifactRepositoryFactory;
import org.eclipse.equinox.internal.p2.metadata.repository.SimpleMetadataRepositoryFactory;
import org.eclipse.equinox.internal.p2.repository.helpers.RepositoryHelper;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.query.CompoundQueryable;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.IRepository;
import org.eclipse.equinox.p2.repository.IRepositoryManager;
import org.eclipse.equinox.p2.repository.artifact.ArtifactKeyQuery;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.tycho.IRepositoryIdManager;
import org.eclipse.tycho.helper.MavenPropertyHelper;
import org.eclipse.tycho.p2maven.ListCompositeArtifactRepository;
import org.eclipse.tycho.p2maven.LoggerProgressMonitor;

@Component(role=P2RepositoryManager.class)
public class P2RepositoryManager {
    private static final String PROPERTY_KEY = "eclipse.p2.maxDownloadAttempts";
    @Requirement
    MavenPropertyHelper propertyHelper;
    @Requirement
    IRepositoryIdManager repositoryIdManager;
    @Requirement
    IProvisioningAgent agent;
    @Requirement
    Logger logger;

    public IArtifactRepository getArtifactRepository(Repository repository) throws URISyntaxException, ProvisionException {
        return this.getArtifactRepository(new URI(repository.getUrl()), repository.getId());
    }

    public IArtifactRepository getCompositeArtifactRepository(Collection<Repository> repositories) throws ProvisionException, URISyntaxException {
        if (repositories.size() == 1) {
            return this.getArtifactRepository(repositories.iterator().next());
        }
        ArrayList<IArtifactRepository> childs = new ArrayList<IArtifactRepository>();
        for (Repository repository : repositories) {
            childs.add(this.getArtifactRepository(repository));
        }
        return new ListCompositeArtifactRepository(childs, this.agent);
    }

    public IArtifactRepository createLocalArtifactRepository(Path location, String name, Map<String, String> properties) throws ProvisionException {
        SimpleArtifactRepositoryFactory factory = new SimpleArtifactRepositoryFactory();
        factory.setAgent(this.agent);
        return factory.create(location.toUri(), name, null, properties);
    }

    public IQueryResult<IArtifactKey> allArtifacts(URI location, String id) throws ProvisionException {
        IArtifactRepository repository = this.getArtifactRepository(location, id);
        return repository.query((IQuery)ArtifactKeyQuery.ALL_KEYS, null);
    }

    public IArtifactRepository mirrorArtifactRepositoryData(IArtifactRepository repository, Path targetLocation) throws ProvisionException {
        IArtifactRepository mirror = this.createLocalArtifactRepository(targetLocation, repository.getName(), repository.getProperties());
        IStatus result = mirror.executeBatch(m -> {
            repository.query((IQuery)ArtifactKeyQuery.ALL_KEYS, null).stream().map(a -> repository.getArtifactDescriptors(a)).forEach(a -> mirror.addDescriptors(a, null));
            if (repository instanceof SimpleArtifactRepository) {
                SimpleArtifactRepository simpleSource = (SimpleArtifactRepository)repository;
                if (mirror instanceof SimpleArtifactRepository) {
                    SimpleArtifactRepository simpleTarget = (SimpleArtifactRepository)mirror;
                    simpleTarget.setRules(simpleSource.getRules());
                }
            }
        }, null);
        P2RepositoryManager.assertNoError(result);
        return mirror;
    }

    public IMetadataRepository getMetadataRepository(Repository repository) throws URISyntaxException, ProvisionException {
        return this.getMetadataRepository(new URI(repository.getUrl()), repository.getId());
    }

    public IQueryable<IInstallableUnit> getCompositeMetadataRepository(Collection<Repository> repositories) throws ProvisionException, URISyntaxException {
        if (repositories.size() == 1) {
            return this.getMetadataRepository(repositories.iterator().next());
        }
        ArrayList<IMetadataRepository> queryable = new ArrayList<IMetadataRepository>();
        for (Repository repository : repositories) {
            queryable.add(this.getMetadataRepository(repository));
        }
        return new CompoundQueryable(queryable);
    }

    public IMetadataRepository createLocalMetadataRepository(Path location, String name, Map<String, String> properties) throws ProvisionException {
        SimpleMetadataRepositoryFactory factory = new SimpleMetadataRepositoryFactory();
        factory.setAgent(this.agent);
        return factory.create(location.toUri(), name, null, properties);
    }

    public IQueryResult<IInstallableUnit> allMetadataUnits(URI location, String id) throws ProvisionException {
        IMetadataRepository repository = this.getMetadataRepository(location, id);
        return repository.query(QueryUtil.ALL_UNITS, null);
    }

    public IMetadataRepository mirrorMetadataRepository(IMetadataRepository repository, Path targetLocation) throws ProvisionException {
        IMetadataRepository mirror = this.createLocalMetadataRepository(targetLocation, repository.getName(), repository.getProperties());
        IStatus result = mirror.executeBatch(m -> repository.query(QueryUtil.ALL_UNITS, null).stream().map(List::of).forEach(arg_0 -> ((IMetadataRepository)mirror).addInstallableUnits(arg_0)), null);
        P2RepositoryManager.assertNoError(result);
        return mirror;
    }

    public IArtifactRepository getArtifactRepository(URI location, String id) throws ProvisionException {
        return (IArtifactRepository)this.getRepository(location, id, IArtifactRepositoryManager.class);
    }

    public IMetadataRepository getMetadataRepository(URI location, String id) throws ProvisionException {
        return (IMetadataRepository)this.getRepository(location, id, IMetadataRepositoryManager.class);
    }

    private <K, R extends IRepository<K>, M extends IRepositoryManager<K>> R getRepository(URI location, String id, Class<M> managerType) throws ProvisionException {
        this.repositoryIdManager.addMapping(id, location);
        IRepositoryManager manager = (IRepositoryManager)this.agent.getService(managerType);
        IRepository repositoy = manager.loadRepository(location, (IProgressMonitor)new LoggerProgressMonitor(this.logger));
        return (R)repositoy;
    }

    public static void assertNoError(IStatus status) throws ProvisionException {
        if (status.matches(4)) {
            throw new ProvisionException(status);
        }
    }

    public void downloadArtifact(IInstallableUnit iu, IArtifactRepository artifactRepository, OutputStream outputStream) throws IOException {
        Collection artifacts = iu.getArtifacts();
        int maxDownloadAttempts = this.getMaxDownloadAttempts();
        for (IArtifactKey key : artifacts) {
            IArtifactDescriptor[] descriptors;
            for (IArtifactDescriptor descriptor : descriptors = artifactRepository.getArtifactDescriptors(key)) {
                for (int downloadAttempts = 0; downloadAttempts < maxDownloadAttempts; ++downloadAttempts) {
                    IStatus status = artifactRepository.getRawArtifact(descriptor, outputStream, (IProgressMonitor)new LoggerProgressMonitor(this.logger));
                    if (status.isOK()) {
                        return;
                    }
                    if (status.getCode() != 13) {
                        throw new IOException("Download failed: " + String.valueOf(status));
                    }
                    this.logger.warn("Artifact repository requested retry (attempt [%d/%d]): '%s'".formatted(downloadAttempts + 1, maxDownloadAttempts, status));
                }
            }
        }
        throw new FileNotFoundException();
    }

    private int getMaxDownloadAttempts() {
        String property = this.propertyHelper.getGlobalProperty(PROPERTY_KEY, "3");
        try {
            int maxDownloadAttempts = Integer.valueOf(property);
            if (maxDownloadAttempts <= 0) {
                this.logger.error("Value '%s' for property '%s', is not a positive number! Use 1 as default value.".formatted(property, PROPERTY_KEY));
                return 1;
            }
            return maxDownloadAttempts;
        }
        catch (NumberFormatException e) {
            this.logger.error("Value '%s' for property '%s', is not a number! Use 1 as default value.".formatted(property, PROPERTY_KEY));
            return 1;
        }
    }

    public Collection<Repository> normalizeRepositoryLocations(Collection<Repository> baselineRepositories) {
        return baselineRepositories.stream().mapMulti((repo, downstream) -> {
            String url = repo.getUrl();
            if (url != null) {
                try {
                    URI uri = RepositoryHelper.localRepoURIHelper((URI)new URI(url));
                    Repository clone = repo.clone();
                    clone.setUrl(uri.toASCIIString());
                    downstream.accept(clone);
                }
                catch (URISyntaxException e) {
                    this.logger.warn(e.getMessage(), (Throwable)e);
                }
            }
        }).toList();
    }
}

