/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2maven;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.LegacySupport;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.sisu.equinox.embedder.EmbeddedEquinox;
import org.eclipse.sisu.equinox.embedder.EquinoxLifecycleListener;
import org.osgi.service.url.AbstractURLStreamHandlerService;
import org.osgi.service.url.URLStreamHandlerService;

@Singleton
@Named(value="MavenURLStreamHandlerService")
public class MavenURLStreamHandlerService
extends AbstractURLStreamHandlerService
implements EquinoxLifecycleListener {
    private static final String PROTOCOL = "mvn";
    @Inject
    private Logger logger;
    @Inject
    private LegacySupport context;
    @Inject
    private RepositorySystem repositorySystem;
    private MavenSession mavenSession;
    @Inject
    private ArtifactHandlerManager artifactHandlerManager;

    public void afterFrameworkStarted(EmbeddedEquinox framework) {
        this.mavenSession = this.context.getSession();
        framework.registerService(URLStreamHandlerService.class, (Object)this, Map.of("url.handler.protocol", new String[]{PROTOCOL}));
    }

    public URLConnection openConnection(URL url) throws IOException {
        MavenSession session = this.context.getSession();
        if (session == null) {
            this.logger.warn("Called connect() outside maven thread, using global session, project specific repositories or configuration might be ignored!");
            session = this.mavenSession;
        }
        return new MavenURLConnection(url, session, this.repositorySystem, this.artifactHandlerManager, this.logger);
    }

    private static final class MavenURLConnection
    extends URLConnection {
        private String subPath;
        private Artifact artifact;
        private Logger logger;
        private MavenSession mavenSession;
        private RepositorySystem repositorySystem;
        private ArtifactHandlerManager artifactHandlerManager;

        protected MavenURLConnection(URL url, MavenSession mavenSession, RepositorySystem repositorySystem, ArtifactHandlerManager artifactHandlerManager, Logger logger) {
            super(url);
            this.mavenSession = mavenSession;
            this.repositorySystem = repositorySystem;
            this.artifactHandlerManager = artifactHandlerManager;
            this.logger = logger;
        }

        @Override
        public void connect() throws IOException {
            try {
                Object[] coordinates;
                if (this.artifact != null) {
                    return;
                }
                String path = this.url.getPath();
                if (path == null) {
                    throw new IOException("maven coordinates are missing");
                }
                int subPathIndex = path.indexOf(47);
                if (subPathIndex > -1) {
                    this.subPath = path.substring(subPathIndex);
                    coordinates = path.substring(0, subPathIndex).split(":");
                } else {
                    coordinates = path.split(":");
                }
                if (coordinates.length < 3) {
                    throw new IOException("required format is groupId:artifactId:version[:packaging[:classifier]]");
                }
                String extension = this.getExtension((String[])coordinates);
                String classifier = coordinates.length > 4 ? coordinates[4] : null;
                String groupId = coordinates[0];
                String artifactId = coordinates[1];
                String version = coordinates[2];
                this.artifact = classifier != null && !classifier.isEmpty() ? new DefaultArtifact(groupId, artifactId, classifier, extension, version) : new DefaultArtifact(groupId, artifactId, "", extension, version);
                this.logger.debug("Resolving " + String.valueOf(this.artifact));
                ArtifactRequest artifactRequest = new ArtifactRequest();
                artifactRequest.setArtifact(this.artifact);
                for (ArtifactRepository repo : this.mavenSession.getCurrentProject().getRemoteArtifactRepositories()) {
                    artifactRequest.addRepository(RepositoryUtils.toRepo((ArtifactRepository)repo));
                }
                try {
                    ArtifactResult artifactResult = this.repositorySystem.resolveArtifact(this.mavenSession.getRepositorySession(), artifactRequest);
                    this.artifact = artifactResult.getArtifact();
                    if (!artifactResult.getExceptions().isEmpty()) {
                        String message = "Resolving " + String.valueOf(this.artifact) + " failed";
                        List exceptions = artifactResult.getExceptions();
                        if (exceptions.size() == 1) {
                            throw new IOException(message, (Throwable)exceptions.get(0));
                        }
                        IOException exception = new IOException(message);
                        for (Exception suppressed : exceptions) {
                            exception.addSuppressed(suppressed);
                        }
                        throw exception;
                    }
                    if (artifactResult.isMissing()) {
                        throw new IOException("artifact " + Arrays.toString(coordinates) + " could not be retrieved from any of the available repositories");
                    }
                }
                catch (ArtifactResolutionException e) {
                    throw new IOException("artifact " + Arrays.toString(coordinates) + " could not be resolved");
                }
            }
            catch (RuntimeException e) {
                throw new IOException("internal error connecting to maven url " + String.valueOf(this.url), e);
            }
        }

        private String getExtension(String[] coordinates) {
            String type = coordinates.length > 3 ? coordinates[3] : "jar";
            ArtifactHandler handler = this.artifactHandlerManager.getArtifactHandler(type);
            return handler.getExtension();
        }

        @Override
        public InputStream getInputStream() throws IOException {
            this.connect();
            File location = this.artifact.getFile();
            if (this.subPath == null) {
                return new FileInputStream(location);
            }
            String urlSpec = "jar:" + String.valueOf(location.toURI()) + "!" + this.subPath;
            return new URL(urlSpec).openStream();
        }

        @Override
        public long getLastModified() {
            try {
                this.connect();
            }
            catch (IOException e) {
                return 0L;
            }
            return this.artifact.getFile().lastModified();
        }
    }
}

