/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.bnd.mojos;

import aQute.bnd.build.Project;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.compiler.util.scan.InclusionScanException;
import org.codehaus.plexus.compiler.util.scan.StaleSourceScanner;
import org.codehaus.plexus.compiler.util.scan.mapping.SourceMapping;
import org.codehaus.plexus.util.FileUtils;
import org.eclipse.tycho.bnd.CopyMapping;
import org.eclipse.tycho.bnd.mojos.AbstractBndProjectMojo;

public abstract class AbstractBndCompileMojo
extends AbstractBndProjectMojo {
    private static final Set<String> MATCH_ALL = Collections.singleton("**/*");
    @Parameter(defaultValue="true")
    private boolean copyResources;
    @Parameter
    private Set<String> excludeResources = new HashSet<String>();

    protected void doCopyResources(Project project) throws Exception {
        if (!this.copyResources) {
            return;
        }
        Collection<File> compileSourceRoots = this.getSourcePath(project);
        for (File sourceRootFile : compileSourceRoots) {
            if (!sourceRootFile.isDirectory()) {
                this.getLog().warn((CharSequence)("Source directory " + String.valueOf(sourceRootFile) + " does not exist"));
                continue;
            }
            HashSet<String> excludes = new HashSet<String>();
            excludes.addAll(this.excludeResources);
            excludes.add("**/*.java");
            excludes.add("**/.gitignore");
            excludes.add("**/.gitattributes");
            StaleSourceScanner scanner = new StaleSourceScanner(0L, MATCH_ALL, excludes);
            CopyMapping copyMapping = new CopyMapping();
            scanner.addSourceMapping((SourceMapping)copyMapping);
            try {
                scanner.getIncludedSources(sourceRootFile, this.getOutput(project));
                for (CopyMapping.SourceTargetPair sourceTargetPair : copyMapping.getSourceTargetPairs()) {
                    FileUtils.copyFile((File)new File(sourceRootFile, sourceTargetPair.source), (File)sourceTargetPair.target);
                }
            }
            catch (InclusionScanException e) {
                throw new MojoExecutionException("Exception while scanning for resource files in " + String.valueOf(sourceRootFile), (Exception)((Object)e));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Exception copying resource files from " + String.valueOf(sourceRootFile) + " to " + String.valueOf(this.getOutput(project)), (Exception)e);
            }
        }
    }

    protected abstract Collection<File> getSourcePath(Project var1) throws Exception;

    protected abstract File getOutput(Project var1) throws Exception;
}

