/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.plugins.p2;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.tycho.p2tools.copiedfromp2.AbstractPublisherApplication;

public abstract class AbstractP2MetadataMojo
extends AbstractMojo {
    @Parameter(property="project", required=true, readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${project.name}", required=true)
    protected String metadataRepositoryName;
    @Parameter(defaultValue="${project.build.directory}/site")
    protected File target;
    @Parameter(defaultValue="${project.name} Artifacts", required=true)
    protected String artifactRepositoryName;
    @Parameter(property="p2.timeout")
    private int forkedProcessTimeoutInSeconds;
    @Parameter
    private String argLine;
    @Parameter(defaultValue="true")
    protected boolean generateP2Metadata;
    @Parameter(defaultValue="true")
    private boolean compressRepository;
    @Component
    private IProvisioningAgent agent;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.generateP2Metadata) {
            return;
        }
        try {
            if (this.getUpdateSiteLocation().isDirectory()) {
                this.generateMetadata();
            } else {
                this.logUpdateSiteLocationNotFound();
            }
        }
        catch (MojoFailureException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Cannot generate P2 metadata", e);
        }
    }

    protected void logUpdateSiteLocationNotFound() {
        this.getLog().warn((CharSequence)(this.getUpdateSiteLocation().getAbsolutePath() + " does not exist or is not a directory"));
    }

    private void generateMetadata() throws Exception {
        Object result;
        ArrayList<String> arguments = new ArrayList<String>();
        this.addArguments(arguments);
        if (this.argLine != null && !this.argLine.trim().isEmpty()) {
            arguments.add("-vmargs");
            arguments.add(this.argLine);
        }
        if ((result = this.getPublisherApplication(this.agent).run((String[])arguments.toArray(String[]::new))) != IApplication.EXIT_OK) {
            throw new MojoFailureException("P2 publisher return code was " + String.valueOf(result));
        }
    }

    protected void addArguments(List<String> arguments) throws IOException, MalformedURLException {
        arguments.add("-source");
        arguments.add(this.getUpdateSiteLocation().getAbsolutePath());
        arguments.add("-metadataRepository");
        arguments.add(this.getUpdateSiteLocation().toURI().toString());
        arguments.add("-metadataRepositoryName");
        arguments.add(this.metadataRepositoryName);
        arguments.add("-artifactRepository");
        arguments.add(this.getUpdateSiteLocation().toURI().toString());
        arguments.add("-artifactRepositoryName");
        arguments.add(this.artifactRepositoryName);
        arguments.add("-noDefaultIUs");
        if (this.compressRepository) {
            arguments.add("-compress");
        }
    }

    protected abstract AbstractPublisherApplication getPublisherApplication(IProvisioningAgent var1);

    protected File getUpdateSiteLocation() {
        return this.target;
    }
}

