/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.build;

import java.util.HashSet;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.tycho.build.BuildListener;
import org.eclipse.tycho.helper.PluginRealmHelper;

@Component(role=BuildListeners.class)
public class BuildListeners {
    @Requirement
    private PluginRealmHelper realmHelper;
    @Requirement
    private Logger log;

    public void notifyBuildStart(MavenSession session) {
        HashSet called = new HashSet();
        for (MavenProject project : session.getProjects()) {
            try {
                this.realmHelper.visitPluginExtensions(project, session, BuildListener.class, listener -> {
                    if (called.add(listener.getClass().getName())) {
                        listener.buildStarted(session);
                    }
                });
            }
            catch (Exception e) {
                String message = "Can't call BuildListeners for project: " + project.getId();
                if (!this.log.isDebugEnabled()) continue;
                this.log.error(message, (Throwable)e);
            }
        }
    }

    public void notifyBuildEnd(MavenSession session) {
        HashSet called = new HashSet();
        for (MavenProject project : session.getProjects()) {
            try {
                this.realmHelper.visitPluginExtensions(project, session, BuildListener.class, listener -> {
                    if (called.add(listener.getClass().getName())) {
                        listener.buildEnded(session);
                    }
                });
            }
            catch (Exception e) {
                String message = "Can't call BuildListeners for project: " + project.getId();
                if (!this.log.isDebugEnabled()) continue;
                this.log.error(message, (Throwable)e);
            }
        }
    }
}

