/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.apitools;

import java.io.Serializable;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.pde.api.tools.internal.problems.ApiProblemFactory;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.problems.IApiProblem;

public class ApiProblemDTO
implements IApiProblem,
Serializable {
    private final int severity;
    private final int elementKind;
    private final int messageid;
    private final String resourcePath;
    private final String absolutePath;
    private final String typeName;
    private final String[] messageArguments;
    private final int charStart;
    private final int charEnd;
    private final int lineNumber;
    private final int category;
    private final int id;
    private final String message;
    private final int kind;
    private final int flags;
    private final String toString;

    public ApiProblemDTO(IApiProblem problem, IProject project) {
        IPath absoluteResourcePath;
        this.severity = ApiPlugin.getDefault().getSeverityLevel(ApiProblemFactory.getProblemSeverityId((IApiProblem)problem), project);
        this.elementKind = problem.getElementKind();
        this.messageid = problem.getMessageid();
        this.resourcePath = problem.getResourcePath();
        String absoluteOsPath = null;
        if (this.resourcePath != null && !this.resourcePath.isEmpty() && (absoluteResourcePath = project.getFile((IPath)new Path(problem.getResourcePath())).getLocation()) != null) {
            absoluteOsPath = absoluteResourcePath.toOSString();
        }
        this.absolutePath = absoluteOsPath;
        this.typeName = problem.getTypeName();
        this.messageArguments = problem.getMessageArguments();
        this.charStart = problem.getCharStart();
        this.charEnd = problem.getCharEnd();
        this.lineNumber = problem.getLineNumber();
        this.category = problem.getCategory();
        this.id = problem.getId();
        this.message = problem.getMessage();
        this.kind = problem.getKind();
        this.flags = problem.getFlags();
        this.toString = problem.toString();
    }

    public int getSeverity() {
        return this.severity;
    }

    public int getElementKind() {
        return this.elementKind;
    }

    public int getMessageid() {
        return this.messageid;
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    public String getAbsolutePath() {
        return this.absolutePath;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String[] getMessageArguments() {
        return this.messageArguments;
    }

    public int getCharStart() {
        return this.charStart;
    }

    public int getCharEnd() {
        return this.charEnd;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getCategory() {
        return this.category;
    }

    public int getId() {
        return this.id;
    }

    public String getMessage() {
        return this.message;
    }

    public int getKind() {
        return this.kind;
    }

    public int getFlags() {
        return this.flags;
    }

    public String[] getExtraMarkerAttributeIds() {
        return new String[0];
    }

    public Object[] getExtraMarkerAttributeValues() {
        return new Object[0];
    }

    public String toString() {
        return this.toString;
    }
}

