/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.apitools;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.osgi.service.resolver.ResolverError;
import org.eclipse.pde.api.tools.internal.problems.ApiProblem;
import org.eclipse.tycho.apitools.ApiAnalysisResult;
import org.eclipse.tycho.apitools.ApiProblemDTO;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class ApiAnalysisXmlGenerator {
    private static final String TAG_REPORT = "report";
    private static final String TAG_ADDITIONAL_ATTRIBUTES = "additionalAttributes";
    private static final String TAG_CATEGORY = "category";
    private static final String TAG_COLUMN_END = "columnEnd";
    private static final String TAG_COLUMN_START = "columnStart";
    private static final String TAG_FILE_NAME = "fileName";
    private static final String TAG_ISSUE = "issue";
    private static final String TAG_LINE_END = "lineEnd";
    private static final String TAG_LINE_START = "lineStart";
    private static final String TAG_MESSAGE = "message";
    private static final String TAG_MODULE_NAME = "moduleName";
    private static final String TAG_PACKAGE_NAME = "packageName";
    private static final String TAG_SEVERITY = "severity";
    private static final String TAG_TYPE = "type";
    private static final String SEVERITY_WARNING_LOW = "WARNING_LOW";
    private static final String SEVERITY_WARNING_NORMAL = "WARNING_NORMAL";
    private static final String SEVERITY_ERROR = "ERROR";
    private static final String CATEGORY_RESOLVER_ERROR = "RESOLVER_ERROR";
    private final String componentID;
    private final ApiAnalysisResult result;
    private final Path outFile;

    public ApiAnalysisXmlGenerator(String componentID, ApiAnalysisResult result, Path outFile) {
        this.componentID = componentID;
        this.result = result;
        this.outFile = outFile;
    }

    public void writeReport() throws DOMException, IOException, ParserConfigurationException, TransformerException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document document = db.newDocument();
        document.setXmlStandalone(true);
        this.fillDocument(document);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        DOMSource source = new DOMSource(document);
        Files.createDirectories(this.outFile.getParent(), new FileAttribute[0]);
        try (OutputStream outputStream = Files.newOutputStream(this.outFile, new OpenOption[0]);){
            transformer.transform(source, new StreamResult(outputStream));
        }
    }

    private void fillDocument(Document document) {
        Element report = document.createElement(TAG_REPORT);
        document.appendChild(report);
        this.result.problems().forEach(problem -> this.addIssueElement(document, report, (ApiProblemDTO)problem));
        if (this.result.resolveErrors().findAny().isPresent()) {
            this.result.resolveErrors().forEach(resolverError -> this.addIssueElement(document, report, (ResolverError)resolverError));
        }
    }

    private void addIssueElement(Document document, Element parent, ApiProblemDTO problem) {
        String typeName;
        String path;
        int charEnd;
        int charStart;
        Element issue = document.createElement(TAG_ISSUE);
        this.addTextElement(document, issue, TAG_MODULE_NAME, this.componentID);
        this.addTextElement(document, issue, TAG_MESSAGE, problem.getMessage());
        this.addTextElement(document, issue, TAG_CATEGORY, ApiProblem.getProblemCategory((int)problem.getCategory()));
        this.addTextElement(document, issue, TAG_TYPE, ApiProblem.getProblemKind((int)problem.getCategory(), (int)problem.getKind()));
        this.addTextElement(document, issue, TAG_SEVERITY, switch (problem.getSeverity()) {
            case 2 -> SEVERITY_ERROR;
            case 1 -> SEVERITY_WARNING_NORMAL;
            case 0 -> SEVERITY_WARNING_LOW;
            default -> null;
        });
        int lineNumber = problem.getLineNumber();
        if (lineNumber >= 0) {
            this.addTextElement(document, issue, TAG_LINE_START, String.valueOf(lineNumber));
            this.addTextElement(document, issue, TAG_LINE_END, String.valueOf(lineNumber));
        }
        if ((charStart = problem.getCharStart()) >= 0) {
            this.addTextElement(document, issue, TAG_COLUMN_START, String.valueOf(charStart));
        }
        if ((charEnd = problem.getCharEnd()) >= 0) {
            this.addTextElement(document, issue, TAG_COLUMN_END, String.valueOf(charEnd));
        }
        if ((path = problem.getAbsolutePath()) == null) {
            path = problem.getResourcePath();
        }
        if (path != null && !path.isEmpty()) {
            this.addTextElement(document, issue, TAG_FILE_NAME, path);
        }
        if ((typeName = problem.getTypeName()) != null) {
            int lastDot = typeName.lastIndexOf(46);
            String packageName = lastDot < 0 ? typeName : typeName.substring(0, lastDot);
            this.addTextElement(document, issue, TAG_PACKAGE_NAME, packageName);
        }
        this.addTextElement(document, issue, TAG_ADDITIONAL_ATTRIBUTES, "id=" + Integer.toString(problem.getId()));
        parent.appendChild(issue);
    }

    private void addIssueElement(Document document, Element parent, ResolverError resolverError) {
        Element issue = document.createElement(TAG_ISSUE);
        this.addTextElement(document, issue, TAG_MODULE_NAME, this.componentID);
        this.addTextElement(document, issue, TAG_MESSAGE, resolverError.toString());
        this.addTextElement(document, issue, TAG_CATEGORY, CATEGORY_RESOLVER_ERROR);
        parent.appendChild(issue);
    }

    private void addTextElement(Document document, Element issue, String elementName, String content) {
        if (content != null) {
            Element element = document.createElement(elementName);
            issue.appendChild(element);
            Text textNode = document.createTextNode(content);
            element.appendChild(textNode);
        }
    }
}

