/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.mojo;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.cbi.mojo.InvalidOSGiManifestException;
import org.eclipse.cbi.mojo.OsgiManifestParserException;
import org.eclipse.osgi.container.builders.OSGiManifestBuilderFactory;
import org.eclipse.osgi.framework.util.CaseInsensitiveDictionaryMap;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;

public class OsgiManifest {
    private final CaseInsensitiveDictionaryMap<String, String> headers;
    private final String bundleSymbolicName;
    private final String bundleVersion;
    private String location;

    OsgiManifest(InputStream stream, String location) throws OsgiManifestParserException {
        this.location = location;
        try {
            this.headers = new CaseInsensitiveDictionaryMap();
            ManifestElement.parseBundleManifest((InputStream)stream, this.headers);
            this.bundleSymbolicName = OSGiManifestBuilderFactory.createBuilder(this.headers).getSymbolicName();
        }
        catch (IOException | BundleException e) {
            throw new OsgiManifestParserException(location, e);
        }
        if (this.bundleSymbolicName == null) {
            throw new InvalidOSGiManifestException(location, "Bundle-SymbolicName is missing");
        }
        this.bundleVersion = this.parseBundleVersion();
    }

    private String parseBundleVersion() {
        ManifestElement[] manifestElementArray;
        int n;
        int n2;
        ManifestElement[] elements = this.parseHeader("Bundle-Version");
        if (elements != null && (n2 = 0) < (n = (manifestElementArray = elements).length)) {
            ManifestElement element = manifestElementArray[n2];
            String versionString = element.getValue();
            try {
                return Version.parseVersion((String)versionString).toString();
            }
            catch (NumberFormatException e) {
                throw new InvalidOSGiManifestException(this.location, "Bundle-Version '" + versionString + "' is invalid");
            }
            catch (IllegalArgumentException e) {
                throw new InvalidOSGiManifestException(this.location, e);
            }
        }
        return Version.emptyVersion.toString();
    }

    public String getValue(String key) {
        return (String)this.headers.get((Object)key);
    }

    public String getBundleSymbolicName() {
        return this.bundleSymbolicName;
    }

    public String getBundleVersion() {
        return this.bundleVersion;
    }

    private ManifestElement[] parseHeader(String key) {
        String value = (String)this.headers.get((Object)key);
        if (value == null) {
            return null;
        }
        try {
            return ManifestElement.parseHeader((String)key, (String)value);
        }
        catch (BundleException e) {
            throw new OsgiManifestParserException(this.location, e);
        }
    }
}

