/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.mojo;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.cbi.mojo.OsgiManifest;
import org.eclipse.cbi.mojo.OsgiManifestParserException;

class DefaultBundleReader {
    DefaultBundleReader() {
    }

    public static OsgiManifest loadManifest(File bundleLocation) {
        try {
            if (bundleLocation.isDirectory()) {
                return DefaultBundleReader.loadManifestFromDirectory(bundleLocation);
            }
            if (bundleLocation.isFile()) {
                return DefaultBundleReader.loadManifestFromFile(bundleLocation);
            }
            throw new OsgiManifestParserException(bundleLocation.getAbsolutePath(), "Manifest file not found");
        }
        catch (IOException e) {
            throw new OsgiManifestParserException(bundleLocation.getAbsolutePath(), e);
        }
    }

    private static OsgiManifest loadManifestFromFile(File bundleLocation) throws IOException {
        if (!bundleLocation.getName().toLowerCase().endsWith(".jar")) {
            return DefaultBundleReader.loadManifestFile(bundleLocation);
        }
        try (ZipFile jar = new ZipFile(bundleLocation, 1);){
            ZipEntry manifestEntry = jar.getEntry("META-INF/MANIFEST.MF");
            if (manifestEntry != null) {
                InputStream stream = jar.getInputStream(manifestEntry);
                OsgiManifest osgiManifest = new OsgiManifest(stream, bundleLocation.getAbsolutePath() + "!/META-INF/MANIFEST.MF");
                return osgiManifest;
            }
        }
        throw new OsgiManifestParserException(bundleLocation.getAbsolutePath(), "Manifest file not found in JAR archive");
    }

    private static OsgiManifest loadManifestFromDirectory(File directory) throws IOException {
        File manifestFile = new File(directory, "META-INF/MANIFEST.MF");
        if (!manifestFile.isFile()) {
            throw new OsgiManifestParserException(manifestFile.getAbsolutePath(), "Manifest file not found");
        }
        return DefaultBundleReader.loadManifestFile(manifestFile);
    }

    private static OsgiManifest loadManifestFile(File manifestFile) throws IOException, OsgiManifestParserException {
        return new OsgiManifest(new FileInputStream(manifestFile), manifestFile.getAbsolutePath());
    }
}

