/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.compiler.jdt;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.LegacySupport;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.tycho.compiler.jdt.copied.LibraryInfo;
import org.eclipse.tycho.core.maven.MavenDependenciesResolver;
import org.eclipse.tycho.version.TychoVersion;

@Component(role=JdkLibraryInfoProvider.class)
public class JdkLibraryInfoProvider {
    private static final String TYCHO_LIB_DETECTOR_VERSION = System.getProperty("tycho.libdetector.version", TychoVersion.getTychoVersion());
    @Requirement
    private LegacySupport legacySupport;
    @Requirement
    private MavenDependenciesResolver dependenciesResolver;
    @Requirement
    private Logger log;
    private Map<String, LibraryInfo> libraryInfoCache = new HashMap<String, LibraryInfo>();
    private File libDetectorJar;
    private Boolean isRunningOnJava9orLater;

    public LibraryInfo getLibraryInfo(String javaHome) throws ArtifactResolutionException {
        LibraryInfo libInfo = this.libraryInfoCache.get(javaHome);
        if (libInfo == null) {
            libInfo = this.generateLibraryInfo(javaHome);
            this.libraryInfoCache.put(javaHome, libInfo);
        }
        return libInfo;
    }

    private LibraryInfo generateLibraryInfo(String javaHome) throws ArtifactResolutionException {
        String executable = javaHome + File.separator + "bin" + File.separator + "java";
        if (File.separatorChar == '\\') {
            executable = executable + ".exe";
        }
        if (!new File(executable).isFile()) {
            this.getLog().warn(executable + " not found. Fallback to scan " + javaHome + "/lib/*.jar and " + javaHome + "/lib/ext/*.jar for bootclasspath");
            return new LibraryInfo("unknown", JdkLibraryInfoProvider.scanLibFolders(javaHome), new String[0], new String[0]);
        }
        CommandLine cli = new CommandLine(executable);
        cli.addArguments(new String[]{"-classpath", this.getLibDetectorJar().getAbsolutePath(), "org.eclipse.tycho.libdetector.LibraryDetector"}, false);
        DefaultExecutor executor = DefaultExecutor.builder().get();
        ExecuteWatchdog watchdog = ExecuteWatchdog.builder().setTimeout(Duration.ofMillis(30000L)).get();
        executor.setWatchdog(watchdog);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        PumpStreamHandler handler = new PumpStreamHandler((OutputStream)outputStream);
        executor.setStreamHandler((ExecuteStreamHandler)handler);
        int exitValue = -1;
        try {
            exitValue = executor.execute(cli);
        }
        catch (ExecuteException e) {
            if (watchdog.killedProcess()) {
                throw new RuntimeException("Timeout 30 s exceeded. Commandline " + cli.toString() + " was killed. Output: " + outputStream.toString());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (exitValue == 0) {
            return this.parseLibraryInfo(outputStream.toString(), javaHome);
        }
        throw new RuntimeException(cli.toString() + " process exit code was " + exitValue + ". Output: " + outputStream.toString());
    }

    private static String[] scanLibFolders(String javaHome) {
        ArrayList<String> bootclasspathList = new ArrayList<String>();
        JdkLibraryInfoProvider.addJarsToList(JdkLibraryInfoProvider.scanForJars(new File(javaHome, "lib")), bootclasspathList);
        JdkLibraryInfoProvider.addJarsToList(JdkLibraryInfoProvider.scanForJars(new File(javaHome, "lib/ext")), bootclasspathList);
        return bootclasspathList.toArray(new String[0]);
    }

    private static void addJarsToList(File[] jars, List<String> fileList) {
        for (File jar : jars) {
            fileList.add(jar.getAbsolutePath());
        }
    }

    private static File[] scanForJars(File libDir) {
        if (!libDir.isDirectory()) {
            return new File[0];
        }
        return libDir.listFiles((dir, name) -> name.endsWith(".jar") && new File(dir, name).isFile());
    }

    private LibraryInfo parseLibraryInfo(String output, String javaHome) {
        String[] splitPrefixAndSuffix = output.split(Pattern.quote("####"));
        if (splitPrefixAndSuffix.length < 2) {
            throw new IllegalStateException("Could not parse process output: " + output);
        }
        output = splitPrefixAndSuffix[1];
        String[] parts = output.split(Pattern.quote("|"));
        if (parts.length != 4) {
            throw new IllegalStateException("Could not parse process output: " + output);
        }
        String javaVersion = parts[0];
        String[] bootclasspath = JdkLibraryInfoProvider.splitPath(parts[1]);
        String[] extDirs = JdkLibraryInfoProvider.splitPath(parts[2]);
        String[] endorsedDirs = JdkLibraryInfoProvider.splitPath(parts[3]);
        if (bootclasspath.length == 0) {
            File jrtFsJar = new File(javaHome, "lib/jrt-fs.jar");
            if (!jrtFsJar.isFile() && !(jrtFsJar = new File(javaHome, "jrt-fs.jar")).isFile()) {
                throw new IllegalStateException("jrt-fs.jar not found in " + javaHome);
            }
            bootclasspath = new String[]{jrtFsJar.getAbsolutePath()};
        }
        if (this.isRunningOnJava9orLater()) {
            extDirs = new String[]{};
        }
        String[] filteredBcp = (String[])Arrays.stream(bootclasspath).filter(bcp -> new File((String)bcp).exists()).toArray(String[]::new);
        return new LibraryInfo(javaVersion, filteredBcp, extDirs, endorsedDirs);
    }

    private boolean isRunningOnJava9orLater() {
        if (this.isRunningOnJava9orLater == null) {
            try {
                Runtime.class.getDeclaredMethod("version", new Class[0]);
                this.isRunningOnJava9orLater = Boolean.TRUE;
            }
            catch (Throwable e) {
                this.isRunningOnJava9orLater = Boolean.FALSE;
            }
        }
        return this.isRunningOnJava9orLater;
    }

    private static String[] splitPath(String path) {
        if ("null".equals(path)) {
            return new String[0];
        }
        return path.split(Pattern.quote(File.pathSeparator));
    }

    protected Logger getLog() {
        return this.log;
    }

    protected File getLibDetectorJar() throws ArtifactResolutionException {
        if (this.libDetectorJar != null) {
            return this.libDetectorJar;
        }
        MavenSession mavenSession = this.legacySupport.getSession();
        Dependency dependency = new Dependency();
        dependency.setGroupId("org.eclipse.tycho");
        dependency.setArtifactId("tycho-lib-detector");
        dependency.setVersion(TYCHO_LIB_DETECTOR_VERSION);
        Artifact artifact = this.dependenciesResolver.resolveArtifact(mavenSession.getCurrentProject(), mavenSession, dependency);
        this.libDetectorJar = artifact.getFile();
        return this.libDetectorJar;
    }
}

