/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.extras.custombundle;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.FileSet;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.util.DefaultFileSet;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.core.osgitools.DefaultReactorProject;

@Mojo(name="custom-bundle")
public class CustomBundleMojo
extends AbstractMojo {
    @Parameter(required=true)
    private File bundleLocation;
    @Parameter(required=true)
    private String classifier;
    @Parameter
    private String[] includes = new String[]{"**/*.*"};
    @Parameter
    private String[] excludes;
    @Parameter(required=true)
    private List<DefaultFileSet> fileSets;
    @Parameter(property="project")
    private MavenProject project;
    @Parameter(property="session", readonly=true)
    private MavenSession session;
    @Parameter
    private MavenArchiveConfiguration archive = new MavenArchiveConfiguration();
    @Parameter(defaultValue="${project.build.outputTimestamp}")
    private String outputTimestamp;
    @Component(role=Archiver.class, hint="jar")
    private JarArchiver jarArchiver;
    @Component
    private MavenProjectHelper projectHelper;

    public void execute() throws MojoExecutionException, MojoFailureException {
        File outputJarFile = this.getOutputJarFile();
        MavenArchiver archiver = new MavenArchiver();
        archiver.setArchiver(this.jarArchiver);
        archiver.setOutputFile(outputJarFile);
        archiver.configureReproducibleBuild(this.outputTimestamp);
        try {
            archiver.getArchiver().setManifest(this.updateManifest());
            DefaultFileSet mainFileSet = new DefaultFileSet();
            mainFileSet.setDirectory(this.bundleLocation);
            mainFileSet.setIncludes(this.includes);
            mainFileSet.setExcludes(this.excludes);
            archiver.getArchiver().addFileSet((FileSet)mainFileSet);
            for (FileSet fileSet : this.fileSets) {
                archiver.getArchiver().addFileSet(fileSet);
            }
            archiver.createArchive(this.session, this.project, this.archive);
            this.projectHelper.attachArtifact(this.project, outputJarFile, this.classifier);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Could not create OSGi bundle", e);
        }
    }

    protected File getOutputJarFile() {
        String filename = this.project.getArtifactId() + "-" + this.project.getVersion() + "-" + this.classifier + ".jar";
        return new File(this.project.getBuild().getDirectory(), filename);
    }

    private File updateManifest() throws IOException {
        Manifest mf;
        File mfile = new File(this.bundleLocation, "META-INF/MANIFEST.MF");
        try (FileInputStream is = new FileInputStream(mfile);){
            mf = new Manifest(is);
        }
        Attributes attributes = mf.getMainAttributes();
        if (attributes.getValue(Attributes.Name.MANIFEST_VERSION) == null) {
            attributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        }
        ReactorProject reactorProject = DefaultReactorProject.adapt((MavenProject)this.project);
        attributes.putValue("Bundle-Version", reactorProject.getExpandedVersion());
        mfile = new File(this.project.getBuild().getDirectory(), this.classifier + "-MANIFEST.MF");
        mfile.getParentFile().mkdirs();
        try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(mfile));){
            mf.write(os);
        }
        return mfile;
    }
}

