/*
 * Decompiled with CFR 0.152.
 */
package org.junit.vintage.engine.descriptor;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.apiguardian.api.API;
import org.jspecify.annotations.Nullable;
import org.junit.platform.commons.support.HierarchyTraversalMode;
import org.junit.platform.commons.support.ModifierSupport;
import org.junit.platform.commons.support.ReflectionSupport;
import org.junit.platform.commons.util.FunctionUtils;
import org.junit.platform.commons.util.LruCache;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.engine.support.descriptor.MethodSource;
import org.junit.runner.Description;
import org.junit.vintage.engine.descriptor.DescriptionUtils;

@API(status=API.Status.INTERNAL, since="5.6")
public class TestSourceProvider {
    private static final TestSource NULL_SOURCE = new TestSource(){};
    private final Map<Description, TestSource> testSourceCache = new ConcurrentHashMap<Description, TestSource>();
    private final Map<Class<?>, List<Method>> methodsCache = Collections.synchronizedMap(new LruCache(31));

    public @Nullable TestSource findTestSource(Description description) {
        TestSource testSource = this.testSourceCache.computeIfAbsent(description, this::computeTestSource);
        return testSource == NULL_SOURCE ? null : testSource;
    }

    private TestSource computeTestSource(Description description) {
        Class testClass = description.getTestClass();
        if (testClass != null) {
            Method method;
            String methodName = DescriptionUtils.getMethodName(description);
            if (methodName != null && (method = this.findMethod(testClass, this.sanitizeMethodName(methodName))) != null) {
                return MethodSource.from((Class)testClass, (Method)method);
            }
            return ClassSource.from((Class)testClass);
        }
        return NULL_SOURCE;
    }

    private String sanitizeMethodName(String methodName) {
        if (methodName.contains("[") && methodName.endsWith("]")) {
            return methodName.substring(0, methodName.indexOf("["));
        }
        return methodName;
    }

    private @Nullable Method findMethod(Class<?> testClass, String methodName) {
        List<Object> methods = this.methodsCache.computeIfAbsent(testClass, clazz -> ReflectionSupport.findMethods((Class)clazz, m -> true, (HierarchyTraversalMode)HierarchyTraversalMode.TOP_DOWN)).stream().filter(FunctionUtils.where(Method::getName, Predicate.isEqual(methodName))).toList();
        if (methods.isEmpty()) {
            return null;
        }
        if (methods.size() == 1) {
            return (Method)methods.get(0);
        }
        if ((methods = methods.stream().filter(ModifierSupport::isPublic).toList()).size() == 1) {
            return (Method)methods.get(0);
        }
        return null;
    }
}

