///////////////////////////////////////////////////////////////////////////////
//                                                         
// Terminal.cc
// -----------
// dragon terminal implementation
// 
// Design and Implementation by Bjoern Lemke
//                                                         
// (C)opyright 2000-2007 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// IMPLEMENTATION MODULE
//
// Class: Terminal
// 
// Description: access to dragon termianal information 
//
///////////////////////////////////////////////////////////////////////////////

// DRAGOn INCLUDES
#include "Terminal.h"

Terminal::Terminal()
{
}

Terminal::Terminal(Chain name, Chain regexp, unsigned num)
{
    _name = name;
    _regexp = regexp;
    _num = num;
}

Terminal::~Terminal()
{
}

Terminal& Terminal::operator = (const Terminal& t)
{
    _name = t._name;
    _regexp = t._regexp;
    _num = t._num;
  
    return (*this);
}

bool Terminal::operator == (const Terminal& t)
{
    if ( (Chain)getName() == (Chain)t.getName() )
	return true;
    return false;
}

unsigned Terminal::getNum() const 
{ 
    return _num; 
}

const Chain& Terminal::getName() const 
{ 
    return _name; 
}

const Chain& Terminal::getRegExp() const
{ 
    return _regexp; 
}










