#ifndef _LR1TRANS_H_INCLUDED_
#define _LR1TRANS_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// LR1Trans.h
// ----------
// Dragon transiaiton hash interface defintion
//                                                         
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 2000-2007 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// INTERFACE MODULE
//
// Class: LR1Trans
// 
// Description: 
//
///////////////////////////////////////////////////////////////////////////////

#include <lfcbase/Chain.h>

class LR1Trans {
public:
    
    LR1Trans();
    LR1Trans(unsigned sid, unsigned tid, const Chain& token);
    ~LR1Trans();
    
    unsigned getSid() const;
    unsigned getTid() const;
    const Chain& getToken() const;
    LR1Trans& operator = (const LR1Trans& t);
    bool operator == (const LR1Trans& t) const;
    
private:
    
    unsigned _sid;
    unsigned _tid;
    Chain _token;
    
};

#endif





