#ifndef _LR1HASH_H_INCLUDED_
#define _LR1HASH_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// LR1Hash.h
// -----------
// Dragon transiaiton hash interface defintion
//                                                         
// Design and Implementation by Bjoern Lemke               
//
// (C)opyright 2000-2007 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// INTERFACE MODULE
//
// Class: LR1Hash
// 
// Description:
//
///////////////////////////////////////////////////////////////////////////////

#include <lfcbase/SetT.h>
#include <lfcbase/Chain.h>

#include "LR1Element.h"

class LR1Hash {
public:
    
    LR1Hash();
    LR1Hash(const SetT<LR1Element>& LR1Set);
    LR1Hash(const SetT<LR1Element>& LR1Set, unsigned id);
    ~LR1Hash();
    
    unsigned getId() const;
    
    SetT<LR1Element>& getSet() const;
    
    LR1Hash& operator = (const LR1Hash& h);
    bool operator == (const LR1Hash& h) const;
    
private:
    
    unsigned _id;
    SetT<LR1Element> _LR1Set;
    
};


#endif





