///////////////////////////////////////////////////////////////////////////////
//                                                         
// LR1Hash.cc
// ------------
// Dragon LR1 hash implementation
// 
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 2000-2007 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// IMPLEMENTATION MODULE
//
// Class: LR1Hash
// 
// Description:
//
///////////////////////////////////////////////////////////////////////////////

#include "LR1Hash.h"


LR1Hash::LR1Hash()
{
}

LR1Hash::LR1Hash(const SetT<LR1Element>& LR1Set)
{
    _LR1Set = (SetT<LR1Element>)LR1Set;
}
	
LR1Hash::LR1Hash(const SetT<LR1Element>& LR1Set, unsigned id)
{
    _LR1Set = (SetT<LR1Element>)LR1Set;
    _id = id;
}

LR1Hash::~LR1Hash()
{
}

unsigned LR1Hash::getId() const
{
    return _id;
}
	
SetT<LR1Element>& LR1Hash::getSet() const
{
    return ((LR1Hash*)this)->_LR1Set;
}
	
LR1Hash& LR1Hash::operator = (const LR1Hash& h)
{
    _id = h._id;
    _LR1Set = h._LR1Set;
    return (*this);
}
	
bool LR1Hash::operator == (const LR1Hash& h) const
{
    if (_LR1Set == (SetT<LR1Element>)h._LR1Set)
	return true;
    return false;
}
