///////////////////////////////////////////////////////////////////////////////
//                                                         
// LR1Element.cc
// -------------
// Dragon LR(1) element implementation
//                                               
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 2007 by Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// IMPLEMENTATION MODULE
//
// Class: LR1Element
// 
// Description: description of the LR(1) grammar element  
//
///////////////////////////////////////////////////////////////////////////////

#include "LR1Element.h"

LR1Element::LR1Element()
{
}

LR1Element::LR1Element(Production* pProd, unsigned pos, Chain first)
{
    _pProd = pProd;
    _pos = pos;
    _first = first;
}

LR1Element::~LR1Element()
{
}

Chain LR1Element::asChain() const
{

    Chain s = _pProd->getName();

    s += "->";

    unsigned i=0;
    while ( i < _pProd->getMaxPos() )
    {
	s += " ";
	if ( i == _pos )
	    s += ".";
	Chain sym;
	_pProd->getSymbolAtPos(sym, i);
	s += sym;
	i++;
    }
    if ( i == _pos )
	s += ".";
    
    s += "[";
    s += _first;
    s += "]";
    return s;
}

bool LR1Element::getSymbolAtPos(Chain& s) const
{
    if (_pProd->getSymbolAtPos(s, _pos) )
	return true;
    return false;
}

bool LR1Element::getFollowUpSymbol(Chain& s) const
{
    if ( ( _pos + 1 ) <  _pProd->getMaxPos() )
    {
	_pProd->getSymbolAtPos(s, _pos+1);
	return true;
    }
    else
    {
	return false;
    }
}

bool LR1Element::isProdAtPos() const
{
    if (_pos >= _pProd->getMaxPos())
	return false;
    return (! _pProd->isTermAtPos(_pos) ) ;
}

unsigned long LR1Element::getProdId() const
{
    return _pProd->getId();
}

const Chain& LR1Element::getFirst() const
{
    return _first;
}

void LR1Element::setFirst(const Chain& s)
{
    _first = s;
}

unsigned LR1Element::getPos() const
{
    return _pos;
}

LR1Element LR1Element::jumpOver()
{
    return LR1Element(_pProd, _pos+1, _first);
}

LR1Element& LR1Element::operator = (const LR1Element& e)
{
    _pProd = e._pProd;
    _pos = e._pos;
    _first = e._first;
    return (*this);   
}


bool LR1Element::operator == (const LR1Element& e) const
{
    if ( (_pProd == e._pProd ) && ( _pos == e._pos) &&  ( _first == e._first ) )
	return true;
    return false;
}






