#ifndef _LALRANALYSER_H_INCLUDED_
#define _LALRANALYSER_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// LALRAnalyser.h
// --------------
// Dragon LALR parse table analyser interface defintion
//                                                         
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2007 by Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// INTERFACE MODULE
//
// Class: LALRAnalyser
// 
// Description: 
//
///////////////////////////////////////////////////////////////////////////////

#include <lfcbase/SetT.h>
#include <lfcbase/Chain.h>

#include "Terminal.h"
#include "Production.h"
#include "FirstHash.h"
#include "TransHash.h"
#include "LR0Hash.h"
#include "LR1Hash.h"
#include "LALRHash.h"
#include "LR1Trans.h"
#include "ClosureCache.h"
#include "LR0Element.h"

class LALRAnalyser {
public:
    
    LALRAnalyser(SetT<Terminal> *pTerminalSet, SetT<Production>* pProductionSet,
		 SetT<FirstHash>* pFirstHashSet);

    ~LALRAnalyser();
        
    unsigned analyse(SetT<LR1Hash>& LR1HashSet, SetT<LR1Trans>& LR1TransSet);
    
    
private:

    void hashProdTrans();
    void getSubTrans(const Chain& prodName, SetT<Chain>& transSet);
    void getSymbolSet(SetT<Chain>& symbolSet);
    void getStartElement(LR0Element& e);
    void getClosure(SetT<LR1Element>& t, const LR1Element& e);
    bool jumpAndAdd(const SetT<LR1Trans>& LR1TransSet, unsigned id, const Chain& symbol, const LR1Element& e);
    void getLookAhead(unsigned id, const LR1Element& e, SetT<Chain>& lhset);
    void createLALRClosure(SetT<LR1Hash>& LR1HashSet);
    bool getCoreJump(SetT<LR0Element>& t, SetT<LR0Element>& s, const Chain& symbol);
    bool isEpsilonProd(const Chain& prod);

    unsigned _rot;
    void rotate(const Chain&);
    
    SetT<Terminal>* _pTerminalSet;
    SetT<Production>* _pProductionSet;
    const SetT<FirstHash>* _pFirstHashSet;

    SetT<ClosureCache> _closureCacheSet;

    SetT<TransHash> _transHashSet;
    SetT<LR0Hash> _LR0HashSet;
    SetT<LALRHash> _LALRHashSet;
};

#endif





