///////////////////////////////////////////////////////////////////////////////
//                                                         
// JavaGenerator.cc
// ----------------
// JavaGenerator implementation module
//                                               
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2018 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// IMPLEMENTATION MODULE
//
// Class: JavaGenerator
// 
// Description: Implementation module for the dragon java generator 
//
///////////////////////////////////////////////////////////////////////////////

#include <lfcbase/Exception.h>
#include <lfcbase/Chain.h>
#include <lfcbase/File.h>
#include <lfcbase/Tokenizer.h>
#include <lfcbase/ListT.h>
#include <lfcbase/SetT.h>

#define LOADCOUNT 50

#include "JavaGenerator.h"
#include "Worm.h"


JavaGenerator::JavaGenerator(const Chain& parserName, ParserMode mode, bool dynamicTable) : Dragon(parserName, mode, dynamicTable)
{
}

JavaGenerator::~JavaGenerator()
{
}

void JavaGenerator::generateCode()
{

    Chain javaFileName = _parserName + ".java";
    
    File fout(javaFileName);
    
    fout.open(File::WRITE);
    
    fout << "//\n";
    fout << "// File: "<< _parserName << ".java\n";
    fout << "// This code was produced by the dragon parser generator\n";
    fout << "//\n";
    fout << "import java.util.ArrayList;\n";
    fout << "import java.util.List;\n";
    fout << "import java.util.Stack;\n";

    fout << "\n";
    fout << "public abstract class " << _parserName << "\n";
    fout << "{\n";
    fout << "\n";
    fout << "   final int MAXTOKENVAL = 1000;\n";
    fout << "   List<String> _tokenList = new ArrayList<String>();\n";
    fout << "   Token _reservedToken;\n";
    fout << "   boolean _isReserved;\n";
    fout << "   Token _token;\n";
    fout << "   char _tokenVal[] = new char[MAXTOKENVAL];\n";
    fout << "   int _tokenLen = 0;\n";

    fout << "   int _actNum;\n";
    fout << "   Action _actAction;\n";
    fout << "   int _actFState;\n";

    fout << "\n";
    fout << "   enum Symbol { PROD, TOKEN, NONE };\n";
    fout << "   enum ScannerStateType { START, INTERMEDIATE, FINAL, ANY };\n";
    fout << "   enum Action { SHIFT, REDUCE, ACCEPT };\n";
    fout << "   enum Production {\n";

    // filter out distinct production symbols

    SetT<Chain> symbolSet;

    Production *pProd = _productionSet.First();
    pProd = _productionSet.First();
    while (pProd)
    {
	symbolSet.Insert(pProd->getName());
	pProd = _productionSet.Next();
    }   

    Chain *pS = symbolSet.First();
    while (pS)
    {
	fout << "        " << *pS;
	pS = symbolSet.Next();
	if (pS)
	    fout << ",\n";
	else
	    fout << "\n";
	  
    }
    fout << "    };\n";
    
    fout << "    public List<String> getTokenList() { return _tokenList; }\n";
    fout << "\n";
    fout << "    // source stream \n";
    fout << "    public abstract char nextChar() throws Exception;\n";
    fout << "    public abstract void backChar();\n";

    SetT<Chain> actionList;

    pProd = _productionSet.First();
    while (pProd)
    {
	if ( pProd->getAction() )
	{
	    actionList.Insert(pProd->getAction());
	}
	pProd = _productionSet.Next();
    }   

    Chain *pAction = actionList.First();
    while (pAction)
    {
	fout << "    public abstract void " << *pAction << "() throws Exception;\n";
	pAction = actionList.Next();
    }

    fout << "\n";

    fout << "    enum Token {\n";
    
    Terminal *pTerm = _terminalSet.First();
    while (pTerm)
    {
	fout << "        " << pTerm->getName() << ",\n";
	pTerm = _terminalSet.Next();
    }

    fout << "        ENDTOKEN\n";   
    fout << "    };\n";

    fout << "    void setReserved(Token t)\n";
    fout << "    {\n";
    fout << "       _reservedToken = t;\n";
    fout << "       _isReserved = true;\n";
    fout << "    }\n";



    // Sub Class ScannerStateEntry

    fout << "\n";
    fout << "   class ScannerStateEntry\n";
    fout << "   {\n";
    fout << "      int  _state;\n";
    fout << "      ScannerStateType _type;\n";
    fout << "\n";
    fout << "      ScannerStateEntry() {};\n";
    fout << "      ScannerStateEntry(int state)\n";
    fout << "      {\n";
    fout << "         _state = state;\n";
    fout << "      };\n";
    fout << "      ScannerStateEntry(int state, ScannerStateType type)\n";
    fout << "      {\n";
    fout << "         _state = state;\n";
    fout << "         _type = type;\n";
    fout << "      };\n";
    fout << "      public int getState() { return _state; }\n";
    fout << "      public ScannerStateType getType() { return _type; }\n";
    fout << "      public boolean equals(Object o)\n";
    fout << "      {\n";
    fout << "          if ( _state == ((ScannerStateEntry)o)._state )\n";
    fout << "             return true;\n";
    fout << "          return false;\n";
    fout << "      }\n";
    fout << "   }\n";
    fout << "\n";

    // Sub Class ScannerTransEntry

    fout << "   class ScannerTransEntry\n";
    fout << "   {\n";
    fout << "\n";
    fout << "      int _state;\n";
    fout << "      int _fstate;\n";
    fout << "      char _c;\n";
    fout << "\n";
    fout << "      ScannerTransEntry() {};\n";
    fout << "      ScannerTransEntry(int state, char c)\n";
    fout << "      {\n";
    fout << "         _state = state;\n";
    fout << "         _c = c;\n";
    fout << "      }\n";
    fout << "      ScannerTransEntry(int state, char c, int fstate)\n";
    fout << "      {\n";
    fout << "         _state = state;\n";
    fout << "         _fstate = fstate;\n";
    fout << "         _c = c;\n";
    fout << "      }\n";
    fout << "\n";

    fout << "      public boolean equals(Object o)\n";
    fout << "      {\n";
    fout << "          if ( _state == ((ScannerTransEntry)o)._state && _c == ((ScannerTransEntry)o)._c )\n";
    fout << "             return true;\n";
    fout << "          return false;\n";
    fout << "      }\n";
    fout << "      public int getFState() { return _fstate; };\n";
    fout << "   }\n";
    fout << "\n";

    // Sub Class Scanner

    fout << "   class Scanner\n";
    fout << "   {\n";
    fout << "      Token _t;\n";
    fout << "      List<ScannerStateEntry> _stateList;\n";
    fout << "      List<ScannerTransEntry> _transList;\n";
    fout << "      Scanner()\n";
    fout << "      {\n";
    fout << "         _stateList = new ArrayList<ScannerStateEntry>();\n";
    fout << "         _transList = new ArrayList<ScannerTransEntry>();\n";
    fout << "      }\n";
    fout << "      Scanner(Token t)\n";
    fout << "      {\n";
    fout << "         _t = t;\n";
    fout << "         _stateList = new ArrayList<ScannerStateEntry>();\n";
    fout << "         _transList = new ArrayList<ScannerTransEntry>();\n";
    fout << "      }\n";
    fout << "\n";
    fout << "      Token getToken() { return _t; }\n";
    fout << "      void addState(ScannerStateEntry s)\n";
    fout << "      {\n";
    fout << "         _stateList.add(s);\n";
    fout << "      }\n";
    fout << "      void addTransition(ScannerTransEntry t)\n";
    fout << "      {\n";
    fout << "         _transList.add(t);\n";
    fout << "      }\n";

    fout << "      public boolean checkPattern(String pattern)\n";
    fout << "      {\n";
    fout << "         int state = 0;\n";
    fout << "         int i = 0;\n";
    fout << "         while ( i < _stateList.size() )\n";
    fout << "         {\n";
    fout << "            ScannerStateEntry pS = _stateList.get(i);\n";
    fout << "            if (pS.getType() == ScannerStateType.START || pS.getType() == ScannerStateType.ANY)\n";
    fout << "            {\n";
    fout << "               state = pS.getState();\n";
    fout << "            }\n";
    fout << "            i++;\n";
    fout << "         }\n";
    fout << "         i = 0;\n";

    fout << "         if ( _transList.contains ( new ScannerTransEntry(state, pattern.charAt(i) ) ) )\n";
    fout << "         {\n";
    fout << "            ScannerTransEntry pT = _transList.get( _transList.indexOf(new ScannerTransEntry(state, pattern.charAt(i))));\n";
    fout << "            while ( pT != null )\n";
    fout << "            {\n";
    fout << "               if (_stateList.contains(new ScannerStateEntry(pT.getFState())))\n";
    fout << "               {\n";
    fout << "                  ScannerStateEntry pS = _stateList.get( _stateList.indexOf(new ScannerStateEntry(pT.getFState()))); \n";
    fout << "                  if ( ( i == pattern.length()-1 ) && ( pS.getType() == ScannerStateType.FINAL || pS.getType() == ScannerStateType.ANY))\n";
    fout << "                  {\n";
    fout << "                     return true;\n";
    fout << "                  }\n";
    fout << "                  else\n";
    fout << "                  {\n";
    fout << "                     state = pT.getFState();\n";
    fout << "                  }\n";
    fout << "               }\n";
    fout << "               else\n";
    fout << "               {\n";
    fout << "                  return false;\n";
    fout << "               }\n";
    fout << "               i++;\n";
    fout << "               if ( i < pattern.length() && _transList.contains(new ScannerTransEntry(state, pattern.charAt(i))))\n";
    fout << "               {\n";
    fout << "                  pT = _transList.get( _transList.indexOf( new ScannerTransEntry(state, pattern.charAt(i))));\n";
    fout << "               }\n";
    fout << "               else\n";
    fout << "               {\n";
    fout << "                  return false;\n";
    fout << "               }\n";
    fout << "            }\n";
    fout << "         }\n";
    fout << "         return false;\n";
    fout << "      }\n";
    fout << "   };\n";
    fout << "\n";
    fout << "   List<Scanner> _scannerList;";
    fout << "\n";

    // Sub Class StackEntry

    fout << "   class StackEntry {\n";
    fout << "\n";
    fout << "      Symbol _symbol;\n";
    fout << "      int  _num;\n";
    fout << "      int  _state;\n";
    fout << "      String  _tval;\n";
    fout << "\n";
    fout << "      StackEntry() { _symbol = Symbol.NONE; }\n";
    fout << "      StackEntry(Symbol prod, int num, int state, String tval)\n";
    fout << "      {\n";
    fout << "         _symbol = prod;\n";
    fout << "         _num = num;\n";
    fout << "         _state = state;\n";
    fout << "         _tval = tval;\n";
    fout << "      };\n";
    fout << "\n";
    fout << "      public int getState() { return _state; }\n";
    fout << "      public Symbol getSymbol() { return _symbol; }\n";
    fout << "      public String getTval() { return _tval; }\n";
    fout << "   };\n";
    fout << "\n";
    fout << "   class ActionEntry {\n";
    fout << "\n";
    fout << "      int _state;\n";
    fout << "      Token _token;\n";
    fout << "      Action _action;\n";
    fout << "      int _num;	\n";
    fout << "\n";
    fout << "      ActionEntry() {}\n";
    fout << "      ActionEntry(int state, Token token) { _state = state; _token = token; }\n";
    fout << "      ActionEntry(int state, Token token, Action action, int num)\n";
    fout << "      {\n";
    fout << "         _state=state;\n";
    fout << "         _token=token;\n";
    fout << "         _action=action;\n";
    fout << "         _num=num;\n";
    fout << "      }\n";
    fout << "      public boolean equals(Object a)\n";
    fout << "      {\n";
    fout << "         if ( _state == ((ActionEntry)a)._state && _token == ((ActionEntry)a)._token )\n";
    fout << "            return true;\n";
    fout << "         return false;\n";
    fout << "      }\n";
    fout << "\n";
    fout << "      public Action getAction() { return _action; }\n";
    fout << "      public int getNum() { return _num; }\n";
    fout << "\n";
    fout << "   };\n";
    fout << "\n";
    fout << "   List<ActionEntry> _actionMap;\n";
    fout << "\n";
    fout << "   class JumpEntry {\n";
    fout << "\n";
    fout << " 	   int _state;\n";
    fout << "	   Production _prod;\n";
    fout << "	   int _fstate;	\n";
    fout << "\n";
    fout << "	   JumpEntry() {}\n";
    fout << "	   JumpEntry(int state, Production prod) { _state = state; _prod = prod; }\n";
    fout << "	   JumpEntry(int state, Production prod, int fstate) { _state = state; _prod = prod; _fstate = fstate; }\n";
    fout << "	   public boolean equals(Object j)\n";
    fout << "      {\n";
    fout << "         if ( _state == ((JumpEntry)j)._state && _prod == ((JumpEntry)j)._prod )\n";
    fout << "            return true;\n";
    fout << "         return false;\n";
    fout << "      };\n";
    fout << "\n";
    fout << "      public int getFState() { return _fstate; }\n";
    fout << "\n";
    fout << "   }\n";
    fout << "\n";
    fout << "   List<JumpEntry> _jumpMap;\n";
    fout << "\n";
    fout << "   class ProdEntry {\n";
    fout << "\n";
    fout << "	   int _id;\n";
    fout << "	   Production _prod;\n";
    fout << "	   int _numSymbol;\n";
    fout << "\n";
    fout << "	   ProdEntry() {};\n";
    fout << "	   ProdEntry(int id) { _id = id; }\n";
    fout << "	   ProdEntry(int id, Production prod, int numSymbol)\n";
    fout << "      {\n";
    fout << "         _id = id;\n";
    fout << "         _prod = prod;\n";
    fout << "         _numSymbol = numSymbol;\n";
    fout << "      }\n";
    fout << "      public boolean equals(Object p)\n";
    fout << "      {\n";
    fout << "         if ( _id == ((ProdEntry)p)._id )\n";
    fout << "            return true;\n";
    fout << "         return false;\n";
    fout << "      };\n";

    fout << "\n";
    fout << "      public int getId() { return _id; }\n";
    fout << "      public Production getProd() { return _prod; }\n";
    fout << "      int getNumSymbol() { return _numSymbol; }\n";
    fout << "\n";
    fout << "   }\n";
    fout << "\n";
    fout << "   List<ProdEntry> _prodInfo;\n";
    fout << "\n";
    fout << "   boolean isSepIgnore(char c)\n";
    fout << "   {\n";
    
    Chain *pSep;
    
    pSep = _sepignoreList.First();
    
    while (pSep)
    {
	
	fout << "      if (c == " << *pSep << ") return true;\n";
	pSep = _sepignoreList.Next();
    }
    fout << "      return false;\n";
    fout << "   }\n";


    fout << "   boolean isSepSign(char c)\n";
    fout << "   {\n";
    
    pSep = _sepsignList.First();
    
    while (pSep)
    {
	
	fout << "   if (c == " << *pSep << ") return true;\n";
	pSep = _sepsignList.Next();
    }
    fout << "      return false;\n";
    fout << "   }\n";


    fout << "   boolean shiftToken() throws Exception\n";
    fout << "   {\n";    
    fout << "      int i=0;\n";
    fout << "      char c;\n";
    fout << "      while ( isSepIgnore(c = nextChar()) && ! _isReserved );\n";
    fout << "      if ( _isReserved )\n";
    fout << "      {\n";
    fout << "         _token = _reservedToken;\n";
    fout << "         _isReserved = false;\n";
    fout << "         return true;\n";
    fout << "      }\n";

    fout << "      if (c == 0)\n";
    fout << "      {\n";
    fout << "         _token = Token.ENDTOKEN;\n";
    fout << "         return true;\n";
    fout << "      }\n";
    
    fout << "      if (isSepSign(c))\n";
    fout << "      {\n";
    fout << "         _tokenVal[i]=c;\n";
    fout << "          i++;\n";
    fout << "      }\n";
    fout << "      else\n";
    fout << "      {\n";
    fout << "         while (c != 0 && ! isSepIgnore(c) && ! ( isSepSign(c) && i>0 ) )\n";
    fout << "         {\n";
    fout << "            _tokenVal[i]=c;\n";
    fout << "            i++;\n";
    fout << "            c = nextChar();\n";
    fout << "         }\n"; 
    fout << "         if (isSepSign(c)) backChar();\n";
    fout << "      }\n";
    fout << "      _tokenVal[i]=0;\n";
    fout << "      _tokenLen=i;\n";
    fout << "      int j=0;\n";
    fout << "      Scanner pS;\n";

    fout << "      while (j < _scannerList.size() )\n";
    fout << "      {\n";
    fout << "         pS=_scannerList.get(j);\n";
    fout << "         if (pS.checkPattern(new String(_tokenVal, 0, i)))\n";
    fout << "         {\n";
    fout << "            _token = pS.getToken();\n";
    fout << "            return true;\n";
    fout << "         }\n";
    fout << "         j++;\n";
    fout << "      }\n";
    fout << "      return false;\n";
    fout << "   }\n";

    fout << "   public void parse() throws Exception\n";
    fout << "   {\n";
    fout << "      Stack<StackEntry> s = new Stack<StackEntry>();\n";
    fout << "      StackEntry se = new StackEntry(Symbol.NONE, 0, 0, new String());\n";
    fout << "      s.push(se);    \n";
    fout << "      if ( shiftToken() == false )\n";
    fout << "      {\n";
    fout << "         throw new Exception(\"Invalid token <\" + new String(_tokenVal, 0, _tokenLen) + \">\");\n";
    fout << "      }\n";
    fout << "      while ( true )\n";
    fout << "      {\n";
    fout << "         int num=0;\n";
    fout << "         if ( getAction(s.peek().getState(), _token) )\n";
    fout << "         {\n";
    fout << "            if (_actAction == Action.SHIFT )\n";
    fout << "            {\n";
    fout << "               StackEntry ste = new StackEntry(Symbol.TOKEN, _token.ordinal(), _actNum, new String(_tokenVal, 0, _tokenLen));\n";
    fout << "               s.push(ste);\n";

    fout << "               if ( shiftToken() == false )\n";
    fout << "               {\n";    
    fout << "                  throw new Exception(\"Invalid token <\" + new String(_tokenVal, 0, _tokenLen) + \">\");\n";
    fout << "               }\n";
    fout << "            }\n";
    fout << "            else if ( _actAction == Action.REDUCE)\n";
    fout << "            {\n";
    fout << "               _tokenList.clear();\n";
   
    fout << "               ProdEntry pPE = null;\n";
    fout << "               if (  _prodInfo.contains( new ProdEntry(_actNum) ) )\n";
    fout << "               {\n";
    fout << "                  pPE = _prodInfo.get( _prodInfo.indexOf( new ProdEntry(_actNum) ) );\n";
    fout << "               }\n";
    fout << "               else if ( _actAction == Action.REDUCE)\n";
    fout << "               {\n";
    fout << "                  throw new Exception(\"No production entry found\");\n";
    fout << "               }\n";
    fout << "               for (int i=0; i<pPE.getNumSymbol();i++)\n";
    fout << "               {\n";
    fout << "                  StackEntry ste = s.pop();\n";
    fout << "                  if (ste.getSymbol() == Symbol.TOKEN)\n";
    fout << "                     _tokenList.add(ste.getTval());\n";
    fout << "               }\n";
    fout << "               if (getJump(s.peek().getState(), pPE.getProd()))\n";
    fout << "               {\n";
    fout << "                  StackEntry ste = new StackEntry(Symbol.PROD, pPE.getId(), _actFState, new String(_tokenVal, 0, _tokenLen));\n";
    fout << "                  s.push(ste);\n";
    fout << "               }\n";
    fout << "               else\n";
    fout << "               {\n";
    fout << "                  throw new Exception(\"Cannot reduce after token <\" + new String(_tokenVal, 0, _tokenLen) + \">\");\n";
    fout << "               }\n";
    fout << "               switch (_actNum)\n";
    fout << "               {\n";

    Production *pP;

    pP = _productionSet.First();
    while (pP)
    {
	if ( pP->getId() != 0 && pP->getAction() )
	{
	    fout << "                  case " << pP->getId() << ":\n" 
		 << "                     " << pP->getAction() << "();\n"
		 << "                     break;\n";	
	}
	    pP = _productionSet.Next();

    }

    fout << "               }\n";
    fout << "               _tokenList.clear();\n";
    fout << "            }\n";
    fout << "            else if ( _actAction ==  Action.ACCEPT )\n";
    fout << "            {\n";

    pP = _productionSet.First();
    while (pP)
    {
	if ( pP->getId() == 0 && pP->getAction() )
	{ 
	    fout << "                  " << pP->getAction() << "();\n";
	}
	pP = _productionSet.Next();
    }


    fout << "               return;\n";
    fout << "            }\n";
    fout << "         }\n";
    fout << "         else\n";
    fout << "         {\n";
    fout << "            throw new Exception(\"Parse error at token <\" + new String(_tokenVal, 0, _tokenLen) + \">.\");\n";
    fout << "         }\n";
    fout << "      }\n";
    fout << "   }\n";
    fout << "\n";
    fout << "   boolean getAction(int state, Token token)\n";
    fout << "   {\n";
    fout << "      ActionEntry pA = null;\n";
    fout << "      if (  _actionMap.contains( new ActionEntry(state, token)))\n";
    fout << "      {\n";
    fout << "         pA = _actionMap.get( _actionMap.indexOf( new  ActionEntry(state, token)));\n";
    fout << "      }\n";
    fout << "      if (pA != null )\n";
    fout << "      {\n";
    fout << "         _actAction = pA.getAction();\n";
    fout << "	      _actNum = pA.getNum();\n";
    fout << "	      return true;\n";
    fout << "      }\n";
    fout << "      else\n";
    fout << "      {\n";
    fout << "         return false;\n";
    fout << "      }\n";
    fout << "   }\n";
    fout << "\n";
    fout << "   boolean getJump(int state, Production prod)\n";
    fout << "   {\n";
    fout << "      JumpEntry pJ = null;\n";
    fout << "      if (  _jumpMap.contains( new JumpEntry(state, prod)))\n";
    fout << "      {\n";
    fout << "         pJ = _jumpMap.get( _jumpMap.indexOf( new JumpEntry(state, prod)));\n";
    fout << "      }\n";
    fout << "      if (pJ != null)\n";
    fout << "      {\n";
    fout << "         _actFState = pJ.getFState();\n";
    fout << "	      return true;\n";
    fout << "      }\n";
    fout << "      else\n";
    fout << "      {\n";
    fout << "	      return false;\n";
    fout << "      }\n";
    fout << "   }\n";
    fout << "\n";

    fout << "   void loadScanner()\n";
    fout << "   {\n";
    fout << "\n";


    unsigned sid=0;    

    for (unsigned i = 1; i<=_terminalSet.Size(); i++)
    {

	Terminal *pTerm = _terminalSet.First();
	while (pTerm && pTerm->getNum() != i)
	{
	    pTerm = _terminalSet.Next();
	}
	if (pTerm)
	{

	    Worm w(pTerm->getRegExp(), pTerm->getName());
	 
	    w.makeOptimalDEA();
	    
	    Chain scanner = "s" + Chain(sid);
	    
	    fout << "      Scanner " << scanner << " = new Scanner(Token." << pTerm->getName() << ");\n";
	    
	    FSMState *pS = w.getStateTable().First();	
	    while (pS)
	    {   
		
		fout << "      " << scanner << ".addState(new ScannerStateEntry("
		     << pS->Num() << " ,";
		
		switch (pS->Type())
		{
		case START:
		    fout << "ScannerStateType.START));\n";
		    break;
		case FINAL:
		    fout << "ScannerStateType.FINAL));\n";	
		    break;
		case ANY:
		    fout << "ScannerStateType.ANY));\n";	
		    break;
		case NONE:
		    fout << "ScannerStateType.INTERMEDIATE));\n";
		    break;
		}
		
		pS = w.getStateTable().Next();
	    }
	    
	    FSMTransition *pT = w.getTransitionTable().First();
	    
	    while (pT)
	    {
		
		fout << "      " << scanner << ".addTransition(new ScannerTransEntry("
		     << pT->Source() << " ,'" << pT->Sign() << "' ," << pT->Target() << "));\n";
		
		pT = w.getTransitionTable().Next();
	    }
	    
	    fout << "      _scannerList.add(" << scanner << ");\n";
	    fout << "\n";	
	    
	    sid++;
	}
	
	
    }

    fout << "   }\n";


    unsigned mcount = 0;
    fout << "   void loadParser" + Chain(mcount) + "()\n";
    fout << "   {\n";
    unsigned lcount=0;

    ParseTableEntry *pPTE = _parseTable.First();
    while (pPTE)
    {
	Chain token = pPTE->getToken();
	if ( token == Chain("$") )
	    token = Chain("ENDTOKEN");
	
	switch (pPTE->getAction())
	{
	case ParseTableEntry::SHIFT:
	    fout << "      _actionMap.add(new ActionEntry("
		 << pPTE->getState() << ", Token." << token 
		 << ", Action.SHIFT, " << pPTE->getArg() << "));\n";
	    break;
	case ParseTableEntry::REDUCE:
	    fout << "      _actionMap.add(new ActionEntry("
		 << pPTE->getState() << ", Token." << token
		 << ", Action.REDUCE, " << pPTE->getArg() << "));\n";
	    break;
	case ParseTableEntry::JUMP:
	    fout << "      _jumpMap.add(new JumpEntry("
		 << pPTE->getState() << ", Production." << token
		 << ", " << pPTE->getArg() << "));\n";
	    break;
	case ParseTableEntry::ACCEPT:
	    fout << "      _actionMap.add(new ActionEntry("
		 << pPTE->getState() << ", Token." << token
		 << ", Action.ACCEPT, " << pPTE->getArg() << "));\n";
	    break;
	}
	lcount++;
	pPTE = _parseTable.Next();

	if ( pPTE && lcount == LOADCOUNT )
	{
	    mcount++;
	    lcount=0;
	    fout << "   }\n";
	    fout << "   void loadParser" + Chain(mcount) + "()\n";
	    fout << "   {\n";
	}
    }
    fout << "   }\n";

    fout << "   " <<  _parserName << "()\n";
    fout << "   {\n";
    fout << "      _prodInfo = new ArrayList<ProdEntry>();\n";
    fout << "      _scannerList = new ArrayList<Scanner>();\n";
    fout << "      _actionMap = new ArrayList<ActionEntry>();\n";
    fout << "      _jumpMap = new ArrayList<JumpEntry>();\n";

    fout << "      loadScanner();\n";

    for ( unsigned i=0; i<=mcount; i++)
    {
	fout << "      loadParser" + Chain(i) + "();\n";	
    }

    pP = _productionSet.First();
    while (pP)
    {

	fout << "      _prodInfo.add(new ProdEntry("
	     << pP->getId() << ", Production." << pP->getName() << ", "
	     << pP->getMaxPos() << "));\n";	

	pP = _productionSet.Next();
    }
    
    fout << "      _isReserved = false;\n";

    fout << "   }\n";
    fout << "};\n";

    fout.close();
}

