///////////////////////////////////////////////////////////////////////////////
//                                                         
// FSMState.cc
// -----------
// Dragon final state machine state class implementation
//                                               
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2007 by Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// IMPLEMENTATION MODULE
//
// Class: FSMState 
// 
// Description:
//
///////////////////////////////////////////////////////////////////////////////

#include "FSMState.h"

FSMState::FSMState()
{
    _num = 0;
    _type = NONE;
    _token = Chain("");
}

FSMState::FSMState(const FSMState& x)
{

    _num = x._num;
    _type = x._type;
    _token = x._token;
}

FSMState::FSMState(unsigned long num, StateType type, const Chain& token) 
{
    _num = num;
    _type = type;
    _token = token;
}

FSMState::~FSMState()
{
}

void FSMState::setType(StateType type)
{
    _type = type;
}

unsigned long FSMState::Num()
{
    return _num;
}

StateType FSMState::Type()
{
    return _type;
}

const Chain& FSMState::Token()
{
  return _token;
}

FSMState FSMState::operator = (const FSMState& x)
{
    _num = x._num;
    _type = x._type;
    _token = x._token;
    return (*this);
}

bool FSMState::operator < (FSMState x)
{
    if (_num < x._num)
	return true;
    return false;
}

bool FSMState::operator > (FSMState x)
{
    if (_num > x._num)
	return true;
    return false;
}

bool FSMState::operator == (FSMState x)
{
    if (_num == x._num)
	return true;
    return false;
}

ostream& operator << (ostream& s, FSMState& x)
{
    s << x._num;
    return s;
}



