// IDNA  15.0.0

// clang-format off
#ifndef ADA_IDNA_TABLES_H
#define ADA_IDNA_TABLES_H
#include <cstdint>

namespace ada::idna {

const uint32_t mappings[5164] =
{
	97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113,
	114, 115, 116, 117, 118, 119, 120, 121, 122, 32, 32, 776, 32, 772, 50, 51, 32, 769,
	956, 32, 807, 49, 49, 8260, 52, 49, 8260, 50, 51, 8260, 52, 224, 225, 226, 227,
	228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 243,
	244, 245, 246, 248, 249, 250, 251, 252, 253, 254, 257, 259, 261, 263, 265, 267,
	269, 271, 273, 275, 277, 279, 281, 283, 285, 287, 289, 291, 293, 295, 297, 299,
	301, 303, 105, 775, 309, 311, 314, 316, 318, 108, 183, 322, 324, 326, 328, 700,
	110, 331, 333, 335, 337, 339, 341, 343, 345, 347, 349, 351, 353, 355, 357, 359,
	361, 363, 365, 367, 369, 371, 373, 375, 255, 378, 380, 382, 595, 387, 389, 596,
	392, 598, 599, 396, 477, 601, 603, 402, 608, 611, 617, 616, 409, 623, 626, 629,
	417, 419, 421, 640, 424, 643, 429, 648, 432, 650, 651, 436, 438, 658, 441, 445,
	100, 382, 108, 106, 110, 106, 462, 464, 466, 468, 470, 472, 474, 476, 479, 481,
	483, 485, 487, 489, 491, 493, 495, 100, 122, 501, 405, 447, 505, 507, 509, 511,
	513, 515, 517, 519, 521, 523, 525, 527, 529, 531, 533, 535, 537, 539, 541, 543,
	414, 547, 549, 551, 553, 555, 557, 559, 561, 563, 11365, 572, 410, 11366, 578, 384,
	649, 652, 583, 585, 587, 589, 591, 614, 633, 635, 641, 32, 774, 32, 775, 32, 778,
	32, 808, 32, 771, 32, 779, 661, 768, 787, 776, 769, 953, 881, 883, 697, 887, 32,
	953, 59, 1011, 32, 776, 769, 940, 941, 942, 943, 972, 973, 974, 945, 946, 947, 948,
	949, 950, 951, 952, 954, 955, 957, 958, 959, 960, 961, 963, 964, 965, 966, 967,
	968, 969, 970, 971, 983, 985, 987, 989, 991, 993, 995, 997, 999, 1001, 1003, 1005,
	1007, 1016, 1019, 891, 892, 893, 1104, 1105, 1106, 1107, 1108, 1109, 1110, 1111,
	1112, 1113, 1114, 1115, 1116, 1117, 1118, 1119, 1072, 1073, 1074, 1075, 1076, 1077,
	1078, 1079, 1080, 1081, 1082, 1083, 1084, 1085, 1086, 1087, 1088, 1089, 1090, 1091,
	1092, 1093, 1094, 1095, 1096, 1097, 1098, 1099, 1100, 1101, 1102, 1103, 1121, 1123,
	1125, 1127, 1129, 1131, 1133, 1135, 1137, 1139, 1141, 1143, 1145, 1147, 1149, 1151,
	1153, 1163, 1165, 1167, 1169, 1171, 1173, 1175, 1177, 1179, 1181, 1183, 1185, 1187,
	1189, 1191, 1193, 1195, 1197, 1199, 1201, 1203, 1205, 1207, 1209, 1211, 1213, 1215,
	1218, 1220, 1222, 1224, 1226, 1228, 1230, 1233, 1235, 1237, 1239, 1241, 1243, 1245,
	1247, 1249, 1251, 1253, 1255, 1257, 1259, 1261, 1263, 1265, 1267, 1269, 1271, 1273,
	1275, 1277, 1279, 1281, 1283, 1285, 1287, 1289, 1291, 1293, 1295, 1297, 1299, 1301,
	1303, 1305, 1307, 1309, 1311, 1313, 1315, 1317, 1319, 1321, 1323, 1325, 1327, 1377,
	1378, 1379, 1380, 1381, 1382, 1383, 1384, 1385, 1386, 1387, 1388, 1389, 1390, 1391,
	1392, 1393, 1394, 1395, 1396, 1397, 1398, 1399, 1400, 1401, 1402, 1403, 1404, 1405,
	1406, 1407, 1408, 1409, 1410, 1411, 1412, 1413, 1414, 1381, 1410, 1575, 1652, 1608,
	1652, 1735, 1652, 1610, 1652, 2325, 2364, 2326, 2364, 2327, 2364, 2332, 2364, 2337,
	2364, 2338, 2364, 2347, 2364, 2351, 2364, 2465, 2492, 2466, 2492, 2479, 2492, 2610,
	2620, 2616, 2620, 2582, 2620, 2583, 2620, 2588, 2620, 2603, 2620, 2849, 2876, 2850,
	2876, 3661, 3634, 3789, 3762, 3755, 3737, 3755, 3745, 3851, 3906, 4023, 3916, 4023,
	3921, 4023, 3926, 4023, 3931, 4023, 3904, 4021, 3953, 3954, 3953, 3956, 4018, 3968,
	4018, 3953, 3968, 4019, 3968, 4019, 3953, 3968, 3986, 4023, 3996, 4023, 4001, 4023,
	4006, 4023, 4011, 4023, 3984, 4021, 11559, 11565, 4316, 5104, 5105, 5106, 5107,
	5108, 5109, 42571, 4304, 4305, 4306, 4307, 4308, 4309, 4310, 4311, 4312, 4313, 4314,
	4315, 4317, 4318, 4319, 4320, 4321, 4322, 4323, 4324, 4325, 4326, 4327, 4328, 4329,
	4330, 4331, 4332, 4333, 4334, 4335, 4336, 4337, 4338, 4339, 4340, 4341, 4342, 4343,
	4344, 4345, 4346, 4349, 4350, 4351, 592, 593, 7426, 604, 7446, 7447, 7453, 7461,
	594, 597, 607, 609, 613, 618, 7547, 669, 621, 7557, 671, 625, 624, 627, 628, 632,
	642, 427, 7452, 656, 657, 7681, 7683, 7685, 7687, 7689, 7691, 7693, 7695, 7697,
	7699, 7701, 7703, 7705, 7707, 7709, 7711, 7713, 7715, 7717, 7719, 7721, 7723, 7725,
	7727, 7729, 7731, 7733, 7735, 7737, 7739, 7741, 7743, 7745, 7747, 7749, 7751, 7753,
	7755, 7757, 7759, 7761, 7763, 7765, 7767, 7769, 7771, 7773, 7775, 7777, 7779, 7781,
	7783, 7785, 7787, 7789, 7791, 7793, 7795, 7797, 7799, 7801, 7803, 7805, 7807, 7809,
	7811, 7813, 7815, 7817, 7819, 7821, 7823, 7825, 7827, 7829, 97, 702, 115, 115, 7841,
	7843, 7845, 7847, 7849, 7851, 7853, 7855, 7857, 7859, 7861, 7863, 7865, 7867, 7869,
	7871, 7873, 7875, 7877, 7879, 7881, 7883, 7885, 7887, 7889, 7891, 7893, 7895, 7897,
	7899, 7901, 7903, 7905, 7907, 7909, 7911, 7913, 7915, 7917, 7919, 7921, 7923, 7925,
	7927, 7929, 7931, 7933, 7935, 7936, 7937, 7938, 7939, 7940, 7941, 7942, 7943, 7952,
	7953, 7954, 7955, 7956, 7957, 7968, 7969, 7970, 7971, 7972, 7973, 7974, 7975, 7984,
	7985, 7986, 7987, 7988, 7989, 7990, 7991, 8000, 8001, 8002, 8003, 8004, 8005, 8017,
	8019, 8021, 8023, 8032, 8033, 8034, 8035, 8036, 8037, 8038, 8039, 7936, 953, 7937,
	953, 7938, 953, 7939, 953, 7940, 953, 7941, 953, 7942, 953, 7943, 953, 7968, 953,
	7969, 953, 7970, 953, 7971, 953, 7972, 953, 7973, 953, 7974, 953, 7975, 953, 8032,
	953, 8033, 953, 8034, 953, 8035, 953, 8036, 953, 8037, 953, 8038, 953, 8039, 953,
	8048, 953, 945, 953, 940, 953, 8118, 953, 8112, 8113, 32, 787, 32, 834, 32, 776,
	834, 8052, 953, 951, 953, 942, 953, 8134, 953, 8050, 32, 787, 768, 32, 787, 769,
	32, 787, 834, 912, 8144, 8145, 8054, 32, 788, 768, 32, 788, 769, 32, 788, 834, 944,
	8160, 8161, 8058, 8165, 32, 776, 768, 96, 8060, 953, 969, 953, 974, 953, 8182, 953,
	8056, 8208, 32, 819, 8242, 8242, 8242, 8242, 8242, 8245, 8245, 8245, 8245, 8245,
	33, 33, 32, 773, 63, 63, 63, 33, 33, 63, 48, 53, 54, 55, 56, 57, 43, 8722, 61, 40,
	41, 97, 47, 99, 97, 47, 115, 176, 99, 99, 47, 111, 99, 47, 117, 176, 102, 115, 109,
	116, 101, 108, 116, 109, 1488, 1489, 1490, 1491, 102, 97, 120, 8721, 49, 8260, 55,
	49, 8260, 57, 49, 8260, 49, 48, 49, 8260, 51, 50, 8260, 51, 49, 8260, 53, 50, 8260,
	53, 51, 8260, 53, 52, 8260, 53, 49, 8260, 54, 53, 8260, 54, 49, 8260, 56, 51, 8260,
	56, 53, 8260, 56, 55, 8260, 56, 105, 105, 105, 105, 105, 105, 118, 118, 105, 118,
	105, 105, 118, 105, 105, 105, 105, 120, 120, 105, 120, 105, 105, 48, 8260, 51, 8747,
	8747, 8747, 8747, 8747, 8750, 8750, 8750, 8750, 8750, 12296, 12297, 49, 50, 49,
	51, 49, 52, 49, 53, 49, 54, 49, 55, 49, 56, 49, 57, 50, 48, 40, 49, 41, 40, 50,
	41, 40, 51, 41, 40, 52, 41, 40, 53, 41, 40, 54, 41, 40, 55, 41, 40, 56, 41, 40,
	57, 41, 40, 49, 48, 41, 40, 49, 49, 41, 40, 49, 50, 41, 40, 49, 51, 41, 40, 49,
	52, 41, 40, 49, 53, 41, 40, 49, 54, 41, 40, 49, 55, 41, 40, 49, 56, 41, 40, 49,
	57, 41, 40, 50, 48, 41, 40, 97, 41, 40, 98, 41, 40, 99, 41, 40, 100, 41, 40, 101,
	41, 40, 102, 41, 40, 103, 41, 40, 104, 41, 40, 105, 41, 40, 106, 41, 40, 107, 41,
	40, 108, 41, 40, 109, 41, 40, 110, 41, 40, 111, 41, 40, 112, 41, 40, 113, 41, 40,
	114, 41, 40, 115, 41, 40, 116, 41, 40, 117, 41, 40, 118, 41, 40, 119, 41, 40, 120,
	41, 40, 121, 41, 40, 122, 41, 58, 58, 61, 61, 61, 10973, 824, 11312, 11313, 11314,
	11315, 11316, 11317, 11318, 11319, 11320, 11321, 11322, 11323, 11324, 11325, 11326,
	11327, 11328, 11329, 11330, 11331, 11332, 11333, 11334, 11335, 11336, 11337, 11338,
	11339, 11340, 11341, 11342, 11343, 11344, 11345, 11346, 11347, 11348, 11349, 11350,
	11351, 11352, 11353, 11354, 11355, 11356, 11357, 11358, 11359, 11361, 619, 7549,
	637, 11368, 11370, 11372, 11379, 11382, 575, 576, 11393, 11395, 11397, 11399, 11401,
	11403, 11405, 11407, 11409, 11411, 11413, 11415, 11417, 11419, 11421, 11423, 11425,
	11427, 11429, 11431, 11433, 11435, 11437, 11439, 11441, 11443, 11445, 11447, 11449,
	11451, 11453, 11455, 11457, 11459, 11461, 11463, 11465, 11467, 11469, 11471, 11473,
	11475, 11477, 11479, 11481, 11483, 11485, 11487, 11489, 11491, 11500, 11502, 11507,
	11617, 27597, 40863, 19968, 20008, 20022, 20031, 20057, 20101, 20108, 20128, 20154,
	20799, 20837, 20843, 20866, 20886, 20907, 20960, 20981, 20992, 21147, 21241, 21269,
	21274, 21304, 21313, 21340, 21353, 21378, 21430, 21448, 21475, 22231, 22303, 22763,
	22786, 22794, 22805, 22823, 22899, 23376, 23424, 23544, 23567, 23586, 23608, 23662,
	23665, 24027, 24037, 24049, 24062, 24178, 24186, 24191, 24308, 24318, 24331, 24339,
	24400, 24417, 24435, 24515, 25096, 25142, 25163, 25903, 25908, 25991, 26007, 26020,
	26041, 26080, 26085, 26352, 26376, 26408, 27424, 27490, 27513, 27571, 27595, 27604,
	27611, 27663, 27668, 27700, 28779, 29226, 29238, 29243, 29247, 29255, 29273, 29275,
	29356, 29572, 29577, 29916, 29926, 29976, 29983, 29992, 30000, 30091, 30098, 30326,
	30333, 30382, 30399, 30446, 30683, 30690, 30707, 31034, 31160, 31166, 31348, 31435,
	31481, 31859, 31992, 32566, 32593, 32650, 32701, 32769, 32780, 32786, 32819, 32895,
	32905, 33251, 33258, 33267, 33276, 33292, 33307, 33311, 33390, 33394, 33400, 34381,
	34411, 34880, 34892, 34915, 35198, 35211, 35282, 35328, 35895, 35910, 35925, 35960,
	35997, 36196, 36208, 36275, 36523, 36554, 36763, 36784, 36789, 37009, 37193, 37318,
	37324, 37329, 38263, 38272, 38428, 38582, 38585, 38632, 38737, 38750, 38754, 38761,
	38859, 38893, 38899, 38913, 39080, 39131, 39135, 39318, 39321, 39340, 39592, 39640,
	39647, 39717, 39727, 39730, 39740, 39770, 40165, 40565, 40575, 40613, 40635, 40643,
	40653, 40657, 40697, 40701, 40718, 40723, 40736, 40763, 40778, 40786, 40845, 40860,
	40864, 46, 12306, 21316, 21317, 32, 12441, 32, 12442, 12424, 12426, 12467, 12488,
	4352, 4353, 4522, 4354, 4524, 4525, 4355, 4356, 4357, 4528, 4529, 4530, 4531, 4532,
	4533, 4378, 4358, 4359, 4360, 4385, 4361, 4362, 4363, 4364, 4365, 4366, 4367, 4368,
	4369, 4370, 4449, 4450, 4451, 4452, 4453, 4454, 4455, 4456, 4457, 4458, 4459, 4460,
	4461, 4462, 4463, 4464, 4465, 4466, 4467, 4468, 4469, 4372, 4373, 4551, 4552, 4556,
	4558, 4563, 4567, 4569, 4380, 4573, 4575, 4381, 4382, 4384, 4386, 4387, 4391, 4393,
	4395, 4396, 4397, 4398, 4399, 4402, 4406, 4416, 4423, 4428, 4593, 4594, 4439, 4440,
	4441, 4484, 4485, 4488, 4497, 4498, 4500, 4510, 4513, 19977, 22235, 19978, 20013,
	19979, 30002, 19993, 19969, 22825, 22320, 40, 4352, 41, 40, 4354, 41, 40, 4355,
	41, 40, 4357, 41, 40, 4358, 41, 40, 4359, 41, 40, 4361, 41, 40, 4363, 41, 40, 4364,
	41, 40, 4366, 41, 40, 4367, 41, 40, 4368, 41, 40, 4369, 41, 40, 4370, 41, 40, 44032,
	41, 40, 45208, 41, 40, 45796, 41, 40, 46972, 41, 40, 47560, 41, 40, 48148, 41, 40,
	49324, 41, 40, 50500, 41, 40, 51088, 41, 40, 52264, 41, 40, 52852, 41, 40, 53440,
	41, 40, 54028, 41, 40, 54616, 41, 40, 51452, 41, 40, 50724, 51204, 41, 40, 50724,
	54980, 41, 40, 19968, 41, 40, 20108, 41, 40, 19977, 41, 40, 22235, 41, 40, 20116,
	41, 40, 20845, 41, 40, 19971, 41, 40, 20843, 41, 40, 20061, 41, 40, 21313, 41, 40,
	26376, 41, 40, 28779, 41, 40, 27700, 41, 40, 26408, 41, 40, 37329, 41, 40, 22303,
	41, 40, 26085, 41, 40, 26666, 41, 40, 26377, 41, 40, 31038, 41, 40, 21517, 41, 40,
	29305, 41, 40, 36001, 41, 40, 31069, 41, 40, 21172, 41, 40, 20195, 41, 40, 21628,
	41, 40, 23398, 41, 40, 30435, 41, 40, 20225, 41, 40, 36039, 41, 40, 21332, 41, 40,
	31085, 41, 40, 20241, 41, 40, 33258, 41, 40, 33267, 41, 21839, 24188, 31631, 112,
	116, 101, 50, 50, 50, 52, 50, 53, 50, 54, 50, 55, 50, 56, 50, 57, 51, 48, 51, 51,
	51, 52, 51, 53, 52280, 44256, 51452, 51032, 50864, 31192, 30007, 36969, 20778, 21360,
	27880, 38917, 20889, 27491, 24038, 21491, 21307, 23447, 22812, 51, 54, 51, 55, 51,
	56, 51, 57, 52, 48, 52, 52, 52, 53, 52, 54, 52, 55, 52, 56, 52, 57, 53, 48, 49,
	26376, 50, 26376, 51, 26376, 52, 26376, 53, 26376, 54, 26376, 55, 26376, 56, 26376,
	57, 26376, 49, 48, 26376, 49, 49, 26376, 49, 50, 26376, 104, 103, 101, 114, 103,
	101, 118, 108, 116, 100, 12450, 12452, 12454, 12456, 12458, 12459, 12461, 12463,
	12465, 12469, 12471, 12473, 12475, 12477, 12479, 12481, 12484, 12486, 12490, 12491,
	12492, 12493, 12494, 12495, 12498, 12501, 12504, 12507, 12510, 12511, 12512, 12513,
	12514, 12516, 12518, 12520, 12521, 12522, 12523, 12524, 12525, 12527, 12528, 12529,
	12530, 20196, 21644, 12450, 12497, 12540, 12488, 12450, 12523, 12501, 12449, 12450,
	12531, 12506, 12450, 12450, 12540, 12523, 12452, 12491, 12531, 12464, 12452, 12531,
	12481, 12454, 12457, 12531, 12456, 12473, 12463, 12540, 12489, 12456, 12540, 12459,
	12540, 12458, 12531, 12473, 12458, 12540, 12512, 12459, 12452, 12522, 12459, 12521,
	12483, 12488, 12459, 12525, 12522, 12540, 12460, 12525, 12531, 12460, 12531, 12510,
	12462, 12460, 12462, 12491, 12540, 12461, 12517, 12522, 12540, 12462, 12523, 12480,
	12540, 12461, 12525, 12461, 12525, 12464, 12521, 12512, 12461, 12525, 12513, 12540,
	12488, 12523, 12461, 12525, 12527, 12483, 12488, 12464, 12521, 12512, 12488, 12531,
	12463, 12523, 12476, 12452, 12525, 12463, 12525, 12540, 12493, 12465, 12540, 12473,
	12467, 12523, 12490, 12467, 12540, 12509, 12469, 12452, 12463, 12523, 12469, 12531,
	12481, 12540, 12512, 12471, 12522, 12531, 12464, 12475, 12531, 12481, 12475, 12531,
	12488, 12480, 12540, 12473, 12487, 12471, 12489, 12523, 12490, 12494, 12494, 12483,
	12488, 12495, 12452, 12484, 12497, 12540, 12475, 12531, 12488, 12497, 12540, 12484,
	12496, 12540, 12524, 12523, 12500, 12450, 12473, 12488, 12523, 12500, 12463, 12523,
	12500, 12467, 12499, 12523, 12501, 12449, 12521, 12483, 12489, 12501, 12451, 12540,
	12488, 12502, 12483, 12471, 12455, 12523, 12501, 12521, 12531, 12504, 12463, 12479,
	12540, 12523, 12506, 12477, 12506, 12491, 12498, 12504, 12523, 12484, 12506, 12531,
	12473, 12506, 12540, 12472, 12505, 12540, 12479, 12509, 12452, 12531, 12488, 12508,
	12523, 12488, 12507, 12531, 12509, 12531, 12489, 12507, 12540, 12523, 12507, 12540,
	12531, 12510, 12452, 12463, 12525, 12510, 12452, 12523, 12510, 12483, 12495, 12510,
	12523, 12463, 12510, 12531, 12471, 12519, 12531, 12511, 12463, 12525, 12531, 12511,
	12522, 12511, 12522, 12496, 12540, 12523, 12513, 12460, 12513, 12460, 12488, 12531,
	12516, 12540, 12489, 12516, 12540, 12523, 12518, 12450, 12531, 12522, 12483, 12488,
	12523, 12522, 12521, 12523, 12500, 12540, 12523, 12540, 12502, 12523, 12524, 12512,
	12524, 12531, 12488, 12466, 12531, 48, 28857, 49, 28857, 50, 28857, 51, 28857, 52,
	28857, 53, 28857, 54, 28857, 55, 28857, 56, 28857, 57, 28857, 49, 48, 28857, 49,
	49, 28857, 49, 50, 28857, 49, 51, 28857, 49, 52, 28857, 49, 53, 28857, 49, 54, 28857,
	49, 55, 28857, 49, 56, 28857, 49, 57, 28857, 50, 48, 28857, 50, 49, 28857, 50, 50,
	28857, 50, 51, 28857, 50, 52, 28857, 104, 112, 97, 100, 97, 97, 117, 98, 97, 114,
	111, 118, 112, 99, 100, 109, 100, 109, 50, 100, 109, 51, 105, 117, 24179, 25104,
	26157, 21644, 22823, 27491, 26126, 27835, 26666, 24335, 20250, 31038, 110, 97, 956,
	97, 109, 97, 107, 97, 107, 98, 109, 98, 103, 98, 99, 97, 108, 107, 99, 97, 108,
	112, 102, 110, 102, 956, 102, 956, 103, 109, 103, 107, 103, 104, 122, 107, 104,
	122, 109, 104, 122, 116, 104, 122, 956, 108, 109, 108, 100, 108, 102, 109, 110,
	109, 956, 109, 109, 109, 99, 109, 107, 109, 109, 109, 50, 99, 109, 50, 107, 109,
	50, 109, 109, 51, 99, 109, 51, 107, 109, 51, 109, 8725, 115, 109, 8725, 115, 50,
	107, 112, 97, 109, 112, 97, 103, 112, 97, 114, 97, 100, 114, 97, 100, 8725, 115,
	114, 97, 100, 8725, 115, 50, 112, 115, 110, 115, 956, 115, 109, 115, 112, 118, 110,
	118, 956, 118, 109, 118, 107, 118, 112, 119, 110, 119, 956, 119, 109, 119, 107,
	119, 107, 969, 109, 969, 98, 113, 99, 8725, 107, 103, 100, 98, 103, 121, 104, 97,
	105, 110, 107, 107, 107, 116, 108, 110, 108, 111, 103, 108, 120, 109, 105, 108,
	109, 111, 108, 112, 104, 112, 112, 109, 112, 114, 115, 118, 119, 98, 118, 8725,
	109, 97, 8725, 109, 49, 26085, 50, 26085, 51, 26085, 52, 26085, 53, 26085, 54, 26085,
	55, 26085, 56, 26085, 57, 26085, 49, 48, 26085, 49, 49, 26085, 49, 50, 26085, 49,
	51, 26085, 49, 52, 26085, 49, 53, 26085, 49, 54, 26085, 49, 55, 26085, 49, 56, 26085,
	49, 57, 26085, 50, 48, 26085, 50, 49, 26085, 50, 50, 26085, 50, 51, 26085, 50, 52,
	26085, 50, 53, 26085, 50, 54, 26085, 50, 55, 26085, 50, 56, 26085, 50, 57, 26085,
	51, 48, 26085, 51, 49, 26085, 103, 97, 108, 42561, 42563, 42565, 42567, 42569, 42573,
	42575, 42577, 42579, 42581, 42583, 42585, 42587, 42589, 42591, 42593, 42595, 42597,
	42599, 42601, 42603, 42605, 42625, 42627, 42629, 42631, 42633, 42635, 42637, 42639,
	42641, 42643, 42645, 42647, 42649, 42651, 42787, 42789, 42791, 42793, 42795, 42797,
	42799, 42803, 42805, 42807, 42809, 42811, 42813, 42815, 42817, 42819, 42821, 42823,
	42825, 42827, 42829, 42831, 42833, 42835, 42837, 42839, 42841, 42843, 42845, 42847,
	42849, 42851, 42853, 42855, 42857, 42859, 42861, 42863, 42874, 42876, 7545, 42879,
	42881, 42883, 42885, 42887, 42892, 42897, 42899, 42903, 42905, 42907, 42909, 42911,
	42913, 42915, 42917, 42919, 42921, 620, 670, 647, 43859, 42933, 42935, 42937, 42939,
	42941, 42943, 42945, 42947, 42900, 7566, 42952, 42954, 42961, 42967, 42969, 42998,
	43831, 43858, 653, 5024, 5025, 5026, 5027, 5028, 5029, 5030, 5031, 5032, 5033, 5034,
	5035, 5036, 5037, 5038, 5039, 5040, 5041, 5042, 5043, 5044, 5045, 5046, 5047, 5048,
	5049, 5050, 5051, 5052, 5053, 5054, 5055, 5056, 5057, 5058, 5059, 5060, 5061, 5062,
	5063, 5064, 5065, 5066, 5067, 5068, 5069, 5070, 5071, 5072, 5073, 5074, 5075, 5076,
	5077, 5078, 5079, 5080, 5081, 5082, 5083, 5084, 5085, 5086, 5087, 5088, 5089, 5090,
	5091, 5092, 5093, 5094, 5095, 5096, 5097, 5098, 5099, 5100, 5101, 5102, 5103, 35912,
	26356, 36040, 28369, 20018, 21477, 22865, 21895, 22856, 25078, 30313, 32645, 34367,
	34746, 35064, 37007, 27138, 27931, 28889, 29662, 33853, 37226, 39409, 20098, 21365,
	27396, 29211, 34349, 40478, 23888, 28651, 34253, 35172, 25289, 33240, 34847, 24266,
	26391, 28010, 29436, 37070, 20358, 20919, 21214, 25796, 27347, 29200, 30439, 34310,
	34396, 36335, 38706, 39791, 40442, 30860, 31103, 32160, 33737, 37636, 35542, 22751,
	24324, 31840, 32894, 29282, 30922, 36034, 38647, 22744, 23650, 27155, 28122, 28431,
	32047, 32311, 38475, 21202, 32907, 20956, 20940, 31260, 32190, 33777, 38517, 35712,
	25295, 35582, 20025, 23527, 24594, 29575, 30064, 21271, 30971, 20415, 24489, 19981,
	27852, 25976, 32034, 21443, 22622, 30465, 33865, 35498, 27578, 27784, 25342, 33509,
	25504, 30053, 20142, 20841, 20937, 26753, 31975, 33391, 35538, 37327, 21237, 21570,
	24300, 26053, 28670, 31018, 38317, 39530, 40599, 40654, 26310, 27511, 36706, 24180,
	24976, 25088, 25754, 28451, 29001, 29833, 31178, 32244, 32879, 36646, 34030, 36899,
	37706, 21015, 21155, 21693, 28872, 35010, 24265, 24565, 25467, 27566, 31806, 29557,
	22265, 23994, 24604, 29618, 29801, 32666, 32838, 37428, 38646, 38728, 38936, 20363,
	31150, 37300, 38584, 24801, 20102, 20698, 23534, 23615, 26009, 29134, 30274, 34044,
	36988, 26248, 38446, 21129, 26491, 26611, 27969, 28316, 29705, 30041, 30827, 32016,
	39006, 25134, 38520, 20523, 23833, 28138, 36650, 24459, 24900, 26647, 38534, 21033,
	21519, 23653, 26131, 26446, 26792, 27877, 29702, 30178, 32633, 35023, 35041, 38626,
	21311, 28346, 21533, 29136, 29848, 34298, 38563, 40023, 40607, 26519, 28107, 33256,
	31520, 31890, 29376, 28825, 35672, 20160, 33590, 21050, 20999, 24230, 25299, 31958,
	23429, 27934, 26292, 36667, 38477, 24275, 20800, 21952, 22618, 26228, 20958, 29482,
	30410, 31036, 31070, 31077, 31119, 38742, 31934, 34322, 35576, 36920, 37117, 39151,
	39164, 39208, 40372, 37086, 38583, 20398, 20711, 20813, 21193, 21220, 21329, 21917,
	22022, 22120, 22592, 22696, 23652, 24724, 24936, 24974, 25074, 25935, 26082, 26257,
	26757, 28023, 28186, 28450, 29038, 29227, 29730, 30865, 31049, 31048, 31056, 31062,
	31117, 31118, 31296, 31361, 31680, 32265, 32321, 32626, 32773, 33261, 33401, 33879,
	35088, 35222, 35585, 35641, 36051, 36104, 36790, 38627, 38911, 38971, 24693, 148206,
	33304, 20006, 20917, 20840, 20352, 20805, 20864, 21191, 21242, 21845, 21913, 21986,
	22707, 22852, 22868, 23138, 23336, 24274, 24281, 24425, 24493, 24792, 24910, 24840,
	24928, 25140, 25540, 25628, 25682, 25942, 26395, 26454, 28379, 28363, 28702, 30631,
	29237, 29359, 29809, 29958, 30011, 30237, 30239, 30427, 30452, 30538, 30528, 30924,
	31409, 31867, 32091, 32574, 33618, 33775, 34681, 35137, 35206, 35519, 35531, 35565,
	35722, 36664, 36978, 37273, 37494, 38524, 38875, 38923, 39698, 141386, 141380, 144341,
	15261, 16408, 16441, 152137, 154832, 163539, 40771, 40846, 102, 102, 102, 105, 102,
	108, 102, 102, 108, 1396, 1398, 1396, 1381, 1396, 1387, 1406, 1398, 1396, 1389,
	1497, 1460, 1522, 1463, 1506, 1492, 1499, 1500, 1501, 1512, 1514, 1513, 1473, 1513,
	1474, 1513, 1468, 1473, 1513, 1468, 1474, 1488, 1463, 1488, 1464, 1488, 1468, 1489,
	1468, 1490, 1468, 1491, 1468, 1492, 1468, 1493, 1468, 1494, 1468, 1496, 1468, 1497,
	1468, 1498, 1468, 1499, 1468, 1500, 1468, 1502, 1468, 1504, 1468, 1505, 1468, 1507,
	1468, 1508, 1468, 1510, 1468, 1511, 1468, 1512, 1468, 1514, 1468, 1493, 1465, 1489,
	1471, 1499, 1471, 1508, 1471, 1488, 1500, 1649, 1659, 1662, 1664, 1658, 1663, 1657,
	1700, 1702, 1668, 1667, 1670, 1671, 1677, 1676, 1678, 1672, 1688, 1681, 1705, 1711,
	1715, 1713, 1722, 1723, 1728, 1729, 1726, 1746, 1747, 1709, 1734, 1736, 1739, 1733,
	1737, 1744, 1609, 1574, 1575, 1574, 1749, 1574, 1608, 1574, 1735, 1574, 1734, 1574,
	1736, 1574, 1744, 1574, 1609, 1740, 1574, 1580, 1574, 1581, 1574, 1605, 1574, 1610,
	1576, 1580, 1576, 1581, 1576, 1582, 1576, 1605, 1576, 1609, 1576, 1610, 1578, 1580,
	1578, 1581, 1578, 1582, 1578, 1605, 1578, 1609, 1578, 1610, 1579, 1580, 1579, 1605,
	1579, 1609, 1579, 1610, 1580, 1581, 1580, 1605, 1581, 1605, 1582, 1580, 1582, 1581,
	1582, 1605, 1587, 1580, 1587, 1581, 1587, 1582, 1587, 1605, 1589, 1581, 1589, 1605,
	1590, 1580, 1590, 1581, 1590, 1582, 1590, 1605, 1591, 1581, 1591, 1605, 1592, 1605,
	1593, 1580, 1593, 1605, 1594, 1580, 1594, 1605, 1601, 1580, 1601, 1581, 1601, 1582,
	1601, 1605, 1601, 1609, 1601, 1610, 1602, 1581, 1602, 1605, 1602, 1609, 1602, 1610,
	1603, 1575, 1603, 1580, 1603, 1581, 1603, 1582, 1603, 1604, 1603, 1605, 1603, 1609,
	1603, 1610, 1604, 1580, 1604, 1581, 1604, 1582, 1604, 1605, 1604, 1609, 1604, 1610,
	1605, 1580, 1605, 1605, 1605, 1609, 1605, 1610, 1606, 1580, 1606, 1581, 1606, 1582,
	1606, 1605, 1606, 1609, 1606, 1610, 1607, 1580, 1607, 1605, 1607, 1609, 1607, 1610,
	1610, 1581, 1610, 1582, 1610, 1609, 1584, 1648, 1585, 1648, 1609, 1648, 32, 1612,
	1617, 32, 1613, 1617, 32, 1614, 1617, 32, 1615, 1617, 32, 1616, 1617, 32, 1617,
	1648, 1574, 1585, 1574, 1586, 1574, 1606, 1576, 1585, 1576, 1586, 1576, 1606, 1578,
	1585, 1578, 1586, 1578, 1606, 1579, 1585, 1579, 1586, 1579, 1606, 1605, 1575, 1606,
	1585, 1606, 1586, 1606, 1606, 1610, 1585, 1610, 1586, 1574, 1582, 1574, 1607, 1576,
	1607, 1578, 1607, 1589, 1582, 1604, 1607, 1606, 1607, 1607, 1648, 1579, 1607, 1587,
	1607, 1588, 1605, 1588, 1607, 1600, 1614, 1617, 1600, 1615, 1617, 1600, 1616, 1617,
	1591, 1609, 1591, 1610, 1593, 1609, 1593, 1610, 1594, 1609, 1594, 1610, 1587, 1609,
	1587, 1610, 1588, 1609, 1588, 1610, 1581, 1609, 1580, 1609, 1580, 1610, 1582, 1609,
	1589, 1609, 1589, 1610, 1590, 1609, 1590, 1610, 1588, 1580, 1588, 1581, 1588, 1582,
	1588, 1585, 1587, 1585, 1589, 1585, 1590, 1585, 1575, 1611, 1578, 1580, 1605, 1578,
	1581, 1580, 1578, 1581, 1605, 1578, 1582, 1605, 1578, 1605, 1580, 1578, 1605, 1581,
	1578, 1605, 1582, 1581, 1605, 1610, 1581, 1605, 1609, 1587, 1581, 1580, 1587, 1580,
	1581, 1587, 1580, 1609, 1587, 1605, 1581, 1587, 1605, 1580, 1587, 1605, 1605, 1589,
	1581, 1581, 1589, 1605, 1605, 1588, 1581, 1605, 1588, 1580, 1610, 1588, 1605, 1582,
	1588, 1605, 1605, 1590, 1581, 1609, 1590, 1582, 1605, 1591, 1605, 1581, 1591, 1605,
	1605, 1591, 1605, 1610, 1593, 1580, 1605, 1593, 1605, 1605, 1593, 1605, 1609, 1594,
	1605, 1605, 1594, 1605, 1610, 1594, 1605, 1609, 1601, 1582, 1605, 1602, 1605, 1581,
	1602, 1605, 1605, 1604, 1581, 1605, 1604, 1581, 1610, 1604, 1581, 1609, 1604, 1580,
	1580, 1604, 1582, 1605, 1604, 1605, 1581, 1605, 1581, 1580, 1605, 1581, 1610, 1605,
	1580, 1581, 1605, 1582, 1605, 1605, 1580, 1582, 1607, 1605, 1580, 1607, 1605, 1605,
	1606, 1581, 1605, 1606, 1581, 1609, 1606, 1580, 1605, 1606, 1580, 1609, 1606, 1605,
	1610, 1606, 1605, 1609, 1610, 1605, 1605, 1576, 1582, 1610, 1578, 1580, 1610, 1578,
	1580, 1609, 1578, 1582, 1610, 1578, 1582, 1609, 1578, 1605, 1610, 1578, 1605, 1609,
	1580, 1605, 1610, 1580, 1581, 1609, 1580, 1605, 1609, 1587, 1582, 1609, 1589, 1581,
	1610, 1588, 1581, 1610, 1590, 1581, 1610, 1604, 1580, 1610, 1604, 1605, 1610, 1610,
	1580, 1610, 1610, 1605, 1610, 1605, 1605, 1610, 1602, 1605, 1610, 1606, 1581, 1610,
	1593, 1605, 1610, 1603, 1605, 1610, 1606, 1580, 1581, 1605, 1582, 1610, 1604, 1580,
	1605, 1603, 1605, 1605, 1580, 1581, 1610, 1581, 1580, 1610, 1605, 1580, 1610, 1601,
	1605, 1610, 1576, 1581, 1610, 1587, 1582, 1610, 1606, 1580, 1610, 1589, 1604, 1746,
	1602, 1604, 1746, 1575, 1604, 1604, 1607, 1575, 1603, 1576, 1585, 1605, 1581, 1605,
	1583, 1589, 1604, 1593, 1605, 1585, 1587, 1608, 1604, 1593, 1604, 1610, 1607, 1608,
	1587, 1604, 1605, 1589, 1604, 1609, 1589, 1604, 1609, 32, 1575, 1604, 1604, 1607,
	32, 1593, 1604, 1610, 1607, 32, 1608, 1587, 1604, 1605, 1580, 1604, 32, 1580, 1604,
	1575, 1604, 1607, 1585, 1740, 1575, 1604, 44, 12289, 12310, 12311, 8212, 8211, 95,
	123, 125, 12308, 12309, 12304, 12305, 12298, 12299, 12300, 12301, 12302, 12303,
	91, 93, 35, 38, 42, 45, 60, 62, 92, 36, 37, 64, 32, 1611, 1600, 1611, 1600, 1617,
	32, 1618, 1600, 1618, 1569, 1570, 1571, 1572, 1573, 1577, 1604, 1570, 1604, 1571,
	1604, 1573, 34, 39, 94, 124, 126, 10629, 10630, 12539, 12453, 12515, 162, 163, 172,
	166, 165, 8361, 9474, 8592, 8593, 8594, 8595, 9632, 9675, 66600, 66601, 66602, 66603,
	66604, 66605, 66606, 66607, 66608, 66609, 66610, 66611, 66612, 66613, 66614, 66615,
	66616, 66617, 66618, 66619, 66620, 66621, 66622, 66623, 66624, 66625, 66626, 66627,
	66628, 66629, 66630, 66631, 66632, 66633, 66634, 66635, 66636, 66637, 66638, 66639,
	66776, 66777, 66778, 66779, 66780, 66781, 66782, 66783, 66784, 66785, 66786, 66787,
	66788, 66789, 66790, 66791, 66792, 66793, 66794, 66795, 66796, 66797, 66798, 66799,
	66800, 66801, 66802, 66803, 66804, 66805, 66806, 66807, 66808, 66809, 66810, 66811,
	66967, 66968, 66969, 66970, 66971, 66972, 66973, 66974, 66975, 66976, 66977, 66979,
	66980, 66981, 66982, 66983, 66984, 66985, 66986, 66987, 66988, 66989, 66990, 66991,
	66992, 66993, 66995, 66996, 66997, 66998, 66999, 67000, 67001, 67003, 67004, 720,
	721, 665, 675, 43878, 677, 676, 7569, 600, 606, 681, 612, 610, 667, 668, 615, 644,
	682, 683, 122628, 42894, 622, 122629, 654, 122630, 630, 631, 634, 122632, 638, 680,
	678, 43879, 679, 11377, 655, 673, 674, 664, 448, 449, 450, 122634, 122654, 68800,
	68801, 68802, 68803, 68804, 68805, 68806, 68807, 68808, 68809, 68810, 68811, 68812,
	68813, 68814, 68815, 68816, 68817, 68818, 68819, 68820, 68821, 68822, 68823, 68824,
	68825, 68826, 68827, 68828, 68829, 68830, 68831, 68832, 68833, 68834, 68835, 68836,
	68837, 68838, 68839, 68840, 68841, 68842, 68843, 68844, 68845, 68846, 68847, 68848,
	68849, 68850, 71872, 71873, 71874, 71875, 71876, 71877, 71878, 71879, 71880, 71881,
	71882, 71883, 71884, 71885, 71886, 71887, 71888, 71889, 71890, 71891, 71892, 71893,
	71894, 71895, 71896, 71897, 71898, 71899, 71900, 71901, 71902, 71903, 93792, 93793,
	93794, 93795, 93796, 93797, 93798, 93799, 93800, 93801, 93802, 93803, 93804, 93805,
	93806, 93807, 93808, 93809, 93810, 93811, 93812, 93813, 93814, 93815, 93816, 93817,
	93818, 93819, 93820, 93821, 93822, 93823, 119127, 119141, 119128, 119141, 119128,
	119141, 119150, 119128, 119141, 119151, 119128, 119141, 119152, 119128, 119141,
	119153, 119128, 119141, 119154, 119225, 119141, 119226, 119141, 119225, 119141,
	119150, 119226, 119141, 119150, 119225, 119141, 119151, 119226, 119141, 119151,
	305, 567, 8711, 8706, 1231, 125218, 125219, 125220, 125221, 125222, 125223, 125224,
	125225, 125226, 125227, 125228, 125229, 125230, 125231, 125232, 125233, 125234,
	125235, 125236, 125237, 125238, 125239, 125240, 125241, 125242, 125243, 125244,
	125245, 125246, 125247, 125248, 125249, 125250, 125251, 1646, 1697, 1647, 48, 44,
	49, 44, 50, 44, 51, 44, 52, 44, 53, 44, 54, 44, 55, 44, 56, 44, 57, 44, 12308, 115,
	12309, 119, 122, 104, 118, 115, 100, 112, 112, 118, 119, 99, 109, 114, 100, 106,
	12411, 12363, 12467, 12467, 23383, 21452, 22810, 35299, 20132, 26144, 28961, 21069,
	24460, 20877, 26032, 21021, 32066, 36009, 22768, 21561, 28436, 25237, 25429, 36938,
	25351, 25171, 31105, 31354, 21512, 28288, 30003, 21106, 21942, 37197, 12308, 26412,
	12309, 12308, 19977, 12309, 12308, 20108, 12309, 12308, 23433, 12309, 12308, 28857,
	12309, 12308, 25171, 12309, 12308, 30423, 12309, 12308, 21213, 12309, 12308, 25943,
	12309, 24471, 21487, 20029, 20024, 20033, 131362, 20320, 20411, 20482, 20602, 20633,
	20687, 13470, 132666, 20820, 20836, 20855, 132380, 13497, 20839, 132427, 20887,
	20900, 20172, 20908, 168415, 20995, 13535, 21051, 21062, 21111, 13589, 21253, 21254,
	21321, 21338, 21363, 21373, 21375, 133676, 28784, 21450, 21471, 133987, 21483, 21489,
	21510, 21662, 21560, 21576, 21608, 21666, 21750, 21776, 21843, 21859, 21892, 21931,
	21939, 21954, 22294, 22295, 22097, 22132, 22766, 22478, 22516, 22541, 22411, 22578,
	22577, 22700, 136420, 22770, 22775, 22790, 22818, 22882, 136872, 136938, 23020,
	23067, 23079, 23000, 23142, 14062, 23304, 23358, 137672, 23491, 23512, 23539, 138008,
	23551, 23558, 14209, 23648, 23744, 23693, 138724, 23875, 138726, 23918, 23915, 23932,
	24033, 24034, 14383, 24061, 24104, 24125, 24169, 14434, 139651, 14460, 24240, 24243,
	24246, 172946, 140081, 33281, 24354, 14535, 144056, 156122, 24418, 24427, 14563,
	24474, 24525, 24535, 24569, 24705, 14650, 14620, 141012, 24775, 24904, 24908, 24954,
	25010, 24996, 25007, 25054, 25115, 25181, 25265, 25300, 25424, 142092, 25405, 25340,
	25448, 25475, 25572, 142321, 25634, 25541, 25513, 14894, 25705, 25726, 25757, 25719,
	14956, 25964, 143370, 26083, 26360, 26185, 15129, 15112, 15076, 20882, 20885, 26368,
	26268, 32941, 17369, 26401, 26462, 26451, 144323, 15177, 26618, 26501, 26706, 144493,
	26766, 26655, 26900, 26946, 27043, 27114, 27304, 145059, 27355, 15384, 27425, 145575,
	27476, 15438, 27506, 27551, 27579, 146061, 138507, 146170, 27726, 146620, 27839,
	27853, 27751, 27926, 27966, 28009, 28024, 28037, 146718, 27956, 28207, 28270, 15667,
	28359, 147153, 28153, 28526, 147294, 147342, 28614, 28729, 28699, 15766, 28746,
	28797, 28791, 28845, 132389, 28997, 148067, 29084, 29224, 29264, 149000, 29312,
	29333, 149301, 149524, 29562, 29579, 16044, 29605, 16056, 29767, 29788, 29829, 29898,
	16155, 29988, 150582, 30014, 150674, 139679, 30224, 151457, 151480, 151620, 16380,
	16392, 151795, 151794, 151833, 151859, 30494, 30495, 30603, 16454, 16534, 152605,
	30798, 16611, 153126, 153242, 153285, 31211, 16687, 31306, 31311, 153980, 154279,
	16898, 154539, 31686, 31689, 16935, 154752, 31954, 17056, 31976, 31971, 32000, 155526,
	32099, 17153, 32199, 32258, 32325, 17204, 156200, 156231, 17241, 156377, 32634,
	156478, 32661, 32762, 156890, 156963, 32864, 157096, 32880, 144223, 17365, 32946,
	33027, 17419, 33086, 23221, 157607, 157621, 144275, 144284, 33284, 36766, 17515,
	33425, 33419, 33437, 21171, 33457, 33459, 33469, 33510, 158524, 33565, 33635, 33709,
	33571, 33725, 33767, 33619, 33738, 33740, 33756, 158774, 159083, 158933, 17707,
	34033, 34035, 34070, 160714, 34148, 159532, 17757, 17761, 159665, 159954, 17771,
	34384, 34407, 34409, 34473, 34440, 34574, 34530, 34600, 34667, 34694, 34785, 34817,
	17913, 34912, 161383, 35031, 35038, 17973, 35066, 13499, 161966, 162150, 18110,
	18119, 35488, 162984, 36011, 36033, 36123, 36215, 163631, 133124, 36299, 36284,
	36336, 133342, 36564, 165330, 165357, 37012, 37105, 37137, 165678, 37147, 37432,
	37591, 37592, 37500, 37881, 37909, 166906, 38283, 18837, 38327, 167287, 18918, 38595,
	23986, 38691, 168261, 168474, 19054, 19062, 38880, 168970, 19122, 169110, 38953,
	169398, 39138, 19251, 39209, 39335, 39362, 39422, 19406, 170800, 40000, 40189, 19662,
	19693, 40295, 172238, 19704, 172293, 172558, 172689, 19798, 40702, 40709, 40719,
	40726, 173568,

};
const uint32_t table[8000][2] =
{
	{0, 1}, {65, 16777219}, {66, 16777475}, {67, 16777731},
	{68, 16777987}, {69, 16778243}, {70, 16778499}, {71, 16778755},
	{72, 16779011}, {73, 16779267}, {74, 16779523}, {75, 16779779},
	{76, 16780035}, {77, 16780291}, {78, 16780547}, {79, 16780803},
	{80, 16781059}, {81, 16781315}, {82, 16781571}, {83, 16781827},
	{84, 16782083}, {85, 16782339}, {86, 16782595}, {87, 16782851},
	{88, 16783107}, {89, 16783363}, {90, 16783619}, {91, 1},
	{128, 2}, {160, 16783875}, {161, 1}, {168, 33561347},
	{169, 1}, {170, 16777219}, {171, 1}, {173, 0},
	{174, 1}, {175, 33561859}, {176, 1}, {178, 16785155},
	{179, 16785411}, {180, 33562883}, {181, 16786179}, {182, 1},
	{184, 33563651}, {185, 16786947}, {186, 16780803}, {187, 1},
	{188, 50341635}, {189, 50342403}, {190, 50343171}, {191, 1},
	{192, 16789507}, {193, 16789763}, {194, 16790019}, {195, 16790275},
	{196, 16790531}, {197, 16790787}, {198, 16791043}, {199, 16791299},
	{200, 16791555}, {201, 16791811}, {202, 16792067}, {203, 16792323},
	{204, 16792579}, {205, 16792835}, {206, 16793091}, {207, 16793347},
	{208, 16793603}, {209, 16793859}, {210, 16794115}, {211, 16794371},
	{212, 16794627}, {213, 16794883}, {214, 16795139}, {215, 1},
	{216, 16795395}, {217, 16795651}, {218, 16795907}, {219, 16796163},
	{220, 16796419}, {221, 16796675}, {222, 16796931}, {223, 1},
	{256, 16797187}, {257, 1}, {258, 16797443}, {259, 1},
	{260, 16797699}, {261, 1}, {262, 16797955}, {263, 1},
	{264, 16798211}, {265, 1}, {266, 16798467}, {267, 1},
	{268, 16798723}, {269, 1}, {270, 16798979}, {271, 1},
	{272, 16799235}, {273, 1}, {274, 16799491}, {275, 1},
	{276, 16799747}, {277, 1}, {278, 16800003}, {279, 1},
	{280, 16800259}, {281, 1}, {282, 16800515}, {283, 1},
	{284, 16800771}, {285, 1}, {286, 16801027}, {287, 1},
	{288, 16801283}, {289, 1}, {290, 16801539}, {291, 1},
	{292, 16801795}, {293, 1}, {294, 16802051}, {295, 1},
	{296, 16802307}, {297, 1}, {298, 16802563}, {299, 1},
	{300, 16802819}, {301, 1}, {302, 16803075}, {303, 1},
	{304, 33580547}, {305, 1}, {306, 33556483}, {308, 16803843},
	{309, 1}, {310, 16804099}, {311, 1}, {313, 16804355},
	{314, 1}, {315, 16804611}, {316, 1}, {317, 16804867},
	{318, 1}, {319, 33582339}, {321, 16805635}, {322, 1},
	{323, 16805891}, {324, 1}, {325, 16806147}, {326, 1},
	{327, 16806403}, {328, 1}, {329, 33583875}, {330, 16807171},
	{331, 1}, {332, 16807427}, {333, 1}, {334, 16807683},
	{335, 1}, {336, 16807939}, {337, 1}, {338, 16808195},
	{339, 1}, {340, 16808451}, {341, 1}, {342, 16808707},
	{343, 1}, {344, 16808963}, {345, 1}, {346, 16809219},
	{347, 1}, {348, 16809475}, {349, 1}, {350, 16809731},
	{351, 1}, {352, 16809987}, {353, 1}, {354, 16810243},
	{355, 1}, {356, 16810499}, {357, 1}, {358, 16810755},
	{359, 1}, {360, 16811011}, {361, 1}, {362, 16811267},
	{363, 1}, {364, 16811523}, {365, 1}, {366, 16811779},
	{367, 1}, {368, 16812035}, {369, 1}, {370, 16812291},
	{371, 1}, {372, 16812547}, {373, 1}, {374, 16812803},
	{375, 1}, {376, 16813059}, {377, 16813315}, {378, 1},
	{379, 16813571}, {380, 1}, {381, 16813827}, {382, 1},
	{383, 16781827}, {384, 1}, {385, 16814083}, {386, 16814339},
	{387, 1}, {388, 16814595}, {389, 1}, {390, 16814851},
	{391, 16815107}, {392, 1}, {393, 16815363}, {394, 16815619},
	{395, 16815875}, {396, 1}, {398, 16816131}, {399, 16816387},
	{400, 16816643}, {401, 16816899}, {402, 1}, {403, 16817155},
	{404, 16817411}, {405, 1}, {406, 16817667}, {407, 16817923},
	{408, 16818179}, {409, 1}, {412, 16818435}, {413, 16818691},
	{414, 1}, {415, 16818947}, {416, 16819203}, {417, 1},
	{418, 16819459}, {419, 1}, {420, 16819715}, {421, 1},
	{422, 16819971}, {423, 16820227}, {424, 1}, {425, 16820483},
	{426, 1}, {428, 16820739}, {429, 1}, {430, 16820995},
	{431, 16821251}, {432, 1}, {433, 16821507}, {434, 16821763},
	{435, 16822019}, {436, 1}, {437, 16822275}, {438, 1},
	{439, 16822531}, {440, 16822787}, {441, 1}, {444, 16823043},
	{445, 1}, {452, 33600515}, {455, 33601027}, {458, 33601539},
	{461, 16824835}, {462, 1}, {463, 16825091}, {464, 1},
	{465, 16825347}, {466, 1}, {467, 16825603}, {468, 1},
	{469, 16825859}, {470, 1}, {471, 16826115}, {472, 1},
	{473, 16826371}, {474, 1}, {475, 16826627}, {476, 1},
	{478, 16826883}, {479, 1}, {480, 16827139}, {481, 1},
	{482, 16827395}, {483, 1}, {484, 16827651}, {485, 1},
	{486, 16827907}, {487, 1}, {488, 16828163}, {489, 1},
	{490, 16828419}, {491, 1}, {492, 16828675}, {493, 1},
	{494, 16828931}, {495, 1}, {497, 33606403}, {500, 16829699},
	{501, 1}, {502, 16829955}, {503, 16830211}, {504, 16830467},
	{505, 1}, {506, 16830723}, {507, 1}, {508, 16830979},
	{509, 1}, {510, 16831235}, {511, 1}, {512, 16831491},
	{513, 1}, {514, 16831747}, {515, 1}, {516, 16832003},
	{517, 1}, {518, 16832259}, {519, 1}, {520, 16832515},
	{521, 1}, {522, 16832771}, {523, 1}, {524, 16833027},
	{525, 1}, {526, 16833283}, {527, 1}, {528, 16833539},
	{529, 1}, {530, 16833795}, {531, 1}, {532, 16834051},
	{533, 1}, {534, 16834307}, {535, 1}, {536, 16834563},
	{537, 1}, {538, 16834819}, {539, 1}, {540, 16835075},
	{541, 1}, {542, 16835331}, {543, 1}, {544, 16835587},
	{545, 1}, {546, 16835843}, {547, 1}, {548, 16836099},
	{549, 1}, {550, 16836355}, {551, 1}, {552, 16836611},
	{553, 1}, {554, 16836867}, {555, 1}, {556, 16837123},
	{557, 1}, {558, 16837379}, {559, 1}, {560, 16837635},
	{561, 1}, {562, 16837891}, {563, 1}, {570, 16838147},
	{571, 16838403}, {572, 1}, {573, 16838659}, {574, 16838915},
	{575, 1}, {577, 16839171}, {578, 1}, {579, 16839427},
	{580, 16839683}, {581, 16839939}, {582, 16840195}, {583, 1},
	{584, 16840451}, {585, 1}, {586, 16840707}, {587, 1},
	{588, 16840963}, {589, 1}, {590, 16841219}, {591, 1},
	{688, 16779011}, {689, 16841475}, {690, 16779523}, {691, 16781571},
	{692, 16841731}, {693, 16841987}, {694, 16842243}, {695, 16782851},
	{696, 16783363}, {697, 1}, {728, 33619715}, {729, 33620227},
	{730, 33620739}, {731, 33621251}, {732, 33621763}, {733, 33622275},
	{734, 1}, {736, 16817411}, {737, 16780035}, {738, 16781827},
	{739, 16783107}, {740, 16845571}, {741, 1}, {832, 16845827},
	{833, 16785923}, {834, 1}, {835, 16846083}, {836, 33623555},
	{837, 16846851}, {838, 1}, {847, 0}, {848, 1},
	{880, 16847107}, {881, 1}, {882, 16847363}, {883, 1},
	{884, 16847619}, {885, 1}, {886, 16847875}, {887, 1},
	{888, 2}, {890, 33625347}, {891, 1}, {894, 16848643},
	{895, 16848899}, {896, 2}, {900, 33562883}, {901, 50403587},
	{902, 16849923}, {903, 16805379}, {904, 16850179}, {905, 16850435},
	{906, 16850691}, {907, 2}, {908, 16850947}, {909, 2},
	{910, 16851203}, {911, 16851459}, {912, 1}, {913, 16851715},
	{914, 16851971}, {915, 16852227}, {916, 16852483}, {917, 16852739},
	{918, 16852995}, {919, 16853251}, {920, 16853507}, {921, 16846851},
	{922, 16853763}, {923, 16854019}, {924, 16786179}, {925, 16854275},
	{926, 16854531}, {927, 16854787}, {928, 16855043}, {929, 16855299},
	{930, 2}, {931, 16855555}, {932, 16855811}, {933, 16856067},
	{934, 16856323}, {935, 16856579}, {936, 16856835}, {937, 16857091},
	{938, 16857347}, {939, 16857603}, {940, 1}, {975, 16857859},
	{976, 16851971}, {977, 16853507}, {978, 16856067}, {979, 16851203},
	{980, 16857603}, {981, 16856323}, {982, 16855043}, {983, 1},
	{984, 16858115}, {985, 1}, {986, 16858371}, {987, 1},
	{988, 16858627}, {989, 1}, {990, 16858883}, {991, 1},
	{992, 16859139}, {993, 1}, {994, 16859395}, {995, 1},
	{996, 16859651}, {997, 1}, {998, 16859907}, {999, 1},
	{1000, 16860163}, {1001, 1}, {1002, 16860419}, {1003, 1},
	{1004, 16860675}, {1005, 1}, {1006, 16860931}, {1007, 1},
	{1008, 16853763}, {1009, 16855299}, {1010, 16855555}, {1011, 1},
	{1012, 16853507}, {1013, 16852739}, {1014, 1}, {1015, 16861187},
	{1016, 1}, {1017, 16855555}, {1018, 16861443}, {1019, 1},
	{1021, 16861699}, {1022, 16861955}, {1023, 16862211}, {1024, 16862467},
	{1025, 16862723}, {1026, 16862979}, {1027, 16863235}, {1028, 16863491},
	{1029, 16863747}, {1030, 16864003}, {1031, 16864259}, {1032, 16864515},
	{1033, 16864771}, {1034, 16865027}, {1035, 16865283}, {1036, 16865539},
	{1037, 16865795}, {1038, 16866051}, {1039, 16866307}, {1040, 16866563},
	{1041, 16866819}, {1042, 16867075}, {1043, 16867331}, {1044, 16867587},
	{1045, 16867843}, {1046, 16868099}, {1047, 16868355}, {1048, 16868611},
	{1049, 16868867}, {1050, 16869123}, {1051, 16869379}, {1052, 16869635},
	{1053, 16869891}, {1054, 16870147}, {1055, 16870403}, {1056, 16870659},
	{1057, 16870915}, {1058, 16871171}, {1059, 16871427}, {1060, 16871683},
	{1061, 16871939}, {1062, 16872195}, {1063, 16872451}, {1064, 16872707},
	{1065, 16872963}, {1066, 16873219}, {1067, 16873475}, {1068, 16873731},
	{1069, 16873987}, {1070, 16874243}, {1071, 16874499}, {1072, 1},
	{1120, 16874755}, {1121, 1}, {1122, 16875011}, {1123, 1},
	{1124, 16875267}, {1125, 1}, {1126, 16875523}, {1127, 1},
	{1128, 16875779}, {1129, 1}, {1130, 16876035}, {1131, 1},
	{1132, 16876291}, {1133, 1}, {1134, 16876547}, {1135, 1},
	{1136, 16876803}, {1137, 1}, {1138, 16877059}, {1139, 1},
	{1140, 16877315}, {1141, 1}, {1142, 16877571}, {1143, 1},
	{1144, 16877827}, {1145, 1}, {1146, 16878083}, {1147, 1},
	{1148, 16878339}, {1149, 1}, {1150, 16878595}, {1151, 1},
	{1152, 16878851}, {1153, 1}, {1162, 16879107}, {1163, 1},
	{1164, 16879363}, {1165, 1}, {1166, 16879619}, {1167, 1},
	{1168, 16879875}, {1169, 1}, {1170, 16880131}, {1171, 1},
	{1172, 16880387}, {1173, 1}, {1174, 16880643}, {1175, 1},
	{1176, 16880899}, {1177, 1}, {1178, 16881155}, {1179, 1},
	{1180, 16881411}, {1181, 1}, {1182, 16881667}, {1183, 1},
	{1184, 16881923}, {1185, 1}, {1186, 16882179}, {1187, 1},
	{1188, 16882435}, {1189, 1}, {1190, 16882691}, {1191, 1},
	{1192, 16882947}, {1193, 1}, {1194, 16883203}, {1195, 1},
	{1196, 16883459}, {1197, 1}, {1198, 16883715}, {1199, 1},
	{1200, 16883971}, {1201, 1}, {1202, 16884227}, {1203, 1},
	{1204, 16884483}, {1205, 1}, {1206, 16884739}, {1207, 1},
	{1208, 16884995}, {1209, 1}, {1210, 16885251}, {1211, 1},
	{1212, 16885507}, {1213, 1}, {1214, 16885763}, {1215, 1},
	{1216, 2}, {1217, 16886019}, {1218, 1}, {1219, 16886275},
	{1220, 1}, {1221, 16886531}, {1222, 1}, {1223, 16886787},
	{1224, 1}, {1225, 16887043}, {1226, 1}, {1227, 16887299},
	{1228, 1}, {1229, 16887555}, {1230, 1}, {1232, 16887811},
	{1233, 1}, {1234, 16888067}, {1235, 1}, {1236, 16888323},
	{1237, 1}, {1238, 16888579}, {1239, 1}, {1240, 16888835},
	{1241, 1}, {1242, 16889091}, {1243, 1}, {1244, 16889347},
	{1245, 1}, {1246, 16889603}, {1247, 1}, {1248, 16889859},
	{1249, 1}, {1250, 16890115}, {1251, 1}, {1252, 16890371},
	{1253, 1}, {1254, 16890627}, {1255, 1}, {1256, 16890883},
	{1257, 1}, {1258, 16891139}, {1259, 1}, {1260, 16891395},
	{1261, 1}, {1262, 16891651}, {1263, 1}, {1264, 16891907},
	{1265, 1}, {1266, 16892163}, {1267, 1}, {1268, 16892419},
	{1269, 1}, {1270, 16892675}, {1271, 1}, {1272, 16892931},
	{1273, 1}, {1274, 16893187}, {1275, 1}, {1276, 16893443},
	{1277, 1}, {1278, 16893699}, {1279, 1}, {1280, 16893955},
	{1281, 1}, {1282, 16894211}, {1283, 1}, {1284, 16894467},
	{1285, 1}, {1286, 16894723}, {1287, 1}, {1288, 16894979},
	{1289, 1}, {1290, 16895235}, {1291, 1}, {1292, 16895491},
	{1293, 1}, {1294, 16895747}, {1295, 1}, {1296, 16896003},
	{1297, 1}, {1298, 16896259}, {1299, 1}, {1300, 16896515},
	{1301, 1}, {1302, 16896771}, {1303, 1}, {1304, 16897027},
	{1305, 1}, {1306, 16897283}, {1307, 1}, {1308, 16897539},
	{1309, 1}, {1310, 16897795}, {1311, 1}, {1312, 16898051},
	{1313, 1}, {1314, 16898307}, {1315, 1}, {1316, 16898563},
	{1317, 1}, {1318, 16898819}, {1319, 1}, {1320, 16899075},
	{1321, 1}, {1322, 16899331}, {1323, 1}, {1324, 16899587},
	{1325, 1}, {1326, 16899843}, {1327, 1}, {1328, 2},
	{1329, 16900099}, {1330, 16900355}, {1331, 16900611}, {1332, 16900867},
	{1333, 16901123}, {1334, 16901379}, {1335, 16901635}, {1336, 16901891},
	{1337, 16902147}, {1338, 16902403}, {1339, 16902659}, {1340, 16902915},
	{1341, 16903171}, {1342, 16903427}, {1343, 16903683}, {1344, 16903939},
	{1345, 16904195}, {1346, 16904451}, {1347, 16904707}, {1348, 16904963},
	{1349, 16905219}, {1350, 16905475}, {1351, 16905731}, {1352, 16905987},
	{1353, 16906243}, {1354, 16906499}, {1355, 16906755}, {1356, 16907011},
	{1357, 16907267}, {1358, 16907523}, {1359, 16907779}, {1360, 16908035},
	{1361, 16908291}, {1362, 16908547}, {1363, 16908803}, {1364, 16909059},
	{1365, 16909315}, {1366, 16909571}, {1367, 2}, {1369, 1},
	{1415, 33687043}, {1416, 1}, {1419, 2}, {1421, 1},
	{1424, 2}, {1425, 1}, {1480, 2}, {1488, 1},
	{1515, 2}, {1519, 1}, {1525, 2}, {1542, 1},
	{1564, 2}, {1565, 1}, {1653, 33687555}, {1654, 33688067},
	{1655, 33688579}, {1656, 33689091}, {1657, 1}, {1757, 2},
	{1758, 1}, {1806, 2}, {1808, 1}, {1867, 2},
	{1869, 1}, {1970, 2}, {1984, 1}, {2043, 2},
	{2045, 1}, {2094, 2}, {2096, 1}, {2111, 2},
	{2112, 1}, {2140, 2}, {2142, 1}, {2143, 2},
	{2144, 1}, {2155, 2}, {2160, 1}, {2191, 2},
	{2200, 1}, {2274, 2}, {2275, 1}, {2392, 33689603},
	{2393, 33690115}, {2394, 33690627}, {2395, 33691139}, {2396, 33691651},
	{2397, 33692163}, {2398, 33692675}, {2399, 33693187}, {2400, 1},
	{2436, 2}, {2437, 1}, {2445, 2}, {2447, 1},
	{2449, 2}, {2451, 1}, {2473, 2}, {2474, 1},
	{2481, 2}, {2482, 1}, {2483, 2}, {2486, 1},
	{2490, 2}, {2492, 1}, {2501, 2}, {2503, 1},
	{2505, 2}, {2507, 1}, {2511, 2}, {2519, 1},
	{2520, 2}, {2524, 33693699}, {2525, 33694211}, {2526, 2},
	{2527, 33694723}, {2528, 1}, {2532, 2}, {2534, 1},
	{2559, 2}, {2561, 1}, {2564, 2}, {2565, 1},
	{2571, 2}, {2575, 1}, {2577, 2}, {2579, 1},
	{2601, 2}, {2602, 1}, {2609, 2}, {2610, 1},
	{2611, 33695235}, {2612, 2}, {2613, 1}, {2614, 33695747},
	{2615, 2}, {2616, 1}, {2618, 2}, {2620, 1},
	{2621, 2}, {2622, 1}, {2627, 2}, {2631, 1},
	{2633, 2}, {2635, 1}, {2638, 2}, {2641, 1},
	{2642, 2}, {2649, 33696259}, {2650, 33696771}, {2651, 33697283},
	{2652, 1}, {2653, 2}, {2654, 33697795}, {2655, 2},
	{2662, 1}, {2679, 2}, {2689, 1}, {2692, 2},
	{2693, 1}, {2702, 2}, {2703, 1}, {2706, 2},
	{2707, 1}, {2729, 2}, {2730, 1}, {2737, 2},
	{2738, 1}, {2740, 2}, {2741, 1}, {2746, 2},
	{2748, 1}, {2758, 2}, {2759, 1}, {2762, 2},
	{2763, 1}, {2766, 2}, {2768, 1}, {2769, 2},
	{2784, 1}, {2788, 2}, {2790, 1}, {2802, 2},
	{2809, 1}, {2816, 2}, {2817, 1}, {2820, 2},
	{2821, 1}, {2829, 2}, {2831, 1}, {2833, 2},
	{2835, 1}, {2857, 2}, {2858, 1}, {2865, 2},
	{2866, 1}, {2868, 2}, {2869, 1}, {2874, 2},
	{2876, 1}, {2885, 2}, {2887, 1}, {2889, 2},
	{2891, 1}, {2894, 2}, {2901, 1}, {2904, 2},
	{2908, 33698307}, {2909, 33698819}, {2910, 2}, {2911, 1},
	{2916, 2}, {2918, 1}, {2936, 2}, {2946, 1},
	{2948, 2}, {2949, 1}, {2955, 2}, {2958, 1},
	{2961, 2}, {2962, 1}, {2966, 2}, {2969, 1},
	{2971, 2}, {2972, 1}, {2973, 2}, {2974, 1},
	{2976, 2}, {2979, 1}, {2981, 2}, {2984, 1},
	{2987, 2}, {2990, 1}, {3002, 2}, {3006, 1},
	{3011, 2}, {3014, 1}, {3017, 2}, {3018, 1},
	{3022, 2}, {3024, 1}, {3025, 2}, {3031, 1},
	{3032, 2}, {3046, 1}, {3067, 2}, {3072, 1},
	{3085, 2}, {3086, 1}, {3089, 2}, {3090, 1},
	{3113, 2}, {3114, 1}, {3130, 2}, {3132, 1},
	{3141, 2}, {3142, 1}, {3145, 2}, {3146, 1},
	{3150, 2}, {3157, 1}, {3159, 2}, {3160, 1},
	{3163, 2}, {3165, 1}, {3166, 2}, {3168, 1},
	{3172, 2}, {3174, 1}, {3184, 2}, {3191, 1},
	{3213, 2}, {3214, 1}, {3217, 2}, {3218, 1},
	{3241, 2}, {3242, 1}, {3252, 2}, {3253, 1},
	{3258, 2}, {3260, 1}, {3269, 2}, {3270, 1},
	{3273, 2}, {3274, 1}, {3278, 2}, {3285, 1},
	{3287, 2}, {3293, 1}, {3295, 2}, {3296, 1},
	{3300, 2}, {3302, 1}, {3312, 2}, {3313, 1},
	{3316, 2}, {3328, 1}, {3341, 2}, {3342, 1},
	{3345, 2}, {3346, 1}, {3397, 2}, {3398, 1},
	{3401, 2}, {3402, 1}, {3408, 2}, {3412, 1},
	{3428, 2}, {3430, 1}, {3456, 2}, {3457, 1},
	{3460, 2}, {3461, 1}, {3479, 2}, {3482, 1},
	{3506, 2}, {3507, 1}, {3516, 2}, {3517, 1},
	{3518, 2}, {3520, 1}, {3527, 2}, {3530, 1},
	{3531, 2}, {3535, 1}, {3541, 2}, {3542, 1},
	{3543, 2}, {3544, 1}, {3552, 2}, {3558, 1},
	{3568, 2}, {3570, 1}, {3573, 2}, {3585, 1},
	{3635, 33699331}, {3636, 1}, {3643, 2}, {3647, 1},
	{3676, 2}, {3713, 1}, {3715, 2}, {3716, 1},
	{3717, 2}, {3718, 1}, {3723, 2}, {3724, 1},
	{3748, 2}, {3749, 1}, {3750, 2}, {3751, 1},
	{3763, 33699843}, {3764, 1}, {3774, 2}, {3776, 1},
	{3781, 2}, {3782, 1}, {3783, 2}, {3784, 1},
	{3791, 2}, {3792, 1}, {3802, 2}, {3804, 33700355},
	{3805, 33700867}, {3806, 1}, {3808, 2}, {3840, 1},
	{3852, 16924163}, {3853, 1}, {3907, 33701635}, {3908, 1},
	{3912, 2}, {3913, 1}, {3917, 33702147}, {3918, 1},
	{3922, 33702659}, {3923, 1}, {3927, 33703171}, {3928, 1},
	{3932, 33703683}, {3933, 1}, {3945, 33704195}, {3946, 1},
	{3949, 2}, {3953, 1}, {3955, 33704707}, {3956, 1},
	{3957, 33705219}, {3958, 33705731}, {3959, 50483459}, {3960, 33707011},
	{3961, 50484739}, {3962, 1}, {3969, 33706499}, {3970, 1},
	{3987, 33708291}, {3988, 1}, {3992, 2}, {3993, 1},
	{3997, 33708803}, {3998, 1}, {4002, 33709315}, {4003, 1},
	{4007, 33709827}, {4008, 1}, {4012, 33710339}, {4013, 1},
	{4025, 33710851}, {4026, 1}, {4029, 2}, {4030, 1},
	{4045, 2}, {4046, 1}, {4059, 2}, {4096, 1},
	{4256, 2}, {4295, 16934147}, {4296, 2}, {4301, 16934403},
	{4302, 2}, {4304, 1}, {4348, 16934659}, {4349, 1},
	{4447, 2}, {4449, 1}, {4681, 2}, {4682, 1},
	{4686, 2}, {4688, 1}, {4695, 2}, {4696, 1},
	{4697, 2}, {4698, 1}, {4702, 2}, {4704, 1},
	{4745, 2}, {4746, 1}, {4750, 2}, {4752, 1},
	{4785, 2}, {4786, 1}, {4790, 2}, {4792, 1},
	{4799, 2}, {4800, 1}, {4801, 2}, {4802, 1},
	{4806, 2}, {4808, 1}, {4823, 2}, {4824, 1},
	{4881, 2}, {4882, 1}, {4886, 2}, {4888, 1},
	{4955, 2}, {4957, 1}, {4989, 2}, {4992, 1},
	{5018, 2}, {5024, 1}, {5110, 2}, {5112, 16934915},
	{5113, 16935171}, {5114, 16935427}, {5115, 16935683}, {5116, 16935939},
	{5117, 16936195}, {5118, 2}, {5120, 1}, {5760, 2},
	{5761, 1}, {5789, 2}, {5792, 1}, {5881, 2},
	{5888, 1}, {5910, 2}, {5919, 1}, {5943, 2},
	{5952, 1}, {5972, 2}, {5984, 1}, {5997, 2},
	{5998, 1}, {6001, 2}, {6002, 1}, {6004, 2},
	{6016, 1}, {6068, 2}, {6070, 1}, {6110, 2},
	{6112, 1}, {6122, 2}, {6128, 1}, {6138, 2},
	{6144, 1}, {6150, 2}, {6151, 1}, {6155, 0},
	{6158, 2}, {6159, 0}, {6160, 1}, {6170, 2},
	{6176, 1}, {6265, 2}, {6272, 1}, {6315, 2},
	{6320, 1}, {6390, 2}, {6400, 1}, {6431, 2},
	{6432, 1}, {6444, 2}, {6448, 1}, {6460, 2},
	{6464, 1}, {6465, 2}, {6468, 1}, {6510, 2},
	{6512, 1}, {6517, 2}, {6528, 1}, {6572, 2},
	{6576, 1}, {6602, 2}, {6608, 1}, {6619, 2},
	{6622, 1}, {6684, 2}, {6686, 1}, {6751, 2},
	{6752, 1}, {6781, 2}, {6783, 1}, {6794, 2},
	{6800, 1}, {6810, 2}, {6816, 1}, {6830, 2},
	{6832, 1}, {6863, 2}, {6912, 1}, {6989, 2},
	{6992, 1}, {7039, 2}, {7040, 1}, {7156, 2},
	{7164, 1}, {7224, 2}, {7227, 1}, {7242, 2},
	{7245, 1}, {7296, 16867075}, {7297, 16867587}, {7298, 16870147},
	{7299, 16870915}, {7300, 16871171}, {7302, 16873219}, {7303, 16875011},
	{7304, 16936451}, {7305, 2}, {7312, 16936707}, {7313, 16936963},
	{7314, 16937219}, {7315, 16937475}, {7316, 16937731}, {7317, 16937987},
	{7318, 16938243}, {7319, 16938499}, {7320, 16938755}, {7321, 16939011},
	{7322, 16939267}, {7323, 16939523}, {7324, 16934659}, {7325, 16939779},
	{7326, 16940035}, {7327, 16940291}, {7328, 16940547}, {7329, 16940803},
	{7330, 16941059}, {7331, 16941315}, {7332, 16941571}, {7333, 16941827},
	{7334, 16942083}, {7335, 16942339}, {7336, 16942595}, {7337, 16942851},
	{7338, 16943107}, {7339, 16943363}, {7340, 16943619}, {7341, 16943875},
	{7342, 16944131}, {7343, 16944387}, {7344, 16944643}, {7345, 16944899},
	{7346, 16945155}, {7347, 16945411}, {7348, 16945667}, {7349, 16945923},
	{7350, 16946179}, {7351, 16946435}, {7352, 16946691}, {7353, 16946947},
	{7354, 16947203}, {7355, 2}, {7357, 16947459}, {7358, 16947715},
	{7359, 16947971}, {7360, 1}, {7368, 2}, {7376, 1},
	{7419, 2}, {7424, 1}, {7468, 16777219}, {7469, 16791043},
	{7470, 16777475}, {7471, 1}, {7472, 16777987}, {7473, 16778243},
	{7474, 16816131}, {7475, 16778755}, {7476, 16779011}, {7477, 16779267},
	{7478, 16779523}, {7479, 16779779}, {7480, 16780035}, {7481, 16780291},
	{7482, 16780547}, {7483, 1}, {7484, 16780803}, {7485, 16835843},
	{7486, 16781059}, {7487, 16781571}, {7488, 16782083}, {7489, 16782339},
	{7490, 16782851}, {7491, 16777219}, {7492, 16948227}, {7493, 16948483},
	{7494, 16948739}, {7495, 16777475}, {7496, 16777987}, {7497, 16778243},
	{7498, 16816387}, {7499, 16816643}, {7500, 16948995}, {7501, 16778755},
	{7502, 1}, {7503, 16779779}, {7504, 16780291}, {7505, 16807171},
	{7506, 16780803}, {7507, 16814851}, {7508, 16949251}, {7509, 16949507},
	{7510, 16781059}, {7511, 16782083}, {7512, 16782339}, {7513, 16949763},
	{7514, 16818435}, {7515, 16782595}, {7516, 16950019}, {7517, 16851971},
	{7518, 16852227}, {7519, 16852483}, {7520, 16856323}, {7521, 16856579},
	{7522, 16779267}, {7523, 16781571}, {7524, 16782339}, {7525, 16782595},
	{7526, 16851971}, {7527, 16852227}, {7528, 16855299}, {7529, 16856323},
	{7530, 16856579}, {7531, 1}, {7544, 16869891}, {7545, 1},
	{7579, 16950275}, {7580, 16777731}, {7581, 16950531}, {7582, 16793603},
	{7583, 16948995}, {7584, 16778499}, {7585, 16950787}, {7586, 16951043},
	{7587, 16951299}, {7588, 16817923}, {7589, 16817667}, {7590, 16951555},
	{7591, 16951811}, {7592, 16952067}, {7593, 16952323}, {7594, 16952579},
	{7595, 16952835}, {7596, 16953091}, {7597, 16953347}, {7598, 16818691},
	{7599, 16953603}, {7600, 16953859}, {7601, 16818947}, {7602, 16954115},
	{7603, 16954371}, {7604, 16820483}, {7605, 16954627}, {7606, 16839683},
	{7607, 16821507}, {7608, 16954883}, {7609, 16821763}, {7610, 16839939},
	{7611, 16783619}, {7612, 16955139}, {7613, 16955395}, {7614, 16822531},
	{7615, 16853507}, {7616, 1}, {7680, 16955651}, {7681, 1},
	{7682, 16955907}, {7683, 1}, {7684, 16956163}, {7685, 1},
	{7686, 16956419}, {7687, 1}, {7688, 16956675}, {7689, 1},
	{7690, 16956931}, {7691, 1}, {7692, 16957187}, {7693, 1},
	{7694, 16957443}, {7695, 1}, {7696, 16957699}, {7697, 1},
	{7698, 16957955}, {7699, 1}, {7700, 16958211}, {7701, 1},
	{7702, 16958467}, {7703, 1}, {7704, 16958723}, {7705, 1},
	{7706, 16958979}, {7707, 1}, {7708, 16959235}, {7709, 1},
	{7710, 16959491}, {7711, 1}, {7712, 16959747}, {7713, 1},
	{7714, 16960003}, {7715, 1}, {7716, 16960259}, {7717, 1},
	{7718, 16960515}, {7719, 1}, {7720, 16960771}, {7721, 1},
	{7722, 16961027}, {7723, 1}, {7724, 16961283}, {7725, 1},
	{7726, 16961539}, {7727, 1}, {7728, 16961795}, {7729, 1},
	{7730, 16962051}, {7731, 1}, {7732, 16962307}, {7733, 1},
	{7734, 16962563}, {7735, 1}, {7736, 16962819}, {7737, 1},
	{7738, 16963075}, {7739, 1}, {7740, 16963331}, {7741, 1},
	{7742, 16963587}, {7743, 1}, {7744, 16963843}, {7745, 1},
	{7746, 16964099}, {7747, 1}, {7748, 16964355}, {7749, 1},
	{7750, 16964611}, {7751, 1}, {7752, 16964867}, {7753, 1},
	{7754, 16965123}, {7755, 1}, {7756, 16965379}, {7757, 1},
	{7758, 16965635}, {7759, 1}, {7760, 16965891}, {7761, 1},
	{7762, 16966147}, {7763, 1}, {7764, 16966403}, {7765, 1},
	{7766, 16966659}, {7767, 1}, {7768, 16966915}, {7769, 1},
	{7770, 16967171}, {7771, 1}, {7772, 16967427}, {7773, 1},
	{7774, 16967683}, {7775, 1}, {7776, 16967939}, {7777, 1},
	{7778, 16968195}, {7779, 1}, {7780, 16968451}, {7781, 1},
	{7782, 16968707}, {7783, 1}, {7784, 16968963}, {7785, 1},
	{7786, 16969219}, {7787, 1}, {7788, 16969475}, {7789, 1},
	{7790, 16969731}, {7791, 1}, {7792, 16969987}, {7793, 1},
	{7794, 16970243}, {7795, 1}, {7796, 16970499}, {7797, 1},
	{7798, 16970755}, {7799, 1}, {7800, 16971011}, {7801, 1},
	{7802, 16971267}, {7803, 1}, {7804, 16971523}, {7805, 1},
	{7806, 16971779}, {7807, 1}, {7808, 16972035}, {7809, 1},
	{7810, 16972291}, {7811, 1}, {7812, 16972547}, {7813, 1},
	{7814, 16972803}, {7815, 1}, {7816, 16973059}, {7817, 1},
	{7818, 16973315}, {7819, 1}, {7820, 16973571}, {7821, 1},
	{7822, 16973827}, {7823, 1}, {7824, 16974083}, {7825, 1},
	{7826, 16974339}, {7827, 1}, {7828, 16974595}, {7829, 1},
	{7834, 33752067}, {7835, 16967939}, {7836, 1}, {7838, 33752579},
	{7839, 1}, {7840, 16975875}, {7841, 1}, {7842, 16976131},
	{7843, 1}, {7844, 16976387}, {7845, 1}, {7846, 16976643},
	{7847, 1}, {7848, 16976899}, {7849, 1}, {7850, 16977155},
	{7851, 1}, {7852, 16977411}, {7853, 1}, {7854, 16977667},
	{7855, 1}, {7856, 16977923}, {7857, 1}, {7858, 16978179},
	{7859, 1}, {7860, 16978435}, {7861, 1}, {7862, 16978691},
	{7863, 1}, {7864, 16978947}, {7865, 1}, {7866, 16979203},
	{7867, 1}, {7868, 16979459}, {7869, 1}, {7870, 16979715},
	{7871, 1}, {7872, 16979971}, {7873, 1}, {7874, 16980227},
	{7875, 1}, {7876, 16980483}, {7877, 1}, {7878, 16980739},
	{7879, 1}, {7880, 16980995}, {7881, 1}, {7882, 16981251},
	{7883, 1}, {7884, 16981507}, {7885, 1}, {7886, 16981763},
	{7887, 1}, {7888, 16982019}, {7889, 1}, {7890, 16982275},
	{7891, 1}, {7892, 16982531}, {7893, 1}, {7894, 16982787},
	{7895, 1}, {7896, 16983043}, {7897, 1}, {7898, 16983299},
	{7899, 1}, {7900, 16983555}, {7901, 1}, {7902, 16983811},
	{7903, 1}, {7904, 16984067}, {7905, 1}, {7906, 16984323},
	{7907, 1}, {7908, 16984579}, {7909, 1}, {7910, 16984835},
	{7911, 1}, {7912, 16985091}, {7913, 1}, {7914, 16985347},
	{7915, 1}, {7916, 16985603}, {7917, 1}, {7918, 16985859},
	{7919, 1}, {7920, 16986115}, {7921, 1}, {7922, 16986371},
	{7923, 1}, {7924, 16986627}, {7925, 1}, {7926, 16986883},
	{7927, 1}, {7928, 16987139}, {7929, 1}, {7930, 16987395},
	{7931, 1}, {7932, 16987651}, {7933, 1}, {7934, 16987907},
	{7935, 1}, {7944, 16988163}, {7945, 16988419}, {7946, 16988675},
	{7947, 16988931}, {7948, 16989187}, {7949, 16989443}, {7950, 16989699},
	{7951, 16989955}, {7952, 1}, {7958, 2}, {7960, 16990211},
	{7961, 16990467}, {7962, 16990723}, {7963, 16990979}, {7964, 16991235},
	{7965, 16991491}, {7966, 2}, {7968, 1}, {7976, 16991747},
	{7977, 16992003}, {7978, 16992259}, {7979, 16992515}, {7980, 16992771},
	{7981, 16993027}, {7982, 16993283}, {7983, 16993539}, {7984, 1},
	{7992, 16993795}, {7993, 16994051}, {7994, 16994307}, {7995, 16994563},
	{7996, 16994819}, {7997, 16995075}, {7998, 16995331}, {7999, 16995587},
	{8000, 1}, {8006, 2}, {8008, 16995843}, {8009, 16996099},
	{8010, 16996355}, {8011, 16996611}, {8012, 16996867}, {8013, 16997123},
	{8014, 2}, {8016, 1}, {8024, 2}, {8025, 16997379},
	{8026, 2}, {8027, 16997635}, {8028, 2}, {8029, 16997891},
	{8030, 2}, {8031, 16998147}, {8032, 1}, {8040, 16998403},
	{8041, 16998659}, {8042, 16998915}, {8043, 16999171}, {8044, 16999427},
	{8045, 16999683}, {8046, 16999939}, {8047, 17000195}, {8048, 1},
	{8049, 16849923}, {8050, 1}, {8051, 16850179}, {8052, 1},
	{8053, 16850435}, {8054, 1}, {8055, 16850691}, {8056, 1},
	{8057, 16850947}, {8058, 1}, {8059, 16851203}, {8060, 1},
	{8061, 16851459}, {8062, 2}, {8064, 33777667}, {8065, 33778179},
	{8066, 33778691}, {8067, 33779203}, {8068, 33779715}, {8069, 33780227},
	{8070, 33780739}, {8071, 33781251}, {8072, 33777667}, {8073, 33778179},
	{8074, 33778691}, {8075, 33779203}, {8076, 33779715}, {8077, 33780227},
	{8078, 33780739}, {8079, 33781251}, {8080, 33781763}, {8081, 33782275},
	{8082, 33782787}, {8083, 33783299}, {8084, 33783811}, {8085, 33784323},
	{8086, 33784835}, {8087, 33785347}, {8088, 33781763}, {8089, 33782275},
	{8090, 33782787}, {8091, 33783299}, {8092, 33783811}, {8093, 33784323},
	{8094, 33784835}, {8095, 33785347}, {8096, 33785859}, {8097, 33786371},
	{8098, 33786883}, {8099, 33787395}, {8100, 33787907}, {8101, 33788419},
	{8102, 33788931}, {8103, 33789443}, {8104, 33785859}, {8105, 33786371},
	{8106, 33786883}, {8107, 33787395}, {8108, 33787907}, {8109, 33788419},
	{8110, 33788931}, {8111, 33789443}, {8112, 1}, {8114, 33789955},
	{8115, 33790467}, {8116, 33790979}, {8117, 2}, {8118, 1},
	{8119, 33791491}, {8120, 17014787}, {8121, 17015043}, {8122, 17012739},
	{8123, 16849923}, {8124, 33790467}, {8125, 33792515}, {8126, 16846851},
	{8127, 33792515}, {8128, 33793027}, {8129, 50570755}, {8130, 33794307},
	{8131, 33794819}, {8132, 33795331}, {8133, 2}, {8134, 1},
	{8135, 33795843}, {8136, 17019139}, {8137, 16850179}, {8138, 17017091},
	{8139, 16850435}, {8140, 33794819}, {8141, 50573827}, {8142, 50574595},
	{8143, 50575363}, {8144, 1}, {8147, 17021699}, {8148, 2},
	{8150, 1}, {8152, 17021955}, {8153, 17022211}, {8154, 17022467},
	{8155, 16850691}, {8156, 2}, {8157, 50577155}, {8158, 50577923},
	{8159, 50578691}, {8160, 1}, {8163, 17025027}, {8164, 1},
	{8168, 17025283}, {8169, 17025539}, {8170, 17025795}, {8171, 16851203},
	{8172, 17026051}, {8173, 50580739}, {8174, 50403587}, {8175, 17027075},
	{8176, 2}, {8178, 33804547}, {8179, 33805059}, {8180, 33805571},
	{8181, 2}, {8182, 1}, {8183, 33806083}, {8184, 17029379},
	{8185, 16850947}, {8186, 17027331}, {8187, 16851459}, {8188, 33805059},
	{8189, 33562883}, {8190, 33799939}, {8191, 2}, {8192, 16783875},
	{8203, 0}, {8204, 1}, {8206, 2}, {8208, 1},
	{8209, 17029635}, {8210, 1}, {8215, 33807107}, {8216, 1},
	{8228, 2}, {8231, 1}, {8232, 2}, {8239, 16783875},
	{8240, 1}, {8243, 33807619}, {8244, 50585347}, {8245, 1},
	{8246, 33808899}, {8247, 50586627}, {8248, 1}, {8252, 33810179},
	{8253, 1}, {8254, 33810691}, {8255, 1}, {8263, 33811203},
	{8264, 33811715}, {8265, 33812227}, {8266, 1}, {8279, 67362051},
	{8280, 1}, {8287, 16783875}, {8288, 0}, {8289, 2},
	{8292, 0}, {8293, 2}, {8304, 17035523}, {8305, 16779267},
	{8306, 2}, {8308, 16787715}, {8309, 17035779}, {8310, 17036035},
	{8311, 17036291}, {8312, 17036547}, {8313, 17036803}, {8314, 17037059},
	{8315, 17037315}, {8316, 17037571}, {8317, 17037827}, {8318, 17038083},
	{8319, 16780547}, {8320, 17035523}, {8321, 16786947}, {8322, 16785155},
	{8323, 16785411}, {8324, 16787715}, {8325, 17035779}, {8326, 17036035},
	{8327, 17036291}, {8328, 17036547}, {8329, 17036803}, {8330, 17037059},
	{8331, 17037315}, {8332, 17037571}, {8333, 17037827}, {8334, 17038083},
	{8335, 2}, {8336, 16777219}, {8337, 16778243}, {8338, 16780803},
	{8339, 16783107}, {8340, 16816387}, {8341, 16779011}, {8342, 16779779},
	{8343, 16780035}, {8344, 16780291}, {8345, 16780547}, {8346, 16781059},
	{8347, 16781827}, {8348, 16782083}, {8349, 2}, {8352, 1},
	{8360, 33558787}, {8361, 1}, {8385, 2}, {8400, 1},
	{8433, 2}, {8448, 50592771}, {8449, 50593539}, {8450, 16777731},
	{8451, 33817091}, {8452, 1}, {8453, 50594819}, {8454, 50595587},
	{8455, 16816643}, {8456, 1}, {8457, 33819139}, {8458, 16778755},
	{8459, 16779011}, {8463, 16802051}, {8464, 16779267}, {8466, 16780035},
	{8468, 1}, {8469, 16780547}, {8470, 33557763}, {8471, 1},
	{8473, 16781059}, {8474, 16781315}, {8475, 16781571}, {8478, 1},
	{8480, 33819651}, {8481, 50597379}, {8482, 33820931}, {8483, 1},
	{8484, 16783619}, {8485, 1}, {8486, 16857091}, {8487, 1},
	{8488, 16783619}, {8489, 1}, {8490, 16779779}, {8491, 16790787},
	{8492, 16777475}, {8493, 16777731}, {8494, 1}, {8495, 16778243},
	{8497, 16778499}, {8498, 2}, {8499, 16780291}, {8500, 16780803},
	{8501, 17044227}, {8502, 17044483}, {8503, 17044739}, {8504, 17044995},
	{8505, 16779267}, {8506, 1}, {8507, 50599683}, {8508, 16855043},
	{8509, 16852227}, {8511, 16855043}, {8512, 17046019}, {8513, 1},
	{8517, 16777987}, {8519, 16778243}, {8520, 16779267}, {8521, 16779523},
	{8522, 1}, {8528, 50600707}, {8529, 50601475}, {8530, 67379459},
	{8531, 50603267}, {8532, 50604035}, {8533, 50604803}, {8534, 50605571},
	{8535, 50606339}, {8536, 50607107}, {8537, 50607875}, {8538, 50608643},
	{8539, 50609411}, {8540, 50610179}, {8541, 50610947}, {8542, 50611715},
	{8543, 33564419}, {8544, 16779267}, {8545, 33835267}, {8546, 50612995},
	{8547, 33836547}, {8548, 16782595}, {8549, 33837059}, {8550, 50614787},
	{8551, 67392771}, {8552, 33839363}, {8553, 16783107}, {8554, 33839875},
	{8555, 50617603}, {8556, 16780035}, {8557, 16777731}, {8558, 16777987},
	{8559, 16780291}, {8560, 16779267}, {8561, 33835267}, {8562, 50612483},
	{8563, 33836547}, {8564, 16782595}, {8565, 33837059}, {8566, 50614787},
	{8567, 67392771}, {8568, 33839363}, {8569, 16783107}, {8570, 33839875},
	{8571, 50617603}, {8572, 16780035}, {8573, 16777731}, {8574, 16777987},
	{8575, 16780291}, {8576, 1}, {8579, 2}, {8580, 1},
	{8585, 50618371}, {8586, 1}, {8588, 2}, {8592, 1},
	{8748, 33841923}, {8749, 50619651}, {8750, 1}, {8751, 33843203},
	{8752, 50620931}, {8753, 1}, {9001, 17067267}, {9002, 17067523},
	{9003, 1}, {9255, 2}, {9280, 1}, {9291, 2},
	{9312, 16786947}, {9313, 16785155}, {9314, 16785411}, {9315, 16787715},
	{9316, 17035779}, {9317, 17036035}, {9318, 17036291}, {9319, 17036547},
	{9320, 17036803}, {9321, 33825539}, {9322, 33564163}, {9323, 33844995},
	{9324, 33845507}, {9325, 33846019}, {9326, 33846531}, {9327, 33847043},
	{9328, 33847555}, {9329, 33848067}, {9330, 33848579}, {9331, 33849091},
	{9332, 50626819}, {9333, 50627587}, {9334, 50628355}, {9335, 50629123},
	{9336, 50629891}, {9337, 50630659}, {9338, 50631427}, {9339, 50632195},
	{9340, 50632963}, {9341, 67410947}, {9342, 67411971}, {9343, 67412995},
	{9344, 67414019}, {9345, 67415043}, {9346, 67416067}, {9347, 67417091},
	{9348, 67418115}, {9349, 67419139}, {9350, 67420163}, {9351, 67421187},
	{9352, 2}, {9372, 50644995}, {9373, 50645763}, {9374, 50646531},
	{9375, 50647299}, {9376, 50648067}, {9377, 50648835}, {9378, 50649603},
	{9379, 50650371}, {9380, 50651139}, {9381, 50651907}, {9382, 50652675},
	{9383, 50653443}, {9384, 50654211}, {9385, 50654979}, {9386, 50655747},
	{9387, 50656515}, {9388, 50657283}, {9389, 50658051}, {9390, 50658819},
	{9391, 50659587}, {9392, 50660355}, {9393, 50661123}, {9394, 50661891},
	{9395, 50662659}, {9396, 50663427}, {9397, 50664195}, {9398, 16777219},
	{9399, 16777475}, {9400, 16777731}, {9401, 16777987}, {9402, 16778243},
	{9403, 16778499}, {9404, 16778755}, {9405, 16779011}, {9406, 16779267},
	{9407, 16779523}, {9408, 16779779}, {9409, 16780035}, {9410, 16780291},
	{9411, 16780547}, {9412, 16780803}, {9413, 16781059}, {9414, 16781315},
	{9415, 16781571}, {9416, 16781827}, {9417, 16782083}, {9418, 16782339},
	{9419, 16782595}, {9420, 16782851}, {9421, 16783107}, {9422, 16783363},
	{9423, 16783619}, {9424, 16777219}, {9425, 16777475}, {9426, 16777731},
	{9427, 16777987}, {9428, 16778243}, {9429, 16778499}, {9430, 16778755},
	{9431, 16779011}, {9432, 16779267}, {9433, 16779523}, {9434, 16779779},
	{9435, 16780035}, {9436, 16780291}, {9437, 16780547}, {9438, 16780803},
	{9439, 16781059}, {9440, 16781315}, {9441, 16781571}, {9442, 16781827},
	{9443, 16782083}, {9444, 16782339}, {9445, 16782595}, {9446, 16782851},
	{9447, 16783107}, {9448, 16783363}, {9449, 16783619}, {9450, 17035523},
	{9451, 1}, {10764, 67396355}, {10765, 1}, {10868, 50664963},
	{10869, 33888515}, {10870, 50665475}, {10871, 1}, {10972, 33889027},
	{10973, 1}, {11124, 2}, {11126, 1}, {11158, 2},
	{11159, 1}, {11264, 17112323}, {11265, 17112579}, {11266, 17112835},
	{11267, 17113091}, {11268, 17113347}, {11269, 17113603}, {11270, 17113859},
	{11271, 17114115}, {11272, 17114371}, {11273, 17114627}, {11274, 17114883},
	{11275, 17115139}, {11276, 17115395}, {11277, 17115651}, {11278, 17115907},
	{11279, 17116163}, {11280, 17116419}, {11281, 17116675}, {11282, 17116931},
	{11283, 17117187}, {11284, 17117443}, {11285, 17117699}, {11286, 17117955},
	{11287, 17118211}, {11288, 17118467}, {11289, 17118723}, {11290, 17118979},
	{11291, 17119235}, {11292, 17119491}, {11293, 17119747}, {11294, 17120003},
	{11295, 17120259}, {11296, 17120515}, {11297, 17120771}, {11298, 17121027},
	{11299, 17121283}, {11300, 17121539}, {11301, 17121795}, {11302, 17122051},
	{11303, 17122307}, {11304, 17122563}, {11305, 17122819}, {11306, 17123075},
	{11307, 17123331}, {11308, 17123587}, {11309, 17123843}, {11310, 17124099},
	{11311, 17124355}, {11312, 1}, {11360, 17124611}, {11361, 1},
	{11362, 17124867}, {11363, 17125123}, {11364, 17125379}, {11365, 1},
	{11367, 17125635}, {11368, 1}, {11369, 17125891}, {11370, 1},
	{11371, 17126147}, {11372, 1}, {11373, 16948483}, {11374, 16953091},
	{11375, 16948227}, {11376, 16950275}, {11377, 1}, {11378, 17126403},
	{11379, 1}, {11381, 17126659}, {11382, 1}, {11388, 16779523},
	{11389, 16782595}, {11390, 17126915}, {11391, 17127171}, {11392, 17127427},
	{11393, 1}, {11394, 17127683}, {11395, 1}, {11396, 17127939},
	{11397, 1}, {11398, 17128195}, {11399, 1}, {11400, 17128451},
	{11401, 1}, {11402, 17128707}, {11403, 1}, {11404, 17128963},
	{11405, 1}, {11406, 17129219}, {11407, 1}, {11408, 17129475},
	{11409, 1}, {11410, 17129731}, {11411, 1}, {11412, 17129987},
	{11413, 1}, {11414, 17130243}, {11415, 1}, {11416, 17130499},
	{11417, 1}, {11418, 17130755}, {11419, 1}, {11420, 17131011},
	{11421, 1}, {11422, 17131267}, {11423, 1}, {11424, 17131523},
	{11425, 1}, {11426, 17131779}, {11427, 1}, {11428, 17132035},
	{11429, 1}, {11430, 17132291}, {11431, 1}, {11432, 17132547},
	{11433, 1}, {11434, 17132803}, {11435, 1}, {11436, 17133059},
	{11437, 1}, {11438, 17133315}, {11439, 1}, {11440, 17133571},
	{11441, 1}, {11442, 17133827}, {11443, 1}, {11444, 17134083},
	{11445, 1}, {11446, 17134339}, {11447, 1}, {11448, 17134595},
	{11449, 1}, {11450, 17134851}, {11451, 1}, {11452, 17135107},
	{11453, 1}, {11454, 17135363}, {11455, 1}, {11456, 17135619},
	{11457, 1}, {11458, 17135875}, {11459, 1}, {11460, 17136131},
	{11461, 1}, {11462, 17136387}, {11463, 1}, {11464, 17136643},
	{11465, 1}, {11466, 17136899}, {11467, 1}, {11468, 17137155},
	{11469, 1}, {11470, 17137411}, {11471, 1}, {11472, 17137667},
	{11473, 1}, {11474, 17137923}, {11475, 1}, {11476, 17138179},
	{11477, 1}, {11478, 17138435}, {11479, 1}, {11480, 17138691},
	{11481, 1}, {11482, 17138947}, {11483, 1}, {11484, 17139203},
	{11485, 1}, {11486, 17139459}, {11487, 1}, {11488, 17139715},
	{11489, 1}, {11490, 17139971}, {11491, 1}, {11499, 17140227},
	{11500, 1}, {11501, 17140483}, {11502, 1}, {11506, 17140739},
	{11507, 1}, {11508, 2}, {11513, 1}, {11558, 2},
	{11559, 1}, {11560, 2}, {11565, 1}, {11566, 2},
	{11568, 1}, {11624, 2}, {11631, 17140995}, {11632, 1},
	{11633, 2}, {11647, 1}, {11671, 2}, {11680, 1},
	{11687, 2}, {11688, 1}, {11695, 2}, {11696, 1},
	{11703, 2}, {11704, 1}, {11711, 2}, {11712, 1},
	{11719, 2}, {11720, 1}, {11727, 2}, {11728, 1},
	{11735, 2}, {11736, 1}, {11743, 2}, {11744, 1},
	{11870, 2}, {11904, 1}, {11930, 2}, {11931, 1},
	{11935, 17141251}, {11936, 1}, {12019, 17141507}, {12020, 2},
	{12032, 17141763}, {12033, 17142019}, {12034, 17142275}, {12035, 17142531},
	{12036, 17142787}, {12037, 17143043}, {12038, 17143299}, {12039, 17143555},
	{12040, 17143811}, {12041, 17144067}, {12042, 17144323}, {12043, 17144579},
	{12044, 17144835}, {12045, 17145091}, {12046, 17145347}, {12047, 17145603},
	{12048, 17145859}, {12049, 17146115}, {12050, 17146371}, {12051, 17146627},
	{12052, 17146883}, {12053, 17147139}, {12054, 17147395}, {12055, 17147651},
	{12056, 17147907}, {12057, 17148163}, {12058, 17148419}, {12059, 17148675},
	{12060, 17148931}, {12061, 17149187}, {12062, 17149443}, {12063, 17149699},
	{12064, 17149955}, {12065, 17150211}, {12066, 17150467}, {12067, 17150723},
	{12068, 17150979}, {12069, 17151235}, {12070, 17151491}, {12071, 17151747},
	{12072, 17152003}, {12073, 17152259}, {12074, 17152515}, {12075, 17152771},
	{12076, 17153027}, {12077, 17153283}, {12078, 17153539}, {12079, 17153795},
	{12080, 17154051}, {12081, 17154307}, {12082, 17154563}, {12083, 17154819},
	{12084, 17155075}, {12085, 17155331}, {12086, 17155587}, {12087, 17155843},
	{12088, 17156099}, {12089, 17156355}, {12090, 17156611}, {12091, 17156867},
	{12092, 17157123}, {12093, 17157379}, {12094, 17157635}, {12095, 17157891},
	{12096, 17158147}, {12097, 17158403}, {12098, 17158659}, {12099, 17158915},
	{12100, 17159171}, {12101, 17159427}, {12102, 17159683}, {12103, 17159939},
	{12104, 17160195}, {12105, 17160451}, {12106, 17160707}, {12107, 17160963},
	{12108, 17161219}, {12109, 17161475}, {12110, 17161731}, {12111, 17161987},
	{12112, 17162243}, {12113, 17162499}, {12114, 17162755}, {12115, 17163011},
	{12116, 17163267}, {12117, 17163523}, {12118, 17163779}, {12119, 17164035},
	{12120, 17164291}, {12121, 17164547}, {12122, 17164803}, {12123, 17165059},
	{12124, 17165315}, {12125, 17165571}, {12126, 17165827}, {12127, 17166083},
	{12128, 17166339}, {12129, 17166595}, {12130, 17166851}, {12131, 17167107},
	{12132, 17167363}, {12133, 17167619}, {12134, 17167875}, {12135, 17168131},
	{12136, 17168387}, {12137, 17168643}, {12138, 17168899}, {12139, 17169155},
	{12140, 17169411}, {12141, 17169667}, {12142, 17169923}, {12143, 17170179},
	{12144, 17170435}, {12145, 17170691}, {12146, 17170947}, {12147, 17171203},
	{12148, 17171459}, {12149, 17171715}, {12150, 17171971}, {12151, 17172227},
	{12152, 17172483}, {12153, 17172739}, {12154, 17172995}, {12155, 17173251},
	{12156, 17173507}, {12157, 17173763}, {12158, 17174019}, {12159, 17174275},
	{12160, 17174531}, {12161, 17174787}, {12162, 17175043}, {12163, 17175299},
	{12164, 17175555}, {12165, 17175811}, {12166, 17176067}, {12167, 17176323},
	{12168, 17176579}, {12169, 17176835}, {12170, 17177091}, {12171, 17177347},
	{12172, 17177603}, {12173, 17177859}, {12174, 17178115}, {12175, 17178371},
	{12176, 17178627}, {12177, 17178883}, {12178, 17179139}, {12179, 17179395},
	{12180, 17179651}, {12181, 17179907}, {12182, 17180163}, {12183, 17180419},
	{12184, 17180675}, {12185, 17180931}, {12186, 17181187}, {12187, 17181443},
	{12188, 17181699}, {12189, 17181955}, {12190, 17182211}, {12191, 17182467},
	{12192, 17182723}, {12193, 17182979}, {12194, 17183235}, {12195, 17183491},
	{12196, 17183747}, {12197, 17184003}, {12198, 17184259}, {12199, 17184515},
	{12200, 17184771}, {12201, 17185027}, {12202, 17185283}, {12203, 17185539},
	{12204, 17185795}, {12205, 17186051}, {12206, 17186307}, {12207, 17186563},
	{12208, 17186819}, {12209, 17187075}, {12210, 17187331}, {12211, 17187587},
	{12212, 17187843}, {12213, 17188099}, {12214, 17188355}, {12215, 17188611},
	{12216, 17188867}, {12217, 17189123}, {12218, 17189379}, {12219, 17189635},
	{12220, 17189891}, {12221, 17190147}, {12222, 17190403}, {12223, 17190659},
	{12224, 17190915}, {12225, 17191171}, {12226, 17191427}, {12227, 17191683},
	{12228, 17191939}, {12229, 17192195}, {12230, 17192451}, {12231, 17192707},
	{12232, 17192963}, {12233, 17193219}, {12234, 17193475}, {12235, 17193731},
	{12236, 17193987}, {12237, 17194243}, {12238, 17194499}, {12239, 17194755},
	{12240, 17195011}, {12241, 17195267}, {12242, 17195523}, {12243, 17195779},
	{12244, 17196035}, {12245, 17196291}, {12246, 2}, {12288, 16783875},
	{12289, 1}, {12290, 17196547}, {12291, 1}, {12342, 17196803},
	{12343, 1}, {12344, 17147651}, {12345, 17197059}, {12346, 17197315},
	{12347, 1}, {12352, 2}, {12353, 1}, {12439, 2},
	{12441, 1}, {12443, 33974787}, {12444, 33975299}, {12445, 1},
	{12447, 33975811}, {12448, 1}, {12543, 33976323}, {12544, 2},
	{12549, 1}, {12592, 2}, {12593, 17199619}, {12594, 17199875},
	{12595, 17200131}, {12596, 17200387}, {12597, 17200643}, {12598, 17200899},
	{12599, 17201155}, {12600, 17201411}, {12601, 17201667}, {12602, 17201923},
	{12603, 17202179}, {12604, 17202435}, {12605, 17202691}, {12606, 17202947},
	{12607, 17203203}, {12608, 17203459}, {12609, 17203715}, {12610, 17203971},
	{12611, 17204227}, {12612, 17204483}, {12613, 17204739}, {12614, 17204995},
	{12615, 17205251}, {12616, 17205507}, {12617, 17205763}, {12618, 17206019},
	{12619, 17206275}, {12620, 17206531}, {12621, 17206787}, {12622, 17207043},
	{12623, 17207299}, {12624, 17207555}, {12625, 17207811}, {12626, 17208067},
	{12627, 17208323}, {12628, 17208579}, {12629, 17208835}, {12630, 17209091},
	{12631, 17209347}, {12632, 17209603}, {12633, 17209859}, {12634, 17210115},
	{12635, 17210371}, {12636, 17210627}, {12637, 17210883}, {12638, 17211139},
	{12639, 17211395}, {12640, 17211651}, {12641, 17211907}, {12642, 17212163},
	{12643, 17212419}, {12644, 2}, {12645, 17212675}, {12646, 17212931},
	{12647, 17213187}, {12648, 17213443}, {12649, 17213699}, {12650, 17213955},
	{12651, 17214211}, {12652, 17214467}, {12653, 17214723}, {12654, 17214979},
	{12655, 17215235}, {12656, 17215491}, {12657, 17215747}, {12658, 17216003},
	{12659, 17216259}, {12660, 17216515}, {12661, 17216771}, {12662, 17217027},
	{12663, 17217283}, {12664, 17217539}, {12665, 17217795}, {12666, 17218051},
	{12667, 17218307}, {12668, 17218563}, {12669, 17218819}, {12670, 17219075},
	{12671, 17219331}, {12672, 17219587}, {12673, 17219843}, {12674, 17220099},
	{12675, 17220355}, {12676, 17220611}, {12677, 17220867}, {12678, 17221123},
	{12679, 17221379}, {12680, 17221635}, {12681, 17221891}, {12682, 17222147},
	{12683, 17222403}, {12684, 17222659}, {12685, 17222915}, {12686, 17223171},
	{12687, 2}, {12688, 1}, {12690, 17141763}, {12691, 17143299},
	{12692, 17223427}, {12693, 17223683}, {12694, 17223939}, {12695, 17224195},
	{12696, 17224451}, {12697, 17224707}, {12698, 17142787}, {12699, 17224963},
	{12700, 17225219}, {12701, 17225475}, {12702, 17225731}, {12703, 17143811},
	{12704, 1}, {12772, 2}, {12784, 1}, {12800, 50780419},
	{12801, 50781187}, {12802, 50781955}, {12803, 50782723}, {12804, 50783491},
	{12805, 50784259}, {12806, 50785027}, {12807, 50785795}, {12808, 50786563},
	{12809, 50787331}, {12810, 50788099}, {12811, 50788867}, {12812, 50789635},
	{12813, 50790403}, {12814, 50791171}, {12815, 50791939}, {12816, 50792707},
	{12817, 50793475}, {12818, 50794243}, {12819, 50795011}, {12820, 50795779},
	{12821, 50796547}, {12822, 50797315}, {12823, 50798083}, {12824, 50798851},
	{12825, 50799619}, {12826, 50800387}, {12827, 50801155}, {12828, 50801923},
	{12829, 67579907}, {12830, 67580931}, {12831, 2}, {12832, 50804739},
	{12833, 50805507}, {12834, 50806275}, {12835, 50807043}, {12836, 50807811},
	{12837, 50808579}, {12838, 50809347}, {12839, 50810115}, {12840, 50810883},
	{12841, 50811651}, {12842, 50812419}, {12843, 50813187}, {12844, 50813955},
	{12845, 50814723}, {12846, 50815491}, {12847, 50816259}, {12848, 50817027},
	{12849, 50817795}, {12850, 50818563}, {12851, 50819331}, {12852, 50820099},
	{12853, 50820867}, {12854, 50821635}, {12855, 50822403}, {12856, 50823171},
	{12857, 50823939}, {12858, 50824707}, {12859, 50825475}, {12860, 50826243},
	{12861, 50827011}, {12862, 50827779}, {12863, 50828547}, {12864, 50829315},
	{12865, 50830083}, {12866, 50830851}, {12867, 50831619}, {12868, 17277955},
	{12869, 17278211}, {12870, 17158659}, {12871, 17278467}, {12872, 1},
	{12880, 50833155}, {12881, 33845251}, {12882, 34056707}, {12883, 33562371},
	{12884, 34057219}, {12885, 34057731}, {12886, 34058243}, {12887, 34058755},
	{12888, 34059267}, {12889, 34059779}, {12890, 34060291}, {12891, 33827331},
	{12892, 33826563}, {12893, 34060803}, {12894, 34061315}, {12895, 34061827},
	{12896, 17199619}, {12897, 17200387}, {12898, 17201155}, {12899, 17201667},
	{12900, 17203715}, {12901, 17203971}, {12902, 17204739}, {12903, 17205251},
	{12904, 17205507}, {12905, 17206019}, {12906, 17206275}, {12907, 17206531},
	{12908, 17206787}, {12909, 17207043}, {12910, 17236995}, {12911, 17237763},
	{12912, 17238531}, {12913, 17239299}, {12914, 17240067}, {12915, 17240835},
	{12916, 17241603}, {12917, 17242371}, {12918, 17243139}, {12919, 17243907},
	{12920, 17244675}, {12921, 17245443}, {12922, 17246211}, {12923, 17246979},
	{12924, 34062339}, {12925, 34062851}, {12926, 17286147}, {12927, 1},
	{12928, 17141763}, {12929, 17143299}, {12930, 17223427}, {12931, 17223683},
	{12932, 17253635}, {12933, 17254403}, {12934, 17255171}, {12935, 17144579},
	{12936, 17256707}, {12937, 17147651}, {12938, 17160451}, {12939, 17163523},
	{12940, 17163267}, {12941, 17160707}, {12942, 17184259}, {12943, 17149699},
	{12944, 17159939}, {12945, 17263619}, {12946, 17264387}, {12947, 17265155},
	{12948, 17265923}, {12949, 17266691}, {12950, 17267459}, {12951, 17268227},
	{12952, 17268995}, {12953, 17286403}, {12954, 17286659}, {12955, 17151235},
	{12956, 17286915}, {12957, 17287171}, {12958, 17287427}, {12959, 17287683},
	{12960, 17287939}, {12961, 17275907}, {12962, 17288195}, {12963, 17288451},
	{12964, 17223939}, {12965, 17224195}, {12966, 17224451}, {12967, 17288707},
	{12968, 17288963}, {12969, 17289219}, {12970, 17289475}, {12971, 17271299},
	{12972, 17272067}, {12973, 17272835}, {12974, 17273603}, {12975, 17274371},
	{12976, 17289731}, {12977, 34067203}, {12978, 34067715}, {12979, 34068227},
	{12980, 34068739}, {12981, 34069251}, {12982, 33564931}, {12983, 34057475},
	{12984, 34061571}, {12985, 34069763}, {12986, 34070275}, {12987, 34070787},
	{12988, 34071299}, {12989, 34071811}, {12990, 34072323}, {12991, 34072835},
	{12992, 34073347}, {12993, 34073859}, {12994, 34074371}, {12995, 34074883},
	{12996, 34075395}, {12997, 34075907}, {12998, 34076419}, {12999, 34076931},
	{13000, 34077443}, {13001, 50855171}, {13002, 50855939}, {13003, 50856707},
	{13004, 34080259}, {13005, 50857987}, {13006, 34081539}, {13007, 50859267},
	{13008, 17305603}, {13009, 17305859}, {13010, 17306115}, {13011, 17306371},
	{13012, 17306627}, {13013, 17306883}, {13014, 17307139}, {13015, 17307395},
	{13016, 17307651}, {13017, 17199107}, {13018, 17307907}, {13019, 17308163},
	{13020, 17308419}, {13021, 17308675}, {13022, 17308931}, {13023, 17309187},
	{13024, 17309443}, {13025, 17309699}, {13026, 17309955}, {13027, 17199363},
	{13028, 17310211}, {13029, 17310467}, {13030, 17310723}, {13031, 17310979},
	{13032, 17311235}, {13033, 17311491}, {13034, 17311747}, {13035, 17312003},
	{13036, 17312259}, {13037, 17312515}, {13038, 17312771}, {13039, 17313027},
	{13040, 17313283}, {13041, 17313539}, {13042, 17313795}, {13043, 17314051},
	{13044, 17314307}, {13045, 17314563}, {13046, 17314819}, {13047, 17315075},
	{13048, 17315331}, {13049, 17315587}, {13050, 17315843}, {13051, 17316099},
	{13052, 17316355}, {13053, 17316611}, {13054, 17316867}, {13055, 34094339},
	{13056, 67649283}, {13057, 67650307}, {13058, 67651331}, {13059, 50875139},
	{13060, 67653123}, {13061, 50876931}, {13062, 50877699}, {13063, 84432899},
	{13064, 67656963}, {13065, 50880771}, {13066, 50881539}, {13067, 50882307},
	{13068, 67660291}, {13069, 67661315}, {13070, 50885123}, {13071, 50885891},
	{13072, 34109443}, {13073, 50887171}, {13074, 67665155}, {13075, 67666179},
	{13076, 34112771}, {13077, 84444931}, {13078, 101223427}, {13079, 84447747},
	{13080, 50891011}, {13081, 84449027}, {13082, 84450307}, {13083, 67674371},
	{13084, 50898179}, {13085, 50898947}, {13086, 50899715}, {13087, 67677699},
	{13088, 84455939}, {13089, 67680003}, {13090, 50903811}, {13091, 50904579},
	{13092, 50905347}, {13093, 34128899}, {13094, 34129411}, {13095, 34118147},
	{13096, 34129923}, {13097, 50907651}, {13098, 50908419}, {13099, 84463619},
	{13100, 50910467}, {13101, 67688451}, {13102, 84466691}, {13103, 50913539},
	{13104, 34137091}, {13105, 34137603}, {13106, 84469763}, {13107, 67693827},
	{13108, 84472067}, {13109, 50918915}, {13110, 84474115}, {13111, 34143747},
	{13112, 50921475}, {13113, 50922243}, {13114, 50923011}, {13115, 50923779},
	{13116, 50924547}, {13117, 67702531}, {13118, 50926339}, {13119, 34149891},
	{13120, 50927619}, {13121, 50928387}, {13122, 50929155}, {13123, 67707139},
	{13124, 50930947}, {13125, 50931715}, {13126, 50932483}, {13127, 84487683},
	{13128, 67711747}, {13129, 34158339}, {13130, 84490499}, {13131, 34160131},
	{13132, 67715075}, {13133, 67669507}, {13134, 50938883}, {13135, 50939651},
	{13136, 50940419}, {13137, 67718403}, {13138, 34164995}, {13139, 50942723},
	{13140, 67720707}, {13141, 34167299}, {13142, 84499459}, {13143, 50893827},
	{13144, 34169091}, {13145, 34169603}, {13146, 34170115}, {13147, 34170627},
	{13148, 34171139}, {13149, 34171651}, {13150, 34172163}, {13151, 34172675},
	{13152, 34173187}, {13153, 34173699}, {13154, 50951427}, {13155, 50952195},
	{13156, 50952963}, {13157, 50953731}, {13158, 50954499}, {13159, 50955267},
	{13160, 50956035}, {13161, 50956803}, {13162, 50957571}, {13163, 50958339},
	{13164, 50959107}, {13165, 50959875}, {13166, 50960643}, {13167, 50961411},
	{13168, 50962179}, {13169, 50962947}, {13170, 34186499}, {13171, 34187011},
	{13172, 50964739}, {13173, 34188291}, {13174, 34188803}, {13175, 34189315},
	{13176, 50967043}, {13177, 50967811}, {13178, 34191363}, {13179, 34191875},
	{13180, 34192387}, {13181, 34192899}, {13182, 34193411}, {13183, 67748355},
	{13184, 34185987}, {13185, 34194947}, {13186, 34195459}, {13187, 34195971},
	{13188, 34196483}, {13189, 34196995}, {13190, 34197507}, {13191, 34198019},
	{13192, 50975747}, {13193, 67753731}, {13194, 34200323}, {13195, 34200835},
	{13196, 34201347}, {13197, 34201859}, {13198, 34202371}, {13199, 34202883},
	{13200, 34203395}, {13201, 50981123}, {13202, 50981891}, {13203, 50980355},
	{13204, 50982659}, {13205, 34206211}, {13206, 34206723}, {13207, 34207235},
	{13208, 33556995}, {13209, 34207747}, {13210, 34208259}, {13211, 34208771},
	{13212, 34209283}, {13213, 34209795}, {13214, 34210307}, {13215, 50988035},
	{13216, 50988803}, {13217, 34190083}, {13218, 50989571}, {13219, 50990339},
	{13220, 50991107}, {13221, 34190851}, {13222, 50991875}, {13223, 50992643},
	{13224, 67770627}, {13225, 34185987}, {13226, 50994435}, {13227, 50995203},
	{13228, 50995971}, {13229, 50996739}, {13230, 84551939}, {13231, 101330435},
	{13232, 34223107}, {13233, 34223619}, {13234, 34224131}, {13235, 34224643},
	{13236, 34225155}, {13237, 34225667}, {13238, 34226179}, {13239, 34226691},
	{13240, 34227203}, {13241, 34226691}, {13242, 34227715}, {13243, 34228227},
	{13244, 34228739}, {13245, 34229251}, {13246, 34229763}, {13247, 34229251},
	{13248, 34230275}, {13249, 34230787}, {13250, 2}, {13251, 34231299},
	{13252, 33817347}, {13253, 33554947}, {13254, 67786243}, {13255, 2},
	{13256, 34232835}, {13257, 34233347}, {13258, 34233859}, {13259, 34185731},
	{13260, 34234371}, {13261, 34234883}, {13262, 34210307}, {13263, 34235395},
	{13264, 33557251}, {13265, 34235907}, {13266, 51013635}, {13267, 34237187},
	{13268, 34197507}, {13269, 51014915}, {13270, 51015683}, {13271, 34239235},
	{13272, 2}, {13273, 51016963}, {13274, 34240515}, {13275, 34221315},
	{13276, 34241027}, {13277, 34241539}, {13278, 51019267}, {13279, 51020035},
	{13280, 34243587}, {13281, 34244099}, {13282, 34244611}, {13283, 34245123},
	{13284, 34245635}, {13285, 34246147}, {13286, 34246659}, {13287, 34247171},
	{13288, 34247683}, {13289, 51025411}, {13290, 51026179}, {13291, 51026947},
	{13292, 51027715}, {13293, 51028483}, {13294, 51029251}, {13295, 51030019},
	{13296, 51030787}, {13297, 51031555}, {13298, 51032323}, {13299, 51033091},
	{13300, 51033859}, {13301, 51034627}, {13302, 51035395}, {13303, 51036163},
	{13304, 51036931}, {13305, 51037699}, {13306, 51038467}, {13307, 51039235},
	{13308, 51040003}, {13309, 51040771}, {13310, 51041539}, {13311, 51042307},
	{13312, 1}, {42125, 2}, {42128, 1}, {42183, 2},
	{42192, 1}, {42540, 2}, {42560, 17488643}, {42561, 1},
	{42562, 17488899}, {42563, 1}, {42564, 17489155}, {42565, 1},
	{42566, 17489411}, {42567, 1}, {42568, 17489667}, {42569, 1},
	{42570, 16936451}, {42571, 1}, {42572, 17489923}, {42573, 1},
	{42574, 17490179}, {42575, 1}, {42576, 17490435}, {42577, 1},
	{42578, 17490691}, {42579, 1}, {42580, 17490947}, {42581, 1},
	{42582, 17491203}, {42583, 1}, {42584, 17491459}, {42585, 1},
	{42586, 17491715}, {42587, 1}, {42588, 17491971}, {42589, 1},
	{42590, 17492227}, {42591, 1}, {42592, 17492483}, {42593, 1},
	{42594, 17492739}, {42595, 1}, {42596, 17492995}, {42597, 1},
	{42598, 17493251}, {42599, 1}, {42600, 17493507}, {42601, 1},
	{42602, 17493763}, {42603, 1}, {42604, 17494019}, {42605, 1},
	{42624, 17494275}, {42625, 1}, {42626, 17494531}, {42627, 1},
	{42628, 17494787}, {42629, 1}, {42630, 17495043}, {42631, 1},
	{42632, 17495299}, {42633, 1}, {42634, 17495555}, {42635, 1},
	{42636, 17495811}, {42637, 1}, {42638, 17496067}, {42639, 1},
	{42640, 17496323}, {42641, 1}, {42642, 17496579}, {42643, 1},
	{42644, 17496835}, {42645, 1}, {42646, 17497091}, {42647, 1},
	{42648, 17497347}, {42649, 1}, {42650, 17497603}, {42651, 1},
	{42652, 16873219}, {42653, 16873731}, {42654, 1}, {42744, 2},
	{42752, 1}, {42786, 17497859}, {42787, 1}, {42788, 17498115},
	{42789, 1}, {42790, 17498371}, {42791, 1}, {42792, 17498627},
	{42793, 1}, {42794, 17498883}, {42795, 1}, {42796, 17499139},
	{42797, 1}, {42798, 17499395}, {42799, 1}, {42802, 17499651},
	{42803, 1}, {42804, 17499907}, {42805, 1}, {42806, 17500163},
	{42807, 1}, {42808, 17500419}, {42809, 1}, {42810, 17500675},
	{42811, 1}, {42812, 17500931}, {42813, 1}, {42814, 17501187},
	{42815, 1}, {42816, 17501443}, {42817, 1}, {42818, 17501699},
	{42819, 1}, {42820, 17501955}, {42821, 1}, {42822, 17502211},
	{42823, 1}, {42824, 17502467}, {42825, 1}, {42826, 17502723},
	{42827, 1}, {42828, 17502979}, {42829, 1}, {42830, 17503235},
	{42831, 1}, {42832, 17503491}, {42833, 1}, {42834, 17503747},
	{42835, 1}, {42836, 17504003}, {42837, 1}, {42838, 17504259},
	{42839, 1}, {42840, 17504515}, {42841, 1}, {42842, 17504771},
	{42843, 1}, {42844, 17505027}, {42845, 1}, {42846, 17505283},
	{42847, 1}, {42848, 17505539}, {42849, 1}, {42850, 17505795},
	{42851, 1}, {42852, 17506051}, {42853, 1}, {42854, 17506307},
	{42855, 1}, {42856, 17506563}, {42857, 1}, {42858, 17506819},
	{42859, 1}, {42860, 17507075}, {42861, 1}, {42862, 17507331},
	{42863, 1}, {42864, 17507331}, {42865, 1}, {42873, 17507587},
	{42874, 1}, {42875, 17507843}, {42876, 1}, {42877, 17508099},
	{42878, 17508355}, {42879, 1}, {42880, 17508611}, {42881, 1},
	{42882, 17508867}, {42883, 1}, {42884, 17509123}, {42885, 1},
	{42886, 17509379}, {42887, 1}, {42891, 17509635}, {42892, 1},
	{42893, 16951299}, {42894, 1}, {42896, 17509891}, {42897, 1},
	{42898, 17510147}, {42899, 1}, {42902, 17510403}, {42903, 1},
	{42904, 17510659}, {42905, 1}, {42906, 17510915}, {42907, 1},
	{42908, 17511171}, {42909, 1}, {42910, 17511427}, {42911, 1},
	{42912, 17511683}, {42913, 1}, {42914, 17511939}, {42915, 1},
	{42916, 17512195}, {42917, 1}, {42918, 17512451}, {42919, 1},
	{42920, 17512707}, {42921, 1}, {42922, 16841475}, {42923, 16948995},
	{42924, 16951043}, {42925, 17512963}, {42926, 16951555}, {42927, 1},
	{42928, 17513219}, {42929, 17513475}, {42930, 16952067}, {42931, 17513731},
	{42932, 17513987}, {42933, 1}, {42934, 17514243}, {42935, 1},
	{42936, 17514499}, {42937, 1}, {42938, 17514755}, {42939, 1},
	{42940, 17515011}, {42941, 1}, {42942, 17515267}, {42943, 1},
	{42944, 17515523}, {42945, 1}, {42946, 17515779}, {42947, 1},
	{42948, 17516035}, {42949, 16954371}, {42950, 17516291}, {42951, 17516547},
	{42952, 1}, {42953, 17516803}, {42954, 1}, {42955, 2},
	{42960, 17517059}, {42961, 1}, {42962, 2}, {42963, 1},
	{42964, 2}, {42965, 1}, {42966, 17517315}, {42967, 1},
	{42968, 17517571}, {42969, 1}, {42970, 2}, {42994, 16777731},
	{42995, 16778499}, {42996, 16781315}, {42997, 17517827}, {42998, 1},
	{43000, 16802051}, {43001, 16808195}, {43002, 1}, {43053, 2},
	{43056, 1}, {43066, 2}, {43072, 1}, {43128, 2},
	{43136, 1}, {43206, 2}, {43214, 1}, {43226, 2},
	{43232, 1}, {43348, 2}, {43359, 1}, {43389, 2},
	{43392, 1}, {43470, 2}, {43471, 1}, {43482, 2},
	{43486, 1}, {43519, 2}, {43520, 1}, {43575, 2},
	{43584, 1}, {43598, 2}, {43600, 1}, {43610, 2},
	{43612, 1}, {43715, 2}, {43739, 1}, {43767, 2},
	{43777, 1}, {43783, 2}, {43785, 1}, {43791, 2},
	{43793, 1}, {43799, 2}, {43808, 1}, {43815, 2},
	{43816, 1}, {43823, 2}, {43824, 1}, {43868, 17498371},
	{43869, 17518083}, {43870, 17124867}, {43871, 17518339}, {43872, 1},
	{43881, 17518595}, {43882, 1}, {43884, 2}, {43888, 17518851},
	{43889, 17519107}, {43890, 17519363}, {43891, 17519619}, {43892, 17519875},
	{43893, 17520131}, {43894, 17520387}, {43895, 17520643}, {43896, 17520899},
	{43897, 17521155}, {43898, 17521411}, {43899, 17521667}, {43900, 17521923},
	{43901, 17522179}, {43902, 17522435}, {43903, 17522691}, {43904, 17522947},
	{43905, 17523203}, {43906, 17523459}, {43907, 17523715}, {43908, 17523971},
	{43909, 17524227}, {43910, 17524483}, {43911, 17524739}, {43912, 17524995},
	{43913, 17525251}, {43914, 17525507}, {43915, 17525763}, {43916, 17526019},
	{43917, 17526275}, {43918, 17526531}, {43919, 17526787}, {43920, 17527043},
	{43921, 17527299}, {43922, 17527555}, {43923, 17527811}, {43924, 17528067},
	{43925, 17528323}, {43926, 17528579}, {43927, 17528835}, {43928, 17529091},
	{43929, 17529347}, {43930, 17529603}, {43931, 17529859}, {43932, 17530115},
	{43933, 17530371}, {43934, 17530627}, {43935, 17530883}, {43936, 17531139},
	{43937, 17531395}, {43938, 17531651}, {43939, 17531907}, {43940, 17532163},
	{43941, 17532419}, {43942, 17532675}, {43943, 17532931}, {43944, 17533187},
	{43945, 17533443}, {43946, 17533699}, {43947, 17533955}, {43948, 17534211},
	{43949, 17534467}, {43950, 17534723}, {43951, 17534979}, {43952, 17535235},
	{43953, 17535491}, {43954, 17535747}, {43955, 17536003}, {43956, 17536259},
	{43957, 17536515}, {43958, 17536771}, {43959, 17537027}, {43960, 17537283},
	{43961, 17537539}, {43962, 17537795}, {43963, 17538051}, {43964, 17538307},
	{43965, 17538563}, {43966, 17538819}, {43967, 17539075}, {43968, 1},
	{44014, 2}, {44016, 1}, {44026, 2}, {44032, 1},
	{55204, 2}, {55216, 1}, {55239, 2}, {55243, 1},
	{55292, 2}, {63744, 17539331}, {63745, 17539587}, {63746, 17182211},
	{63747, 17539843}, {63748, 17540099}, {63749, 17540355}, {63750, 17540611},
	{63751, 17196035}, {63753, 17540867}, {63754, 17184259}, {63755, 17541123},
	{63756, 17541379}, {63757, 17541635}, {63758, 17541891}, {63759, 17542147},
	{63760, 17542403}, {63761, 17542659}, {63762, 17542915}, {63763, 17543171},
	{63764, 17543427}, {63765, 17543683}, {63766, 17543939}, {63767, 17544195},
	{63768, 17544451}, {63769, 17544707}, {63770, 17544963}, {63771, 17545219},
	{63772, 17545475}, {63773, 17545731}, {63774, 17545987}, {63775, 17546243},
	{63776, 17546499}, {63777, 17546755}, {63778, 17547011}, {63779, 17547267},
	{63780, 17547523}, {63781, 17547779}, {63782, 17548035}, {63783, 17548291},
	{63784, 17548547}, {63785, 17548803}, {63786, 17549059}, {63787, 17549315},
	{63788, 17549571}, {63789, 17549827}, {63790, 17550083}, {63791, 17550339},
	{63792, 17550595}, {63793, 17550851}, {63794, 17551107}, {63795, 17551363},
	{63796, 17173507}, {63797, 17551619}, {63798, 17551875}, {63799, 17552131},
	{63800, 17552387}, {63801, 17552643}, {63802, 17552899}, {63803, 17553155},
	{63804, 17553411}, {63805, 17553667}, {63806, 17553923}, {63807, 17554179},
	{63808, 17192195}, {63809, 17554435}, {63810, 17554691}, {63811, 17554947},
	{63812, 17555203}, {63813, 17555459}, {63814, 17555715}, {63815, 17555971},
	{63816, 17556227}, {63817, 17556483}, {63818, 17556739}, {63819, 17556995},
	{63820, 17557251}, {63821, 17557507}, {63822, 17557763}, {63823, 17558019},
	{63824, 17558275}, {63825, 17558531}, {63826, 17558787}, {63827, 17559043},
	{63828, 17559299}, {63829, 17559555}, {63830, 17559811}, {63831, 17560067},
	{63832, 17560323}, {63833, 17560579}, {63834, 17560835}, {63835, 17561091},
	{63836, 17543427}, {63837, 17561347}, {63838, 17561603}, {63839, 17561859},
	{63840, 17562115}, {63841, 17562371}, {63842, 17562627}, {63843, 17562883},
	{63844, 17563139}, {63845, 17563395}, {63846, 17563651}, {63847, 17563907},
	{63848, 17564163}, {63849, 17564419}, {63850, 17564675}, {63851, 17564931},
	{63852, 17565187}, {63853, 17565443}, {63854, 17565699}, {63855, 17565955},
	{63856, 17566211}, {63857, 17182723}, {63858, 17566467}, {63859, 17566723},
	{63860, 17566979}, {63861, 17567235}, {63862, 17567491}, {63863, 17567747},
	{63864, 17568003}, {63865, 17568259}, {63866, 17568515}, {63867, 17568771},
	{63868, 17569027}, {63869, 17569283}, {63870, 17569539}, {63871, 17569795},
	{63872, 17570051}, {63873, 17151235}, {63874, 17570307}, {63875, 17570563},
	{63876, 17570819}, {63877, 17571075}, {63878, 17571331}, {63879, 17571587},
	{63880, 17571843}, {63881, 17572099}, {63882, 17146371}, {63883, 17572355},
	{63884, 17572611}, {63885, 17572867}, {63886, 17573123}, {63887, 17573379},
	{63888, 17573635}, {63889, 17573891}, {63890, 17574147}, {63891, 17574403},
	{63892, 17574659}, {63893, 17574915}, {63894, 17575171}, {63895, 17575427},
	{63896, 17575683}, {63897, 17575939}, {63898, 17576195}, {63899, 17576451},
	{63900, 17576707}, {63901, 17576963}, {63902, 17577219}, {63903, 17577475},
	{63904, 17577731}, {63905, 17565955}, {63906, 17577987}, {63907, 17578243},
	{63908, 17578499}, {63909, 17578755}, {63910, 17579011}, {63911, 17579267},
	{63912, 17317123}, {63913, 17579523}, {63914, 17561859}, {63915, 17579779},
	{63916, 17580035}, {63917, 17580291}, {63918, 17580547}, {63919, 17580803},
	{63920, 17581059}, {63921, 17581315}, {63922, 17581571}, {63923, 17581827},
	{63924, 17582083}, {63925, 17582339}, {63926, 17582595}, {63927, 17582851},
	{63928, 17583107}, {63929, 17583363}, {63930, 17583619}, {63931, 17583875},
	{63932, 17584131}, {63933, 17584387}, {63934, 17584643}, {63935, 17543427},
	{63936, 17584899}, {63937, 17585155}, {63938, 17585411}, {63939, 17585667},
	{63940, 17195779}, {63941, 17585923}, {63942, 17586179}, {63943, 17586435},
	{63944, 17586691}, {63945, 17586947}, {63946, 17587203}, {63947, 17587459},
	{63948, 17587715}, {63949, 17587971}, {63950, 17588227}, {63951, 17588483},
	{63952, 17588739}, {63953, 17254403}, {63954, 17588995}, {63955, 17589251},
	{63956, 17589507}, {63957, 17589763}, {63958, 17590019}, {63959, 17590275},
	{63960, 17590531}, {63961, 17590787}, {63962, 17591043}, {63963, 17562371},
	{63964, 17591299}, {63965, 17591555}, {63966, 17591811}, {63967, 17592067},
	{63968, 17592323}, {63969, 17592579}, {63970, 17592835}, {63971, 17593091},
	{63972, 17593347}, {63973, 17593603}, {63974, 17593859}, {63975, 17594115},
	{63976, 17594371}, {63977, 17184003}, {63978, 17594627}, {63979, 17594883},
	{63980, 17595139}, {63981, 17595395}, {63982, 17595651}, {63983, 17595907},
	{63984, 17596163}, {63985, 17596419}, {63986, 17596675}, {63987, 17596931},
	{63988, 17597187}, {63989, 17597443}, {63990, 17597699}, {63991, 17171459},
	{63992, 17597955}, {63993, 17598211}, {63994, 17598467}, {63995, 17598723},
	{63996, 17598979}, {63997, 17599235}, {63998, 17599491}, {63999, 17599747},
	{64000, 17600003}, {64001, 17600259}, {64002, 17600515}, {64003, 17600771},
	{64004, 17601027}, {64005, 17601283}, {64006, 17601539}, {64007, 17601795},
	{64008, 17178371}, {64009, 17602051}, {64010, 17179139}, {64011, 17602307},
	{64012, 17602563}, {64013, 17602819}, {64014, 1}, {64016, 17603075},
	{64017, 1}, {64018, 17603331}, {64019, 1}, {64021, 17603587},
	{64022, 17603843}, {64023, 17604099}, {64024, 17604355}, {64025, 17604611},
	{64026, 17604867}, {64027, 17605123}, {64028, 17605379}, {64029, 17605635},
	{64030, 17173251}, {64031, 1}, {64032, 17605891}, {64033, 1},
	{64034, 17606147}, {64035, 1}, {64037, 17606403}, {64038, 17606659},
	{64039, 1}, {64042, 17606915}, {64043, 17607171}, {64044, 17607427},
	{64045, 17607683}, {64046, 17607939}, {64047, 17608195}, {64048, 17608451},
	{64049, 17608707}, {64050, 17608963}, {64051, 17609219}, {64052, 17609475},
	{64053, 17609731}, {64054, 17609987}, {64055, 17610243}, {64056, 17610499},
	{64057, 17610755}, {64058, 17611011}, {64059, 17611267}, {64060, 17153027},
	{64061, 17611523}, {64062, 17611779}, {64063, 17612035}, {64064, 17612291},
	{64065, 17612547}, {64066, 17612803}, {64067, 17613059}, {64068, 17613315},
	{64069, 17613571}, {64070, 17613827}, {64071, 17614083}, {64072, 17614339},
	{64073, 17614595}, {64074, 17614851}, {64075, 17615107}, {64076, 17265155},
	{64077, 17615363}, {64078, 17615619}, {64079, 17615875}, {64080, 17616131},
	{64081, 17268227}, {64082, 17616387}, {64083, 17616643}, {64084, 17616899},
	{64085, 17617155}, {64086, 17617411}, {64087, 17575171}, {64088, 17617667},
	{64089, 17617923}, {64090, 17618179}, {64091, 17618435}, {64092, 17618691},
	{64093, 17618947}, {64095, 17619203}, {64096, 17619459}, {64097, 17619715},
	{64098, 17619971}, {64099, 17620227}, {64100, 17620483}, {64101, 17620739},
	{64102, 17620995}, {64103, 17606403}, {64104, 17621251}, {64105, 17621507},
	{64106, 17621763}, {64107, 17622019}, {64108, 17622275}, {64109, 17622531},
	{64110, 2}, {64112, 17622787}, {64113, 17623043}, {64114, 17623299},
	{64115, 17623555}, {64116, 17623811}, {64117, 17624067}, {64118, 17624323},
	{64119, 17624579}, {64120, 17609987}, {64121, 17624835}, {64122, 17625091},
	{64123, 17625347}, {64124, 17603075}, {64125, 17625603}, {64126, 17625859},
	{64127, 17626115}, {64128, 17626371}, {64129, 17626627}, {64130, 17626883},
	{64131, 17627139}, {64132, 17627395}, {64133, 17627651}, {64134, 17627907},
	{64135, 17628163}, {64136, 17628419}, {64137, 17612035}, {64138, 17628675},
	{64139, 17612291}, {64140, 17628931}, {64141, 17629187}, {64142, 17629443},
	{64143, 17629699}, {64144, 17629955}, {64145, 17603331}, {64146, 17548803},
	{64147, 17630211}, {64148, 17630467}, {64149, 17161475}, {64150, 17566211},
	{64151, 17587203}, {64152, 17630723}, {64153, 17630979}, {64154, 17614083},
	{64155, 17631235}, {64156, 17614339}, {64157, 17631491}, {64158, 17631747},
	{64159, 17632003}, {64160, 17603843}, {64161, 17632259}, {64162, 17632515},
	{64163, 17632771}, {64164, 17633027}, {64165, 17633283}, {64166, 17604099},
	{64167, 17633539}, {64168, 17633795}, {64169, 17634051}, {64170, 17634307},
	{64171, 17634563}, {64172, 17634819}, {64173, 17617411}, {64174, 17635075},
	{64175, 17635331}, {64176, 17575171}, {64177, 17635587}, {64178, 17618435},
	{64179, 17635843}, {64180, 17636099}, {64181, 17636355}, {64182, 17636611},
	{64183, 17636867}, {64184, 17619715}, {64185, 17637123}, {64186, 17606147},
	{64187, 17637379}, {64188, 17619971}, {64189, 17561347}, {64190, 17637635},
	{64191, 17620227}, {64192, 17637891}, {64193, 17620739}, {64194, 17638147},
	{64195, 17638403}, {64196, 17638659}, {64197, 17638915}, {64198, 17639171},
	{64199, 17621251}, {64200, 17605379}, {64201, 17639427}, {64202, 17621507},
	{64203, 17639683}, {64204, 17621763}, {64205, 17639939}, {64206, 17196035},
	{64207, 17640195}, {64208, 17640451}, {64209, 17640707}, {64210, 17640963},
	{64211, 17641219}, {64212, 17641475}, {64213, 17641731}, {64214, 17641987},
	{64215, 17642243}, {64216, 17642499}, {64217, 17642755}, {64218, 2},
	{64256, 34420227}, {64257, 34420739}, {64258, 34421251}, {64259, 51197699},
	{64260, 51198979}, {64261, 33559043}, {64263, 2}, {64275, 34422531},
	{64276, 34423043}, {64277, 34423555}, {64278, 34424067}, {64279, 34424579},
	{64280, 2}, {64285, 34425091}, {64286, 1}, {64287, 34425603},
	{64288, 17648899}, {64289, 17044227}, {64290, 17044995}, {64291, 17649155},
	{64292, 17649411}, {64293, 17649667}, {64294, 17649923}, {64295, 17650179},
	{64296, 17650435}, {64297, 17037059}, {64298, 34427907}, {64299, 34428419},
	{64300, 51206147}, {64301, 51206915}, {64302, 34430467}, {64303, 34430979},
	{64304, 34431491}, {64305, 34432003}, {64306, 34432515}, {64307, 34433027},
	{64308, 34433539}, {64309, 34434051}, {64310, 34434563}, {64311, 2},
	{64312, 34435075}, {64313, 34435587}, {64314, 34436099}, {64315, 34436611},
	{64316, 34437123}, {64317, 2}, {64318, 34437635}, {64319, 2},
	{64320, 34438147}, {64321, 34438659}, {64322, 2}, {64323, 34439171},
	{64324, 34439683}, {64325, 2}, {64326, 34440195}, {64327, 34440707},
	{64328, 34441219}, {64329, 34428931}, {64330, 34441731}, {64331, 34442243},
	{64332, 34442755}, {64333, 34443267}, {64334, 34443779}, {64335, 34444291},
	{64336, 17667587}, {64338, 17667843}, {64342, 17668099}, {64346, 17668355},
	{64350, 17668611}, {64354, 17668867}, {64358, 17669123}, {64362, 17669379},
	{64366, 17669635}, {64370, 17669891}, {64374, 17670147}, {64378, 17670403},
	{64382, 17670659}, {64386, 17670915}, {64388, 17671171}, {64390, 17671427},
	{64392, 17671683}, {64394, 17671939}, {64396, 17672195}, {64398, 17672451},
	{64402, 17672707}, {64406, 17672963}, {64410, 17673219}, {64414, 17673475},
	{64416, 17673731}, {64420, 17673987}, {64422, 17674243}, {64426, 17674499},
	{64430, 17674755}, {64432, 17675011}, {64434, 1}, {64451, 2},
	{64467, 17675267}, {64471, 16911363}, {64473, 17675523}, {64475, 17675779},
	{64477, 33688579}, {64478, 17676035}, {64480, 17676291}, {64482, 17676547},
	{64484, 17676803}, {64488, 17677059}, {64490, 34454531}, {64492, 34455043},
	{64494, 34455555}, {64496, 34456067}, {64498, 34456579}, {64500, 34457091},
	{64502, 34457603}, {64505, 34458115}, {64508, 17681411}, {64512, 34458883},
	{64513, 34459395}, {64514, 34459907}, {64515, 34458115}, {64516, 34460419},
	{64517, 34460931}, {64518, 34461443}, {64519, 34461955}, {64520, 34462467},
	{64521, 34462979}, {64522, 34463491}, {64523, 34464003}, {64524, 34464515},
	{64525, 34465027}, {64526, 34465539}, {64527, 34466051}, {64528, 34466563},
	{64529, 34467075}, {64530, 34467587}, {64531, 34468099}, {64532, 34468611},
	{64533, 34469123}, {64534, 34469635}, {64535, 34469379}, {64536, 34470147},
	{64537, 34470659}, {64538, 34471171}, {64539, 34471683}, {64540, 34472195},
	{64541, 34472707}, {64542, 34473219}, {64543, 34473731}, {64544, 34474243},
	{64545, 34474755}, {64546, 34475267}, {64547, 34475779}, {64548, 34476291},
	{64549, 34476803}, {64550, 34477315}, {64551, 34477827}, {64552, 34478339},
	{64553, 34478851}, {64554, 34479363}, {64555, 34479875}, {64556, 34480387},
	{64557, 34480899}, {64558, 34481411}, {64559, 34481923}, {64560, 34482435},
	{64561, 34482947}, {64562, 34483459}, {64563, 34483971}, {64564, 34484483},
	{64565, 34484995}, {64566, 34485507}, {64567, 34486019}, {64568, 34486531},
	{64569, 34487043}, {64570, 34487555}, {64571, 34488067}, {64572, 34488579},
	{64573, 34489091}, {64574, 34489603}, {64575, 34490115}, {64576, 34490627},
	{64577, 34491139}, {64578, 34491651}, {64579, 34492163}, {64580, 34492675},
	{64581, 34493187}, {64582, 34469891}, {64583, 34470403}, {64584, 34493699},
	{64585, 34494211}, {64586, 34494723}, {64587, 34495235}, {64588, 34495747},
	{64589, 34496259}, {64590, 34496771}, {64591, 34497283}, {64592, 34497795},
	{64593, 34498307}, {64594, 34498819}, {64595, 34499331}, {64596, 34499843},
	{64597, 34468867}, {64598, 34500355}, {64599, 34500867}, {64600, 34492931},
	{64601, 34501379}, {64602, 34500099}, {64603, 34501891}, {64604, 34502403},
	{64605, 34502915}, {64606, 51280643}, {64607, 51281411}, {64608, 51282179},
	{64609, 51282947}, {64610, 51283715}, {64611, 51284483}, {64612, 34508035},
	{64613, 34508547}, {64614, 34459907}, {64615, 34509059}, {64616, 34458115},
	{64617, 34460419}, {64618, 34509571}, {64619, 34510083}, {64620, 34462467},
	{64621, 34510595}, {64622, 34462979}, {64623, 34463491}, {64624, 34511107},
	{64625, 34511619}, {64626, 34465539}, {64627, 34512131}, {64628, 34466051},
	{64629, 34466563}, {64630, 34512643}, {64631, 34513155}, {64632, 34467587},
	{64633, 34513667}, {64634, 34468099}, {64635, 34468611}, {64636, 34482947},
	{64637, 34483459}, {64638, 34484995}, {64639, 34485507}, {64640, 34486019},
	{64641, 34488067}, {64642, 34488579}, {64643, 34489091}, {64644, 34489603},
	{64645, 34491651}, {64646, 34492163}, {64647, 34492675}, {64648, 34514179},
	{64649, 34493699}, {64650, 34514691}, {64651, 34515203}, {64652, 34496771},
	{64653, 34515715}, {64654, 34497283}, {64655, 34497795}, {64656, 34502915},
	{64657, 34516227}, {64658, 34516739}, {64659, 34492931}, {64660, 34494979},
	{64661, 34501379}, {64662, 34500099}, {64663, 34458883}, {64664, 34459395},
	{64665, 34517251}, {64666, 34459907}, {64667, 34517763}, {64668, 34460931},
	{64669, 34461443}, {64670, 34461955}, {64671, 34462467}, {64672, 34518275},
	{64673, 34464003}, {64674, 34464515}, {64675, 34465027}, {64676, 34465539},
	{64677, 34518787}, {64678, 34467587}, {64679, 34469123}, {64680, 34469635},
	{64681, 34469379}, {64682, 34470147}, {64683, 34470659}, {64684, 34471683},
	{64685, 34472195}, {64686, 34472707}, {64687, 34473219}, {64688, 34473731},
	{64689, 34474243}, {64690, 34519299}, {64691, 34474755}, {64692, 34475267},
	{64693, 34475779}, {64694, 34476291}, {64695, 34476803}, {64696, 34477315},
	{64697, 34478339}, {64698, 34478851}, {64699, 34479363}, {64700, 34479875},
	{64701, 34480387}, {64702, 34480899}, {64703, 34481411}, {64704, 34481923},
	{64705, 34482435}, {64706, 34483971}, {64707, 34484483}, {64708, 34486531},
	{64709, 34487043}, {64710, 34487555}, {64711, 34488067}, {64712, 34488579},
	{64713, 34490115}, {64714, 34490627}, {64715, 34491139}, {64716, 34491651},
	{64717, 34519811}, {64718, 34493187}, {64719, 34469891}, {64720, 34470403},
	{64721, 34493699}, {64722, 34495235}, {64723, 34495747}, {64724, 34496259},
	{64725, 34496771}, {64726, 34520323}, {64727, 34498307}, {64728, 34498819},
	{64729, 34520835}, {64730, 34468867}, {64731, 34500355}, {64732, 34500867},
	{64733, 34492931}, {64734, 34498051}, {64735, 34459907}, {64736, 34517763},
	{64737, 34462467}, {64738, 34518275}, {64739, 34465539}, {64740, 34518787},
	{64741, 34467587}, {64742, 34521347}, {64743, 34473731}, {64744, 34521859},
	{64745, 34522371}, {64746, 34522883}, {64747, 34488067}, {64748, 34488579},
	{64749, 34491651}, {64750, 34496771}, {64751, 34520323}, {64752, 34492931},
	{64753, 34498051}, {64754, 51300611}, {64755, 51301379}, {64756, 51302147},
	{64757, 34525699}, {64758, 34526211}, {64759, 34526723}, {64760, 34527235},
	{64761, 34527747}, {64762, 34528259}, {64763, 34528771}, {64764, 34529283},
	{64765, 34529795}, {64766, 34530307}, {64767, 34530819}, {64768, 34500611},
	{64769, 34531331}, {64770, 34531843}, {64771, 34532355}, {64772, 34501123},
	{64773, 34532867}, {64774, 34533379}, {64775, 34533891}, {64776, 34534403},
	{64777, 34534915}, {64778, 34535427}, {64779, 34535939}, {64780, 34522371},
	{64781, 34536451}, {64782, 34536963}, {64783, 34537475}, {64784, 34537987},
	{64785, 34525699}, {64786, 34526211}, {64787, 34526723}, {64788, 34527235},
	{64789, 34527747}, {64790, 34528259}, {64791, 34528771}, {64792, 34529283},
	{64793, 34529795}, {64794, 34530307}, {64795, 34530819}, {64796, 34500611},
	{64797, 34531331}, {64798, 34531843}, {64799, 34532355}, {64800, 34501123},
	{64801, 34532867}, {64802, 34533379}, {64803, 34533891}, {64804, 34534403},
	{64805, 34534915}, {64806, 34535427}, {64807, 34535939}, {64808, 34522371},
	{64809, 34536451}, {64810, 34536963}, {64811, 34537475}, {64812, 34537987},
	{64813, 34534915}, {64814, 34535427}, {64815, 34535939}, {64816, 34522371},
	{64817, 34521859}, {64818, 34522883}, {64819, 34477827}, {64820, 34472195},
	{64821, 34472707}, {64822, 34473219}, {64823, 34534915}, {64824, 34535427},
	{64825, 34535939}, {64826, 34477827}, {64827, 34478339}, {64828, 34538499},
	{64830, 1}, {64848, 51316227}, {64849, 51316995}, {64851, 51317763},
	{64852, 51318531}, {64853, 51319299}, {64854, 51320067}, {64855, 51320835},
	{64856, 51246851}, {64858, 51321603}, {64859, 51322371}, {64860, 51323139},
	{64861, 51323907}, {64862, 51324675}, {64863, 51325443}, {64865, 51326211},
	{64866, 51326979}, {64868, 51327747}, {64870, 51328515}, {64871, 51329283},
	{64873, 51330051}, {64874, 51330819}, {64876, 51331587}, {64878, 51332355},
	{64879, 51333123}, {64881, 51333891}, {64883, 51334659}, {64884, 51335427},
	{64885, 51336195}, {64886, 51336963}, {64888, 51337731}, {64889, 51338499},
	{64890, 51339267}, {64891, 51340035}, {64892, 51340803}, {64894, 51341571},
	{64895, 51342339}, {64896, 51343107}, {64897, 51343875}, {64898, 51344643},
	{64899, 51345411}, {64901, 51346179}, {64903, 51346947}, {64905, 51347715},
	{64906, 51247107}, {64907, 51348483}, {64908, 51349251}, {64909, 51270403},
	{64910, 51247619}, {64911, 51350019}, {64912, 2}, {64914, 51350787},
	{64915, 51351555}, {64916, 51352323}, {64917, 51353091}, {64918, 51353859},
	{64919, 51354627}, {64921, 51355395}, {64922, 51356163}, {64923, 51356931},
	{64924, 51357699}, {64926, 51358467}, {64927, 51359235}, {64928, 51360003},
	{64929, 51360771}, {64930, 51361539}, {64931, 51362307}, {64932, 51363075},
	{64933, 51363843}, {64934, 51364611}, {64935, 51365379}, {64936, 51366147},
	{64937, 51366915}, {64938, 51367683}, {64939, 51368451}, {64940, 51369219},
	{64941, 51369987}, {64942, 51277571}, {64943, 51370755}, {64944, 51371523},
	{64945, 51372291}, {64946, 51373059}, {64947, 51373827}, {64948, 51341571},
	{64949, 51343107}, {64950, 51374595}, {64951, 51375363}, {64952, 51376131},
	{64953, 51376899}, {64954, 51377667}, {64955, 51378435}, {64956, 51377667},
	{64957, 51376131}, {64958, 51379203}, {64959, 51379971}, {64960, 51380739},
	{64961, 51381507}, {64962, 51382275}, {64963, 51378435}, {64964, 51336195},
	{64965, 51328515}, {64966, 51383043}, {64967, 51383811}, {64968, 2},
	{64975, 1}, {64976, 2}, {65008, 51384579}, {65009, 51385347},
	{65010, 68163331}, {65011, 68164355}, {65012, 68165379}, {65013, 68166403},
	{65014, 68167427}, {65015, 68168451}, {65016, 68169475}, {65017, 51393283},
	{65018, 303052291}, {65019, 135284739}, {65020, 68177923}, {65021, 1},
	{65024, 0}, {65040, 17847299}, {65041, 17847555}, {65042, 2},
	{65043, 17110531}, {65044, 16848643}, {65045, 17032963}, {65046, 17033987},
	{65047, 17847811}, {65048, 17848067}, {65049, 2}, {65056, 1},
	{65072, 2}, {65073, 17848323}, {65074, 17848579}, {65075, 17848835},
	{65077, 17037827}, {65078, 17038083}, {65079, 17849091}, {65080, 17849347},
	{65081, 17849603}, {65082, 17849859}, {65083, 17850115}, {65084, 17850371},
	{65085, 17850627}, {65086, 17850883}, {65087, 17067267}, {65088, 17067523},
	{65089, 17851139}, {65090, 17851395}, {65091, 17851651}, {65092, 17851907},
	{65093, 1}, {65095, 17852163}, {65096, 17852419}, {65097, 33810691},
	{65101, 17848835}, {65104, 17847299}, {65105, 17847555}, {65106, 2},
	{65108, 16848643}, {65109, 17110531}, {65110, 17033987}, {65111, 17032963},
	{65112, 17848323}, {65113, 17037827}, {65114, 17038083}, {65115, 17849091},
	{65116, 17849347}, {65117, 17849603}, {65118, 17849859}, {65119, 17852675},
	{65120, 17852931}, {65121, 17853187}, {65122, 17037059}, {65123, 17853443},
	{65124, 17853699}, {65125, 17853955}, {65126, 17037571}, {65127, 2},
	{65128, 17854211}, {65129, 17854467}, {65130, 17854723}, {65131, 17854979},
	{65132, 2}, {65136, 34632451}, {65137, 34632963}, {65138, 34503427},
	{65139, 1}, {65140, 34504195}, {65141, 2}, {65142, 34504963},
	{65143, 34523395}, {65144, 34505731}, {65145, 34524163}, {65146, 34506499},
	{65147, 34524931}, {65148, 34507267}, {65149, 34633475}, {65150, 34633987},
	{65151, 34634499}, {65152, 17857795}, {65153, 17858051}, {65155, 17858307},
	{65157, 17858563}, {65159, 17858819}, {65161, 17677315}, {65165, 16910339},
	{65167, 17683715}, {65171, 17859075}, {65173, 17686787}, {65177, 17689859},
	{65181, 17681923}, {65185, 17682435}, {65189, 17684995}, {65193, 17834499},
	{65195, 17724675}, {65197, 17725187}, {65199, 17731587}, {65201, 17694979},
	{65205, 17745155}, {65209, 17697027}, {65213, 17698051}, {65217, 17700099},
	{65221, 17701123}, {65225, 17701635}, {65229, 17702659}, {65233, 17703683},
	{65237, 17706755}, {65241, 17708803}, {65245, 17711107}, {65249, 17682947},
	{65253, 17718019}, {65257, 17721091}, {65261, 16910851}, {65263, 17677059},
	{65265, 16911875}, {65269, 34636547}, {65271, 34637059}, {65273, 34637571},
	{65275, 34622467}, {65277, 2}, {65279, 0}, {65280, 2},
	{65281, 17032963}, {65282, 17860867}, {65283, 17852675}, {65284, 17854467},
	{65285, 17854723}, {65286, 17852931}, {65287, 17861123}, {65288, 17037827},
	{65289, 17038083}, {65290, 17853187}, {65291, 17037059}, {65292, 17847299},
	{65293, 17853443}, {65294, 17196547}, {65295, 17038595}, {65296, 17035523},
	{65297, 16786947}, {65298, 16785155}, {65299, 16785411}, {65300, 16787715},
	{65301, 17035779}, {65302, 17036035}, {65303, 17036291}, {65304, 17036547},
	{65305, 17036803}, {65306, 17110531}, {65307, 16848643}, {65308, 17853699},
	{65309, 17037571}, {65310, 17853955}, {65311, 17033987}, {65312, 17854979},
	{65313, 16777219}, {65314, 16777475}, {65315, 16777731}, {65316, 16777987},
	{65317, 16778243}, {65318, 16778499}, {65319, 16778755}, {65320, 16779011},
	{65321, 16779267}, {65322, 16779523}, {65323, 16779779}, {65324, 16780035},
	{65325, 16780291}, {65326, 16780547}, {65327, 16780803}, {65328, 16781059},
	{65329, 16781315}, {65330, 16781571}, {65331, 16781827}, {65332, 16782083},
	{65333, 16782339}, {65334, 16782595}, {65335, 16782851}, {65336, 16783107},
	{65337, 16783363}, {65338, 16783619}, {65339, 17852163}, {65340, 17854211},
	{65341, 17852419}, {65342, 17861379}, {65343, 17848835}, {65344, 17027075},
	{65345, 16777219}, {65346, 16777475}, {65347, 16777731}, {65348, 16777987},
	{65349, 16778243}, {65350, 16778499}, {65351, 16778755}, {65352, 16779011},
	{65353, 16779267}, {65354, 16779523}, {65355, 16779779}, {65356, 16780035},
	{65357, 16780291}, {65358, 16780547}, {65359, 16780803}, {65360, 16781059},
	{65361, 16781315}, {65362, 16781571}, {65363, 16781827}, {65364, 16782083},
	{65365, 16782339}, {65366, 16782595}, {65367, 16782851}, {65368, 16783107},
	{65369, 16783363}, {65370, 16783619}, {65371, 17849091}, {65372, 17861635},
	{65373, 17849347}, {65374, 17861891}, {65375, 17862147}, {65376, 17862403},
	{65377, 17196547}, {65378, 17851139}, {65379, 17851395}, {65380, 17847555},
	{65381, 17862659}, {65382, 17316867}, {65383, 17319427}, {65384, 17362435},
	{65385, 17862915}, {65386, 17363971}, {65387, 17323523}, {65388, 17863171},
	{65389, 17333763}, {65390, 17379587}, {65391, 17329155}, {65392, 17318147},
	{65393, 17305603}, {65394, 17305859}, {65395, 17306115}, {65396, 17306371},
	{65397, 17306627}, {65398, 17306883}, {65399, 17307139}, {65400, 17307395},
	{65401, 17307651}, {65402, 17199107}, {65403, 17307907}, {65404, 17308163},
	{65405, 17308419}, {65406, 17308675}, {65407, 17308931}, {65408, 17309187},
	{65409, 17309443}, {65410, 17309699}, {65411, 17309955}, {65412, 17199363},
	{65413, 17310211}, {65414, 17310467}, {65415, 17310723}, {65416, 17310979},
	{65417, 17311235}, {65418, 17311491}, {65419, 17311747}, {65420, 17312003},
	{65421, 17312259}, {65422, 17312515}, {65423, 17312771}, {65424, 17313027},
	{65425, 17313283}, {65426, 17313539}, {65427, 17313795}, {65428, 17314051},
	{65429, 17314307}, {65430, 17314563}, {65431, 17314819}, {65432, 17315075},
	{65433, 17315331}, {65434, 17315587}, {65435, 17315843}, {65436, 17316099},
	{65437, 17319939}, {65438, 17197827}, {65439, 17198339}, {65440, 2},
	{65441, 17199619}, {65442, 17199875}, {65443, 17200131}, {65444, 17200387},
	{65445, 17200643}, {65446, 17200899}, {65447, 17201155}, {65448, 17201411},
	{65449, 17201667}, {65450, 17201923}, {65451, 17202179}, {65452, 17202435},
	{65453, 17202691}, {65454, 17202947}, {65455, 17203203}, {65456, 17203459},
	{65457, 17203715}, {65458, 17203971}, {65459, 17204227}, {65460, 17204483},
	{65461, 17204739}, {65462, 17204995}, {65463, 17205251}, {65464, 17205507},
	{65465, 17205763}, {65466, 17206019}, {65467, 17206275}, {65468, 17206531},
	{65469, 17206787}, {65470, 17207043}, {65471, 2}, {65474, 17207299},
	{65475, 17207555}, {65476, 17207811}, {65477, 17208067}, {65478, 17208323},
	{65479, 17208579}, {65480, 2}, {65482, 17208835}, {65483, 17209091},
	{65484, 17209347}, {65485, 17209603}, {65486, 17209859}, {65487, 17210115},
	{65488, 2}, {65490, 17210371}, {65491, 17210627}, {65492, 17210883},
	{65493, 17211139}, {65494, 17211395}, {65495, 17211651}, {65496, 2},
	{65498, 17211907}, {65499, 17212163}, {65500, 17212419}, {65501, 2},
	{65504, 17863427}, {65505, 17863683}, {65506, 17863939}, {65507, 33561859},
	{65508, 17864195}, {65509, 17864451}, {65510, 17864707}, {65511, 2},
	{65512, 17864963}, {65513, 17865219}, {65514, 17865475}, {65515, 17865731},
	{65516, 17865987}, {65517, 17866243}, {65518, 17866499}, {65519, 2},
	{65536, 1}, {65548, 2}, {65549, 1}, {65575, 2},
	{65576, 1}, {65595, 2}, {65596, 1}, {65598, 2},
	{65599, 1}, {65614, 2}, {65616, 1}, {65630, 2},
	{65664, 1}, {65787, 2}, {65792, 1}, {65795, 2},
	{65799, 1}, {65844, 2}, {65847, 1}, {65935, 2},
	{65936, 1}, {65949, 2}, {65952, 1}, {65953, 2},
	{66000, 1}, {66046, 2}, {66176, 1}, {66205, 2},
	{66208, 1}, {66257, 2}, {66272, 1}, {66300, 2},
	{66304, 1}, {66340, 2}, {66349, 1}, {66379, 2},
	{66384, 1}, {66427, 2}, {66432, 1}, {66462, 2},
	{66463, 1}, {66500, 2}, {66504, 1}, {66518, 2},
	{66560, 17866755}, {66561, 17867011}, {66562, 17867267}, {66563, 17867523},
	{66564, 17867779}, {66565, 17868035}, {66566, 17868291}, {66567, 17868547},
	{66568, 17868803}, {66569, 17869059}, {66570, 17869315}, {66571, 17869571},
	{66572, 17869827}, {66573, 17870083}, {66574, 17870339}, {66575, 17870595},
	{66576, 17870851}, {66577, 17871107}, {66578, 17871363}, {66579, 17871619},
	{66580, 17871875}, {66581, 17872131}, {66582, 17872387}, {66583, 17872643},
	{66584, 17872899}, {66585, 17873155}, {66586, 17873411}, {66587, 17873667},
	{66588, 17873923}, {66589, 17874179}, {66590, 17874435}, {66591, 17874691},
	{66592, 17874947}, {66593, 17875203}, {66594, 17875459}, {66595, 17875715},
	{66596, 17875971}, {66597, 17876227}, {66598, 17876483}, {66599, 17876739},
	{66600, 1}, {66718, 2}, {66720, 1}, {66730, 2},
	{66736, 17876995}, {66737, 17877251}, {66738, 17877507}, {66739, 17877763},
	{66740, 17878019}, {66741, 17878275}, {66742, 17878531}, {66743, 17878787},
	{66744, 17879043}, {66745, 17879299}, {66746, 17879555}, {66747, 17879811},
	{66748, 17880067}, {66749, 17880323}, {66750, 17880579}, {66751, 17880835},
	{66752, 17881091}, {66753, 17881347}, {66754, 17881603}, {66755, 17881859},
	{66756, 17882115}, {66757, 17882371}, {66758, 17882627}, {66759, 17882883},
	{66760, 17883139}, {66761, 17883395}, {66762, 17883651}, {66763, 17883907},
	{66764, 17884163}, {66765, 17884419}, {66766, 17884675}, {66767, 17884931},
	{66768, 17885187}, {66769, 17885443}, {66770, 17885699}, {66771, 17885955},
	{66772, 2}, {66776, 1}, {66812, 2}, {66816, 1},
	{66856, 2}, {66864, 1}, {66916, 2}, {66927, 1},
	{66928, 17886211}, {66929, 17886467}, {66930, 17886723}, {66931, 17886979},
	{66932, 17887235}, {66933, 17887491}, {66934, 17887747}, {66935, 17888003},
	{66936, 17888259}, {66937, 17888515}, {66938, 17888771}, {66939, 2},
	{66940, 17889027}, {66941, 17889283}, {66942, 17889539}, {66943, 17889795},
	{66944, 17890051}, {66945, 17890307}, {66946, 17890563}, {66947, 17890819},
	{66948, 17891075}, {66949, 17891331}, {66950, 17891587}, {66951, 17891843},
	{66952, 17892099}, {66953, 17892355}, {66954, 17892611}, {66955, 2},
	{66956, 17892867}, {66957, 17893123}, {66958, 17893379}, {66959, 17893635},
	{66960, 17893891}, {66961, 17894147}, {66962, 17894403}, {66963, 2},
	{66964, 17894659}, {66965, 17894915}, {66966, 2}, {66967, 1},
	{66978, 2}, {66979, 1}, {66994, 2}, {66995, 1},
	{67002, 2}, {67003, 1}, {67005, 2}, {67072, 1},
	{67383, 2}, {67392, 1}, {67414, 2}, {67424, 1},
	{67432, 2}, {67456, 1}, {67457, 17895171}, {67458, 17895427},
	{67459, 16791043}, {67460, 17895683}, {67461, 16814083}, {67462, 2},
	{67463, 17895939}, {67464, 17896195}, {67465, 17896451}, {67466, 17896707},
	{67467, 16815363}, {67468, 16815619}, {67469, 17896963}, {67470, 17897219},
	{67471, 17897475}, {67472, 17897731}, {67473, 17897987}, {67474, 17898243},
	{67475, 16817155}, {67476, 17898499}, {67477, 16802051}, {67478, 17898755},
	{67479, 17899011}, {67480, 17899267}, {67481, 17899523}, {67482, 17899779},
	{67483, 17512963}, {67484, 17900035}, {67485, 17900291}, {67486, 17900547},
	{67487, 17900803}, {67488, 17901059}, {67489, 17901315}, {67490, 16795395},
	{67491, 17901571}, {67492, 17901827}, {67493, 16781315}, {67494, 17902083},
	{67495, 17902339}, {67496, 17125379}, {67497, 17902595}, {67498, 16819971},
	{67499, 17902851}, {67500, 17903107}, {67501, 17903363}, {67502, 17903619},
	{67503, 16820995}, {67504, 17903875}, {67505, 2}, {67506, 17904131},
	{67507, 17904387}, {67508, 17904643}, {67509, 17904899}, {67510, 17905155},
	{67511, 17905411}, {67512, 17905667}, {67513, 17905923}, {67514, 17906179},
	{67515, 2}, {67584, 1}, {67590, 2}, {67592, 1},
	{67593, 2}, {67594, 1}, {67638, 2}, {67639, 1},
	{67641, 2}, {67644, 1}, {67645, 2}, {67647, 1},
	{67670, 2}, {67671, 1}, {67743, 2}, {67751, 1},
	{67760, 2}, {67808, 1}, {67827, 2}, {67828, 1},
	{67830, 2}, {67835, 1}, {67868, 2}, {67871, 1},
	{67898, 2}, {67903, 1}, {67904, 2}, {67968, 1},
	{68024, 2}, {68028, 1}, {68048, 2}, {68050, 1},
	{68100, 2}, {68101, 1}, {68103, 2}, {68108, 1},
	{68116, 2}, {68117, 1}, {68120, 2}, {68121, 1},
	{68150, 2}, {68152, 1}, {68155, 2}, {68159, 1},
	{68169, 2}, {68176, 1}, {68185, 2}, {68192, 1},
	{68256, 2}, {68288, 1}, {68327, 2}, {68331, 1},
	{68343, 2}, {68352, 1}, {68406, 2}, {68409, 1},
	{68438, 2}, {68440, 1}, {68467, 2}, {68472, 1},
	{68498, 2}, {68505, 1}, {68509, 2}, {68521, 1},
	{68528, 2}, {68608, 1}, {68681, 2}, {68736, 17906435},
	{68737, 17906691}, {68738, 17906947}, {68739, 17907203}, {68740, 17907459},
	{68741, 17907715}, {68742, 17907971}, {68743, 17908227}, {68744, 17908483},
	{68745, 17908739}, {68746, 17908995}, {68747, 17909251}, {68748, 17909507},
	{68749, 17909763}, {68750, 17910019}, {68751, 17910275}, {68752, 17910531},
	{68753, 17910787}, {68754, 17911043}, {68755, 17911299}, {68756, 17911555},
	{68757, 17911811}, {68758, 17912067}, {68759, 17912323}, {68760, 17912579},
	{68761, 17912835}, {68762, 17913091}, {68763, 17913347}, {68764, 17913603},
	{68765, 17913859}, {68766, 17914115}, {68767, 17914371}, {68768, 17914627},
	{68769, 17914883}, {68770, 17915139}, {68771, 17915395}, {68772, 17915651},
	{68773, 17915907}, {68774, 17916163}, {68775, 17916419}, {68776, 17916675},
	{68777, 17916931}, {68778, 17917187}, {68779, 17917443}, {68780, 17917699},
	{68781, 17917955}, {68782, 17918211}, {68783, 17918467}, {68784, 17918723},
	{68785, 17918979}, {68786, 17919235}, {68787, 2}, {68800, 1},
	{68851, 2}, {68858, 1}, {68904, 2}, {68912, 1},
	{68922, 2}, {69216, 1}, {69247, 2}, {69248, 1},
	{69290, 2}, {69291, 1}, {69294, 2}, {69296, 1},
	{69298, 2}, {69373, 1}, {69416, 2}, {69424, 1},
	{69466, 2}, {69488, 1}, {69514, 2}, {69552, 1},
	{69580, 2}, {69600, 1}, {69623, 2}, {69632, 1},
	{69710, 2}, {69714, 1}, {69750, 2}, {69759, 1},
	{69821, 2}, {69822, 1}, {69827, 2}, {69840, 1},
	{69865, 2}, {69872, 1}, {69882, 2}, {69888, 1},
	{69941, 2}, {69942, 1}, {69960, 2}, {69968, 1},
	{70007, 2}, {70016, 1}, {70112, 2}, {70113, 1},
	{70133, 2}, {70144, 1}, {70162, 2}, {70163, 1},
	{70210, 2}, {70272, 1}, {70279, 2}, {70280, 1},
	{70281, 2}, {70282, 1}, {70286, 2}, {70287, 1},
	{70302, 2}, {70303, 1}, {70314, 2}, {70320, 1},
	{70379, 2}, {70384, 1}, {70394, 2}, {70400, 1},
	{70404, 2}, {70405, 1}, {70413, 2}, {70415, 1},
	{70417, 2}, {70419, 1}, {70441, 2}, {70442, 1},
	{70449, 2}, {70450, 1}, {70452, 2}, {70453, 1},
	{70458, 2}, {70459, 1}, {70469, 2}, {70471, 1},
	{70473, 2}, {70475, 1}, {70478, 2}, {70480, 1},
	{70481, 2}, {70487, 1}, {70488, 2}, {70493, 1},
	{70500, 2}, {70502, 1}, {70509, 2}, {70512, 1},
	{70517, 2}, {70656, 1}, {70748, 2}, {70749, 1},
	{70754, 2}, {70784, 1}, {70856, 2}, {70864, 1},
	{70874, 2}, {71040, 1}, {71094, 2}, {71096, 1},
	{71134, 2}, {71168, 1}, {71237, 2}, {71248, 1},
	{71258, 2}, {71264, 1}, {71277, 2}, {71296, 1},
	{71354, 2}, {71360, 1}, {71370, 2}, {71424, 1},
	{71451, 2}, {71453, 1}, {71468, 2}, {71472, 1},
	{71495, 2}, {71680, 1}, {71740, 2}, {71840, 17919491},
	{71841, 17919747}, {71842, 17920003}, {71843, 17920259}, {71844, 17920515},
	{71845, 17920771}, {71846, 17921027}, {71847, 17921283}, {71848, 17921539},
	{71849, 17921795}, {71850, 17922051}, {71851, 17922307}, {71852, 17922563},
	{71853, 17922819}, {71854, 17923075}, {71855, 17923331}, {71856, 17923587},
	{71857, 17923843}, {71858, 17924099}, {71859, 17924355}, {71860, 17924611},
	{71861, 17924867}, {71862, 17925123}, {71863, 17925379}, {71864, 17925635},
	{71865, 17925891}, {71866, 17926147}, {71867, 17926403}, {71868, 17926659},
	{71869, 17926915}, {71870, 17927171}, {71871, 17927427}, {71872, 1},
	{71923, 2}, {71935, 1}, {71943, 2}, {71945, 1},
	{71946, 2}, {71948, 1}, {71956, 2}, {71957, 1},
	{71959, 2}, {71960, 1}, {71990, 2}, {71991, 1},
	{71993, 2}, {71995, 1}, {72007, 2}, {72016, 1},
	{72026, 2}, {72096, 1}, {72104, 2}, {72106, 1},
	{72152, 2}, {72154, 1}, {72165, 2}, {72192, 1},
	{72264, 2}, {72272, 1}, {72355, 2}, {72368, 1},
	{72441, 2}, {72448, 1}, {72458, 2}, {72704, 1},
	{72713, 2}, {72714, 1}, {72759, 2}, {72760, 1},
	{72774, 2}, {72784, 1}, {72813, 2}, {72816, 1},
	{72848, 2}, {72850, 1}, {72872, 2}, {72873, 1},
	{72887, 2}, {72960, 1}, {72967, 2}, {72968, 1},
	{72970, 2}, {72971, 1}, {73015, 2}, {73018, 1},
	{73019, 2}, {73020, 1}, {73022, 2}, {73023, 1},
	{73032, 2}, {73040, 1}, {73050, 2}, {73056, 1},
	{73062, 2}, {73063, 1}, {73065, 2}, {73066, 1},
	{73103, 2}, {73104, 1}, {73106, 2}, {73107, 1},
	{73113, 2}, {73120, 1}, {73130, 2}, {73440, 1},
	{73465, 2}, {73472, 1}, {73489, 2}, {73490, 1},
	{73531, 2}, {73534, 1}, {73562, 2}, {73648, 1},
	{73649, 2}, {73664, 1}, {73714, 2}, {73727, 1},
	{74650, 2}, {74752, 1}, {74863, 2}, {74864, 1},
	{74869, 2}, {74880, 1}, {75076, 2}, {77712, 1},
	{77811, 2}, {77824, 1}, {78896, 2}, {78912, 1},
	{78934, 2}, {82944, 1}, {83527, 2}, {92160, 1},
	{92729, 2}, {92736, 1}, {92767, 2}, {92768, 1},
	{92778, 2}, {92782, 1}, {92863, 2}, {92864, 1},
	{92874, 2}, {92880, 1}, {92910, 2}, {92912, 1},
	{92918, 2}, {92928, 1}, {92998, 2}, {93008, 1},
	{93018, 2}, {93019, 1}, {93026, 2}, {93027, 1},
	{93048, 2}, {93053, 1}, {93072, 2}, {93760, 17927683},
	{93761, 17927939}, {93762, 17928195}, {93763, 17928451}, {93764, 17928707},
	{93765, 17928963}, {93766, 17929219}, {93767, 17929475}, {93768, 17929731},
	{93769, 17929987}, {93770, 17930243}, {93771, 17930499}, {93772, 17930755},
	{93773, 17931011}, {93774, 17931267}, {93775, 17931523}, {93776, 17931779},
	{93777, 17932035}, {93778, 17932291}, {93779, 17932547}, {93780, 17932803},
	{93781, 17933059}, {93782, 17933315}, {93783, 17933571}, {93784, 17933827},
	{93785, 17934083}, {93786, 17934339}, {93787, 17934595}, {93788, 17934851},
	{93789, 17935107}, {93790, 17935363}, {93791, 17935619}, {93792, 1},
	{93851, 2}, {93952, 1}, {94027, 2}, {94031, 1},
	{94088, 2}, {94095, 1}, {94112, 2}, {94176, 1},
	{94181, 2}, {94192, 1}, {94194, 2}, {94208, 1},
	{100344, 2}, {100352, 1}, {101590, 2}, {101632, 1},
	{101641, 2}, {110576, 1}, {110580, 2}, {110581, 1},
	{110588, 2}, {110589, 1}, {110591, 2}, {110592, 1},
	{110883, 2}, {110898, 1}, {110899, 2}, {110928, 1},
	{110931, 2}, {110933, 1}, {110934, 2}, {110948, 1},
	{110952, 2}, {110960, 1}, {111356, 2}, {113664, 1},
	{113771, 2}, {113776, 1}, {113789, 2}, {113792, 1},
	{113801, 2}, {113808, 1}, {113818, 2}, {113820, 1},
	{113824, 0}, {113828, 2}, {118528, 1}, {118574, 2},
	{118576, 1}, {118599, 2}, {118608, 1}, {118724, 2},
	{118784, 1}, {119030, 2}, {119040, 1}, {119079, 2},
	{119081, 1}, {119134, 34713091}, {119135, 34713603}, {119136, 51491331},
	{119137, 51492099}, {119138, 51492867}, {119139, 51493635}, {119140, 51494403},
	{119141, 1}, {119155, 2}, {119163, 1}, {119227, 34717955},
	{119228, 34718467}, {119229, 51496195}, {119230, 51496963}, {119231, 51497731},
	{119232, 51498499}, {119233, 1}, {119275, 2}, {119296, 1},
	{119366, 2}, {119488, 1}, {119508, 2}, {119520, 1},
	{119540, 2}, {119552, 1}, {119639, 2}, {119648, 1},
	{119673, 2}, {119808, 16777219}, {119809, 16777475}, {119810, 16777731},
	{119811, 16777987}, {119812, 16778243}, {119813, 16778499}, {119814, 16778755},
	{119815, 16779011}, {119816, 16779267}, {119817, 16779523}, {119818, 16779779},
	{119819, 16780035}, {119820, 16780291}, {119821, 16780547}, {119822, 16780803},
	{119823, 16781059}, {119824, 16781315}, {119825, 16781571}, {119826, 16781827},
	{119827, 16782083}, {119828, 16782339}, {119829, 16782595}, {119830, 16782851},
	{119831, 16783107}, {119832, 16783363}, {119833, 16783619}, {119834, 16777219},
	{119835, 16777475}, {119836, 16777731}, {119837, 16777987}, {119838, 16778243},
	{119839, 16778499}, {119840, 16778755}, {119841, 16779011}, {119842, 16779267},
	{119843, 16779523}, {119844, 16779779}, {119845, 16780035}, {119846, 16780291},
	{119847, 16780547}, {119848, 16780803}, {119849, 16781059}, {119850, 16781315},
	{119851, 16781571}, {119852, 16781827}, {119853, 16782083}, {119854, 16782339},
	{119855, 16782595}, {119856, 16782851}, {119857, 16783107}, {119858, 16783363},
	{119859, 16783619}, {119860, 16777219}, {119861, 16777475}, {119862, 16777731},
	{119863, 16777987}, {119864, 16778243}, {119865, 16778499}, {119866, 16778755},
	{119867, 16779011}, {119868, 16779267}, {119869, 16779523}, {119870, 16779779},
	{119871, 16780035}, {119872, 16780291}, {119873, 16780547}, {119874, 16780803},
	{119875, 16781059}, {119876, 16781315}, {119877, 16781571}, {119878, 16781827},
	{119879, 16782083}, {119880, 16782339}, {119881, 16782595}, {119882, 16782851},
	{119883, 16783107}, {119884, 16783363}, {119885, 16783619}, {119886, 16777219},
	{119887, 16777475}, {119888, 16777731}, {119889, 16777987}, {119890, 16778243},
	{119891, 16778499}, {119892, 16778755}, {119893, 2}, {119894, 16779267},
	{119895, 16779523}, {119896, 16779779}, {119897, 16780035}, {119898, 16780291},
	{119899, 16780547}, {119900, 16780803}, {119901, 16781059}, {119902, 16781315},
	{119903, 16781571}, {119904, 16781827}, {119905, 16782083}, {119906, 16782339},
	{119907, 16782595}, {119908, 16782851}, {119909, 16783107}, {119910, 16783363},
	{119911, 16783619}, {119912, 16777219}, {119913, 16777475}, {119914, 16777731},
	{119915, 16777987}, {119916, 16778243}, {119917, 16778499}, {119918, 16778755},
	{119919, 16779011}, {119920, 16779267}, {119921, 16779523}, {119922, 16779779},
	{119923, 16780035}, {119924, 16780291}, {119925, 16780547}, {119926, 16780803},
	{119927, 16781059}, {119928, 16781315}, {119929, 16781571}, {119930, 16781827},
	{119931, 16782083}, {119932, 16782339}, {119933, 16782595}, {119934, 16782851},
	{119935, 16783107}, {119936, 16783363}, {119937, 16783619}, {119938, 16777219},
	{119939, 16777475}, {119940, 16777731}, {119941, 16777987}, {119942, 16778243},
	{119943, 16778499}, {119944, 16778755}, {119945, 16779011}, {119946, 16779267},
	{119947, 16779523}, {119948, 16779779}, {119949, 16780035}, {119950, 16780291},
	{119951, 16780547}, {119952, 16780803}, {119953, 16781059}, {119954, 16781315},
	{119955, 16781571}, {119956, 16781827}, {119957, 16782083}, {119958, 16782339},
	{119959, 16782595}, {119960, 16782851}, {119961, 16783107}, {119962, 16783363},
	{119963, 16783619}, {119964, 16777219}, {119965, 2}, {119966, 16777731},
	{119967, 16777987}, {119968, 2}, {119970, 16778755}, {119971, 2},
	{119973, 16779523}, {119974, 16779779}, {119975, 2}, {119977, 16780547},
	{119978, 16780803}, {119979, 16781059}, {119980, 16781315}, {119981, 2},
	{119982, 16781827}, {119983, 16782083}, {119984, 16782339}, {119985, 16782595},
	{119986, 16782851}, {119987, 16783107}, {119988, 16783363}, {119989, 16783619},
	{119990, 16777219}, {119991, 16777475}, {119992, 16777731}, {119993, 16777987},
	{119994, 2}, {119995, 16778499}, {119996, 2}, {119997, 16779011},
	{119998, 16779267}, {119999, 16779523}, {120000, 16779779}, {120001, 16780035},
	{120002, 16780291}, {120003, 16780547}, {120004, 2}, {120005, 16781059},
	{120006, 16781315}, {120007, 16781571}, {120008, 16781827}, {120009, 16782083},
	{120010, 16782339}, {120011, 16782595}, {120012, 16782851}, {120013, 16783107},
	{120014, 16783363}, {120015, 16783619}, {120016, 16777219}, {120017, 16777475},
	{120018, 16777731}, {120019, 16777987}, {120020, 16778243}, {120021, 16778499},
	{120022, 16778755}, {120023, 16779011}, {120024, 16779267}, {120025, 16779523},
	{120026, 16779779}, {120027, 16780035}, {120028, 16780291}, {120029, 16780547},
	{120030, 16780803}, {120031, 16781059}, {120032, 16781315}, {120033, 16781571},
	{120034, 16781827}, {120035, 16782083}, {120036, 16782339}, {120037, 16782595},
	{120038, 16782851}, {120039, 16783107}, {120040, 16783363}, {120041, 16783619},
	{120042, 16777219}, {120043, 16777475}, {120044, 16777731}, {120045, 16777987},
	{120046, 16778243}, {120047, 16778499}, {120048, 16778755}, {120049, 16779011},
	{120050, 16779267}, {120051, 16779523}, {120052, 16779779}, {120053, 16780035},
	{120054, 16780291}, {120055, 16780547}, {120056, 16780803}, {120057, 16781059},
	{120058, 16781315}, {120059, 16781571}, {120060, 16781827}, {120061, 16782083},
	{120062, 16782339}, {120063, 16782595}, {120064, 16782851}, {120065, 16783107},
	{120066, 16783363}, {120067, 16783619}, {120068, 16777219}, {120069, 16777475},
	{120070, 2}, {120071, 16777987}, {120072, 16778243}, {120073, 16778499},
	{120074, 16778755}, {120075, 2}, {120077, 16779523}, {120078, 16779779},
	{120079, 16780035}, {120080, 16780291}, {120081, 16780547}, {120082, 16780803},
	{120083, 16781059}, {120084, 16781315}, {120085, 2}, {120086, 16781827},
	{120087, 16782083}, {120088, 16782339}, {120089, 16782595}, {120090, 16782851},
	{120091, 16783107}, {120092, 16783363}, {120093, 2}, {120094, 16777219},
	{120095, 16777475}, {120096, 16777731}, {120097, 16777987}, {120098, 16778243},
	{120099, 16778499}, {120100, 16778755}, {120101, 16779011}, {120102, 16779267},
	{120103, 16779523}, {120104, 16779779}, {120105, 16780035}, {120106, 16780291},
	{120107, 16780547}, {120108, 16780803}, {120109, 16781059}, {120110, 16781315},
	{120111, 16781571}, {120112, 16781827}, {120113, 16782083}, {120114, 16782339},
	{120115, 16782595}, {120116, 16782851}, {120117, 16783107}, {120118, 16783363},
	{120119, 16783619}, {120120, 16777219}, {120121, 16777475}, {120122, 2},
	{120123, 16777987}, {120124, 16778243}, {120125, 16778499}, {120126, 16778755},
	{120127, 2}, {120128, 16779267}, {120129, 16779523}, {120130, 16779779},
	{120131, 16780035}, {120132, 16780291}, {120133, 2}, {120134, 16780803},
	{120135, 2}, {120138, 16781827}, {120139, 16782083}, {120140, 16782339},
	{120141, 16782595}, {120142, 16782851}, {120143, 16783107}, {120144, 16783363},
	{120145, 2}, {120146, 16777219}, {120147, 16777475}, {120148, 16777731},
	{120149, 16777987}, {120150, 16778243}, {120151, 16778499}, {120152, 16778755},
	{120153, 16779011}, {120154, 16779267}, {120155, 16779523}, {120156, 16779779},
	{120157, 16780035}, {120158, 16780291}, {120159, 16780547}, {120160, 16780803},
	{120161, 16781059}, {120162, 16781315}, {120163, 16781571}, {120164, 16781827},
	{120165, 16782083}, {120166, 16782339}, {120167, 16782595}, {120168, 16782851},
	{120169, 16783107}, {120170, 16783363}, {120171, 16783619}, {120172, 16777219},
	{120173, 16777475}, {120174, 16777731}, {120175, 16777987}, {120176, 16778243},
	{120177, 16778499}, {120178, 16778755}, {120179, 16779011}, {120180, 16779267},
	{120181, 16779523}, {120182, 16779779}, {120183, 16780035}, {120184, 16780291},
	{120185, 16780547}, {120186, 16780803}, {120187, 16781059}, {120188, 16781315},
	{120189, 16781571}, {120190, 16781827}, {120191, 16782083}, {120192, 16782339},
	{120193, 16782595}, {120194, 16782851}, {120195, 16783107}, {120196, 16783363},
	{120197, 16783619}, {120198, 16777219}, {120199, 16777475}, {120200, 16777731},
	{120201, 16777987}, {120202, 16778243}, {120203, 16778499}, {120204, 16778755},
	{120205, 16779011}, {120206, 16779267}, {120207, 16779523}, {120208, 16779779},
	{120209, 16780035}, {120210, 16780291}, {120211, 16780547}, {120212, 16780803},
	{120213, 16781059}, {120214, 16781315}, {120215, 16781571}, {120216, 16781827},
	{120217, 16782083}, {120218, 16782339}, {120219, 16782595}, {120220, 16782851},
	{120221, 16783107}, {120222, 16783363}, {120223, 16783619}, {120224, 16777219},
	{120225, 16777475}, {120226, 16777731}, {120227, 16777987}, {120228, 16778243},
	{120229, 16778499}, {120230, 16778755}, {120231, 16779011}, {120232, 16779267},
	{120233, 16779523}, {120234, 16779779}, {120235, 16780035}, {120236, 16780291},
	{120237, 16780547}, {120238, 16780803}, {120239, 16781059}, {120240, 16781315},
	{120241, 16781571}, {120242, 16781827}, {120243, 16782083}, {120244, 16782339},
	{120245, 16782595}, {120246, 16782851}, {120247, 16783107}, {120248, 16783363},
	{120249, 16783619}, {120250, 16777219}, {120251, 16777475}, {120252, 16777731},
	{120253, 16777987}, {120254, 16778243}, {120255, 16778499}, {120256, 16778755},
	{120257, 16779011}, {120258, 16779267}, {120259, 16779523}, {120260, 16779779},
	{120261, 16780035}, {120262, 16780291}, {120263, 16780547}, {120264, 16780803},
	{120265, 16781059}, {120266, 16781315}, {120267, 16781571}, {120268, 16781827},
	{120269, 16782083}, {120270, 16782339}, {120271, 16782595}, {120272, 16782851},
	{120273, 16783107}, {120274, 16783363}, {120275, 16783619}, {120276, 16777219},
	{120277, 16777475}, {120278, 16777731}, {120279, 16777987}, {120280, 16778243},
	{120281, 16778499}, {120282, 16778755}, {120283, 16779011}, {120284, 16779267},
	{120285, 16779523}, {120286, 16779779}, {120287, 16780035}, {120288, 16780291},
	{120289, 16780547}, {120290, 16780803}, {120291, 16781059}, {120292, 16781315},
	{120293, 16781571}, {120294, 16781827}, {120295, 16782083}, {120296, 16782339},
	{120297, 16782595}, {120298, 16782851}, {120299, 16783107}, {120300, 16783363},
	{120301, 16783619}, {120302, 16777219}, {120303, 16777475}, {120304, 16777731},
	{120305, 16777987}, {120306, 16778243}, {120307, 16778499}, {120308, 16778755},
	{120309, 16779011}, {120310, 16779267}, {120311, 16779523}, {120312, 16779779},
	{120313, 16780035}, {120314, 16780291}, {120315, 16780547}, {120316, 16780803},
	{120317, 16781059}, {120318, 16781315}, {120319, 16781571}, {120320, 16781827},
	{120321, 16782083}, {120322, 16782339}, {120323, 16782595}, {120324, 16782851},
	{120325, 16783107}, {120326, 16783363}, {120327, 16783619}, {120328, 16777219},
	{120329, 16777475}, {120330, 16777731}, {120331, 16777987}, {120332, 16778243},
	{120333, 16778499}, {120334, 16778755}, {120335, 16779011}, {120336, 16779267},
	{120337, 16779523}, {120338, 16779779}, {120339, 16780035}, {120340, 16780291},
	{120341, 16780547}, {120342, 16780803}, {120343, 16781059}, {120344, 16781315},
	{120345, 16781571}, {120346, 16781827}, {120347, 16782083}, {120348, 16782339},
	{120349, 16782595}, {120350, 16782851}, {120351, 16783107}, {120352, 16783363},
	{120353, 16783619}, {120354, 16777219}, {120355, 16777475}, {120356, 16777731},
	{120357, 16777987}, {120358, 16778243}, {120359, 16778499}, {120360, 16778755},
	{120361, 16779011}, {120362, 16779267}, {120363, 16779523}, {120364, 16779779},
	{120365, 16780035}, {120366, 16780291}, {120367, 16780547}, {120368, 16780803},
	{120369, 16781059}, {120370, 16781315}, {120371, 16781571}, {120372, 16781827},
	{120373, 16782083}, {120374, 16782339}, {120375, 16782595}, {120376, 16782851},
	{120377, 16783107}, {120378, 16783363}, {120379, 16783619}, {120380, 16777219},
	{120381, 16777475}, {120382, 16777731}, {120383, 16777987}, {120384, 16778243},
	{120385, 16778499}, {120386, 16778755}, {120387, 16779011}, {120388, 16779267},
	{120389, 16779523}, {120390, 16779779}, {120391, 16780035}, {120392, 16780291},
	{120393, 16780547}, {120394, 16780803}, {120395, 16781059}, {120396, 16781315},
	{120397, 16781571}, {120398, 16781827}, {120399, 16782083}, {120400, 16782339},
	{120401, 16782595}, {120402, 16782851}, {120403, 16783107}, {120404, 16783363},
	{120405, 16783619}, {120406, 16777219}, {120407, 16777475}, {120408, 16777731},
	{120409, 16777987}, {120410, 16778243}, {120411, 16778499}, {120412, 16778755},
	{120413, 16779011}, {120414, 16779267}, {120415, 16779523}, {120416, 16779779},
	{120417, 16780035}, {120418, 16780291}, {120419, 16780547}, {120420, 16780803},
	{120421, 16781059}, {120422, 16781315}, {120423, 16781571}, {120424, 16781827},
	{120425, 16782083}, {120426, 16782339}, {120427, 16782595}, {120428, 16782851},
	{120429, 16783107}, {120430, 16783363}, {120431, 16783619}, {120432, 16777219},
	{120433, 16777475}, {120434, 16777731}, {120435, 16777987}, {120436, 16778243},
	{120437, 16778499}, {120438, 16778755}, {120439, 16779011}, {120440, 16779267},
	{120441, 16779523}, {120442, 16779779}, {120443, 16780035}, {120444, 16780291},
	{120445, 16780547}, {120446, 16780803}, {120447, 16781059}, {120448, 16781315},
	{120449, 16781571}, {120450, 16781827}, {120451, 16782083}, {120452, 16782339},
	{120453, 16782595}, {120454, 16782851}, {120455, 16783107}, {120456, 16783363},
	{120457, 16783619}, {120458, 16777219}, {120459, 16777475}, {120460, 16777731},
	{120461, 16777987}, {120462, 16778243}, {120463, 16778499}, {120464, 16778755},
	{120465, 16779011}, {120466, 16779267}, {120467, 16779523}, {120468, 16779779},
	{120469, 16780035}, {120470, 16780291}, {120471, 16780547}, {120472, 16780803},
	{120473, 16781059}, {120474, 16781315}, {120475, 16781571}, {120476, 16781827},
	{120477, 16782083}, {120478, 16782339}, {120479, 16782595}, {120480, 16782851},
	{120481, 16783107}, {120482, 16783363}, {120483, 16783619}, {120484, 17944835},
	{120485, 17945091}, {120486, 2}, {120488, 16851715}, {120489, 16851971},
	{120490, 16852227}, {120491, 16852483}, {120492, 16852739}, {120493, 16852995},
	{120494, 16853251}, {120495, 16853507}, {120496, 16846851}, {120497, 16853763},
	{120498, 16854019}, {120499, 16786179}, {120500, 16854275}, {120501, 16854531},
	{120502, 16854787}, {120503, 16855043}, {120504, 16855299}, {120505, 16853507},
	{120506, 16855555}, {120507, 16855811}, {120508, 16856067}, {120509, 16856323},
	{120510, 16856579}, {120511, 16856835}, {120512, 16857091}, {120513, 17945347},
	{120514, 16851715}, {120515, 16851971}, {120516, 16852227}, {120517, 16852483},
	{120518, 16852739}, {120519, 16852995}, {120520, 16853251}, {120521, 16853507},
	{120522, 16846851}, {120523, 16853763}, {120524, 16854019}, {120525, 16786179},
	{120526, 16854275}, {120527, 16854531}, {120528, 16854787}, {120529, 16855043},
	{120530, 16855299}, {120531, 16855555}, {120533, 16855811}, {120534, 16856067},
	{120535, 16856323}, {120536, 16856579}, {120537, 16856835}, {120538, 16857091},
	{120539, 17945603}, {120540, 16852739}, {120541, 16853507}, {120542, 16853763},
	{120543, 16856323}, {120544, 16855299}, {120545, 16855043}, {120546, 16851715},
	{120547, 16851971}, {120548, 16852227}, {120549, 16852483}, {120550, 16852739},
	{120551, 16852995}, {120552, 16853251}, {120553, 16853507}, {120554, 16846851},
	{120555, 16853763}, {120556, 16854019}, {120557, 16786179}, {120558, 16854275},
	{120559, 16854531}, {120560, 16854787}, {120561, 16855043}, {120562, 16855299},
	{120563, 16853507}, {120564, 16855555}, {120565, 16855811}, {120566, 16856067},
	{120567, 16856323}, {120568, 16856579}, {120569, 16856835}, {120570, 16857091},
	{120571, 17945347}, {120572, 16851715}, {120573, 16851971}, {120574, 16852227},
	{120575, 16852483}, {120576, 16852739}, {120577, 16852995}, {120578, 16853251},
	{120579, 16853507}, {120580, 16846851}, {120581, 16853763}, {120582, 16854019},
	{120583, 16786179}, {120584, 16854275}, {120585, 16854531}, {120586, 16854787},
	{120587, 16855043}, {120588, 16855299}, {120589, 16855555}, {120591, 16855811},
	{120592, 16856067}, {120593, 16856323}, {120594, 16856579}, {120595, 16856835},
	{120596, 16857091}, {120597, 17945603}, {120598, 16852739}, {120599, 16853507},
	{120600, 16853763}, {120601, 16856323}, {120602, 16855299}, {120603, 16855043},
	{120604, 16851715}, {120605, 16851971}, {120606, 16852227}, {120607, 16852483},
	{120608, 16852739}, {120609, 16852995}, {120610, 16853251}, {120611, 16853507},
	{120612, 16846851}, {120613, 16853763}, {120614, 16854019}, {120615, 16786179},
	{120616, 16854275}, {120617, 16854531}, {120618, 16854787}, {120619, 16855043},
	{120620, 16855299}, {120621, 16853507}, {120622, 16855555}, {120623, 16855811},
	{120624, 16856067}, {120625, 16856323}, {120626, 16856579}, {120627, 16856835},
	{120628, 16857091}, {120629, 17945347}, {120630, 16851715}, {120631, 16851971},
	{120632, 16852227}, {120633, 16852483}, {120634, 16852739}, {120635, 16852995},
	{120636, 16853251}, {120637, 16853507}, {120638, 16846851}, {120639, 16853763},
	{120640, 16854019}, {120641, 16786179}, {120642, 16854275}, {120643, 16854531},
	{120644, 16854787}, {120645, 16855043}, {120646, 16855299}, {120647, 16855555},
	{120649, 16855811}, {120650, 16856067}, {120651, 16856323}, {120652, 16856579},
	{120653, 16856835}, {120654, 16857091}, {120655, 17945603}, {120656, 16852739},
	{120657, 16853507}, {120658, 16853763}, {120659, 16856323}, {120660, 16855299},
	{120661, 16855043}, {120662, 16851715}, {120663, 16851971}, {120664, 16852227},
	{120665, 16852483}, {120666, 16852739}, {120667, 16852995}, {120668, 16853251},
	{120669, 16853507}, {120670, 16846851}, {120671, 16853763}, {120672, 16854019},
	{120673, 16786179}, {120674, 16854275}, {120675, 16854531}, {120676, 16854787},
	{120677, 16855043}, {120678, 16855299}, {120679, 16853507}, {120680, 16855555},
	{120681, 16855811}, {120682, 16856067}, {120683, 16856323}, {120684, 16856579},
	{120685, 16856835}, {120686, 16857091}, {120687, 17945347}, {120688, 16851715},
	{120689, 16851971}, {120690, 16852227}, {120691, 16852483}, {120692, 16852739},
	{120693, 16852995}, {120694, 16853251}, {120695, 16853507}, {120696, 16846851},
	{120697, 16853763}, {120698, 16854019}, {120699, 16786179}, {120700, 16854275},
	{120701, 16854531}, {120702, 16854787}, {120703, 16855043}, {120704, 16855299},
	{120705, 16855555}, {120707, 16855811}, {120708, 16856067}, {120709, 16856323},
	{120710, 16856579}, {120711, 16856835}, {120712, 16857091}, {120713, 17945603},
	{120714, 16852739}, {120715, 16853507}, {120716, 16853763}, {120717, 16856323},
	{120718, 16855299}, {120719, 16855043}, {120720, 16851715}, {120721, 16851971},
	{120722, 16852227}, {120723, 16852483}, {120724, 16852739}, {120725, 16852995},
	{120726, 16853251}, {120727, 16853507}, {120728, 16846851}, {120729, 16853763},
	{120730, 16854019}, {120731, 16786179}, {120732, 16854275}, {120733, 16854531},
	{120734, 16854787}, {120735, 16855043}, {120736, 16855299}, {120737, 16853507},
	{120738, 16855555}, {120739, 16855811}, {120740, 16856067}, {120741, 16856323},
	{120742, 16856579}, {120743, 16856835}, {120744, 16857091}, {120745, 17945347},
	{120746, 16851715}, {120747, 16851971}, {120748, 16852227}, {120749, 16852483},
	{120750, 16852739}, {120751, 16852995}, {120752, 16853251}, {120753, 16853507},
	{120754, 16846851}, {120755, 16853763}, {120756, 16854019}, {120757, 16786179},
	{120758, 16854275}, {120759, 16854531}, {120760, 16854787}, {120761, 16855043},
	{120762, 16855299}, {120763, 16855555}, {120765, 16855811}, {120766, 16856067},
	{120767, 16856323}, {120768, 16856579}, {120769, 16856835}, {120770, 16857091},
	{120771, 17945603}, {120772, 16852739}, {120773, 16853507}, {120774, 16853763},
	{120775, 16856323}, {120776, 16855299}, {120777, 16855043}, {120778, 16858627},
	{120780, 2}, {120782, 17035523}, {120783, 16786947}, {120784, 16785155},
	{120785, 16785411}, {120786, 16787715}, {120787, 17035779}, {120788, 17036035},
	{120789, 17036291}, {120790, 17036547}, {120791, 17036803}, {120792, 17035523},
	{120793, 16786947}, {120794, 16785155}, {120795, 16785411}, {120796, 16787715},
	{120797, 17035779}, {120798, 17036035}, {120799, 17036291}, {120800, 17036547},
	{120801, 17036803}, {120802, 17035523}, {120803, 16786947}, {120804, 16785155},
	{120805, 16785411}, {120806, 16787715}, {120807, 17035779}, {120808, 17036035},
	{120809, 17036291}, {120810, 17036547}, {120811, 17036803}, {120812, 17035523},
	{120813, 16786947}, {120814, 16785155}, {120815, 16785411}, {120816, 16787715},
	{120817, 17035779}, {120818, 17036035}, {120819, 17036291}, {120820, 17036547},
	{120821, 17036803}, {120822, 17035523}, {120823, 16786947}, {120824, 16785155},
	{120825, 16785411}, {120826, 16787715}, {120827, 17035779}, {120828, 17036035},
	{120829, 17036291}, {120830, 17036547}, {120831, 17036803}, {120832, 1},
	{121484, 2}, {121499, 1}, {121504, 2}, {121505, 1},
	{121520, 2}, {122624, 1}, {122655, 2}, {122661, 1},
	{122667, 2}, {122880, 1}, {122887, 2}, {122888, 1},
	{122905, 2}, {122907, 1}, {122914, 2}, {122915, 1},
	{122917, 2}, {122918, 1}, {122923, 2}, {122928, 16866563},
	{122929, 16866819}, {122930, 16867075}, {122931, 16867331}, {122932, 16867587},
	{122933, 16867843}, {122934, 16868099}, {122935, 16868355}, {122936, 16868611},
	{122937, 16869123}, {122938, 16869379}, {122939, 16869635}, {122940, 16870147},
	{122941, 16870403}, {122942, 16870659}, {122943, 16870915}, {122944, 16871171},
	{122945, 16871427}, {122946, 16871683}, {122947, 16871939}, {122948, 16872195},
	{122949, 16872451}, {122950, 16872707}, {122951, 16873475}, {122952, 16873987},
	{122953, 16874243}, {122954, 17495299}, {122955, 16888835}, {122956, 16864003},
	{122957, 16864515}, {122958, 16890883}, {122959, 16883715}, {122960, 17945859},
	{122961, 16866563}, {122962, 16866819}, {122963, 16867075}, {122964, 16867331},
	{122965, 16867587}, {122966, 16867843}, {122967, 16868099}, {122968, 16868355},
	{122969, 16868611}, {122970, 16869123}, {122971, 16869379}, {122972, 16870147},
	{122973, 16870403}, {122974, 16870915}, {122975, 16871427}, {122976, 16871683},
	{122977, 16871939}, {122978, 16872195}, {122979, 16872451}, {122980, 16872707},
	{122981, 16873219}, {122982, 16873475}, {122983, 16879875}, {122984, 16864003},
	{122985, 16863747}, {122986, 16866307}, {122987, 16883203}, {122988, 17490435},
	{122989, 16883971}, {122990, 2}, {123023, 1}, {123024, 2},
	{123136, 1}, {123181, 2}, {123184, 1}, {123198, 2},
	{123200, 1}, {123210, 2}, {123214, 1}, {123216, 2},
	{123536, 1}, {123567, 2}, {123584, 1}, {123642, 2},
	{123647, 1}, {123648, 2}, {124112, 1}, {124154, 2},
	{124896, 1}, {124903, 2}, {124904, 1}, {124908, 2},
	{124909, 1}, {124911, 2}, {124912, 1}, {124927, 2},
	{124928, 1}, {125125, 2}, {125127, 1}, {125143, 2},
	{125184, 17946115}, {125185, 17946371}, {125186, 17946627}, {125187, 17946883},
	{125188, 17947139}, {125189, 17947395}, {125190, 17947651}, {125191, 17947907},
	{125192, 17948163}, {125193, 17948419}, {125194, 17948675}, {125195, 17948931},
	{125196, 17949187}, {125197, 17949443}, {125198, 17949699}, {125199, 17949955},
	{125200, 17950211}, {125201, 17950467}, {125202, 17950723}, {125203, 17950979},
	{125204, 17951235}, {125205, 17951491}, {125206, 17951747}, {125207, 17952003},
	{125208, 17952259}, {125209, 17952515}, {125210, 17952771}, {125211, 17953027},
	{125212, 17953283}, {125213, 17953539}, {125214, 17953795}, {125215, 17954051},
	{125216, 17954307}, {125217, 17954563}, {125218, 1}, {125260, 2},
	{125264, 1}, {125274, 2}, {125278, 1}, {125280, 2},
	{126065, 1}, {126133, 2}, {126209, 1}, {126270, 2},
	{126464, 16910339}, {126465, 17683715}, {126466, 17681923}, {126467, 17834499},
	{126468, 2}, {126469, 16910851}, {126470, 17731587}, {126471, 17682435},
	{126472, 17700099}, {126473, 16911875}, {126474, 17708803}, {126475, 17711107},
	{126476, 17682947}, {126477, 17718019}, {126478, 17694979}, {126479, 17701635},
	{126480, 17703683}, {126481, 17697027}, {126482, 17706755}, {126483, 17725187},
	{126484, 17745155}, {126485, 17686787}, {126486, 17689859}, {126487, 17684995},
	{126488, 17724675}, {126489, 17698051}, {126490, 17701123}, {126491, 17702659},
	{126492, 17954819}, {126493, 17673475}, {126494, 17955075}, {126495, 17955331},
	{126496, 2}, {126497, 17683715}, {126498, 17681923}, {126499, 2},
	{126500, 17721091}, {126501, 2}, {126503, 17682435}, {126504, 2},
	{126505, 16911875}, {126506, 17708803}, {126507, 17711107}, {126508, 17682947},
	{126509, 17718019}, {126510, 17694979}, {126511, 17701635}, {126512, 17703683},
	{126513, 17697027}, {126514, 17706755}, {126515, 2}, {126516, 17745155},
	{126517, 17686787}, {126518, 17689859}, {126519, 17684995}, {126520, 2},
	{126521, 17698051}, {126522, 2}, {126523, 17702659}, {126524, 2},
	{126530, 17681923}, {126531, 2}, {126535, 17682435}, {126536, 2},
	{126537, 16911875}, {126538, 2}, {126539, 17711107}, {126540, 2},
	{126541, 17718019}, {126542, 17694979}, {126543, 17701635}, {126544, 2},
	{126545, 17697027}, {126546, 17706755}, {126547, 2}, {126548, 17745155},
	{126549, 2}, {126551, 17684995}, {126552, 2}, {126553, 17698051},
	{126554, 2}, {126555, 17702659}, {126556, 2}, {126557, 17673475},
	{126558, 2}, {126559, 17955331}, {126560, 2}, {126561, 17683715},
	{126562, 17681923}, {126563, 2}, {126564, 17721091}, {126565, 2},
	{126567, 17682435}, {126568, 17700099}, {126569, 16911875}, {126570, 17708803},
	{126571, 2}, {126572, 17682947}, {126573, 17718019}, {126574, 17694979},
	{126575, 17701635}, {126576, 17703683}, {126577, 17697027}, {126578, 17706755},
	{126579, 2}, {126580, 17745155}, {126581, 17686787}, {126582, 17689859},
	{126583, 17684995}, {126584, 2}, {126585, 17698051}, {126586, 17701123},
	{126587, 17702659}, {126588, 17954819}, {126589, 2}, {126590, 17955075},
	{126591, 2}, {126592, 16910339}, {126593, 17683715}, {126594, 17681923},
	{126595, 17834499}, {126596, 17721091}, {126597, 16910851}, {126598, 17731587},
	{126599, 17682435}, {126600, 17700099}, {126601, 16911875}, {126602, 2},
	{126603, 17711107}, {126604, 17682947}, {126605, 17718019}, {126606, 17694979},
	{126607, 17701635}, {126608, 17703683}, {126609, 17697027}, {126610, 17706755},
	{126611, 17725187}, {126612, 17745155}, {126613, 17686787}, {126614, 17689859},
	{126615, 17684995}, {126616, 17724675}, {126617, 17698051}, {126618, 17701123},
	{126619, 17702659}, {126620, 2}, {126625, 17683715}, {126626, 17681923},
	{126627, 17834499}, {126628, 2}, {126629, 16910851}, {126630, 17731587},
	{126631, 17682435}, {126632, 17700099}, {126633, 16911875}, {126634, 2},
	{126635, 17711107}, {126636, 17682947}, {126637, 17718019}, {126638, 17694979},
	{126639, 17701635}, {126640, 17703683}, {126641, 17697027}, {126642, 17706755},
	{126643, 17725187}, {126644, 17745155}, {126645, 17686787}, {126646, 17689859},
	{126647, 17684995}, {126648, 17724675}, {126649, 17698051}, {126650, 17701123},
	{126651, 17702659}, {126652, 2}, {126704, 1}, {126706, 2},
	{126976, 1}, {127020, 2}, {127024, 1}, {127124, 2},
	{127136, 1}, {127151, 2}, {127153, 1}, {127168, 2},
	{127169, 1}, {127184, 2}, {127185, 1}, {127222, 2},
	{127233, 34732803}, {127234, 34733315}, {127235, 34733827}, {127236, 34734339},
	{127237, 34734851}, {127238, 34735363}, {127239, 34735875}, {127240, 34736387},
	{127241, 34736899}, {127242, 34737411}, {127243, 1}, {127248, 50644995},
	{127249, 50645763}, {127250, 50646531}, {127251, 50647299}, {127252, 50648067},
	{127253, 50648835}, {127254, 50649603}, {127255, 50650371}, {127256, 50651139},
	{127257, 50651907}, {127258, 50652675}, {127259, 50653443}, {127260, 50654211},
	{127261, 50654979}, {127262, 50655747}, {127263, 50656515}, {127264, 50657283},
	{127265, 50658051}, {127266, 50658819}, {127267, 50659587}, {127268, 50660355},
	{127269, 50661123}, {127270, 50661891}, {127271, 50662659}, {127272, 50663427},
	{127273, 50664195}, {127274, 51515139}, {127275, 16777731}, {127276, 16781571},
	{127277, 33554947}, {127278, 34738691}, {127279, 1}, {127280, 16777219},
	{127281, 16777475}, {127282, 16777731}, {127283, 16777987}, {127284, 16778243},
	{127285, 16778499}, {127286, 16778755}, {127287, 16779011}, {127288, 16779267},
	{127289, 16779523}, {127290, 16779779}, {127291, 16780035}, {127292, 16780291},
	{127293, 16780547}, {127294, 16780803}, {127295, 16781059}, {127296, 16781315},
	{127297, 16781571}, {127298, 16781827}, {127299, 16782083}, {127300, 16782339},
	{127301, 16782595}, {127302, 16782851}, {127303, 16783107}, {127304, 16783363},
	{127305, 16783619}, {127306, 34739203}, {127307, 34226691}, {127308, 34739715},
	{127309, 33752579}, {127310, 51517443}, {127311, 34740995}, {127312, 1},
	{127338, 34209539}, {127339, 34189571}, {127340, 34741507}, {127341, 1},
	{127376, 34742019}, {127377, 1}, {127406, 2}, {127462, 1},
	{127488, 34742531}, {127489, 34743043}, {127490, 17307907}, {127491, 2},
	{127504, 17157891}, {127505, 17966339}, {127506, 17966595}, {127507, 17351683},
	{127508, 17143299}, {127509, 17966851}, {127510, 17967107}, {127511, 17225475},
	{127512, 17967363}, {127513, 17967619}, {127514, 17967875}, {127515, 17584643},
	{127516, 17968131}, {127517, 17968387}, {127518, 17968643}, {127519, 17968899},
	{127520, 17969155}, {127521, 17969411}, {127522, 17167107}, {127523, 17969667},
	{127524, 17969923}, {127525, 17970179}, {127526, 17970435}, {127527, 17970691},
	{127528, 17970947}, {127529, 17141763}, {127530, 17223427}, {127531, 17971203},
	{127532, 17288707}, {127533, 17224195}, {127534, 17288963}, {127535, 17971459},
	{127536, 17181443}, {127537, 17971715}, {127538, 17971971}, {127539, 17972227},
	{127540, 17972483}, {127541, 17972739}, {127542, 17264387}, {127543, 17160451},
	{127544, 17972995}, {127545, 17973251}, {127546, 17973507}, {127547, 17973763},
	{127548, 2}, {127552, 51528451}, {127553, 51529219}, {127554, 51529987},
	{127555, 51530755}, {127556, 51531523}, {127557, 51532291}, {127558, 51533059},
	{127559, 51533827}, {127560, 51534595}, {127561, 2}, {127568, 17980931},
	{127569, 17981187}, {127570, 2}, {127584, 1}, {127590, 2},
	{127744, 1}, {128728, 2}, {128732, 1}, {128749, 2},
	{128752, 1}, {128765, 2}, {128768, 1}, {128887, 2},
	{128891, 1}, {128986, 2}, {128992, 1}, {129004, 2},
	{129008, 1}, {129009, 2}, {129024, 1}, {129036, 2},
	{129040, 1}, {129096, 2}, {129104, 1}, {129114, 2},
	{129120, 1}, {129160, 2}, {129168, 1}, {129198, 2},
	{129200, 1}, {129202, 2}, {129280, 1}, {129620, 2},
	{129632, 1}, {129646, 2}, {129648, 1}, {129661, 2},
	{129664, 1}, {129673, 2}, {129680, 1}, {129726, 2},
	{129727, 1}, {129734, 2}, {129742, 1}, {129756, 2},
	{129760, 1}, {129769, 2}, {129776, 1}, {129785, 2},
	{129792, 1}, {129939, 2}, {129940, 1}, {129995, 2},
	{130032, 17035523}, {130033, 16786947}, {130034, 16785155}, {130035, 16785411},
	{130036, 16787715}, {130037, 17035779}, {130038, 17036035}, {130039, 17036291},
	{130040, 17036547}, {130041, 17036803}, {130042, 2}, {131072, 1},
	{173792, 2}, {173824, 1}, {177978, 2}, {177984, 1},
	{178206, 2}, {178208, 1}, {183970, 2}, {183984, 1},
	{191457, 2}, {194560, 17981443}, {194561, 17981699}, {194562, 17981955},
	{194563, 17982211}, {194564, 17982467}, {194565, 17608451}, {194566, 17982723},
	{194567, 17982979}, {194568, 17983235}, {194569, 17983491}, {194570, 17608707},
	{194571, 17983747}, {194572, 17984003}, {194573, 17984259}, {194574, 17608963},
	{194575, 17984515}, {194576, 17984771}, {194577, 17985027}, {194578, 17985283},
	{194579, 17985539}, {194580, 17985795}, {194581, 17968643}, {194582, 17986051},
	{194583, 17986307}, {194584, 17986563}, {194585, 17986819}, {194586, 17987075},
	{194587, 17623043}, {194588, 17987331}, {194589, 17145859}, {194590, 17987587},
	{194591, 17987843}, {194592, 17988099}, {194593, 17988355}, {194594, 17973251},
	{194595, 17988611}, {194596, 17988867}, {194597, 17624323}, {194598, 17609219},
	{194599, 17609475}, {194600, 17624579}, {194601, 17989123}, {194602, 17989379},
	{194603, 17562883}, {194604, 17989635}, {194605, 17609731}, {194606, 17989891},
	{194607, 17990147}, {194608, 17990403}, {194609, 17990659}, {194612, 17990915},
	{194613, 17991171}, {194614, 17991427}, {194615, 17991683}, {194616, 17991939},
	{194617, 17992195}, {194618, 17992451}, {194619, 17992707}, {194620, 17992963},
	{194621, 17993219}, {194622, 17993475}, {194623, 17993731}, {194624, 17993987},
	{194625, 17994243}, {194626, 17994499}, {194627, 17994755}, {194628, 17995011},
	{194629, 17995267}, {194631, 17625091}, {194632, 17995523}, {194633, 17995779},
	{194634, 17996035}, {194635, 17996291}, {194636, 17610243}, {194637, 17996547},
	{194638, 17996803}, {194639, 17997059}, {194640, 17600003}, {194641, 17997315},
	{194642, 17997571}, {194643, 17997827}, {194644, 17998083}, {194645, 17998339},
	{194646, 17998595}, {194647, 17998851}, {194648, 17999107}, {194649, 17999363},
	{194650, 17999619}, {194651, 17999875}, {194652, 18000131}, {194653, 17966851},
	{194654, 18000387}, {194655, 18000643}, {194656, 18000899}, {194657, 18001155},
	{194658, 18001411}, {194659, 18001667}, {194660, 18001923}, {194661, 18002179},
	{194662, 18002435}, {194663, 18002691}, {194664, 2}, {194665, 18002947},
	{194666, 18003203}, {194668, 18003459}, {194669, 18003715}, {194670, 18003971},
	{194671, 17561859}, {194672, 18004227}, {194673, 18004483}, {194674, 18004739},
	{194675, 18004995}, {194676, 2}, {194677, 17152515}, {194678, 18005251},
	{194679, 18005507}, {194680, 17153027}, {194681, 18005763}, {194682, 18006019},
	{194683, 18006275}, {194684, 18006531}, {194685, 18006787}, {194686, 18007043},
	{194687, 18007299}, {194688, 18007555}, {194689, 18007811}, {194690, 18008067},
	{194691, 18008323}, {194692, 18008579}, {194693, 18008835}, {194694, 18009091},
	{194695, 18009347}, {194696, 18009603}, {194697, 18009859}, {194698, 18010115},
	{194699, 18010371}, {194700, 18010627}, {194701, 18010883}, {194702, 17548547},
	{194703, 18011139}, {194704, 17155587}, {194705, 18011395}, {194707, 18011651},
	{194708, 18011907}, {194710, 18012163}, {194711, 18012419}, {194712, 18012675},
	{194713, 18012931}, {194714, 18013187}, {194715, 18013443}, {194716, 18013699},
	{194717, 18013955}, {194718, 18014211}, {194719, 18014467}, {194720, 18014723},
	{194721, 18014979}, {194722, 18015235}, {194723, 17611523}, {194724, 18015491},
	{194725, 18015747}, {194726, 18016003}, {194727, 18016259}, {194728, 17628163},
	{194729, 18016259}, {194730, 18016515}, {194731, 17612035}, {194732, 18016771},
	{194733, 18017027}, {194734, 18017283}, {194735, 18017539}, {194736, 17612291},
	{194737, 17541635}, {194738, 17414915}, {194739, 18017795}, {194740, 18018051},
	{194741, 18018307}, {194742, 18018563}, {194743, 18018819}, {194744, 18019075},
	{194745, 18019331}, {194746, 18019587}, {194747, 18019843}, {194748, 18020099},
	{194749, 18020355}, {194750, 18020611}, {194751, 18020867}, {194752, 18021123},
	{194753, 18021379}, {194754, 18021635}, {194755, 18021891}, {194756, 18022147},
	{194757, 18022403}, {194758, 18022659}, {194759, 18022915}, {194760, 17612547},
	{194761, 18023171}, {194762, 18023427}, {194763, 18023683}, {194764, 18023939},
	{194765, 18024195}, {194766, 18024451}, {194767, 17613059}, {194768, 18024707},
	{194769, 18024963}, {194770, 18025219}, {194771, 18025475}, {194772, 18025731},
	{194773, 18025987}, {194774, 18026243}, {194775, 18026499}, {194776, 17548803},
	{194777, 17630211}, {194778, 18026755}, {194779, 18027011}, {194780, 18027267},
	{194781, 18027523}, {194782, 18027779}, {194783, 18028035}, {194784, 18028291},
	{194785, 18028547}, {194786, 17613315}, {194787, 18028803}, {194788, 18029059},
	{194789, 18029315}, {194790, 18029571}, {194791, 17640963}, {194792, 18029827},
	{194793, 18030083}, {194794, 18030339}, {194795, 18030595}, {194796, 18030851},
	{194797, 18031107}, {194798, 18031363}, {194799, 18031619}, {194800, 18031875},
	{194801, 18032131}, {194802, 18032387}, {194803, 18032643}, {194804, 18032899},
	{194805, 17566211}, {194806, 18033155}, {194807, 18033411}, {194808, 18033667},
	{194809, 18033923}, {194810, 18034179}, {194811, 18034435}, {194812, 18034691},
	{194813, 18034947}, {194814, 18035203}, {194815, 18035459}, {194816, 18035715},
	{194817, 17613571}, {194818, 17587203}, {194819, 18035971}, {194820, 18036227},
	{194821, 18036483}, {194822, 18036739}, {194823, 18036995}, {194824, 18037251},
	{194825, 18037507}, {194826, 18037763}, {194827, 17630979}, {194828, 18038019},
	{194829, 18038275}, {194830, 18038531}, {194831, 18038787}, {194832, 18039043},
	{194833, 18039299}, {194834, 18039555}, {194835, 18039811}, {194836, 17631235},
	{194837, 18040067}, {194838, 18040323}, {194839, 18040579}, {194840, 18040835},
	{194841, 18041091}, {194842, 18041347}, {194843, 18041603}, {194844, 18041859},
	{194845, 18042115}, {194846, 18042371}, {194847, 2}, {194848, 18042627},
	{194849, 17631747}, {194850, 18042883}, {194851, 18043139}, {194852, 18043395},
	{194853, 18043651}, {194854, 18043907}, {194855, 18044163}, {194856, 18044419},
	{194857, 18044675}, {194858, 18044931}, {194859, 18045187}, {194860, 18045443},
	{194862, 18045699}, {194863, 18045955}, {194864, 17632259}, {194865, 18046211},
	{194866, 18046467}, {194867, 18046723}, {194868, 18046979}, {194869, 18047235},
	{194870, 18047491}, {194871, 18047747}, {194872, 17562627}, {194873, 18048003},
	{194874, 18048259}, {194875, 18048515}, {194876, 18048771}, {194877, 18049027},
	{194878, 18049283}, {194879, 18049539}, {194880, 17633795}, {194881, 18049795},
	{194882, 18050051}, {194883, 18050307}, {194884, 18050563}, {194885, 18050819},
	{194886, 18051075}, {194888, 17634051}, {194889, 17641475}, {194890, 18051331},
	{194891, 18051587}, {194892, 18051843}, {194893, 18052099}, {194894, 18052355},
	{194895, 17553155}, {194896, 17634563}, {194897, 18052611}, {194898, 18052867},
	{194899, 17616131}, {194900, 18053123}, {194901, 18053379}, {194902, 17605123},
	{194903, 18053635}, {194904, 18053891}, {194905, 17616899}, {194906, 18054147},
	{194907, 18054403}, {194908, 18054659}, {194909, 18054915}, {194911, 2},
	{194912, 18055171}, {194913, 18055427}, {194914, 18055683}, {194915, 18055939},
	{194916, 18056195}, {194917, 18056451}, {194918, 18056707}, {194919, 18056963},
	{194920, 18057219}, {194921, 18057475}, {194922, 18057731}, {194923, 18057987},
	{194924, 18058243}, {194925, 18058499}, {194926, 18058755}, {194927, 18059011},
	{194928, 18059267}, {194929, 18059523}, {194930, 18059779}, {194931, 18060035},
	{194932, 18060291}, {194933, 18060547}, {194934, 18060803}, {194935, 18061059},
	{194936, 18061315}, {194937, 18061571}, {194938, 17618435}, {194939, 18061827},
	{194940, 18062083}, {194941, 18062339}, {194942, 18062595}, {194943, 18062851},
	{194944, 18063107}, {194945, 18063363}, {194946, 18063619}, {194947, 18063875},
	{194948, 18064131}, {194949, 18064387}, {194950, 18064643}, {194951, 18064899},
	{194952, 18065155}, {194953, 18065411}, {194954, 18065667}, {194955, 18011651},
	{194956, 18065923}, {194957, 18066179}, {194958, 18066435}, {194959, 18066691},
	{194960, 18066947}, {194961, 18067203}, {194962, 18067459}, {194963, 18067715},
	{194964, 18067971}, {194965, 18068227}, {194966, 18068483}, {194967, 18068739},
	{194968, 17566979}, {194969, 18068995}, {194970, 18069251}, {194971, 18069507},
	{194972, 18069763}, {194973, 18070019}, {194974, 18070275}, {194975, 17619203},
	{194976, 18070531}, {194977, 18070787}, {194978, 18071043}, {194979, 18071299},
	{194980, 18071555}, {194981, 18071811}, {194982, 18072067}, {194983, 18072323},
	{194984, 18072579}, {194985, 18072835}, {194986, 18073091}, {194987, 18073347},
	{194988, 18073603}, {194989, 18073859}, {194990, 18074115}, {194991, 18074371},
	{194992, 18074627}, {194993, 18074883}, {194994, 18075139}, {194995, 18075395},
	{194996, 17551875}, {194997, 18075651}, {194998, 18075907}, {194999, 18076163},
	{195000, 18076419}, {195001, 18076675}, {195002, 18076931}, {195003, 17636355},
	{195004, 18077187}, {195005, 18077443}, {195006, 18077699}, {195007, 2},
	{195008, 18077955}, {195009, 18078211}, {195010, 18078467}, {195011, 18078723},
	{195012, 17178627}, {195013, 18078979}, {195014, 18079235}, {195015, 18079491},
	{195016, 18079747}, {195017, 18080003}, {195018, 18080259}, {195019, 18080515},
	{195020, 18080771}, {195021, 18081027}, {195022, 18081283}, {195023, 18081539},
	{195024, 17637635}, {195025, 17637891}, {195026, 17180419}, {195027, 18081795},
	{195028, 18082051}, {195029, 18082307}, {195030, 18082563}, {195031, 18082819},
	{195032, 18083075}, {195033, 18083331}, {195034, 18083587}, {195035, 18083843},
	{195036, 18084099}, {195037, 18084355}, {195038, 18084611}, {195039, 17638147},
	{195040, 18084867}, {195041, 18085123}, {195042, 18085379}, {195043, 18085635},
	{195044, 18085891}, {195045, 18086147}, {195046, 18086403}, {195047, 18086659},
	{195048, 18086915}, {195049, 18087171}, {195050, 18087427}, {195051, 18087683},
	{195052, 18087939}, {195053, 18088195}, {195054, 18088451}, {195055, 18088707},
	{195056, 18088963}, {195057, 18089219}, {195058, 18089475}, {195059, 18089731},
	{195060, 18089987}, {195061, 18090243}, {195062, 18090499}, {195063, 18090755},
	{195064, 18091011}, {195065, 18091267}, {195066, 18091523}, {195067, 18091779},
	{195068, 18092035}, {195069, 18092291}, {195070, 17639683}, {195072, 18092547},
	{195073, 18092803}, {195074, 18093059}, {195075, 18093315}, {195076, 18093571},
	{195077, 18093827}, {195078, 18094083}, {195079, 18094339}, {195080, 18094595},
	{195081, 18094851}, {195082, 17639939}, {195083, 18095107}, {195084, 18095363},
	{195085, 18095619}, {195086, 18095875}, {195087, 18096131}, {195088, 18096387},
	{195089, 18096643}, {195090, 18096899}, {195091, 18097155}, {195092, 18097411},
	{195093, 17192707}, {195094, 18097667}, {195095, 17193731}, {195096, 18097923},
	{195097, 18098179}, {195098, 18098435}, {195099, 18098691}, {195100, 17195011},
	{195101, 18098947}, {195102, 2}, {196608, 1}, {201547, 2},
	{201552, 1}, {205744, 2}, {917760, 0}, {918000, 2}
};


} // namespace ada::idna
#endif // ADA_IDNA_TABLES_H

