/*
 * Copyright (c) 2001 Daniel Hartmeier
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *    - Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 *    - Redistributions in binary form must reproduce the above
 *      copyright notice, this list of conditions and the following
 *      disclaimer in the documentation and/or other materials provided
 *      with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
 * ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 *	$OpenBSD: pfvar.h,v 1.282 2009/01/29 15:12:28 pyr Exp $
 *	$FreeBSD: releng/11.3/sys/netpfil/pf/pf_altq.h 287009 2015-08-21 22:02:22Z loos $
 */

#ifndef	_NET_PF_ALTQ_H_
#define	_NET_PF_ALTQ_H_

struct cbq_opts {
	u_int		minburst;
	u_int		maxburst;
	u_int		pktsize;
	u_int		maxpktsize;
	u_int		ns_per_byte;
	u_int		maxidle;
	int		minidle;
	u_int		offtime;
	int		flags;
};

struct codel_opts {
	u_int		target;
	u_int		interval;
	int		ecn;
};

struct priq_opts {
	int		flags;
};

struct hfsc_opts {
	/* real-time service curve */
	u_int		rtsc_m1;	/* slope of the 1st segment in bps */
	u_int		rtsc_d;		/* the x-projection of m1 in msec */
	u_int		rtsc_m2;	/* slope of the 2nd segment in bps */
	/* link-sharing service curve */
	u_int		lssc_m1;
	u_int		lssc_d;
	u_int		lssc_m2;
	/* upper-limit service curve */
	u_int		ulsc_m1;
	u_int		ulsc_d;
	u_int		ulsc_m2;
	int		flags;
};

/*
 * XXX this needs some work
 */
struct fairq_opts {
	u_int           nbuckets;
	u_int           hogs_m1;
	int             flags;

	/* link sharing service curve */
	u_int           lssc_m1;
	u_int           lssc_d;
	u_int           lssc_m2;
};

struct pf_altq {
	char			 ifname[IFNAMSIZ];

	void			*altq_disc;	/* discipline-specific state */
	TAILQ_ENTRY(pf_altq)	 entries;

	/* scheduler spec */
	uint8_t			 scheduler;	/* scheduler type */
	uint16_t		 tbrsize;	/* tokenbucket regulator size */
	uint32_t		 ifbandwidth;	/* interface bandwidth */

	/* queue spec */
	char			 qname[PF_QNAME_SIZE];	/* queue name */
	char			 parent[PF_QNAME_SIZE];	/* parent name */
	uint32_t		 parent_qid;	/* parent queue id */
	uint32_t		 bandwidth;	/* queue bandwidth */
	uint8_t			 priority;	/* priority */
	uint8_t			 local_flags;	/* dynamic interface */
#define	PFALTQ_FLAG_IF_REMOVED		0x01

	uint16_t		 qlimit;	/* queue size limit */
	uint16_t		 flags;		/* misc flags */
	union {
		struct cbq_opts		 cbq_opts;
		struct codel_opts	 codel_opts;
		struct priq_opts	 priq_opts;
		struct hfsc_opts	 hfsc_opts;
		struct fairq_opts        fairq_opts;
	} pq_u;

	uint32_t		 qid;		/* return value */
};

#endif	/* _NET_PF_ALTQ_H_ */
