/*-
 * Copyright (c) 1997, 1999 Kenneth D. Merry.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $FreeBSD: releng/11.3/sys/cam/scsi/scsi_pass.h 291716 2015-12-03 20:54:55Z ken $
 */

#ifndef _SCSI_PASS_H
#define _SCSI_PASS_H 1

#include <sys/ioccom.h>

#include <cam/cam_ccb.h>

/*
 * Convert to using a pointer to a ccb in the next major version.
 * This should allow us to avoid an extra copy of the CCB data.
 */
#define CAMIOCOMMAND	_IOWR(CAM_VERSION, 2, union ccb)
#define CAMGETPASSTHRU	_IOWR(CAM_VERSION, 3, union ccb)

/*
 * These two ioctls take a union ccb *, but that is not explicitly declared
 * to avoid having the ioctl handling code malloc and free their own copy
 * of the CCB or the CCB pointer.
 */
#define CAMIOQUEUE	_IO(CAM_VERSION, 4)
#define CAMIOGET	_IO(CAM_VERSION, 5)

#endif
