# MongoDB C++ Driver

## Driver status by family and version

Stability indicates whether this driver is recommended for production use.
Currently, no drivers guarantee API or ABI stability.

| Family/version       | Stability | Development        | Purpose                            |
| -------------------- | --------- | ------------------ | ---------------------------------- |
| (repo master branch) | Unstable  | Active development | New feature development            |
| mongocxx 3.10.x      | Stable    | Bug fixes only     | Current stable C++ driver release  |
| mongocxx 3.9.x       | Stable    | None               | Previous stable C++ driver release  |
| mongocxx 3.8.x       | Stable    | None               | Previous stable C++ driver release |
| mongocxx 3.7.x       | Stable    | None               | Previous stable C++ driver release |
| mongocxx 3.6.x       | Stable    | None               | Previous stable C++ driver release |
| mongocxx 3.5.x       | Stable    | None               | Previous stable C++ driver release |
| mongocxx 3.4.x       | Stable    | None               | Previous stable C++ driver release |
| mongocxx 3.3.x       | Stable    | None               | Previous stable C++ driver release |
| mongocxx 3.2.x       | Stable    | None               | Previous stable C++ driver release |
| mongocxx 3.1.x       | Stable    | None               | Previous stable C++ driver release |
| mongocxx 3.0.x       | Stable    | None               | Previous stable C++ driver release |

## Documentation versions available

| mongocxx                             |
| ------------------------------------ |
| [mongocxx-3.9.0](../mongocxx-3.9.0)  |
| [mongocxx-3.8.1](../mongocxx-3.8.1)  |
| [mongocxx-3.8.0](../mongocxx-3.8.0)  |
| [mongocxx-3.7.2](../mongocxx-3.7.2)  |
| [mongocxx-3.7.1](../mongocxx-3.7.1)  |
| [mongocxx-3.7.0](../mongocxx-3.7.0)  |
| [mongocxx-3.6.7](../mongocxx-3.6.7)  |
| [mongocxx-3.6.6](../mongocxx-3.6.6)  |
| [mongocxx-3.6.5](../mongocxx-3.6.5)  |
| [mongocxx-3.6.4](../mongocxx-3.6.4)  |
| [mongocxx-3.6.3](../mongocxx-3.6.3)  |
| [mongocxx-3.6.2](../mongocxx-3.6.2)  |
| [mongocxx-3.6.1](../mongocxx-3.6.1)  |
| [mongocxx-3.6.0](../mongocxx-3.6.0)  |
| [mongocxx-3.5.1](../mongocxx-3.5.1)  |
| [mongocxx-3.5.0](../mongocxx-3.5.0)  |
| [mongocxx-3.4.2](../mongocxx-3.4.2)  |
| [mongocxx-3.4.1](../mongocxx-3.4.1)  |
| [mongocxx-3.4.0](../mongocxx-3.4.0)  |
| [mongocxx-3.3.2](../mongocxx-3.3.2)  |
| [mongocxx-3.3.1](../mongocxx-3.3.1)  |
| [mongocxx-3.3.0](../mongocxx-3.3.0)  |
| [mongocxx-3.2.1](../mongocxx-3.2.1)  |
| [mongocxx-3.2.0](../mongocxx-3.2.0)  |
| [mongocxx-3.1.4](../mongocxx-3.1.4/) |
| [mongocxx-3.1.3](../mongocxx-3.1.3/) |
| [mongocxx-3.1.2](../mongocxx-3.1.2/) |
| [mongocxx-3.1.1](../mongocxx-3.1.1/) |
| [mongocxx-3.1.0](../mongocxx-3.1.0/) |
| [mongocxx-3.0.3](../mongocxx-3.0.3/) |
| [mongocxx-3.0.2](../mongocxx-3.0.2/) |
| [mongocxx-3.0.1](../mongocxx-3.0.1/) |
| [mongocxx-3.0.0](../mongocxx-3.0.0/) |

## MongoDB compatibility

Compatibility of each C++ driver version with each MongoDB server is documented in the [MongoDB manual](https://www.mongodb.com/docs/drivers/cxx#mongodb-compatibility).

## Resources

* [MongoDB C++ Driver Quickstart](https://mongocxx.org/mongocxx-v3/tutorial/)
* [MongoDB C++ Driver Manual](https://mongocxx.org/)
* [MongoDB C++ Driver Source Code on GitHub](https://github.com/mongodb/mongo-cxx-driver)
* [MongoDB Database Manual](https://www.mongodb.com/docs/manual/)

## Bugs and issues

See our [JIRA project](https://jira.mongodb.com/browse/CXX).

## License

The source files in this repository are made available under the terms of
the Apache License, version 2.0.
