---
id: bindings
title: Bindings
sidebar_label: Bindings
slug: /community/bindings
---

As a C library, bindings can be made to call H3 functions from different programming languages. This page lists different bindings currently available. Contributions to this list are welcome, please feel free to open a [pull request](https://github.com/uber/h3/tree/master/website/docs/community/bindings.md).

## BigQuery

- [cartodb/bigquery-jslibs](https://github.com/CartoDB/bigquery-jslibs)

## C&#35;

- [entrepreneur-interet-general/h3.standard](https://github.com/entrepreneur-interet-general/H3.Standard)
- [richardvasquez/h3net](https://github.com/RichardVasquez/h3net) - A translation instead of a binding

## ClickHouse

- [Functions for Working with H3 Indexes](https://clickhouse.tech/docs/en/sql-reference/functions/geo/h3/)

## Clojure 

- [Factual/geo](https://github.com/Factual/geo)

## ECL

- [hpcc-systems/HPCC-Platform](https://github.com/hpcc-systems/HPCC-Platform/tree/master/plugins/h3)

## Erlang

- [helium/erlang-h3](https://github.com/helium/erlang-h3)

## Go

- [uber/h3-go](https://github.com/uber/h3-go)

## Java

- [uber/h3-java](https://github.com/uber/h3-java)

## JavaScript

- [uber/h3-js](https://github.com/uber/h3-js)
- [dfellis/h3-node](https://github.com/dfellis/h3-node)
- [realPrimoh/h3-reactnative](https://github.com/realPrimoh/h3-reactnative)

## Julia

- [wookay/H3.jl](https://github.com/wookay/H3.jl)

## OCaml

- [travisbrady/ocaml-h3](https://github.com/travisbrady/ocaml-h3)

## PHP

- [neatlife/php-h3](https://github.com/neatlife/php-h3)

## PostgreSQL

- [dlr-eoc/pgh3](https://github.com/dlr-eoc/pgh3)
- [bytesandbrains/h3-pg](https://github.com/bytesandbrains/h3-pg)

## Python

- [uber/h3-py](https://github.com/uber/h3-py)

## R

- [scottmmjackson/h3r](https://github.com/scottmmjackson/h3r)
- [crazycapivara/h3-r](https://github.com/crazycapivara/h3-r)
- [obrl-soil/h3jsr](https://github.com/obrl-soil/h3jsr)

## Ruby

- [StuartApp/h3_ruby](https://github.com/StuartApp/h3_ruby)

## Rust

- [rustyconover/libh3-sys](https://github.com/rustyconover/libh3-sys)
- [rustyconover/libh3](https://github.com/rustyconover/libh3)
- [nmandery/h3ron](https://github.com/nmandery/h3ron)
