---
id: s2
title: S2
sidebar_label: S2
slug: /comparisons/s2
---

[S2](https://s2geometry.io/), like H3, implements an open source, hierarchical, discrete, and global grid system. The systems share a number of similarities, including the use of 64 bit integers as cell indexes, making it very efficient to use both of them in big data systems.

One of the main differences between S2 and H3 is the choice of cell shape. S2 uses square cells while H3 uses hexagonal cells. This leads to several important differences.

## Neighbors

Squares have two classes of neighbors: those that they share an edge with, and those that they share a point with. This can complicate analysis of moving things in the real world, because they are very unlikely to move in a way aligned with the grid. Instead, the analyst will need to account for different types of neighbors.

Hexagons have only one class of neighbor, that they share an edge with. This makes running convolutions and smoothing over the data much simpler, since only the grid distance (as opposed to the geographic distance) from a cell needs to be considered.

## Subdivision

S2 uses an *aperture 4* system where each cell is subdivided into 4 finer, child cells. Squares subdivide exactly into 4 child squares. This means that when indexing a point to an S2 cell, and then truncating to the parent S2 cell, there is no possibility that the point is not contained in the bounds of the parent cell.

This differs from H3 where the same operation is approximate. This is the case because hexagons do not exactly subdivide into 7 child hexagons.

## Visualization

S2 cells are squares in the system's projection. When those cells are visualized on a map using a projection like the Web Mercator projection, the cells can subjectively appear distorted (i.e. as a quadrilateral rather than square).

H3 cells have the same non-alignment with the map projection, but in our experience the effect is less noticeable to viewers for hexagons.

## Links

* [Geometry on the Sphere: Google's S2 Library](https://docs.google.com/presentation/d/1Hl4KapfAENAOf4gv-pSngKwvS_jwNVHRPZTTDzXXn6Q/edit)

## S2 vs H3 Comparison

<iframe width="100%" height="500px" src="https://studio.unfolded.ai/public/851dc25a-c8c8-4f20-96b8-ea47b3e3e9a7/embed" frameborder="0" allowfullscreen></iframe>

S2 on the left, H3 on the right. Data: [San Francisco Street Tree List](https://data.sfgov.org/City-Infrastructure/Street-Tree-List/tkzw-k3nq)
