// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/workstations/v1/workstations.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_WORKSTATIONS_V1_WORKSTATIONS_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_WORKSTATIONS_V1_WORKSTATIONS_CONNECTION_H

#include "google/cloud/workstations/v1/internal/workstations_retry_traits.h"
#include "google/cloud/workstations/v1/workstations_connection_idempotency_policy.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/future.h"
#include "google/cloud/internal/retry_policy_impl.h"
#include "google/cloud/no_await_tag.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <google/cloud/workstations/v1/workstations.pb.h>
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace workstations_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

/// The retry policy for `WorkstationsConnection`.
class WorkstationsRetryPolicy : public ::google::cloud::RetryPolicy {
 public:
  /// Creates a new instance of the policy, reset to the initial state.
  virtual std::unique_ptr<WorkstationsRetryPolicy> clone() const = 0;
};

/**
 * A retry policy for `WorkstationsConnection` based on counting errors.
 *
 * This policy stops retrying if:
 * - An RPC returns a non-transient error.
 * - More than a prescribed number of transient failures is detected.
 *
 * In this class the following status codes are treated as transient errors:
 * - [`kUnavailable`](@ref google::cloud::StatusCode)
 */
class WorkstationsLimitedErrorCountRetryPolicy
    : public WorkstationsRetryPolicy {
 public:
  /**
   * Create an instance that tolerates up to @p maximum_failures transient
   * errors.
   *
   * @note Disable the retry loop by providing an instance of this policy with
   *     @p maximum_failures == 0.
   */
  explicit WorkstationsLimitedErrorCountRetryPolicy(int maximum_failures)
      : impl_(maximum_failures) {}

  WorkstationsLimitedErrorCountRetryPolicy(
      WorkstationsLimitedErrorCountRetryPolicy&& rhs) noexcept
      : WorkstationsLimitedErrorCountRetryPolicy(rhs.maximum_failures()) {}
  WorkstationsLimitedErrorCountRetryPolicy(
      WorkstationsLimitedErrorCountRetryPolicy const& rhs) noexcept
      : WorkstationsLimitedErrorCountRetryPolicy(rhs.maximum_failures()) {}

  int maximum_failures() const { return impl_.maximum_failures(); }

  bool OnFailure(Status const& status) override {
    return impl_.OnFailure(status);
  }
  bool IsExhausted() const override { return impl_.IsExhausted(); }
  bool IsPermanentFailure(Status const& status) const override {
    return impl_.IsPermanentFailure(status);
  }
  std::unique_ptr<WorkstationsRetryPolicy> clone() const override {
    return std::make_unique<WorkstationsLimitedErrorCountRetryPolicy>(
        maximum_failures());
  }

  // This is provided only for backwards compatibility.
  using BaseType = WorkstationsRetryPolicy;

 private:
  google::cloud::internal::LimitedErrorCountRetryPolicy<
      workstations_v1_internal::WorkstationsRetryTraits>
      impl_;
};

/**
 * A retry policy for `WorkstationsConnection` based on elapsed time.
 *
 * This policy stops retrying if:
 * - An RPC returns a non-transient error.
 * - The elapsed time in the retry loop exceeds a prescribed duration.
 *
 * In this class the following status codes are treated as transient errors:
 * - [`kUnavailable`](@ref google::cloud::StatusCode)
 */
class WorkstationsLimitedTimeRetryPolicy : public WorkstationsRetryPolicy {
 public:
  /**
   * Constructor given a `std::chrono::duration<>` object.
   *
   * @tparam DurationRep a placeholder to match the `Rep` tparam for @p
   *     duration's type. The semantics of this template parameter are
   *     documented in `std::chrono::duration<>`. In brief, the underlying
   *     arithmetic type used to store the number of ticks. For our purposes it
   *     is simply a formal parameter.
   * @tparam DurationPeriod a placeholder to match the `Period` tparam for @p
   *     duration's type. The semantics of this template parameter are
   *     documented in `std::chrono::duration<>`. In brief, the length of the
   *     tick in seconds, expressed as a `std::ratio<>`. For our purposes it is
   *     simply a formal parameter.
   * @param maximum_duration the maximum time allowed before the policy expires.
   *     While the application can express this time in any units they desire,
   *     the class truncates to milliseconds.
   *
   * @see https://en.cppreference.com/w/cpp/chrono/duration for more information
   *     about `std::chrono::duration`.
   */
  template <typename DurationRep, typename DurationPeriod>
  explicit WorkstationsLimitedTimeRetryPolicy(
      std::chrono::duration<DurationRep, DurationPeriod> maximum_duration)
      : impl_(maximum_duration) {}

  WorkstationsLimitedTimeRetryPolicy(
      WorkstationsLimitedTimeRetryPolicy&& rhs) noexcept
      : WorkstationsLimitedTimeRetryPolicy(rhs.maximum_duration()) {}
  WorkstationsLimitedTimeRetryPolicy(
      WorkstationsLimitedTimeRetryPolicy const& rhs) noexcept
      : WorkstationsLimitedTimeRetryPolicy(rhs.maximum_duration()) {}

  std::chrono::milliseconds maximum_duration() const {
    return impl_.maximum_duration();
  }

  bool OnFailure(Status const& status) override {
    return impl_.OnFailure(status);
  }
  bool IsExhausted() const override { return impl_.IsExhausted(); }
  bool IsPermanentFailure(Status const& status) const override {
    return impl_.IsPermanentFailure(status);
  }
  std::unique_ptr<WorkstationsRetryPolicy> clone() const override {
    return std::make_unique<WorkstationsLimitedTimeRetryPolicy>(
        maximum_duration());
  }

  // This is provided only for backwards compatibility.
  using BaseType = WorkstationsRetryPolicy;

 private:
  google::cloud::internal::LimitedTimeRetryPolicy<
      workstations_v1_internal::WorkstationsRetryTraits>
      impl_;
};

/**
 * The `WorkstationsConnection` object for `WorkstationsClient`.
 *
 * This interface defines virtual methods for each of the user-facing overload
 * sets in `WorkstationsClient`. This allows users to inject custom behavior
 * (e.g., with a Google Mock object) when writing tests that use objects of type
 * `WorkstationsClient`.
 *
 * To create a concrete instance, see `MakeWorkstationsConnection()`.
 *
 * For mocking, see `workstations_v1_mocks::MockWorkstationsConnection`.
 */
class WorkstationsConnection {
 public:
  virtual ~WorkstationsConnection() = 0;

  virtual Options options() { return Options{}; }

  virtual StatusOr<google::cloud::workstations::v1::WorkstationCluster>
  GetWorkstationCluster(
      google::cloud::workstations::v1::GetWorkstationClusterRequest const&
          request);

  virtual StreamRange<google::cloud::workstations::v1::WorkstationCluster>
  ListWorkstationClusters(
      google::cloud::workstations::v1::ListWorkstationClustersRequest request);

  virtual future<StatusOr<google::cloud::workstations::v1::WorkstationCluster>>
  CreateWorkstationCluster(
      google::cloud::workstations::v1::CreateWorkstationClusterRequest const&
          request);

  virtual StatusOr<google::longrunning::Operation> CreateWorkstationCluster(
      NoAwaitTag,
      google::cloud::workstations::v1::CreateWorkstationClusterRequest const&
          request);

  virtual future<StatusOr<google::cloud::workstations::v1::WorkstationCluster>>
  CreateWorkstationCluster(google::longrunning::Operation const& operation);

  virtual future<StatusOr<google::cloud::workstations::v1::WorkstationCluster>>
  UpdateWorkstationCluster(
      google::cloud::workstations::v1::UpdateWorkstationClusterRequest const&
          request);

  virtual StatusOr<google::longrunning::Operation> UpdateWorkstationCluster(
      NoAwaitTag,
      google::cloud::workstations::v1::UpdateWorkstationClusterRequest const&
          request);

  virtual future<StatusOr<google::cloud::workstations::v1::WorkstationCluster>>
  UpdateWorkstationCluster(google::longrunning::Operation const& operation);

  virtual future<StatusOr<google::cloud::workstations::v1::WorkstationCluster>>
  DeleteWorkstationCluster(
      google::cloud::workstations::v1::DeleteWorkstationClusterRequest const&
          request);

  virtual StatusOr<google::longrunning::Operation> DeleteWorkstationCluster(
      NoAwaitTag,
      google::cloud::workstations::v1::DeleteWorkstationClusterRequest const&
          request);

  virtual future<StatusOr<google::cloud::workstations::v1::WorkstationCluster>>
  DeleteWorkstationCluster(google::longrunning::Operation const& operation);

  virtual StatusOr<google::cloud::workstations::v1::WorkstationConfig>
  GetWorkstationConfig(
      google::cloud::workstations::v1::GetWorkstationConfigRequest const&
          request);

  virtual StreamRange<google::cloud::workstations::v1::WorkstationConfig>
  ListWorkstationConfigs(
      google::cloud::workstations::v1::ListWorkstationConfigsRequest request);

  virtual StreamRange<google::cloud::workstations::v1::WorkstationConfig>
  ListUsableWorkstationConfigs(
      google::cloud::workstations::v1::ListUsableWorkstationConfigsRequest
          request);

  virtual future<StatusOr<google::cloud::workstations::v1::WorkstationConfig>>
  CreateWorkstationConfig(
      google::cloud::workstations::v1::CreateWorkstationConfigRequest const&
          request);

  virtual StatusOr<google::longrunning::Operation> CreateWorkstationConfig(
      NoAwaitTag,
      google::cloud::workstations::v1::CreateWorkstationConfigRequest const&
          request);

  virtual future<StatusOr<google::cloud::workstations::v1::WorkstationConfig>>
  CreateWorkstationConfig(google::longrunning::Operation const& operation);

  virtual future<StatusOr<google::cloud::workstations::v1::WorkstationConfig>>
  UpdateWorkstationConfig(
      google::cloud::workstations::v1::UpdateWorkstationConfigRequest const&
          request);

  virtual StatusOr<google::longrunning::Operation> UpdateWorkstationConfig(
      NoAwaitTag,
      google::cloud::workstations::v1::UpdateWorkstationConfigRequest const&
          request);

  virtual future<StatusOr<google::cloud::workstations::v1::WorkstationConfig>>
  UpdateWorkstationConfig(google::longrunning::Operation const& operation);

  virtual future<StatusOr<google::cloud::workstations::v1::WorkstationConfig>>
  DeleteWorkstationConfig(
      google::cloud::workstations::v1::DeleteWorkstationConfigRequest const&
          request);

  virtual StatusOr<google::longrunning::Operation> DeleteWorkstationConfig(
      NoAwaitTag,
      google::cloud::workstations::v1::DeleteWorkstationConfigRequest const&
          request);

  virtual future<StatusOr<google::cloud::workstations::v1::WorkstationConfig>>
  DeleteWorkstationConfig(google::longrunning::Operation const& operation);

  virtual StatusOr<google::cloud::workstations::v1::Workstation> GetWorkstation(
      google::cloud::workstations::v1::GetWorkstationRequest const& request);

  virtual StreamRange<google::cloud::workstations::v1::Workstation>
  ListWorkstations(
      google::cloud::workstations::v1::ListWorkstationsRequest request);

  virtual StreamRange<google::cloud::workstations::v1::Workstation>
  ListUsableWorkstations(
      google::cloud::workstations::v1::ListUsableWorkstationsRequest request);

  virtual future<StatusOr<google::cloud::workstations::v1::Workstation>>
  CreateWorkstation(
      google::cloud::workstations::v1::CreateWorkstationRequest const& request);

  virtual StatusOr<google::longrunning::Operation> CreateWorkstation(
      NoAwaitTag,
      google::cloud::workstations::v1::CreateWorkstationRequest const& request);

  virtual future<StatusOr<google::cloud::workstations::v1::Workstation>>
  CreateWorkstation(google::longrunning::Operation const& operation);

  virtual future<StatusOr<google::cloud::workstations::v1::Workstation>>
  UpdateWorkstation(
      google::cloud::workstations::v1::UpdateWorkstationRequest const& request);

  virtual StatusOr<google::longrunning::Operation> UpdateWorkstation(
      NoAwaitTag,
      google::cloud::workstations::v1::UpdateWorkstationRequest const& request);

  virtual future<StatusOr<google::cloud::workstations::v1::Workstation>>
  UpdateWorkstation(google::longrunning::Operation const& operation);

  virtual future<StatusOr<google::cloud::workstations::v1::Workstation>>
  DeleteWorkstation(
      google::cloud::workstations::v1::DeleteWorkstationRequest const& request);

  virtual StatusOr<google::longrunning::Operation> DeleteWorkstation(
      NoAwaitTag,
      google::cloud::workstations::v1::DeleteWorkstationRequest const& request);

  virtual future<StatusOr<google::cloud::workstations::v1::Workstation>>
  DeleteWorkstation(google::longrunning::Operation const& operation);

  virtual future<StatusOr<google::cloud::workstations::v1::Workstation>>
  StartWorkstation(
      google::cloud::workstations::v1::StartWorkstationRequest const& request);

  virtual StatusOr<google::longrunning::Operation> StartWorkstation(
      NoAwaitTag,
      google::cloud::workstations::v1::StartWorkstationRequest const& request);

  virtual future<StatusOr<google::cloud::workstations::v1::Workstation>>
  StartWorkstation(google::longrunning::Operation const& operation);

  virtual future<StatusOr<google::cloud::workstations::v1::Workstation>>
  StopWorkstation(
      google::cloud::workstations::v1::StopWorkstationRequest const& request);

  virtual StatusOr<google::longrunning::Operation> StopWorkstation(
      NoAwaitTag,
      google::cloud::workstations::v1::StopWorkstationRequest const& request);

  virtual future<StatusOr<google::cloud::workstations::v1::Workstation>>
  StopWorkstation(google::longrunning::Operation const& operation);

  virtual StatusOr<google::cloud::workstations::v1::GenerateAccessTokenResponse>
  GenerateAccessToken(
      google::cloud::workstations::v1::GenerateAccessTokenRequest const&
          request);

  virtual StatusOr<google::iam::v1::Policy> SetIamPolicy(
      google::iam::v1::SetIamPolicyRequest const& request);

  virtual StatusOr<google::iam::v1::Policy> GetIamPolicy(
      google::iam::v1::GetIamPolicyRequest const& request);

  virtual StatusOr<google::iam::v1::TestIamPermissionsResponse>
  TestIamPermissions(google::iam::v1::TestIamPermissionsRequest const& request);

  virtual StreamRange<google::longrunning::Operation> ListOperations(
      google::longrunning::ListOperationsRequest request);

  virtual StatusOr<google::longrunning::Operation> GetOperation(
      google::longrunning::GetOperationRequest const& request);

  virtual Status DeleteOperation(
      google::longrunning::DeleteOperationRequest const& request);

  virtual Status CancelOperation(
      google::longrunning::CancelOperationRequest const& request);
};

/**
 * A factory function to construct an object of type `WorkstationsConnection`.
 *
 * The returned connection object should not be used directly; instead it
 * should be passed as an argument to the constructor of WorkstationsClient.
 *
 * The optional @p options argument may be used to configure aspects of the
 * returned `WorkstationsConnection`. Expected options are any of the types in
 * the following option lists:
 *
 * - `google::cloud::CommonOptionList`
 * - `google::cloud::GrpcOptionList`
 * - `google::cloud::UnifiedCredentialsOptionList`
 * - `google::cloud::workstations_v1::WorkstationsPolicyOptionList`
 *
 * @note Unexpected options will be ignored. To log unexpected options instead,
 *     set `GOOGLE_CLOUD_CPP_ENABLE_CLOG=yes` in the environment.
 *
 * @param options (optional) Configure the `WorkstationsConnection` created by
 * this function.
 */
std::shared_ptr<WorkstationsConnection> MakeWorkstationsConnection(
    Options options = {});

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace workstations_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_WORKSTATIONS_V1_WORKSTATIONS_CONNECTION_H
