// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/workflows/executions/v1/executions.proto

#include "google/cloud/workflows/executions/v1/internal/executions_logging_decorator.h"
#include "google/cloud/internal/log_wrapper.h"
#include "google/cloud/status_or.h"
#include <google/cloud/workflows/executions/v1/executions.grpc.pb.h>
#include <memory>
#include <set>
#include <string>
#include <utility>

namespace google {
namespace cloud {
namespace workflows_executions_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

ExecutionsLogging::ExecutionsLogging(std::shared_ptr<ExecutionsStub> child,
                                     TracingOptions tracing_options,
                                     std::set<std::string> const&)
    : child_(std::move(child)), tracing_options_(std::move(tracing_options)) {}

StatusOr<google::cloud::workflows::executions::v1::ListExecutionsResponse>
ExecutionsLogging::ListExecutions(
    grpc::ClientContext& context, Options const& options,
    google::cloud::workflows::executions::v1::ListExecutionsRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::workflows::executions::v1::ListExecutionsRequest const&
              request) {
        return child_->ListExecutions(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::workflows::executions::v1::Execution>
ExecutionsLogging::CreateExecution(
    grpc::ClientContext& context, Options const& options,
    google::cloud::workflows::executions::v1::CreateExecutionRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::workflows::executions::v1::
                 CreateExecutionRequest const& request) {
        return child_->CreateExecution(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::workflows::executions::v1::Execution>
ExecutionsLogging::GetExecution(
    grpc::ClientContext& context, Options const& options,
    google::cloud::workflows::executions::v1::GetExecutionRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::workflows::executions::v1::GetExecutionRequest const&
              request) {
        return child_->GetExecution(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::workflows::executions::v1::Execution>
ExecutionsLogging::CancelExecution(
    grpc::ClientContext& context, Options const& options,
    google::cloud::workflows::executions::v1::CancelExecutionRequest const&
        request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::workflows::executions::v1::
                 CancelExecutionRequest const& request) {
        return child_->CancelExecution(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace workflows_executions_v1_internal
}  // namespace cloud
}  // namespace google
