// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/webrisk/v1/webrisk.proto

#include "google/cloud/webrisk/v1/web_risk_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace webrisk_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

WebRiskServiceConnectionIdempotencyPolicy::
    ~WebRiskServiceConnectionIdempotencyPolicy() = default;

std::unique_ptr<WebRiskServiceConnectionIdempotencyPolicy>
WebRiskServiceConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<WebRiskServiceConnectionIdempotencyPolicy>(*this);
}

Idempotency WebRiskServiceConnectionIdempotencyPolicy::ComputeThreatListDiff(
    google::cloud::webrisk::v1::ComputeThreatListDiffRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency WebRiskServiceConnectionIdempotencyPolicy::SearchUris(
    google::cloud::webrisk::v1::SearchUrisRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency WebRiskServiceConnectionIdempotencyPolicy::SearchHashes(
    google::cloud::webrisk::v1::SearchHashesRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency WebRiskServiceConnectionIdempotencyPolicy::CreateSubmission(
    google::cloud::webrisk::v1::CreateSubmissionRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency WebRiskServiceConnectionIdempotencyPolicy::SubmitUri(
    google::cloud::webrisk::v1::SubmitUriRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency WebRiskServiceConnectionIdempotencyPolicy::ListOperations(
    google::longrunning::ListOperationsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency WebRiskServiceConnectionIdempotencyPolicy::GetOperation(
    google::longrunning::GetOperationRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency WebRiskServiceConnectionIdempotencyPolicy::DeleteOperation(
    google::longrunning::DeleteOperationRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency WebRiskServiceConnectionIdempotencyPolicy::CancelOperation(
    google::longrunning::CancelOperationRequest const&) {
  return Idempotency::kNonIdempotent;
}

std::unique_ptr<WebRiskServiceConnectionIdempotencyPolicy>
MakeDefaultWebRiskServiceConnectionIdempotencyPolicy() {
  return std::make_unique<WebRiskServiceConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace webrisk_v1
}  // namespace cloud
}  // namespace google
