// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/vpcaccess/v1/vpc_access.proto

#include "google/cloud/vpcaccess/v1/vpc_access_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace vpcaccess_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

VpcAccessServiceClient::VpcAccessServiceClient(
    std::shared_ptr<VpcAccessServiceConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
VpcAccessServiceClient::~VpcAccessServiceClient() = default;

future<StatusOr<google::cloud::vpcaccess::v1::Connector>>
VpcAccessServiceClient::CreateConnector(
    std::string const& parent, std::string const& connector_id,
    google::cloud::vpcaccess::v1::Connector const& connector, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vpcaccess::v1::CreateConnectorRequest request;
  request.set_parent(parent);
  request.set_connector_id(connector_id);
  *request.mutable_connector() = connector;
  return connection_->CreateConnector(request);
}

StatusOr<google::longrunning::Operation>
VpcAccessServiceClient::CreateConnector(
    NoAwaitTag, std::string const& parent, std::string const& connector_id,
    google::cloud::vpcaccess::v1::Connector const& connector, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vpcaccess::v1::CreateConnectorRequest request;
  request.set_parent(parent);
  request.set_connector_id(connector_id);
  *request.mutable_connector() = connector;
  return connection_->CreateConnector(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::vpcaccess::v1::Connector>>
VpcAccessServiceClient::CreateConnector(
    google::cloud::vpcaccess::v1::CreateConnectorRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateConnector(request);
}

StatusOr<google::longrunning::Operation>
VpcAccessServiceClient::CreateConnector(
    NoAwaitTag,
    google::cloud::vpcaccess::v1::CreateConnectorRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateConnector(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::vpcaccess::v1::Connector>>
VpcAccessServiceClient::CreateConnector(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateConnector(operation);
}

StatusOr<google::cloud::vpcaccess::v1::Connector>
VpcAccessServiceClient::GetConnector(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vpcaccess::v1::GetConnectorRequest request;
  request.set_name(name);
  return connection_->GetConnector(request);
}

StatusOr<google::cloud::vpcaccess::v1::Connector>
VpcAccessServiceClient::GetConnector(
    google::cloud::vpcaccess::v1::GetConnectorRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetConnector(request);
}

StreamRange<google::cloud::vpcaccess::v1::Connector>
VpcAccessServiceClient::ListConnectors(std::string const& parent,
                                       Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vpcaccess::v1::ListConnectorsRequest request;
  request.set_parent(parent);
  return connection_->ListConnectors(request);
}

StreamRange<google::cloud::vpcaccess::v1::Connector>
VpcAccessServiceClient::ListConnectors(
    google::cloud::vpcaccess::v1::ListConnectorsRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListConnectors(std::move(request));
}

future<StatusOr<google::cloud::vpcaccess::v1::OperationMetadata>>
VpcAccessServiceClient::DeleteConnector(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vpcaccess::v1::DeleteConnectorRequest request;
  request.set_name(name);
  return connection_->DeleteConnector(request);
}

StatusOr<google::longrunning::Operation>
VpcAccessServiceClient::DeleteConnector(NoAwaitTag, std::string const& name,
                                        Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vpcaccess::v1::DeleteConnectorRequest request;
  request.set_name(name);
  return connection_->DeleteConnector(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::vpcaccess::v1::OperationMetadata>>
VpcAccessServiceClient::DeleteConnector(
    google::cloud::vpcaccess::v1::DeleteConnectorRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteConnector(request);
}

StatusOr<google::longrunning::Operation>
VpcAccessServiceClient::DeleteConnector(
    NoAwaitTag,
    google::cloud::vpcaccess::v1::DeleteConnectorRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteConnector(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::vpcaccess::v1::OperationMetadata>>
VpcAccessServiceClient::DeleteConnector(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteConnector(operation);
}

StreamRange<google::cloud::location::Location>
VpcAccessServiceClient::ListLocations(
    google::cloud::location::ListLocationsRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListLocations(std::move(request));
}

StreamRange<google::longrunning::Operation>
VpcAccessServiceClient::ListOperations(std::string const& name,
                                       std::string const& filter,
                                       Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::longrunning::ListOperationsRequest request;
  request.set_name(name);
  request.set_filter(filter);
  return connection_->ListOperations(request);
}

StreamRange<google::longrunning::Operation>
VpcAccessServiceClient::ListOperations(
    google::longrunning::ListOperationsRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListOperations(std::move(request));
}

StatusOr<google::longrunning::Operation> VpcAccessServiceClient::GetOperation(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::longrunning::GetOperationRequest request;
  request.set_name(name);
  return connection_->GetOperation(request);
}

StatusOr<google::longrunning::Operation> VpcAccessServiceClient::GetOperation(
    google::longrunning::GetOperationRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetOperation(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace vpcaccess_v1
}  // namespace cloud
}  // namespace google
