// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/vmwareengine/v1/vmwareengine.proto

#include "google/cloud/vmwareengine/v1/vmware_engine_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace vmwareengine_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

VmwareEngineClient::VmwareEngineClient(
    std::shared_ptr<VmwareEngineConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
VmwareEngineClient::~VmwareEngineClient() = default;

StreamRange<google::cloud::vmwareengine::v1::PrivateCloud>
VmwareEngineClient::ListPrivateClouds(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::ListPrivateCloudsRequest request;
  request.set_parent(parent);
  return connection_->ListPrivateClouds(request);
}

StreamRange<google::cloud::vmwareengine::v1::PrivateCloud>
VmwareEngineClient::ListPrivateClouds(
    google::cloud::vmwareengine::v1::ListPrivateCloudsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListPrivateClouds(std::move(request));
}

StatusOr<google::cloud::vmwareengine::v1::PrivateCloud>
VmwareEngineClient::GetPrivateCloud(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::GetPrivateCloudRequest request;
  request.set_name(name);
  return connection_->GetPrivateCloud(request);
}

StatusOr<google::cloud::vmwareengine::v1::PrivateCloud>
VmwareEngineClient::GetPrivateCloud(
    google::cloud::vmwareengine::v1::GetPrivateCloudRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetPrivateCloud(request);
}

future<StatusOr<google::cloud::vmwareengine::v1::PrivateCloud>>
VmwareEngineClient::CreatePrivateCloud(
    std::string const& parent,
    google::cloud::vmwareengine::v1::PrivateCloud const& private_cloud,
    std::string const& private_cloud_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::CreatePrivateCloudRequest request;
  request.set_parent(parent);
  *request.mutable_private_cloud() = private_cloud;
  request.set_private_cloud_id(private_cloud_id);
  return connection_->CreatePrivateCloud(request);
}

StatusOr<google::longrunning::Operation> VmwareEngineClient::CreatePrivateCloud(
    NoAwaitTag, std::string const& parent,
    google::cloud::vmwareengine::v1::PrivateCloud const& private_cloud,
    std::string const& private_cloud_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::CreatePrivateCloudRequest request;
  request.set_parent(parent);
  *request.mutable_private_cloud() = private_cloud;
  request.set_private_cloud_id(private_cloud_id);
  return connection_->CreatePrivateCloud(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::vmwareengine::v1::PrivateCloud>>
VmwareEngineClient::CreatePrivateCloud(
    google::cloud::vmwareengine::v1::CreatePrivateCloudRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreatePrivateCloud(request);
}

StatusOr<google::longrunning::Operation> VmwareEngineClient::CreatePrivateCloud(
    NoAwaitTag,
    google::cloud::vmwareengine::v1::CreatePrivateCloudRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreatePrivateCloud(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::vmwareengine::v1::PrivateCloud>>
VmwareEngineClient::CreatePrivateCloud(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreatePrivateCloud(operation);
}

future<StatusOr<google::cloud::vmwareengine::v1::PrivateCloud>>
VmwareEngineClient::UpdatePrivateCloud(
    google::cloud::vmwareengine::v1::PrivateCloud const& private_cloud,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::UpdatePrivateCloudRequest request;
  *request.mutable_private_cloud() = private_cloud;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdatePrivateCloud(request);
}

StatusOr<google::longrunning::Operation> VmwareEngineClient::UpdatePrivateCloud(
    NoAwaitTag,
    google::cloud::vmwareengine::v1::PrivateCloud const& private_cloud,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::UpdatePrivateCloudRequest request;
  *request.mutable_private_cloud() = private_cloud;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdatePrivateCloud(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::vmwareengine::v1::PrivateCloud>>
VmwareEngineClient::UpdatePrivateCloud(
    google::cloud::vmwareengine::v1::UpdatePrivateCloudRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdatePrivateCloud(request);
}

StatusOr<google::longrunning::Operation> VmwareEngineClient::UpdatePrivateCloud(
    NoAwaitTag,
    google::cloud::vmwareengine::v1::UpdatePrivateCloudRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdatePrivateCloud(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::vmwareengine::v1::PrivateCloud>>
VmwareEngineClient::UpdatePrivateCloud(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdatePrivateCloud(operation);
}

future<StatusOr<google::cloud::vmwareengine::v1::PrivateCloud>>
VmwareEngineClient::DeletePrivateCloud(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::DeletePrivateCloudRequest request;
  request.set_name(name);
  return connection_->DeletePrivateCloud(request);
}

StatusOr<google::longrunning::Operation> VmwareEngineClient::DeletePrivateCloud(
    NoAwaitTag, std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::DeletePrivateCloudRequest request;
  request.set_name(name);
  return connection_->DeletePrivateCloud(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::vmwareengine::v1::PrivateCloud>>
VmwareEngineClient::DeletePrivateCloud(
    google::cloud::vmwareengine::v1::DeletePrivateCloudRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeletePrivateCloud(request);
}

StatusOr<google::longrunning::Operation> VmwareEngineClient::DeletePrivateCloud(
    NoAwaitTag,
    google::cloud::vmwareengine::v1::DeletePrivateCloudRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeletePrivateCloud(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::vmwareengine::v1::PrivateCloud>>
VmwareEngineClient::DeletePrivateCloud(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeletePrivateCloud(operation);
}

future<StatusOr<google::cloud::vmwareengine::v1::PrivateCloud>>
VmwareEngineClient::UndeletePrivateCloud(std::string const& name,
                                         Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::UndeletePrivateCloudRequest request;
  request.set_name(name);
  return connection_->UndeletePrivateCloud(request);
}

StatusOr<google::longrunning::Operation>
VmwareEngineClient::UndeletePrivateCloud(NoAwaitTag, std::string const& name,
                                         Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::UndeletePrivateCloudRequest request;
  request.set_name(name);
  return connection_->UndeletePrivateCloud(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::vmwareengine::v1::PrivateCloud>>
VmwareEngineClient::UndeletePrivateCloud(
    google::cloud::vmwareengine::v1::UndeletePrivateCloudRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UndeletePrivateCloud(request);
}

StatusOr<google::longrunning::Operation>
VmwareEngineClient::UndeletePrivateCloud(
    NoAwaitTag,
    google::cloud::vmwareengine::v1::UndeletePrivateCloudRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UndeletePrivateCloud(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::vmwareengine::v1::PrivateCloud>>
VmwareEngineClient::UndeletePrivateCloud(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UndeletePrivateCloud(operation);
}

StreamRange<google::cloud::vmwareengine::v1::Cluster>
VmwareEngineClient::ListClusters(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::ListClustersRequest request;
  request.set_parent(parent);
  return connection_->ListClusters(request);
}

StreamRange<google::cloud::vmwareengine::v1::Cluster>
VmwareEngineClient::ListClusters(
    google::cloud::vmwareengine::v1::ListClustersRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListClusters(std::move(request));
}

StatusOr<google::cloud::vmwareengine::v1::Cluster>
VmwareEngineClient::GetCluster(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::GetClusterRequest request;
  request.set_name(name);
  return connection_->GetCluster(request);
}

StatusOr<google::cloud::vmwareengine::v1::Cluster>
VmwareEngineClient::GetCluster(
    google::cloud::vmwareengine::v1::GetClusterRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetCluster(request);
}

future<StatusOr<google::cloud::vmwareengine::v1::Cluster>>
VmwareEngineClient::CreateCluster(
    std::string const& parent,
    google::cloud::vmwareengine::v1::Cluster const& cluster,
    std::string const& cluster_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::CreateClusterRequest request;
  request.set_parent(parent);
  *request.mutable_cluster() = cluster;
  request.set_cluster_id(cluster_id);
  return connection_->CreateCluster(request);
}

StatusOr<google::longrunning::Operation> VmwareEngineClient::CreateCluster(
    NoAwaitTag, std::string const& parent,
    google::cloud::vmwareengine::v1::Cluster const& cluster,
    std::string const& cluster_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::CreateClusterRequest request;
  request.set_parent(parent);
  *request.mutable_cluster() = cluster;
  request.set_cluster_id(cluster_id);
  return connection_->CreateCluster(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::vmwareengine::v1::Cluster>>
VmwareEngineClient::CreateCluster(
    google::cloud::vmwareengine::v1::CreateClusterRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateCluster(request);
}

StatusOr<google::longrunning::Operation> VmwareEngineClient::CreateCluster(
    NoAwaitTag,
    google::cloud::vmwareengine::v1::CreateClusterRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateCluster(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::vmwareengine::v1::Cluster>>
VmwareEngineClient::CreateCluster(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateCluster(operation);
}

future<StatusOr<google::cloud::vmwareengine::v1::Cluster>>
VmwareEngineClient::UpdateCluster(
    google::cloud::vmwareengine::v1::Cluster const& cluster,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::UpdateClusterRequest request;
  *request.mutable_cluster() = cluster;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateCluster(request);
}

StatusOr<google::longrunning::Operation> VmwareEngineClient::UpdateCluster(
    NoAwaitTag, google::cloud::vmwareengine::v1::Cluster const& cluster,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::UpdateClusterRequest request;
  *request.mutable_cluster() = cluster;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateCluster(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::vmwareengine::v1::Cluster>>
VmwareEngineClient::UpdateCluster(
    google::cloud::vmwareengine::v1::UpdateClusterRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateCluster(request);
}

StatusOr<google::longrunning::Operation> VmwareEngineClient::UpdateCluster(
    NoAwaitTag,
    google::cloud::vmwareengine::v1::UpdateClusterRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateCluster(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::vmwareengine::v1::Cluster>>
VmwareEngineClient::UpdateCluster(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateCluster(operation);
}

future<StatusOr<google::cloud::vmwareengine::v1::OperationMetadata>>
VmwareEngineClient::DeleteCluster(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::DeleteClusterRequest request;
  request.set_name(name);
  return connection_->DeleteCluster(request);
}

StatusOr<google::longrunning::Operation> VmwareEngineClient::DeleteCluster(
    NoAwaitTag, std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::DeleteClusterRequest request;
  request.set_name(name);
  return connection_->DeleteCluster(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::vmwareengine::v1::OperationMetadata>>
VmwareEngineClient::DeleteCluster(
    google::cloud::vmwareengine::v1::DeleteClusterRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteCluster(request);
}

StatusOr<google::longrunning::Operation> VmwareEngineClient::DeleteCluster(
    NoAwaitTag,
    google::cloud::vmwareengine::v1::DeleteClusterRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteCluster(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::vmwareengine::v1::OperationMetadata>>
VmwareEngineClient::DeleteCluster(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteCluster(operation);
}

StreamRange<google::cloud::vmwareengine::v1::Node>
VmwareEngineClient::ListNodes(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::ListNodesRequest request;
  request.set_parent(parent);
  return connection_->ListNodes(request);
}

StreamRange<google::cloud::vmwareengine::v1::Node>
VmwareEngineClient::ListNodes(
    google::cloud::vmwareengine::v1::ListNodesRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListNodes(std::move(request));
}

StatusOr<google::cloud::vmwareengine::v1::Node> VmwareEngineClient::GetNode(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::GetNodeRequest request;
  request.set_name(name);
  return connection_->GetNode(request);
}

StatusOr<google::cloud::vmwareengine::v1::Node> VmwareEngineClient::GetNode(
    google::cloud::vmwareengine::v1::GetNodeRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetNode(request);
}

StreamRange<google::cloud::vmwareengine::v1::ExternalAddress>
VmwareEngineClient::ListExternalAddresses(std::string const& parent,
                                          Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::ListExternalAddressesRequest request;
  request.set_parent(parent);
  return connection_->ListExternalAddresses(request);
}

StreamRange<google::cloud::vmwareengine::v1::ExternalAddress>
VmwareEngineClient::ListExternalAddresses(
    google::cloud::vmwareengine::v1::ListExternalAddressesRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListExternalAddresses(std::move(request));
}

StreamRange<google::cloud::vmwareengine::v1::ExternalAddress>
VmwareEngineClient::FetchNetworkPolicyExternalAddresses(
    std::string const& network_policy, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::FetchNetworkPolicyExternalAddressesRequest
      request;
  request.set_network_policy(network_policy);
  return connection_->FetchNetworkPolicyExternalAddresses(request);
}

StreamRange<google::cloud::vmwareengine::v1::ExternalAddress>
VmwareEngineClient::FetchNetworkPolicyExternalAddresses(
    google::cloud::vmwareengine::v1::FetchNetworkPolicyExternalAddressesRequest
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->FetchNetworkPolicyExternalAddresses(std::move(request));
}

StatusOr<google::cloud::vmwareengine::v1::ExternalAddress>
VmwareEngineClient::GetExternalAddress(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::GetExternalAddressRequest request;
  request.set_name(name);
  return connection_->GetExternalAddress(request);
}

StatusOr<google::cloud::vmwareengine::v1::ExternalAddress>
VmwareEngineClient::GetExternalAddress(
    google::cloud::vmwareengine::v1::GetExternalAddressRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetExternalAddress(request);
}

future<StatusOr<google::cloud::vmwareengine::v1::ExternalAddress>>
VmwareEngineClient::CreateExternalAddress(
    std::string const& parent,
    google::cloud::vmwareengine::v1::ExternalAddress const& external_address,
    std::string const& external_address_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::CreateExternalAddressRequest request;
  request.set_parent(parent);
  *request.mutable_external_address() = external_address;
  request.set_external_address_id(external_address_id);
  return connection_->CreateExternalAddress(request);
}

StatusOr<google::longrunning::Operation>
VmwareEngineClient::CreateExternalAddress(
    NoAwaitTag, std::string const& parent,
    google::cloud::vmwareengine::v1::ExternalAddress const& external_address,
    std::string const& external_address_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::CreateExternalAddressRequest request;
  request.set_parent(parent);
  *request.mutable_external_address() = external_address;
  request.set_external_address_id(external_address_id);
  return connection_->CreateExternalAddress(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::vmwareengine::v1::ExternalAddress>>
VmwareEngineClient::CreateExternalAddress(
    google::cloud::vmwareengine::v1::CreateExternalAddressRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateExternalAddress(request);
}

StatusOr<google::longrunning::Operation>
VmwareEngineClient::CreateExternalAddress(
    NoAwaitTag,
    google::cloud::vmwareengine::v1::CreateExternalAddressRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateExternalAddress(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::vmwareengine::v1::ExternalAddress>>
VmwareEngineClient::CreateExternalAddress(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateExternalAddress(operation);
}

future<StatusOr<google::cloud::vmwareengine::v1::ExternalAddress>>
VmwareEngineClient::UpdateExternalAddress(
    google::cloud::vmwareengine::v1::ExternalAddress const& external_address,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::UpdateExternalAddressRequest request;
  *request.mutable_external_address() = external_address;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateExternalAddress(request);
}

StatusOr<google::longrunning::Operation>
VmwareEngineClient::UpdateExternalAddress(
    NoAwaitTag,
    google::cloud::vmwareengine::v1::ExternalAddress const& external_address,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::UpdateExternalAddressRequest request;
  *request.mutable_external_address() = external_address;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateExternalAddress(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::vmwareengine::v1::ExternalAddress>>
VmwareEngineClient::UpdateExternalAddress(
    google::cloud::vmwareengine::v1::UpdateExternalAddressRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateExternalAddress(request);
}

StatusOr<google::longrunning::Operation>
VmwareEngineClient::UpdateExternalAddress(
    NoAwaitTag,
    google::cloud::vmwareengine::v1::UpdateExternalAddressRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateExternalAddress(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::vmwareengine::v1::ExternalAddress>>
VmwareEngineClient::UpdateExternalAddress(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateExternalAddress(operation);
}

future<StatusOr<google::cloud::vmwareengine::v1::OperationMetadata>>
VmwareEngineClient::DeleteExternalAddress(std::string const& name,
                                          Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::DeleteExternalAddressRequest request;
  request.set_name(name);
  return connection_->DeleteExternalAddress(request);
}

StatusOr<google::longrunning::Operation>
VmwareEngineClient::DeleteExternalAddress(NoAwaitTag, std::string const& name,
                                          Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::DeleteExternalAddressRequest request;
  request.set_name(name);
  return connection_->DeleteExternalAddress(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::vmwareengine::v1::OperationMetadata>>
VmwareEngineClient::DeleteExternalAddress(
    google::cloud::vmwareengine::v1::DeleteExternalAddressRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteExternalAddress(request);
}

StatusOr<google::longrunning::Operation>
VmwareEngineClient::DeleteExternalAddress(
    NoAwaitTag,
    google::cloud::vmwareengine::v1::DeleteExternalAddressRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteExternalAddress(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::vmwareengine::v1::OperationMetadata>>
VmwareEngineClient::DeleteExternalAddress(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteExternalAddress(operation);
}

StreamRange<google::cloud::vmwareengine::v1::Subnet>
VmwareEngineClient::ListSubnets(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::ListSubnetsRequest request;
  request.set_parent(parent);
  return connection_->ListSubnets(request);
}

StreamRange<google::cloud::vmwareengine::v1::Subnet>
VmwareEngineClient::ListSubnets(
    google::cloud::vmwareengine::v1::ListSubnetsRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListSubnets(std::move(request));
}

StatusOr<google::cloud::vmwareengine::v1::Subnet> VmwareEngineClient::GetSubnet(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::GetSubnetRequest request;
  request.set_name(name);
  return connection_->GetSubnet(request);
}

StatusOr<google::cloud::vmwareengine::v1::Subnet> VmwareEngineClient::GetSubnet(
    google::cloud::vmwareengine::v1::GetSubnetRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetSubnet(request);
}

future<StatusOr<google::cloud::vmwareengine::v1::Subnet>>
VmwareEngineClient::UpdateSubnet(
    google::cloud::vmwareengine::v1::Subnet const& subnet,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::UpdateSubnetRequest request;
  *request.mutable_subnet() = subnet;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateSubnet(request);
}

StatusOr<google::longrunning::Operation> VmwareEngineClient::UpdateSubnet(
    NoAwaitTag, google::cloud::vmwareengine::v1::Subnet const& subnet,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::UpdateSubnetRequest request;
  *request.mutable_subnet() = subnet;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateSubnet(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::vmwareengine::v1::Subnet>>
VmwareEngineClient::UpdateSubnet(
    google::cloud::vmwareengine::v1::UpdateSubnetRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateSubnet(request);
}

StatusOr<google::longrunning::Operation> VmwareEngineClient::UpdateSubnet(
    NoAwaitTag,
    google::cloud::vmwareengine::v1::UpdateSubnetRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateSubnet(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::vmwareengine::v1::Subnet>>
VmwareEngineClient::UpdateSubnet(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateSubnet(operation);
}

StreamRange<google::cloud::vmwareengine::v1::ExternalAccessRule>
VmwareEngineClient::ListExternalAccessRules(std::string const& parent,
                                            Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::ListExternalAccessRulesRequest request;
  request.set_parent(parent);
  return connection_->ListExternalAccessRules(request);
}

StreamRange<google::cloud::vmwareengine::v1::ExternalAccessRule>
VmwareEngineClient::ListExternalAccessRules(
    google::cloud::vmwareengine::v1::ListExternalAccessRulesRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListExternalAccessRules(std::move(request));
}

StatusOr<google::cloud::vmwareengine::v1::ExternalAccessRule>
VmwareEngineClient::GetExternalAccessRule(std::string const& name,
                                          Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::GetExternalAccessRuleRequest request;
  request.set_name(name);
  return connection_->GetExternalAccessRule(request);
}

StatusOr<google::cloud::vmwareengine::v1::ExternalAccessRule>
VmwareEngineClient::GetExternalAccessRule(
    google::cloud::vmwareengine::v1::GetExternalAccessRuleRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetExternalAccessRule(request);
}

future<StatusOr<google::cloud::vmwareengine::v1::ExternalAccessRule>>
VmwareEngineClient::CreateExternalAccessRule(
    std::string const& parent,
    google::cloud::vmwareengine::v1::ExternalAccessRule const&
        external_access_rule,
    std::string const& external_access_rule_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::CreateExternalAccessRuleRequest request;
  request.set_parent(parent);
  *request.mutable_external_access_rule() = external_access_rule;
  request.set_external_access_rule_id(external_access_rule_id);
  return connection_->CreateExternalAccessRule(request);
}

StatusOr<google::longrunning::Operation>
VmwareEngineClient::CreateExternalAccessRule(
    NoAwaitTag, std::string const& parent,
    google::cloud::vmwareengine::v1::ExternalAccessRule const&
        external_access_rule,
    std::string const& external_access_rule_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::CreateExternalAccessRuleRequest request;
  request.set_parent(parent);
  *request.mutable_external_access_rule() = external_access_rule;
  request.set_external_access_rule_id(external_access_rule_id);
  return connection_->CreateExternalAccessRule(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::vmwareengine::v1::ExternalAccessRule>>
VmwareEngineClient::CreateExternalAccessRule(
    google::cloud::vmwareengine::v1::CreateExternalAccessRuleRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateExternalAccessRule(request);
}

StatusOr<google::longrunning::Operation>
VmwareEngineClient::CreateExternalAccessRule(
    NoAwaitTag,
    google::cloud::vmwareengine::v1::CreateExternalAccessRuleRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateExternalAccessRule(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::vmwareengine::v1::ExternalAccessRule>>
VmwareEngineClient::CreateExternalAccessRule(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateExternalAccessRule(operation);
}

future<StatusOr<google::cloud::vmwareengine::v1::ExternalAccessRule>>
VmwareEngineClient::UpdateExternalAccessRule(
    google::cloud::vmwareengine::v1::ExternalAccessRule const&
        external_access_rule,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::UpdateExternalAccessRuleRequest request;
  *request.mutable_external_access_rule() = external_access_rule;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateExternalAccessRule(request);
}

StatusOr<google::longrunning::Operation>
VmwareEngineClient::UpdateExternalAccessRule(
    NoAwaitTag,
    google::cloud::vmwareengine::v1::ExternalAccessRule const&
        external_access_rule,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::UpdateExternalAccessRuleRequest request;
  *request.mutable_external_access_rule() = external_access_rule;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateExternalAccessRule(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::vmwareengine::v1::ExternalAccessRule>>
VmwareEngineClient::UpdateExternalAccessRule(
    google::cloud::vmwareengine::v1::UpdateExternalAccessRuleRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateExternalAccessRule(request);
}

StatusOr<google::longrunning::Operation>
VmwareEngineClient::UpdateExternalAccessRule(
    NoAwaitTag,
    google::cloud::vmwareengine::v1::UpdateExternalAccessRuleRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateExternalAccessRule(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::vmwareengine::v1::ExternalAccessRule>>
VmwareEngineClient::UpdateExternalAccessRule(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateExternalAccessRule(operation);
}

future<StatusOr<google::cloud::vmwareengine::v1::OperationMetadata>>
VmwareEngineClient::DeleteExternalAccessRule(std::string const& name,
                                             Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::DeleteExternalAccessRuleRequest request;
  request.set_name(name);
  return connection_->DeleteExternalAccessRule(request);
}

StatusOr<google::longrunning::Operation>
VmwareEngineClient::DeleteExternalAccessRule(NoAwaitTag,
                                             std::string const& name,
                                             Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::DeleteExternalAccessRuleRequest request;
  request.set_name(name);
  return connection_->DeleteExternalAccessRule(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::vmwareengine::v1::OperationMetadata>>
VmwareEngineClient::DeleteExternalAccessRule(
    google::cloud::vmwareengine::v1::DeleteExternalAccessRuleRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteExternalAccessRule(request);
}

StatusOr<google::longrunning::Operation>
VmwareEngineClient::DeleteExternalAccessRule(
    NoAwaitTag,
    google::cloud::vmwareengine::v1::DeleteExternalAccessRuleRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteExternalAccessRule(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::vmwareengine::v1::OperationMetadata>>
VmwareEngineClient::DeleteExternalAccessRule(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteExternalAccessRule(operation);
}

StreamRange<google::cloud::vmwareengine::v1::LoggingServer>
VmwareEngineClient::ListLoggingServers(std::string const& parent,
                                       Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::ListLoggingServersRequest request;
  request.set_parent(parent);
  return connection_->ListLoggingServers(request);
}

StreamRange<google::cloud::vmwareengine::v1::LoggingServer>
VmwareEngineClient::ListLoggingServers(
    google::cloud::vmwareengine::v1::ListLoggingServersRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListLoggingServers(std::move(request));
}

StatusOr<google::cloud::vmwareengine::v1::LoggingServer>
VmwareEngineClient::GetLoggingServer(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::GetLoggingServerRequest request;
  request.set_name(name);
  return connection_->GetLoggingServer(request);
}

StatusOr<google::cloud::vmwareengine::v1::LoggingServer>
VmwareEngineClient::GetLoggingServer(
    google::cloud::vmwareengine::v1::GetLoggingServerRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetLoggingServer(request);
}

future<StatusOr<google::cloud::vmwareengine::v1::LoggingServer>>
VmwareEngineClient::CreateLoggingServer(
    std::string const& parent,
    google::cloud::vmwareengine::v1::LoggingServer const& logging_server,
    std::string const& logging_server_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::CreateLoggingServerRequest request;
  request.set_parent(parent);
  *request.mutable_logging_server() = logging_server;
  request.set_logging_server_id(logging_server_id);
  return connection_->CreateLoggingServer(request);
}

StatusOr<google::longrunning::Operation>
VmwareEngineClient::CreateLoggingServer(
    NoAwaitTag, std::string const& parent,
    google::cloud::vmwareengine::v1::LoggingServer const& logging_server,
    std::string const& logging_server_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::CreateLoggingServerRequest request;
  request.set_parent(parent);
  *request.mutable_logging_server() = logging_server;
  request.set_logging_server_id(logging_server_id);
  return connection_->CreateLoggingServer(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::vmwareengine::v1::LoggingServer>>
VmwareEngineClient::CreateLoggingServer(
    google::cloud::vmwareengine::v1::CreateLoggingServerRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateLoggingServer(request);
}

StatusOr<google::longrunning::Operation>
VmwareEngineClient::CreateLoggingServer(
    NoAwaitTag,
    google::cloud::vmwareengine::v1::CreateLoggingServerRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateLoggingServer(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::vmwareengine::v1::LoggingServer>>
VmwareEngineClient::CreateLoggingServer(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateLoggingServer(operation);
}

future<StatusOr<google::cloud::vmwareengine::v1::LoggingServer>>
VmwareEngineClient::UpdateLoggingServer(
    google::cloud::vmwareengine::v1::LoggingServer const& logging_server,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::UpdateLoggingServerRequest request;
  *request.mutable_logging_server() = logging_server;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateLoggingServer(request);
}

StatusOr<google::longrunning::Operation>
VmwareEngineClient::UpdateLoggingServer(
    NoAwaitTag,
    google::cloud::vmwareengine::v1::LoggingServer const& logging_server,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::UpdateLoggingServerRequest request;
  *request.mutable_logging_server() = logging_server;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateLoggingServer(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::vmwareengine::v1::LoggingServer>>
VmwareEngineClient::UpdateLoggingServer(
    google::cloud::vmwareengine::v1::UpdateLoggingServerRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateLoggingServer(request);
}

StatusOr<google::longrunning::Operation>
VmwareEngineClient::UpdateLoggingServer(
    NoAwaitTag,
    google::cloud::vmwareengine::v1::UpdateLoggingServerRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateLoggingServer(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::vmwareengine::v1::LoggingServer>>
VmwareEngineClient::UpdateLoggingServer(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateLoggingServer(operation);
}

future<StatusOr<google::cloud::vmwareengine::v1::OperationMetadata>>
VmwareEngineClient::DeleteLoggingServer(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::DeleteLoggingServerRequest request;
  request.set_name(name);
  return connection_->DeleteLoggingServer(request);
}

StatusOr<google::longrunning::Operation>
VmwareEngineClient::DeleteLoggingServer(NoAwaitTag, std::string const& name,
                                        Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::DeleteLoggingServerRequest request;
  request.set_name(name);
  return connection_->DeleteLoggingServer(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::vmwareengine::v1::OperationMetadata>>
VmwareEngineClient::DeleteLoggingServer(
    google::cloud::vmwareengine::v1::DeleteLoggingServerRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteLoggingServer(request);
}

StatusOr<google::longrunning::Operation>
VmwareEngineClient::DeleteLoggingServer(
    NoAwaitTag,
    google::cloud::vmwareengine::v1::DeleteLoggingServerRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteLoggingServer(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::vmwareengine::v1::OperationMetadata>>
VmwareEngineClient::DeleteLoggingServer(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteLoggingServer(operation);
}

StreamRange<google::cloud::vmwareengine::v1::NodeType>
VmwareEngineClient::ListNodeTypes(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::ListNodeTypesRequest request;
  request.set_parent(parent);
  return connection_->ListNodeTypes(request);
}

StreamRange<google::cloud::vmwareengine::v1::NodeType>
VmwareEngineClient::ListNodeTypes(
    google::cloud::vmwareengine::v1::ListNodeTypesRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListNodeTypes(std::move(request));
}

StatusOr<google::cloud::vmwareengine::v1::NodeType>
VmwareEngineClient::GetNodeType(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::GetNodeTypeRequest request;
  request.set_name(name);
  return connection_->GetNodeType(request);
}

StatusOr<google::cloud::vmwareengine::v1::NodeType>
VmwareEngineClient::GetNodeType(
    google::cloud::vmwareengine::v1::GetNodeTypeRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetNodeType(request);
}

StatusOr<google::cloud::vmwareengine::v1::Credentials>
VmwareEngineClient::ShowNsxCredentials(std::string const& private_cloud,
                                       Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::ShowNsxCredentialsRequest request;
  request.set_private_cloud(private_cloud);
  return connection_->ShowNsxCredentials(request);
}

StatusOr<google::cloud::vmwareengine::v1::Credentials>
VmwareEngineClient::ShowNsxCredentials(
    google::cloud::vmwareengine::v1::ShowNsxCredentialsRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ShowNsxCredentials(request);
}

StatusOr<google::cloud::vmwareengine::v1::Credentials>
VmwareEngineClient::ShowVcenterCredentials(std::string const& private_cloud,
                                           Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::ShowVcenterCredentialsRequest request;
  request.set_private_cloud(private_cloud);
  return connection_->ShowVcenterCredentials(request);
}

StatusOr<google::cloud::vmwareengine::v1::Credentials>
VmwareEngineClient::ShowVcenterCredentials(
    google::cloud::vmwareengine::v1::ShowVcenterCredentialsRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ShowVcenterCredentials(request);
}

future<StatusOr<google::cloud::vmwareengine::v1::PrivateCloud>>
VmwareEngineClient::ResetNsxCredentials(std::string const& private_cloud,
                                        Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::ResetNsxCredentialsRequest request;
  request.set_private_cloud(private_cloud);
  return connection_->ResetNsxCredentials(request);
}

StatusOr<google::longrunning::Operation>
VmwareEngineClient::ResetNsxCredentials(NoAwaitTag,
                                        std::string const& private_cloud,
                                        Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::ResetNsxCredentialsRequest request;
  request.set_private_cloud(private_cloud);
  return connection_->ResetNsxCredentials(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::vmwareengine::v1::PrivateCloud>>
VmwareEngineClient::ResetNsxCredentials(
    google::cloud::vmwareengine::v1::ResetNsxCredentialsRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ResetNsxCredentials(request);
}

StatusOr<google::longrunning::Operation>
VmwareEngineClient::ResetNsxCredentials(
    NoAwaitTag,
    google::cloud::vmwareengine::v1::ResetNsxCredentialsRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ResetNsxCredentials(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::vmwareengine::v1::PrivateCloud>>
VmwareEngineClient::ResetNsxCredentials(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ResetNsxCredentials(operation);
}

future<StatusOr<google::cloud::vmwareengine::v1::PrivateCloud>>
VmwareEngineClient::ResetVcenterCredentials(std::string const& private_cloud,
                                            Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::ResetVcenterCredentialsRequest request;
  request.set_private_cloud(private_cloud);
  return connection_->ResetVcenterCredentials(request);
}

StatusOr<google::longrunning::Operation>
VmwareEngineClient::ResetVcenterCredentials(NoAwaitTag,
                                            std::string const& private_cloud,
                                            Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::ResetVcenterCredentialsRequest request;
  request.set_private_cloud(private_cloud);
  return connection_->ResetVcenterCredentials(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::vmwareengine::v1::PrivateCloud>>
VmwareEngineClient::ResetVcenterCredentials(
    google::cloud::vmwareengine::v1::ResetVcenterCredentialsRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ResetVcenterCredentials(request);
}

StatusOr<google::longrunning::Operation>
VmwareEngineClient::ResetVcenterCredentials(
    NoAwaitTag,
    google::cloud::vmwareengine::v1::ResetVcenterCredentialsRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ResetVcenterCredentials(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::vmwareengine::v1::PrivateCloud>>
VmwareEngineClient::ResetVcenterCredentials(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ResetVcenterCredentials(operation);
}

StatusOr<google::cloud::vmwareengine::v1::DnsForwarding>
VmwareEngineClient::GetDnsForwarding(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::GetDnsForwardingRequest request;
  request.set_name(name);
  return connection_->GetDnsForwarding(request);
}

StatusOr<google::cloud::vmwareengine::v1::DnsForwarding>
VmwareEngineClient::GetDnsForwarding(
    google::cloud::vmwareengine::v1::GetDnsForwardingRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetDnsForwarding(request);
}

future<StatusOr<google::cloud::vmwareengine::v1::DnsForwarding>>
VmwareEngineClient::UpdateDnsForwarding(
    google::cloud::vmwareengine::v1::DnsForwarding const& dns_forwarding,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::UpdateDnsForwardingRequest request;
  *request.mutable_dns_forwarding() = dns_forwarding;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateDnsForwarding(request);
}

StatusOr<google::longrunning::Operation>
VmwareEngineClient::UpdateDnsForwarding(
    NoAwaitTag,
    google::cloud::vmwareengine::v1::DnsForwarding const& dns_forwarding,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::UpdateDnsForwardingRequest request;
  *request.mutable_dns_forwarding() = dns_forwarding;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateDnsForwarding(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::vmwareengine::v1::DnsForwarding>>
VmwareEngineClient::UpdateDnsForwarding(
    google::cloud::vmwareengine::v1::UpdateDnsForwardingRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateDnsForwarding(request);
}

StatusOr<google::longrunning::Operation>
VmwareEngineClient::UpdateDnsForwarding(
    NoAwaitTag,
    google::cloud::vmwareengine::v1::UpdateDnsForwardingRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateDnsForwarding(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::vmwareengine::v1::DnsForwarding>>
VmwareEngineClient::UpdateDnsForwarding(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateDnsForwarding(operation);
}

StatusOr<google::cloud::vmwareengine::v1::NetworkPeering>
VmwareEngineClient::GetNetworkPeering(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::GetNetworkPeeringRequest request;
  request.set_name(name);
  return connection_->GetNetworkPeering(request);
}

StatusOr<google::cloud::vmwareengine::v1::NetworkPeering>
VmwareEngineClient::GetNetworkPeering(
    google::cloud::vmwareengine::v1::GetNetworkPeeringRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetNetworkPeering(request);
}

StreamRange<google::cloud::vmwareengine::v1::NetworkPeering>
VmwareEngineClient::ListNetworkPeerings(std::string const& parent,
                                        Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::ListNetworkPeeringsRequest request;
  request.set_parent(parent);
  return connection_->ListNetworkPeerings(request);
}

StreamRange<google::cloud::vmwareengine::v1::NetworkPeering>
VmwareEngineClient::ListNetworkPeerings(
    google::cloud::vmwareengine::v1::ListNetworkPeeringsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListNetworkPeerings(std::move(request));
}

future<StatusOr<google::cloud::vmwareengine::v1::NetworkPeering>>
VmwareEngineClient::CreateNetworkPeering(
    std::string const& parent,
    google::cloud::vmwareengine::v1::NetworkPeering const& network_peering,
    std::string const& network_peering_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::CreateNetworkPeeringRequest request;
  request.set_parent(parent);
  *request.mutable_network_peering() = network_peering;
  request.set_network_peering_id(network_peering_id);
  return connection_->CreateNetworkPeering(request);
}

StatusOr<google::longrunning::Operation>
VmwareEngineClient::CreateNetworkPeering(
    NoAwaitTag, std::string const& parent,
    google::cloud::vmwareengine::v1::NetworkPeering const& network_peering,
    std::string const& network_peering_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::CreateNetworkPeeringRequest request;
  request.set_parent(parent);
  *request.mutable_network_peering() = network_peering;
  request.set_network_peering_id(network_peering_id);
  return connection_->CreateNetworkPeering(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::vmwareengine::v1::NetworkPeering>>
VmwareEngineClient::CreateNetworkPeering(
    google::cloud::vmwareengine::v1::CreateNetworkPeeringRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateNetworkPeering(request);
}

StatusOr<google::longrunning::Operation>
VmwareEngineClient::CreateNetworkPeering(
    NoAwaitTag,
    google::cloud::vmwareengine::v1::CreateNetworkPeeringRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateNetworkPeering(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::vmwareengine::v1::NetworkPeering>>
VmwareEngineClient::CreateNetworkPeering(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateNetworkPeering(operation);
}

future<StatusOr<google::cloud::vmwareengine::v1::OperationMetadata>>
VmwareEngineClient::DeleteNetworkPeering(std::string const& name,
                                         Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::DeleteNetworkPeeringRequest request;
  request.set_name(name);
  return connection_->DeleteNetworkPeering(request);
}

StatusOr<google::longrunning::Operation>
VmwareEngineClient::DeleteNetworkPeering(NoAwaitTag, std::string const& name,
                                         Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::DeleteNetworkPeeringRequest request;
  request.set_name(name);
  return connection_->DeleteNetworkPeering(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::vmwareengine::v1::OperationMetadata>>
VmwareEngineClient::DeleteNetworkPeering(
    google::cloud::vmwareengine::v1::DeleteNetworkPeeringRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteNetworkPeering(request);
}

StatusOr<google::longrunning::Operation>
VmwareEngineClient::DeleteNetworkPeering(
    NoAwaitTag,
    google::cloud::vmwareengine::v1::DeleteNetworkPeeringRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteNetworkPeering(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::vmwareengine::v1::OperationMetadata>>
VmwareEngineClient::DeleteNetworkPeering(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteNetworkPeering(operation);
}

future<StatusOr<google::cloud::vmwareengine::v1::NetworkPeering>>
VmwareEngineClient::UpdateNetworkPeering(
    google::cloud::vmwareengine::v1::NetworkPeering const& network_peering,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::UpdateNetworkPeeringRequest request;
  *request.mutable_network_peering() = network_peering;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateNetworkPeering(request);
}

StatusOr<google::longrunning::Operation>
VmwareEngineClient::UpdateNetworkPeering(
    NoAwaitTag,
    google::cloud::vmwareengine::v1::NetworkPeering const& network_peering,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::UpdateNetworkPeeringRequest request;
  *request.mutable_network_peering() = network_peering;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateNetworkPeering(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::vmwareengine::v1::NetworkPeering>>
VmwareEngineClient::UpdateNetworkPeering(
    google::cloud::vmwareengine::v1::UpdateNetworkPeeringRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateNetworkPeering(request);
}

StatusOr<google::longrunning::Operation>
VmwareEngineClient::UpdateNetworkPeering(
    NoAwaitTag,
    google::cloud::vmwareengine::v1::UpdateNetworkPeeringRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateNetworkPeering(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::vmwareengine::v1::NetworkPeering>>
VmwareEngineClient::UpdateNetworkPeering(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateNetworkPeering(operation);
}

StreamRange<google::cloud::vmwareengine::v1::PeeringRoute>
VmwareEngineClient::ListPeeringRoutes(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::ListPeeringRoutesRequest request;
  request.set_parent(parent);
  return connection_->ListPeeringRoutes(request);
}

StreamRange<google::cloud::vmwareengine::v1::PeeringRoute>
VmwareEngineClient::ListPeeringRoutes(
    google::cloud::vmwareengine::v1::ListPeeringRoutesRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListPeeringRoutes(std::move(request));
}

future<StatusOr<google::cloud::vmwareengine::v1::HcxActivationKey>>
VmwareEngineClient::CreateHcxActivationKey(
    std::string const& parent,
    google::cloud::vmwareengine::v1::HcxActivationKey const& hcx_activation_key,
    std::string const& hcx_activation_key_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::CreateHcxActivationKeyRequest request;
  request.set_parent(parent);
  *request.mutable_hcx_activation_key() = hcx_activation_key;
  request.set_hcx_activation_key_id(hcx_activation_key_id);
  return connection_->CreateHcxActivationKey(request);
}

StatusOr<google::longrunning::Operation>
VmwareEngineClient::CreateHcxActivationKey(
    NoAwaitTag, std::string const& parent,
    google::cloud::vmwareengine::v1::HcxActivationKey const& hcx_activation_key,
    std::string const& hcx_activation_key_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::CreateHcxActivationKeyRequest request;
  request.set_parent(parent);
  *request.mutable_hcx_activation_key() = hcx_activation_key;
  request.set_hcx_activation_key_id(hcx_activation_key_id);
  return connection_->CreateHcxActivationKey(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::vmwareengine::v1::HcxActivationKey>>
VmwareEngineClient::CreateHcxActivationKey(
    google::cloud::vmwareengine::v1::CreateHcxActivationKeyRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateHcxActivationKey(request);
}

StatusOr<google::longrunning::Operation>
VmwareEngineClient::CreateHcxActivationKey(
    NoAwaitTag,
    google::cloud::vmwareengine::v1::CreateHcxActivationKeyRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateHcxActivationKey(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::vmwareengine::v1::HcxActivationKey>>
VmwareEngineClient::CreateHcxActivationKey(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateHcxActivationKey(operation);
}

StreamRange<google::cloud::vmwareengine::v1::HcxActivationKey>
VmwareEngineClient::ListHcxActivationKeys(std::string const& parent,
                                          Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::ListHcxActivationKeysRequest request;
  request.set_parent(parent);
  return connection_->ListHcxActivationKeys(request);
}

StreamRange<google::cloud::vmwareengine::v1::HcxActivationKey>
VmwareEngineClient::ListHcxActivationKeys(
    google::cloud::vmwareengine::v1::ListHcxActivationKeysRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListHcxActivationKeys(std::move(request));
}

StatusOr<google::cloud::vmwareengine::v1::HcxActivationKey>
VmwareEngineClient::GetHcxActivationKey(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::GetHcxActivationKeyRequest request;
  request.set_name(name);
  return connection_->GetHcxActivationKey(request);
}

StatusOr<google::cloud::vmwareengine::v1::HcxActivationKey>
VmwareEngineClient::GetHcxActivationKey(
    google::cloud::vmwareengine::v1::GetHcxActivationKeyRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetHcxActivationKey(request);
}

StatusOr<google::cloud::vmwareengine::v1::NetworkPolicy>
VmwareEngineClient::GetNetworkPolicy(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::GetNetworkPolicyRequest request;
  request.set_name(name);
  return connection_->GetNetworkPolicy(request);
}

StatusOr<google::cloud::vmwareengine::v1::NetworkPolicy>
VmwareEngineClient::GetNetworkPolicy(
    google::cloud::vmwareengine::v1::GetNetworkPolicyRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetNetworkPolicy(request);
}

StreamRange<google::cloud::vmwareengine::v1::NetworkPolicy>
VmwareEngineClient::ListNetworkPolicies(std::string const& parent,
                                        Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::ListNetworkPoliciesRequest request;
  request.set_parent(parent);
  return connection_->ListNetworkPolicies(request);
}

StreamRange<google::cloud::vmwareengine::v1::NetworkPolicy>
VmwareEngineClient::ListNetworkPolicies(
    google::cloud::vmwareengine::v1::ListNetworkPoliciesRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListNetworkPolicies(std::move(request));
}

future<StatusOr<google::cloud::vmwareengine::v1::NetworkPolicy>>
VmwareEngineClient::CreateNetworkPolicy(
    std::string const& parent,
    google::cloud::vmwareengine::v1::NetworkPolicy const& network_policy,
    std::string const& network_policy_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::CreateNetworkPolicyRequest request;
  request.set_parent(parent);
  *request.mutable_network_policy() = network_policy;
  request.set_network_policy_id(network_policy_id);
  return connection_->CreateNetworkPolicy(request);
}

StatusOr<google::longrunning::Operation>
VmwareEngineClient::CreateNetworkPolicy(
    NoAwaitTag, std::string const& parent,
    google::cloud::vmwareengine::v1::NetworkPolicy const& network_policy,
    std::string const& network_policy_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::CreateNetworkPolicyRequest request;
  request.set_parent(parent);
  *request.mutable_network_policy() = network_policy;
  request.set_network_policy_id(network_policy_id);
  return connection_->CreateNetworkPolicy(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::vmwareengine::v1::NetworkPolicy>>
VmwareEngineClient::CreateNetworkPolicy(
    google::cloud::vmwareengine::v1::CreateNetworkPolicyRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateNetworkPolicy(request);
}

StatusOr<google::longrunning::Operation>
VmwareEngineClient::CreateNetworkPolicy(
    NoAwaitTag,
    google::cloud::vmwareengine::v1::CreateNetworkPolicyRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateNetworkPolicy(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::vmwareengine::v1::NetworkPolicy>>
VmwareEngineClient::CreateNetworkPolicy(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateNetworkPolicy(operation);
}

future<StatusOr<google::cloud::vmwareengine::v1::NetworkPolicy>>
VmwareEngineClient::UpdateNetworkPolicy(
    google::cloud::vmwareengine::v1::NetworkPolicy const& network_policy,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::UpdateNetworkPolicyRequest request;
  *request.mutable_network_policy() = network_policy;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateNetworkPolicy(request);
}

StatusOr<google::longrunning::Operation>
VmwareEngineClient::UpdateNetworkPolicy(
    NoAwaitTag,
    google::cloud::vmwareengine::v1::NetworkPolicy const& network_policy,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::UpdateNetworkPolicyRequest request;
  *request.mutable_network_policy() = network_policy;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateNetworkPolicy(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::vmwareengine::v1::NetworkPolicy>>
VmwareEngineClient::UpdateNetworkPolicy(
    google::cloud::vmwareengine::v1::UpdateNetworkPolicyRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateNetworkPolicy(request);
}

StatusOr<google::longrunning::Operation>
VmwareEngineClient::UpdateNetworkPolicy(
    NoAwaitTag,
    google::cloud::vmwareengine::v1::UpdateNetworkPolicyRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateNetworkPolicy(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::vmwareengine::v1::NetworkPolicy>>
VmwareEngineClient::UpdateNetworkPolicy(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateNetworkPolicy(operation);
}

future<StatusOr<google::cloud::vmwareengine::v1::OperationMetadata>>
VmwareEngineClient::DeleteNetworkPolicy(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::DeleteNetworkPolicyRequest request;
  request.set_name(name);
  return connection_->DeleteNetworkPolicy(request);
}

StatusOr<google::longrunning::Operation>
VmwareEngineClient::DeleteNetworkPolicy(NoAwaitTag, std::string const& name,
                                        Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::DeleteNetworkPolicyRequest request;
  request.set_name(name);
  return connection_->DeleteNetworkPolicy(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::vmwareengine::v1::OperationMetadata>>
VmwareEngineClient::DeleteNetworkPolicy(
    google::cloud::vmwareengine::v1::DeleteNetworkPolicyRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteNetworkPolicy(request);
}

StatusOr<google::longrunning::Operation>
VmwareEngineClient::DeleteNetworkPolicy(
    NoAwaitTag,
    google::cloud::vmwareengine::v1::DeleteNetworkPolicyRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteNetworkPolicy(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::vmwareengine::v1::OperationMetadata>>
VmwareEngineClient::DeleteNetworkPolicy(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteNetworkPolicy(operation);
}

StreamRange<google::cloud::vmwareengine::v1::ManagementDnsZoneBinding>
VmwareEngineClient::ListManagementDnsZoneBindings(std::string const& parent,
                                                  Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::ListManagementDnsZoneBindingsRequest request;
  request.set_parent(parent);
  return connection_->ListManagementDnsZoneBindings(request);
}

StreamRange<google::cloud::vmwareengine::v1::ManagementDnsZoneBinding>
VmwareEngineClient::ListManagementDnsZoneBindings(
    google::cloud::vmwareengine::v1::ListManagementDnsZoneBindingsRequest
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListManagementDnsZoneBindings(std::move(request));
}

StatusOr<google::cloud::vmwareengine::v1::ManagementDnsZoneBinding>
VmwareEngineClient::GetManagementDnsZoneBinding(std::string const& name,
                                                Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::GetManagementDnsZoneBindingRequest request;
  request.set_name(name);
  return connection_->GetManagementDnsZoneBinding(request);
}

StatusOr<google::cloud::vmwareengine::v1::ManagementDnsZoneBinding>
VmwareEngineClient::GetManagementDnsZoneBinding(
    google::cloud::vmwareengine::v1::GetManagementDnsZoneBindingRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetManagementDnsZoneBinding(request);
}

future<StatusOr<google::cloud::vmwareengine::v1::ManagementDnsZoneBinding>>
VmwareEngineClient::CreateManagementDnsZoneBinding(
    std::string const& parent,
    google::cloud::vmwareengine::v1::ManagementDnsZoneBinding const&
        management_dns_zone_binding,
    std::string const& management_dns_zone_binding_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::CreateManagementDnsZoneBindingRequest
      request;
  request.set_parent(parent);
  *request.mutable_management_dns_zone_binding() = management_dns_zone_binding;
  request.set_management_dns_zone_binding_id(management_dns_zone_binding_id);
  return connection_->CreateManagementDnsZoneBinding(request);
}

StatusOr<google::longrunning::Operation>
VmwareEngineClient::CreateManagementDnsZoneBinding(
    NoAwaitTag, std::string const& parent,
    google::cloud::vmwareengine::v1::ManagementDnsZoneBinding const&
        management_dns_zone_binding,
    std::string const& management_dns_zone_binding_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::CreateManagementDnsZoneBindingRequest
      request;
  request.set_parent(parent);
  *request.mutable_management_dns_zone_binding() = management_dns_zone_binding;
  request.set_management_dns_zone_binding_id(management_dns_zone_binding_id);
  return connection_->CreateManagementDnsZoneBinding(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::vmwareengine::v1::ManagementDnsZoneBinding>>
VmwareEngineClient::CreateManagementDnsZoneBinding(
    google::cloud::vmwareengine::v1::
        CreateManagementDnsZoneBindingRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateManagementDnsZoneBinding(request);
}

StatusOr<google::longrunning::Operation>
VmwareEngineClient::CreateManagementDnsZoneBinding(
    NoAwaitTag,
    google::cloud::vmwareengine::v1::
        CreateManagementDnsZoneBindingRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateManagementDnsZoneBinding(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::vmwareengine::v1::ManagementDnsZoneBinding>>
VmwareEngineClient::CreateManagementDnsZoneBinding(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateManagementDnsZoneBinding(operation);
}

future<StatusOr<google::cloud::vmwareengine::v1::ManagementDnsZoneBinding>>
VmwareEngineClient::UpdateManagementDnsZoneBinding(
    google::cloud::vmwareengine::v1::ManagementDnsZoneBinding const&
        management_dns_zone_binding,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::UpdateManagementDnsZoneBindingRequest
      request;
  *request.mutable_management_dns_zone_binding() = management_dns_zone_binding;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateManagementDnsZoneBinding(request);
}

StatusOr<google::longrunning::Operation>
VmwareEngineClient::UpdateManagementDnsZoneBinding(
    NoAwaitTag,
    google::cloud::vmwareengine::v1::ManagementDnsZoneBinding const&
        management_dns_zone_binding,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::UpdateManagementDnsZoneBindingRequest
      request;
  *request.mutable_management_dns_zone_binding() = management_dns_zone_binding;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateManagementDnsZoneBinding(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::vmwareengine::v1::ManagementDnsZoneBinding>>
VmwareEngineClient::UpdateManagementDnsZoneBinding(
    google::cloud::vmwareengine::v1::
        UpdateManagementDnsZoneBindingRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateManagementDnsZoneBinding(request);
}

StatusOr<google::longrunning::Operation>
VmwareEngineClient::UpdateManagementDnsZoneBinding(
    NoAwaitTag,
    google::cloud::vmwareengine::v1::
        UpdateManagementDnsZoneBindingRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateManagementDnsZoneBinding(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::vmwareengine::v1::ManagementDnsZoneBinding>>
VmwareEngineClient::UpdateManagementDnsZoneBinding(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateManagementDnsZoneBinding(operation);
}

future<StatusOr<google::cloud::vmwareengine::v1::OperationMetadata>>
VmwareEngineClient::DeleteManagementDnsZoneBinding(std::string const& name,
                                                   Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::DeleteManagementDnsZoneBindingRequest
      request;
  request.set_name(name);
  return connection_->DeleteManagementDnsZoneBinding(request);
}

StatusOr<google::longrunning::Operation>
VmwareEngineClient::DeleteManagementDnsZoneBinding(NoAwaitTag,
                                                   std::string const& name,
                                                   Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::DeleteManagementDnsZoneBindingRequest
      request;
  request.set_name(name);
  return connection_->DeleteManagementDnsZoneBinding(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::vmwareengine::v1::OperationMetadata>>
VmwareEngineClient::DeleteManagementDnsZoneBinding(
    google::cloud::vmwareengine::v1::
        DeleteManagementDnsZoneBindingRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteManagementDnsZoneBinding(request);
}

StatusOr<google::longrunning::Operation>
VmwareEngineClient::DeleteManagementDnsZoneBinding(
    NoAwaitTag,
    google::cloud::vmwareengine::v1::
        DeleteManagementDnsZoneBindingRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteManagementDnsZoneBinding(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::vmwareengine::v1::OperationMetadata>>
VmwareEngineClient::DeleteManagementDnsZoneBinding(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteManagementDnsZoneBinding(operation);
}

future<StatusOr<google::cloud::vmwareengine::v1::ManagementDnsZoneBinding>>
VmwareEngineClient::RepairManagementDnsZoneBinding(std::string const& name,
                                                   Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::RepairManagementDnsZoneBindingRequest
      request;
  request.set_name(name);
  return connection_->RepairManagementDnsZoneBinding(request);
}

StatusOr<google::longrunning::Operation>
VmwareEngineClient::RepairManagementDnsZoneBinding(NoAwaitTag,
                                                   std::string const& name,
                                                   Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::RepairManagementDnsZoneBindingRequest
      request;
  request.set_name(name);
  return connection_->RepairManagementDnsZoneBinding(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::vmwareengine::v1::ManagementDnsZoneBinding>>
VmwareEngineClient::RepairManagementDnsZoneBinding(
    google::cloud::vmwareengine::v1::
        RepairManagementDnsZoneBindingRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->RepairManagementDnsZoneBinding(request);
}

StatusOr<google::longrunning::Operation>
VmwareEngineClient::RepairManagementDnsZoneBinding(
    NoAwaitTag,
    google::cloud::vmwareengine::v1::
        RepairManagementDnsZoneBindingRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->RepairManagementDnsZoneBinding(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::vmwareengine::v1::ManagementDnsZoneBinding>>
VmwareEngineClient::RepairManagementDnsZoneBinding(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->RepairManagementDnsZoneBinding(operation);
}

future<StatusOr<google::cloud::vmwareengine::v1::VmwareEngineNetwork>>
VmwareEngineClient::CreateVmwareEngineNetwork(
    std::string const& parent,
    google::cloud::vmwareengine::v1::VmwareEngineNetwork const&
        vmware_engine_network,
    std::string const& vmware_engine_network_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::CreateVmwareEngineNetworkRequest request;
  request.set_parent(parent);
  *request.mutable_vmware_engine_network() = vmware_engine_network;
  request.set_vmware_engine_network_id(vmware_engine_network_id);
  return connection_->CreateVmwareEngineNetwork(request);
}

StatusOr<google::longrunning::Operation>
VmwareEngineClient::CreateVmwareEngineNetwork(
    NoAwaitTag, std::string const& parent,
    google::cloud::vmwareengine::v1::VmwareEngineNetwork const&
        vmware_engine_network,
    std::string const& vmware_engine_network_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::CreateVmwareEngineNetworkRequest request;
  request.set_parent(parent);
  *request.mutable_vmware_engine_network() = vmware_engine_network;
  request.set_vmware_engine_network_id(vmware_engine_network_id);
  return connection_->CreateVmwareEngineNetwork(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::vmwareengine::v1::VmwareEngineNetwork>>
VmwareEngineClient::CreateVmwareEngineNetwork(
    google::cloud::vmwareengine::v1::CreateVmwareEngineNetworkRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateVmwareEngineNetwork(request);
}

StatusOr<google::longrunning::Operation>
VmwareEngineClient::CreateVmwareEngineNetwork(
    NoAwaitTag,
    google::cloud::vmwareengine::v1::CreateVmwareEngineNetworkRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateVmwareEngineNetwork(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::vmwareengine::v1::VmwareEngineNetwork>>
VmwareEngineClient::CreateVmwareEngineNetwork(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateVmwareEngineNetwork(operation);
}

future<StatusOr<google::cloud::vmwareengine::v1::VmwareEngineNetwork>>
VmwareEngineClient::UpdateVmwareEngineNetwork(
    google::cloud::vmwareengine::v1::VmwareEngineNetwork const&
        vmware_engine_network,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::UpdateVmwareEngineNetworkRequest request;
  *request.mutable_vmware_engine_network() = vmware_engine_network;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateVmwareEngineNetwork(request);
}

StatusOr<google::longrunning::Operation>
VmwareEngineClient::UpdateVmwareEngineNetwork(
    NoAwaitTag,
    google::cloud::vmwareengine::v1::VmwareEngineNetwork const&
        vmware_engine_network,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::UpdateVmwareEngineNetworkRequest request;
  *request.mutable_vmware_engine_network() = vmware_engine_network;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateVmwareEngineNetwork(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::vmwareengine::v1::VmwareEngineNetwork>>
VmwareEngineClient::UpdateVmwareEngineNetwork(
    google::cloud::vmwareengine::v1::UpdateVmwareEngineNetworkRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateVmwareEngineNetwork(request);
}

StatusOr<google::longrunning::Operation>
VmwareEngineClient::UpdateVmwareEngineNetwork(
    NoAwaitTag,
    google::cloud::vmwareengine::v1::UpdateVmwareEngineNetworkRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateVmwareEngineNetwork(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::vmwareengine::v1::VmwareEngineNetwork>>
VmwareEngineClient::UpdateVmwareEngineNetwork(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateVmwareEngineNetwork(operation);
}

future<StatusOr<google::cloud::vmwareengine::v1::OperationMetadata>>
VmwareEngineClient::DeleteVmwareEngineNetwork(std::string const& name,
                                              Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::DeleteVmwareEngineNetworkRequest request;
  request.set_name(name);
  return connection_->DeleteVmwareEngineNetwork(request);
}

StatusOr<google::longrunning::Operation>
VmwareEngineClient::DeleteVmwareEngineNetwork(NoAwaitTag,
                                              std::string const& name,
                                              Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::DeleteVmwareEngineNetworkRequest request;
  request.set_name(name);
  return connection_->DeleteVmwareEngineNetwork(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::vmwareengine::v1::OperationMetadata>>
VmwareEngineClient::DeleteVmwareEngineNetwork(
    google::cloud::vmwareengine::v1::DeleteVmwareEngineNetworkRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteVmwareEngineNetwork(request);
}

StatusOr<google::longrunning::Operation>
VmwareEngineClient::DeleteVmwareEngineNetwork(
    NoAwaitTag,
    google::cloud::vmwareengine::v1::DeleteVmwareEngineNetworkRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteVmwareEngineNetwork(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::vmwareengine::v1::OperationMetadata>>
VmwareEngineClient::DeleteVmwareEngineNetwork(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteVmwareEngineNetwork(operation);
}

StatusOr<google::cloud::vmwareengine::v1::VmwareEngineNetwork>
VmwareEngineClient::GetVmwareEngineNetwork(std::string const& name,
                                           Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::GetVmwareEngineNetworkRequest request;
  request.set_name(name);
  return connection_->GetVmwareEngineNetwork(request);
}

StatusOr<google::cloud::vmwareengine::v1::VmwareEngineNetwork>
VmwareEngineClient::GetVmwareEngineNetwork(
    google::cloud::vmwareengine::v1::GetVmwareEngineNetworkRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetVmwareEngineNetwork(request);
}

StreamRange<google::cloud::vmwareengine::v1::VmwareEngineNetwork>
VmwareEngineClient::ListVmwareEngineNetworks(std::string const& parent,
                                             Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::ListVmwareEngineNetworksRequest request;
  request.set_parent(parent);
  return connection_->ListVmwareEngineNetworks(request);
}

StreamRange<google::cloud::vmwareengine::v1::VmwareEngineNetwork>
VmwareEngineClient::ListVmwareEngineNetworks(
    google::cloud::vmwareengine::v1::ListVmwareEngineNetworksRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListVmwareEngineNetworks(std::move(request));
}

future<StatusOr<google::cloud::vmwareengine::v1::PrivateConnection>>
VmwareEngineClient::CreatePrivateConnection(
    std::string const& parent,
    google::cloud::vmwareengine::v1::PrivateConnection const&
        private_connection,
    std::string const& private_connection_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::CreatePrivateConnectionRequest request;
  request.set_parent(parent);
  *request.mutable_private_connection() = private_connection;
  request.set_private_connection_id(private_connection_id);
  return connection_->CreatePrivateConnection(request);
}

StatusOr<google::longrunning::Operation>
VmwareEngineClient::CreatePrivateConnection(
    NoAwaitTag, std::string const& parent,
    google::cloud::vmwareengine::v1::PrivateConnection const&
        private_connection,
    std::string const& private_connection_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::CreatePrivateConnectionRequest request;
  request.set_parent(parent);
  *request.mutable_private_connection() = private_connection;
  request.set_private_connection_id(private_connection_id);
  return connection_->CreatePrivateConnection(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::vmwareengine::v1::PrivateConnection>>
VmwareEngineClient::CreatePrivateConnection(
    google::cloud::vmwareengine::v1::CreatePrivateConnectionRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreatePrivateConnection(request);
}

StatusOr<google::longrunning::Operation>
VmwareEngineClient::CreatePrivateConnection(
    NoAwaitTag,
    google::cloud::vmwareengine::v1::CreatePrivateConnectionRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreatePrivateConnection(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::vmwareengine::v1::PrivateConnection>>
VmwareEngineClient::CreatePrivateConnection(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreatePrivateConnection(operation);
}

StatusOr<google::cloud::vmwareengine::v1::PrivateConnection>
VmwareEngineClient::GetPrivateConnection(std::string const& name,
                                         Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::GetPrivateConnectionRequest request;
  request.set_name(name);
  return connection_->GetPrivateConnection(request);
}

StatusOr<google::cloud::vmwareengine::v1::PrivateConnection>
VmwareEngineClient::GetPrivateConnection(
    google::cloud::vmwareengine::v1::GetPrivateConnectionRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetPrivateConnection(request);
}

StreamRange<google::cloud::vmwareengine::v1::PrivateConnection>
VmwareEngineClient::ListPrivateConnections(std::string const& parent,
                                           Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::ListPrivateConnectionsRequest request;
  request.set_parent(parent);
  return connection_->ListPrivateConnections(request);
}

StreamRange<google::cloud::vmwareengine::v1::PrivateConnection>
VmwareEngineClient::ListPrivateConnections(
    google::cloud::vmwareengine::v1::ListPrivateConnectionsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListPrivateConnections(std::move(request));
}

future<StatusOr<google::cloud::vmwareengine::v1::PrivateConnection>>
VmwareEngineClient::UpdatePrivateConnection(
    google::cloud::vmwareengine::v1::PrivateConnection const&
        private_connection,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::UpdatePrivateConnectionRequest request;
  *request.mutable_private_connection() = private_connection;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdatePrivateConnection(request);
}

StatusOr<google::longrunning::Operation>
VmwareEngineClient::UpdatePrivateConnection(
    NoAwaitTag,
    google::cloud::vmwareengine::v1::PrivateConnection const&
        private_connection,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::UpdatePrivateConnectionRequest request;
  *request.mutable_private_connection() = private_connection;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdatePrivateConnection(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::vmwareengine::v1::PrivateConnection>>
VmwareEngineClient::UpdatePrivateConnection(
    google::cloud::vmwareengine::v1::UpdatePrivateConnectionRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdatePrivateConnection(request);
}

StatusOr<google::longrunning::Operation>
VmwareEngineClient::UpdatePrivateConnection(
    NoAwaitTag,
    google::cloud::vmwareengine::v1::UpdatePrivateConnectionRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdatePrivateConnection(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::vmwareengine::v1::PrivateConnection>>
VmwareEngineClient::UpdatePrivateConnection(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdatePrivateConnection(operation);
}

future<StatusOr<google::cloud::vmwareengine::v1::OperationMetadata>>
VmwareEngineClient::DeletePrivateConnection(std::string const& name,
                                            Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::DeletePrivateConnectionRequest request;
  request.set_name(name);
  return connection_->DeletePrivateConnection(request);
}

StatusOr<google::longrunning::Operation>
VmwareEngineClient::DeletePrivateConnection(NoAwaitTag, std::string const& name,
                                            Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::DeletePrivateConnectionRequest request;
  request.set_name(name);
  return connection_->DeletePrivateConnection(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::vmwareengine::v1::OperationMetadata>>
VmwareEngineClient::DeletePrivateConnection(
    google::cloud::vmwareengine::v1::DeletePrivateConnectionRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeletePrivateConnection(request);
}

StatusOr<google::longrunning::Operation>
VmwareEngineClient::DeletePrivateConnection(
    NoAwaitTag,
    google::cloud::vmwareengine::v1::DeletePrivateConnectionRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeletePrivateConnection(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::vmwareengine::v1::OperationMetadata>>
VmwareEngineClient::DeletePrivateConnection(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeletePrivateConnection(operation);
}

StreamRange<google::cloud::vmwareengine::v1::PeeringRoute>
VmwareEngineClient::ListPrivateConnectionPeeringRoutes(
    std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::ListPrivateConnectionPeeringRoutesRequest
      request;
  request.set_parent(parent);
  return connection_->ListPrivateConnectionPeeringRoutes(request);
}

StreamRange<google::cloud::vmwareengine::v1::PeeringRoute>
VmwareEngineClient::ListPrivateConnectionPeeringRoutes(
    google::cloud::vmwareengine::v1::ListPrivateConnectionPeeringRoutesRequest
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListPrivateConnectionPeeringRoutes(std::move(request));
}

future<StatusOr<google::cloud::vmwareengine::v1::DnsBindPermission>>
VmwareEngineClient::GrantDnsBindPermission(
    std::string const& name,
    google::cloud::vmwareengine::v1::Principal const& principal, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::GrantDnsBindPermissionRequest request;
  request.set_name(name);
  *request.mutable_principal() = principal;
  return connection_->GrantDnsBindPermission(request);
}

StatusOr<google::longrunning::Operation>
VmwareEngineClient::GrantDnsBindPermission(
    NoAwaitTag, std::string const& name,
    google::cloud::vmwareengine::v1::Principal const& principal, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::GrantDnsBindPermissionRequest request;
  request.set_name(name);
  *request.mutable_principal() = principal;
  return connection_->GrantDnsBindPermission(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::vmwareengine::v1::DnsBindPermission>>
VmwareEngineClient::GrantDnsBindPermission(
    google::cloud::vmwareengine::v1::GrantDnsBindPermissionRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GrantDnsBindPermission(request);
}

StatusOr<google::longrunning::Operation>
VmwareEngineClient::GrantDnsBindPermission(
    NoAwaitTag,
    google::cloud::vmwareengine::v1::GrantDnsBindPermissionRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GrantDnsBindPermission(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::vmwareengine::v1::DnsBindPermission>>
VmwareEngineClient::GrantDnsBindPermission(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GrantDnsBindPermission(operation);
}

StatusOr<google::cloud::vmwareengine::v1::DnsBindPermission>
VmwareEngineClient::GetDnsBindPermission(std::string const& name,
                                         Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::GetDnsBindPermissionRequest request;
  request.set_name(name);
  return connection_->GetDnsBindPermission(request);
}

StatusOr<google::cloud::vmwareengine::v1::DnsBindPermission>
VmwareEngineClient::GetDnsBindPermission(
    google::cloud::vmwareengine::v1::GetDnsBindPermissionRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetDnsBindPermission(request);
}

future<StatusOr<google::cloud::vmwareengine::v1::DnsBindPermission>>
VmwareEngineClient::RevokeDnsBindPermission(
    std::string const& name,
    google::cloud::vmwareengine::v1::Principal const& principal, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::RevokeDnsBindPermissionRequest request;
  request.set_name(name);
  *request.mutable_principal() = principal;
  return connection_->RevokeDnsBindPermission(request);
}

StatusOr<google::longrunning::Operation>
VmwareEngineClient::RevokeDnsBindPermission(
    NoAwaitTag, std::string const& name,
    google::cloud::vmwareengine::v1::Principal const& principal, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::vmwareengine::v1::RevokeDnsBindPermissionRequest request;
  request.set_name(name);
  *request.mutable_principal() = principal;
  return connection_->RevokeDnsBindPermission(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::vmwareengine::v1::DnsBindPermission>>
VmwareEngineClient::RevokeDnsBindPermission(
    google::cloud::vmwareengine::v1::RevokeDnsBindPermissionRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->RevokeDnsBindPermission(request);
}

StatusOr<google::longrunning::Operation>
VmwareEngineClient::RevokeDnsBindPermission(
    NoAwaitTag,
    google::cloud::vmwareengine::v1::RevokeDnsBindPermissionRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->RevokeDnsBindPermission(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::vmwareengine::v1::DnsBindPermission>>
VmwareEngineClient::RevokeDnsBindPermission(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->RevokeDnsBindPermission(operation);
}

StreamRange<google::cloud::location::Location>
VmwareEngineClient::ListLocations(
    google::cloud::location::ListLocationsRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListLocations(std::move(request));
}

StatusOr<google::cloud::location::Location> VmwareEngineClient::GetLocation(
    google::cloud::location::GetLocationRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetLocation(request);
}

StatusOr<google::iam::v1::Policy> VmwareEngineClient::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SetIamPolicy(request);
}

StatusOr<google::iam::v1::Policy> VmwareEngineClient::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetIamPolicy(request);
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
VmwareEngineClient::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->TestIamPermissions(request);
}

StreamRange<google::longrunning::Operation> VmwareEngineClient::ListOperations(
    std::string const& name, std::string const& filter, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::longrunning::ListOperationsRequest request;
  request.set_name(name);
  request.set_filter(filter);
  return connection_->ListOperations(request);
}

StreamRange<google::longrunning::Operation> VmwareEngineClient::ListOperations(
    google::longrunning::ListOperationsRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListOperations(std::move(request));
}

StatusOr<google::longrunning::Operation> VmwareEngineClient::GetOperation(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::longrunning::GetOperationRequest request;
  request.set_name(name);
  return connection_->GetOperation(request);
}

StatusOr<google::longrunning::Operation> VmwareEngineClient::GetOperation(
    google::longrunning::GetOperationRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetOperation(request);
}

Status VmwareEngineClient::DeleteOperation(std::string const& name,
                                           Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::longrunning::DeleteOperationRequest request;
  request.set_name(name);
  return connection_->DeleteOperation(request);
}

Status VmwareEngineClient::DeleteOperation(
    google::longrunning::DeleteOperationRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteOperation(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace vmwareengine_v1
}  // namespace cloud
}  // namespace google
